/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PageRanges;
import javax.swing.RepaintManager;
import util.BrLogger;

public class PrintControler
implements Printable {
    private final PrinterJob printJob;
    private PageFormat page;
    int idx = 0;
    private Point page_range = new Point(0, 0);
    private PrintRequestAttributeSet Atributos = new HashPrintRequestAttributeSet();
    private PageRanges pgr = null;
    private JobName jbn = new JobName("brModelo", Locale.getDefault());
    BufferedImage[] imgs = null;

    public PrintControler() {
        this.printJob = PrinterJob.getPrinterJob();
        this.page = this.printJob.defaultPage();
        this.page.setOrientation(1);
    }

    public void print() {
        this.getPrintJob().setPrintable(this, this.getPage());
        if (this.Atributos.isEmpty()) {
            this.Atributos.add(this.jbn);
        }
        this.Atributos.remove(this.pgr);
        this.pgr = new PageRanges(this.page_range.x, this.page_range.y);
        this.Atributos.add(this.pgr);
        if (this.getPrintJob().printDialog(this.Atributos)) {
            try {
                this.getPrintJob().print(this.Atributos);
            }
            catch (PrinterException pe) {
                BrLogger.Logger("ERROR_PRINTING", pe.getMessage());
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex < this.imgs.length) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.addRenderingHints(renderHints);
            int w = this.getPageWidth();
            int h = this.getPageHeigth();
            g2d.drawImage(this.imgs[pageIndex], 0, 0, w, h, null);
            return 0;
        }
        return 1;
    }

    public final void setJobName(String jobName) {
        this.getPrintJob().setJobName(jobName);
    }

    public void pageSetup() {
        this.page = this.getPrintJob().pageDialog(this.getPage());
    }

    public void printSetup() {
        if (this.Atributos.isEmpty()) {
            this.Atributos.add(this.jbn);
        }
        this.Atributos.remove(this.pgr);
        this.pgr = new PageRanges(this.page_range.x, this.page_range.y);
        this.Atributos.add(this.pgr);
        if (this.getPrintJob().printDialog(this.Atributos)) {
            this.page = this.getPrintJob().getPageFormat(this.Atributos);
        }
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public PrinterJob getPrintJob() {
        return this.printJob;
    }

    public PageFormat getPage() {
        return this.page;
    }

    public int getPageWidth() {
        return (int)this.getPage().getImageableWidth();
    }

    public int getPageHeigth() {
        return (int)this.getPage().getImageableHeight();
    }

    public boolean isLandscape() {
        return this.getPage().getOrientation() == 0;
    }

    public int getRealFolhaWidth() {
        return (int)this.getPage().getWidth();
    }

    public int getRealFolhaHeigth() {
        return (int)this.getPage().getHeight();
    }

    public void setPaginas(BufferedImage[] imgs) {
        this.imgs = imgs;
        if (imgs == null) {
            this.page_range = new Point(0, 0);
            return;
        }
        this.page_range = new Point(1, imgs.length);
    }
}

