/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Diagrama;
import desenho.formas.Forma;
import desenho.formas.FormaNaoRetangularBase;
import desenho.formas.FormaTriangular;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import desenho.linhas.SuperLinha;
import desenho.preAnyDiagrama.PreEntidade;
import diagramas.conceitual.Entidade;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class PreEspecializacao
extends FormaTriangular {
    private static final long serialVersionUID = 4701897775925018386L;
    protected PontoDeLinha[] ocupados = new PontoDeLinha[]{null, null, null};
    private boolean parcial = false;
    protected boolean paintParcial = false;

    public PreEspecializacao(Diagrama modelo) {
        super(modelo);
    }

    public PreEspecializacao(Diagrama modelo, String texto) {
        super(modelo, texto);
    }

    @Override
    public void menosLigacao(PontoDeLinha aThis) {
        super.menosLigacao(aThis);
        this.RemovaOcupados(aThis);
    }

    public PreEntidade LigadaAoPontoPrincipal() {
        PontoDeLinha pri = this.ocupados[0];
        if (pri == null) {
            return null;
        }
        Forma op = pri.getDono().getOutraPonta(this);
        if (op != null) {
            return (PreEntidade)op;
        }
        return null;
    }

    @Override
    protected void Posicione3Pontos(PontoDeLinha ponto) {
        super.Posicione3Pontos(ponto);
        Point[] pts = this.getPontosDoTriangulo();
        Point pt1 = pts[0];
        Point pt2 = pts[1];
        Point pt3 = pts[2];
        Point pMeio = pts[3];
        if (ponto.getCentro().equals(pt1)) {
            this.verifiqueOcupacao(ponto, pt1, 0, pMeio);
        } else if (ponto.getCentro().equals(pt2)) {
            this.verifiqueOcupacao(ponto, pt2, 1, pMeio);
        } else if (ponto.getCentro().equals(pt3)) {
            this.verifiqueOcupacao(ponto, pt3, 2, pMeio);
        }
    }

    private void verifiqueOcupacao(PontoDeLinha ponto, Point p, int posi, Point pMeio) {
        this.RemovaOcupados(ponto);
        if (this.ocupados[posi] != null) {
            ponto.setCentro(pMeio);
        } else {
            this.ocupados[posi] = ponto;
            ponto.setCentro(p);
        }
    }

    private void RemovaOcupados(PontoDeLinha pt) {
        for (int i = 0; i < this.ocupados.length; ++i) {
            if (this.ocupados[i] != pt) continue;
            this.ocupados[i] = null;
            return;
        }
    }

    @Override
    public void setDirecaoTriangulo(FormaNaoRetangularBase.Direcao direcaoTriangulo) {
        Point[] pts = this.getPontosDoTriangulo();
        if (direcaoTriangulo.ordinal() > 3) {
            direcaoTriangulo = FormaNaoRetangularBase.Direcao.Up;
        }
        this.setDirecaoNaoNotifique(direcaoTriangulo);
        this.DestruaRegiao();
        Point[] pts2 = this.getPontosDoTriangulo();
        ArrayList<PontoDeLinha> btns = this.getListaDePontosLigados();
        block0: for (PontoDeLinha pdl : btns) {
            Point atual = pdl.getCentro();
            int i = 0;
            for (Point p : pts) {
                if (atual.equals(p)) {
                    pdl.setCentro(pts2[i]);
                    continue block0;
                }
                ++i;
            }
        }
        this.SendNotificacao(5);
        this.InvalidateArea();
    }

    @Override
    public boolean CanLiga(Forma forma, Linha lin) {
        if (forma == null) {
            ((SuperLinha)lin).setInteligente(false);
            return true;
        }
        if (super.CanLiga(forma, lin)) {
            if (!(forma instanceof Entidade)) {
                return false;
            }
            if (!this.FinderLinked(forma, this)) {
                return true;
            }
        }
        return false;
    }

    protected boolean FinderLinked(Forma quem, Forma origem) {
        return false;
    }

    public boolean isParcial() {
        return this.parcial;
    }

    public void setParcial(boolean parcial) {
        this.parcial = parcial;
        this.InvalidateArea();
    }

    public void setDirecaoFromInspector(int di) {
        FormaNaoRetangularBase.Direcao dr = FormaNaoRetangularBase.Direcao.values()[di];
        this.setDirecaoTriangulo(dr);
    }

    public int getDirecaoForInspector() {
        return this.getDirecaoTriangulo().ordinal();
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorInteger(doc, "Direcao", this.getDirecaoForInspector()));
        me.appendChild(XMLGenerate.ValorRefFormElementar(doc, "Ocupado01", this.ocupados[0] == null ? null : this.ocupados[0].getEm()));
        me.appendChild(XMLGenerate.ValorRefFormElementar(doc, "Ocupado02", this.ocupados[1] == null ? null : this.ocupados[1].getEm()));
        me.appendChild(XMLGenerate.ValorRefFormElementar(doc, "Ocupado03", this.ocupados[2] == null ? null : this.ocupados[2].getEm()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Parcial", this.isParcial()));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setParcial(XMLGenerate.getValorBooleanFrom(me, "Parcial"));
        int l = XMLGenerate.getValorIntegerFrom(me, "Direcao");
        if (l != -1) {
            this.setDirecaoFromInspector(l);
        }
        return true;
    }

    @Override
    public void DoPaint(Graphics2D g) {
        super.DoPaint(g);
        int h = this.getHeight() / 8;
        int w = this.getWidth() / 8;
        Font fbkp = this.getFont();
        g.setFont(this.getFont());
        int fh = g.getFontMetrics().getHeight() / 2;
        int fw = g.getFontMetrics().stringWidth("p");
        int x = 0;
        int y = 0;
        Rectangle r = this.getBounds();
        Shape bkp = g.getClip();
        g.setClip(this.Regiao);
        switch (this.getDirecao()) {
            case Up: {
                g.fillRect(r.x, r.y, r.width, h);
                x = r.x + r.width - fw;
                y = r.y + r.height / 2 + fh / 2;
                break;
            }
            case Right: {
                g.fillRect(this.getLeftWidth() - w, r.y, w, r.height);
                x = r.x + r.width / 2 - fw / 2;
                y = r.y + fh;
                break;
            }
            case Down: {
                g.fillRect(r.x, this.getTopHeight() - h, r.width, h);
                x = r.x + r.width - fw;
                y = r.y + r.height / 2 + fh / 2;
                break;
            }
            case Left: {
                g.fillRect(r.x, r.y, w, r.height);
                x = r.x + r.width / 2 - fw / 2;
                y = r.y + fh;
            }
        }
        g.setClip(bkp);
        this.PaintPDeParcial(g, x, y);
        g.setFont(fbkp);
    }

    protected void PaintPDeParcial(Graphics2D g, int x, int y) {
        if (this.paintParcial && this.isParcial()) {
            g.drawString("p", x, y);
        }
    }
}

