/*
 * Decompiled with CFR 0.152.
 */
package desenho;

import controlador.Diagrama;
import desenho.FormaElementar;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class Ancorador
extends FormaElementar {
    private static final long serialVersionUID = 7623942990410762612L;
    protected Shape Regiao = null;
    public static final int CODE_ANCORAR = 0;
    public static final int CODE_DEL = 1;
    public static final int CODE_ORG_AT = 2;
    private final ArrayList<Rectangle> areas = new ArrayList();
    private transient Rectangle overRNow = null;
    private ArrayList<Integer> ancorasCode = null;

    public Ancorador(Diagrama master) {
        this.Inicie(master);
    }

    private void Inicie(Diagrama master) {
        this.setMaster(master);
        if (this.getMaster() != null) {
            this.InitializeSubItens(master);
        }
        this.setCursor(new Cursor(12));
        this.setVisible(false);
    }

    public void setOverNow(Rectangle overNow) {
        if (this.overRNow == overNow) {
            return;
        }
        if (this.overRNow != null && this.overRNow.equals(overNow)) {
            return;
        }
        if (this.overRNow != null) {
            this.InvalidateArea(this.overRNow);
        }
        this.overRNow = overNow;
        if (this.overRNow != null) {
            this.InvalidateArea(this.overRNow);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getMaster() == null) {
            return;
        }
        if (this.getMaster().getCursor().getType() != this.getCursor().getType()) {
            this.getMaster().setCursor(new Cursor(this.getCursor().getType()));
        }
        Point p = e.getPoint();
        this.ChecarOver(p);
    }

    private void ChecarOver(Point p) {
        if (this.areas.isEmpty()) {
            return;
        }
        for (Rectangle r : this.areas) {
            if (!r.contains(p)) continue;
            this.setOverNow(r);
            return;
        }
        this.setOverNow(null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.areas.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.areas.size(); ++i) {
            Rectangle r = this.areas.get(i);
            if (!r.contains(e.getPoint())) continue;
            this.ProcessClick(this.getAncorasCode().get(i));
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseDblClicked(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    public boolean isMyEvent(MouseEvent e) {
        if (e == null || this.getMaster().getComando() != null) {
            return false;
        }
        return this.IsMe(e.getPoint());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setOverNow(null);
    }

    public Shape getRegiao() {
        if (this.Regiao == null) {
            this.Regiao = new Rectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        }
        return this.Regiao;
    }

    public void setRegiao(Shape regiao) {
        this.Regiao = regiao;
    }

    @Override
    public void ReSized() {
        this.DestruaRegiao();
        super.ReSized();
    }

    protected void DestruaRegiao() {
        this.setRegiao(null);
    }

    @Override
    public boolean IsMe(Point p) {
        if (super.IsMe(p)) {
            return this.getRegiao().contains(p);
        }
        return false;
    }

    @Override
    public boolean IntersectPath(Rectangle recsel) {
        return false;
    }

    public void Posicione(FormaElementar selecionado) {
        if (selecionado == null || !this.getMaster().getEditor().isAncorador()) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
            return;
        }
        int espaco = 8;
        this.SetVisible(true);
        int L = selecionado.getLeft() - this.getWidth() - 8;
        int T = selecionado.getTop();
        if (L < 0) {
            L = selecionado.getLeftWidth() + 8;
        }
        if (T + this.getHeight() + 8 > this.getMaster().getHeight()) {
            T = this.getMaster().getHeight() - (this.getHeight() + 8);
        }
        int H = this.Construa(selecionado);
        this.SetBounds(L, T, this.getWidth(), H);
    }

    public int Construa(FormaElementar sel) {
        this.getAncorasCode().clear();
        int larg = this.getWidth();
        int y = this.getTop();
        int sx = 2;
        for (Integer c : sel.getAncorasCode()) {
            y += larg + 2;
            this.getAncorasCode().add(c);
        }
        return y - 2;
    }

    @Override
    public void DoPaint(Graphics2D g) {
        if (!this.isVisible() || this.getMaster().getSelecionado() == null) {
            return;
        }
        g.setFont(this.getFont());
        this.areas.clear();
        int larg = this.getWidth();
        int x = this.getLeft();
        int y = this.getTop();
        int sx = 2;
        for (Integer c : this.getAncorasCode()) {
            this.areas.add(new Rectangle(x, y, larg, larg + 2));
            y += larg + 2;
        }
        if (this.areas.isEmpty()) {
            return;
        }
        g.setColor(new Color(204, 204, 255));
        int i = 0;
        for (Integer c : this.getAncorasCode()) {
            Rectangle r = this.areas.get(i);
            g.setColor(Color.white);
            g.fillRect(r.x, r.y + 1, r.width - 1, r.height - 4);
            g.setColor(Color.gray);
            String whatDraw = this.getMaster().getSelecionado().WhatDrawOnAcorador(c);
            g.drawImage(this.getMaster().getEditor().getControler().ImagemDeDiagrama.get(whatDraw).getImage(), r.x + 1, r.y + 1, null);
            if (this.overRNow != null && this.overRNow.equals(r)) {
                g.setColor(Color.lightGray);
                g.drawRect(r.x, r.y + 1, r.width - 1, r.height - 4);
                g.setColor(Color.darkGray);
                g.drawLine(r.x + 2, r.y + r.height - 2, r.x + r.width - 1, r.y + r.height - 2);
                g.drawLine(r.x + r.width - 1, r.y + 4, r.x + r.width - 1, r.y + r.height - 2);
            }
            ++i;
        }
    }

    public Rectangle getOverNow() {
        return this.overRNow;
    }

    private void ProcessClick(Integer c) {
        if (this.getMaster().getSelecionado() == null) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
            return;
        }
        this.setOverNow(null);
        this.InvalidateArea();
        this.getMaster().getSelecionado().runAncorasCode(c);
        this.Posicione(this.getMaster().getSelecionado());
    }

    @Override
    public ArrayList<Integer> getAncorasCode() {
        if (this.ancorasCode == null) {
            this.ancorasCode = new ArrayList();
        }
        return this.ancorasCode;
    }
}

