/*
 * Decompiled with CFR 0.152.
 */
package controlador.inspector;

import controlador.Editor;
import controlador.inspector.InspectorPprtAgrupador;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import util.Utilidades;

public class InspectorProperty {
    public String configuracaoStr = "";
    public String opcional = "";
    public String property = "";
    public String caption = "";
    public String dica = "";
    public String valor_string = "";
    public TipoDeProperty tipo = TipoDeProperty.tpNothing;
    public InspectorPprtAgrupador agrupada = null;
    public int Tag = 0;
    private boolean forceDisable = false;
    private boolean forceEnable = false;
    public List<String> opcoesMenu = null;

    public InspectorProperty() {
    }

    public InspectorProperty(String partCaption) {
        if (!"".equals(partCaption)) {
            this.caption = this.CaptionFromConfig(partCaption);
        }
        this.configuracaoStr = partCaption;
        this.GeraTextoHelper(InspectorProperty.FullDica(partCaption));
    }

    public final String CaptionFromConfig(String newParCaption) {
        return Editor.fromConfiguracao.getValor(InspectorProperty.FullCaption(newParCaption));
    }

    public void ReSetCaptionFromConfig(String partCaption) {
        this.caption = this.CaptionFromConfig(partCaption);
        this.GeraTextoHelper(InspectorProperty.FullDica(partCaption));
    }

    public static String FullCaption(String parCaption) {
        return "Inspector.obj." + parCaption;
    }

    public static String FullDica(String parCaption) {
        return "Inspector.dica." + parCaption;
    }

    private void GeraTextoHelper(String fullDica) {
        this.dica = Editor.fromConfiguracao.getValor(fullDica);
        if (this.dica.equals(fullDica)) {
            this.dica = "";
        }
    }

    public boolean isForceDisable() {
        return this.forceDisable;
    }

    public void setForceDisable(boolean forceDisable) {
        this.forceDisable = forceDisable;
        if (this.forceDisable) {
            this.forceEnable = false;
        }
    }

    public boolean isForceEnable() {
        return this.forceEnable;
    }

    public void setForceEnable(boolean forceEnable) {
        this.forceEnable = forceEnable;
        if (this.forceEnable) {
            this.forceDisable = false;
        }
    }

    public InspectorProperty PropertyForceDisable(boolean sn) {
        this.setForceDisable(sn);
        return this;
    }

    public InspectorProperty PropertyForceEnable(boolean sn) {
        this.setForceEnable(sn);
        return this;
    }

    public boolean isMineCaption(String byCaption) {
        return this.caption.equals(this.CaptionFromConfig(byCaption));
    }

    public boolean isMe(String byProperty) {
        return this.property.equals(byProperty);
    }

    public boolean IsIgual(InspectorProperty este) {
        boolean r = this.tipo.equals((Object)este.tipo);
        if (!r) {
            return false;
        }
        if (this.agrupada == null && este.agrupada == null) {
            return true;
        }
        if (this.agrupada != null && este.agrupada != null) {
            return this.agrupada.getPropriedade().equals(este.agrupada.getPropriedade());
        }
        return false;
    }

    public InspectorProperty setTag(int tg) {
        this.Tag = tg;
        return this;
    }

    public int getTag() {
        return this.Tag;
    }

    public ArrayList<String> QuaisCanEditIf(String valor) {
        if (this.agrupada == null) {
            return null;
        }
        return this.agrupada.QuaisEnableIf(valor);
    }

    public ArrayList<String> QuaisCanEditNotIf(String valor) {
        if (this.agrupada == null) {
            return null;
        }
        return this.agrupada.QuaisDisableIf(valor);
    }

    public InspectorProperty AddCondicao(String[] enableIf, String[] afetados) {
        if (this.agrupada == null) {
            this.agrupada = new InspectorPprtAgrupador(this.property);
        }
        this.agrupada.AddCondicao(enableIf, afetados);
        return this;
    }

    public InspectorProperty AddCondicaoForTrue(String[] afetados) {
        return this.AddCondicao(new String[]{Boolean.toString(true)}, afetados);
    }

    public InspectorProperty AddCondicaoForFalse(String[] afetados) {
        return this.AddCondicao(new String[]{Boolean.toString(false)}, afetados);
    }

    public static InspectorProperty getPropertySeparador(String caption) {
        InspectorProperty pprt = new InspectorProperty();
        pprt.tipo = TipoDeProperty.tpSeparador;
        pprt.caption = caption;
        pprt.dica = "";
        return pprt;
    }

    public static InspectorProperty FindByCaption(ArrayList<InspectorProperty> lista, String cap) {
        for (InspectorProperty res : lista) {
            if (!res.isMineCaption(cap)) continue;
            return res;
        }
        return null;
    }

    public static InspectorProperty FindByProperty(ArrayList<InspectorProperty> lista, String ppr) {
        for (InspectorProperty res : lista) {
            if (!res.isMe(ppr)) continue;
            return res;
        }
        return null;
    }

    public static InspectorProperty PropertyFactorySN(String partCaption, String prop, boolean valor) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.property = prop;
        ppr.valor_string = Boolean.toString(valor);
        ppr.tipo = TipoDeProperty.tpBooleano;
        return ppr;
    }

    public static InspectorProperty PropertyFactorySeparador(String partCaption) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.tipo = TipoDeProperty.tpSeparador;
        ppr.property = partCaption;
        return ppr;
    }

    public static InspectorProperty PropertyFactorySeparador(String partCaption, boolean encolhido) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.tipo = TipoDeProperty.tpSeparador;
        ppr.property = partCaption;
        if (encolhido) {
            ppr.opcional = "-";
        }
        return ppr;
    }

    public static InspectorProperty PropertyFactoryApenasLeituraSN(String partCaption, boolean valor) {
        return InspectorProperty.PropertyFactoryApenasLeituraTexto(partCaption, Editor.fromConfiguracao.getValor("Inspector.obj." + Boolean.toString(valor).toLowerCase()));
    }

    public static InspectorProperty PropertyFactoryApenasLeituraTexto(String partCaption, String valor) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.property = partCaption;
        ppr.valor_string = valor;
        ppr.tipo = TipoDeProperty.tpApenasLeituraTexto;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryCommand(String pprt) {
        InspectorProperty ppr = new InspectorProperty(pprt.toLowerCase());
        ppr.valor_string = "...";
        ppr.property = pprt;
        ppr.tipo = TipoDeProperty.tpCommand;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryCommand(String pprt, String partCaption) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.valor_string = "...";
        ppr.property = pprt;
        ppr.tipo = TipoDeProperty.tpCommand;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryCommand(String pprt, String partCaption, String valor) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.valor_string = valor;
        ppr.property = pprt;
        ppr.tipo = TipoDeProperty.tpCommand;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryCommandPlain(String pprt, String partCaption, String caption) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.caption = caption;
        ppr.valor_string = "...";
        ppr.property = pprt;
        ppr.tipo = TipoDeProperty.tpCommand;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryActionSelect(String Caption, String valor, String strID) {
        InspectorProperty ppr = new InspectorProperty();
        ppr.caption = Caption;
        String tmp = Editor.fromConfiguracao.getValor(InspectorProperty.FullDica(Caption));
        if (tmp.equals(InspectorProperty.FullDica(Caption))) {
            ppr.GeraTextoHelper(InspectorProperty.FullDica("siga"));
        } else {
            ppr.GeraTextoHelper(InspectorProperty.FullDica(Caption));
            ppr.configuracaoStr = Caption;
        }
        ppr.valor_string = valor;
        ppr.tipo = TipoDeProperty.tpSelecObject;
        ppr.property = strID;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryCor(String partCaption, String prop, Color valor) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.property = prop;
        ppr.valor_string = Utilidades.ColorToString(valor);
        ppr.tipo = TipoDeProperty.tpCor;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryTextoL(String partCaption, String prop, String valor) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.property = prop;
        ppr.valor_string = valor;
        ppr.tipo = TipoDeProperty.tpTextoLongo;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryTexto(String partCaption, String prop, String valor) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.property = prop;
        ppr.valor_string = valor;
        ppr.tipo = TipoDeProperty.tpTextoNormal;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryNumero(String partCaption, String prop, int valor) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.property = prop;
        ppr.valor_string = Integer.toString(valor);
        ppr.tipo = TipoDeProperty.tpNumero;
        return ppr;
    }

    public static InspectorProperty PropertyFactoryMenu(String partCaption, String prop, int valor, List<String> opc) {
        InspectorProperty ppr = new InspectorProperty(partCaption);
        ppr.property = prop;
        ppr.valor_string = Integer.toString(valor);
        ppr.tipo = TipoDeProperty.tpMenu;
        ppr.opcoesMenu = new ArrayList<String>(opc);
        return ppr;
    }

    public static enum TipoDeProperty {
        tpNothing,
        tpSeparador,
        tpApenasLeituraTexto,
        tpApenasLeituraCor,
        tpTextoNormal,
        tpTextoLongo,
        tpNumero,
        tpBooleano,
        tpMenu,
        tpCor,
        tpSelecObject,
        tpCommand;

    }
}

