/*
 * Decompiled with CFR 0.152.
 */
package controlador.inspector;

import controlador.BaseControlador;
import controlador.inspector.Inspector;
import controlador.inspector.InspectorExtenderEditor;
import controlador.inspector.InspectorItemCor;
import controlador.inspector.InspectorItemExtender;
import controlador.inspector.InspectorItemMenu;
import controlador.inspector.InspectorItemSN;
import controlador.inspector.InspectorItemSeparador;
import controlador.inspector.InspectorItemTexto;
import controlador.inspector.InspectorProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class InspectorItemBase
extends BaseControlador {
    protected Inspector Criador;
    private boolean selecionado = false;
    protected boolean falhou = false;
    private boolean canEdit = true;
    private JComponent ondeEditar;
    private InspectorProperty propriedade = null;
    private Rectangle area = null;
    transient boolean isMouseDown = false;

    public boolean isSelecionado() {
        return this.selecionado;
    }

    protected final void getCorParaTexto(Graphics g) {
        if (this.falhou) {
            g.setColor(Color.red);
            return;
        }
        if (!this.CanEdit()) {
            g.setColor(Color.LIGHT_GRAY);
            return;
        }
        g.setColor(Color.black);
    }

    protected void setSelecionado(boolean selecionado) {
        this.selecionado = selecionado;
        if (this.ondeEditar != null) {
            if (selecionado) {
                int tam = this.getWidth() / 2 - 2;
                this.ondeEditar.setBounds(tam + 3, 1, tam - 2, this.Criador.altura - 2);
                this.add(this.ondeEditar);
                this.ondeEditar.setVisible(true);
                this.ondeEditar.requestFocus();
                this.validate();
                this.ondeEditar.setEnabled(this.CanEdit());
                if (this.ondeEditar instanceof JTextField) {
                    ((JTextField)this.ondeEditar).selectAll();
                }
            } else {
                this.remove(this.ondeEditar);
            }
        }
        this.repaint();
    }

    public InspectorItemBase(Inspector criador) {
        this();
        this.Criador = criador;
        this.setDoubleBuffered(true);
    }

    public InspectorItemBase() {
        this.setLayout(null);
        this.setFocusable(true);
    }

    public boolean CanEdit() {
        return this.canEdit;
    }

    public void setCanEdit(boolean canEdit) {
        if (this.propriedade.isForceDisable()) {
            canEdit = false;
        } else if (this.propriedade.isForceEnable()) {
            canEdit = true;
        }
        if (this.canEdit != canEdit) {
            this.canEdit = canEdit;
            if (this.ondeEditar != null && this.selecionado) {
                this.ondeEditar.setEnabled(this.CanEdit());
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Graphics2D Canvas = (Graphics2D)g;
        Canvas.addRenderingHints(renderHints);
        Canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        Canvas.setPaint(Color.BLACK);
        this.paint2D(Canvas);
    }

    public void paint2D(Graphics2D g) {
        int esq = (int)((double)this.getWidth() * this.Criador.getDivisor()) - 2;
        int dir = this.getWidth() - (esq + 2);
        if (this.isSelecionado() && this.ondeEditar != null && this.ondeEditar.isVisible() && this.ondeEditar.getWidth() != dir - 2) {
            Dimension d = new Dimension(dir - 2, this.Criador.altura - 2);
            this.ondeEditar.setPreferredSize(d);
            this.ondeEditar.setSize(d);
            this.ondeEditar.setLocation(esq + 3, 1);
            this.ondeEditar.repaint();
            this.ondeEditar.validate();
        }
        this.paintBase(g);
    }

    protected void paintBase(Graphics2D g) {
        Rectangle r = this.getBounds();
        int esq = (int)((double)r.width * this.Criador.getDivisor());
        int dir = r.width - esq;
        this.area = new Rectangle(esq - 2, 0, 4, r.height - 1);
        if (!this.isSelecionado()) {
            g.setColor(Color.GRAY);
            g.drawRoundRect(0, 0, r.width - 1, r.height - 1, 10, 10);
            g.drawLine(esq, 0, esq, r.height - 1);
            g.setColor(Color.BLACK);
            Rectangle bkp = g.getClipBounds();
            g.clipRect(0, 0, esq - 1, r.height);
            this.getCorParaTexto(g);
            g.drawString(this.getTexto(), this.Criador.espaco * 2 + 1, (int)((double)r.height * 0.72));
            g.setClip(bkp);
            g.clipRect(esq + 1, 0, dir - 1, r.height);
            g.drawString(this.getTransValor().replaceAll("\n", " | "), esq + this.Criador.espaco * 2 + 1, (int)((double)r.height * 0.72));
            g.setClip(bkp);
        } else {
            g.setColor(Color.BLACK);
            g.drawRoundRect(0, 0, r.width - 1, r.height - 1, 10, 10);
            g.drawLine(esq, 0, esq, r.height - 1);
            Rectangle bkp = g.getClipBounds();
            g.setFont(new Font(this.getFont().getFontName(), 1, this.getFont().getSize()));
            g.clipRect(0, 0, esq - 1, r.height);
            g.setColor(Color.BLACK);
            this.getCorParaTexto(g);
            g.drawString(this.getTexto(), this.Criador.espaco * 2 + 1, (int)((double)r.height * 0.72));
            g.setClip(bkp);
        }
    }

    public JComponent getOndeEditar() {
        return this.ondeEditar;
    }

    public void setOndeEditar(JComponent ondeEditar) {
        if (this.ondeEditar != null) {
            this.remove(ondeEditar);
        }
        this.ondeEditar = ondeEditar;
    }

    public InspectorProperty getPropriedade() {
        return this.propriedade;
    }

    public void setPropriedade(InspectorProperty propriedade) {
        this.propriedade = propriedade;
        this.setCanEdit(true);
        if (this.Criador.getEditor().isMostrarTooltips()) {
            this.setToolTipText(this.getTransValor());
        }
    }

    public String getTexto() {
        if (this.propriedade == null) {
            return "";
        }
        return this.propriedade.caption;
    }

    public String getTransValor() {
        if (this.propriedade == null) {
            return "";
        }
        return this.Traduza(this.propriedade.valor_string);
    }

    public String getValor() {
        if (this.propriedade == null) {
            return "";
        }
        return this.propriedade.valor_string;
    }

    public void setValor(String valor) {
        if (this.propriedade == null) {
            return;
        }
        this.propriedade.valor_string = valor;
    }

    public void setFalhou(boolean b) {
        if (this.falhou != b) {
            this.falhou = b;
            this.repaint();
        }
    }

    public int getTag() {
        return this.propriedade.getTag();
    }

    public void setTag(int tag) {
        this.propriedade.setTag(tag);
    }

    public String Traduza(String texto) {
        return texto;
    }

    public static InspectorItemBase SuperFactory(Inspector principal, InspectorProperty pprt) {
        InspectorItemBase ib = null;
        if (pprt.tipo == InspectorProperty.TipoDeProperty.tpNothing) {
            return null;
        }
        switch (pprt.tipo) {
            case tpBooleano: {
                ib = new InspectorItemSN(principal);
                break;
            }
            case tpCor: {
                ib = new InspectorItemCor(principal);
                break;
            }
            case tpTextoLongo: {
                ib = new InspectorItemExtender(principal, InspectorExtenderEditor.TipoDeAcao.tpAcaoDlgTexto);
                break;
            }
            case tpApenasLeituraTexto: {
                ib = new InspectorItemExtender(principal, InspectorExtenderEditor.TipoDeAcao.tpReadOnlyTexto);
                break;
            }
            case tpApenasLeituraCor: {
                ib = new InspectorItemExtender(principal, InspectorExtenderEditor.TipoDeAcao.tpReadOnlyCor);
                break;
            }
            case tpSelecObject: {
                ib = new InspectorItemExtender(principal, InspectorExtenderEditor.TipoDeAcao.tpAcaoSelectObj);
                break;
            }
            case tpCommand: {
                ib = new InspectorItemExtender(principal, InspectorExtenderEditor.TipoDeAcao.tpAcaoCommand);
                break;
            }
            case tpSeparador: {
                ib = new InspectorItemSeparador(principal);
                break;
            }
            case tpMenu: {
                ib = new InspectorItemMenu(principal);
                break;
            }
            default: {
                ib = new InspectorItemTexto(principal);
            }
        }
        ib.setPropriedade(pprt);
        return ib;
    }

    protected void performGroupSelect() {
    }

    public void RefreshGrupoCanEdit() {
        if (this.propriedade.agrupada == null || !this.CanEdit()) {
            return;
        }
        this.Criador.MakeCanEditGrupo(this);
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void setArea(Rectangle area) {
        this.area = area;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isMouseDown) {
            this.isMouseDown = false;
        }
        super.mouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        int X = e.getX();
        if (this.isMouseDown) {
            this.Caucule(X);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.Criador.PerformSelect(this);
        if (this.area != null && this.area.contains(e.getPoint())) {
            this.isMouseDown = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (this.area != null && this.area.contains(e.getPoint())) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void Caucule(int movido) {
        if (movido > this.getWidth() - 20) {
            movido = this.getWidth() - 20;
        }
        if (movido < 20) {
            movido = 20;
        }
        double x = (double)movido / (double)this.getWidth();
        this.Criador.setDivisor(x);
    }
}

