/*
 * Decompiled with CFR 0.152.
 */
package controlador.conversor;

import controlador.BaseControlador;
import controlador.Diagrama;
import controlador.conversor.conversorOpcoes;
import desenho.FormaElementar;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class conversorDrawer
extends BaseControlador {
    public ButtonGroup Grp = null;
    private BufferedImage toPaint = null;
    private Diagrama origem = null;
    private Diagrama destino = null;
    private final ArrayList<JRadioButton> listaRD = new ArrayList();

    public conversorDrawer() {
        this.doInit();
    }

    private void doInit() {
        this.setBackground(Color.WHITE);
        this.setLayout(new BoxLayout(this, 3));
    }

    @Override
    protected void paintComponent(Graphics grphcs) {
        super.paintComponent(grphcs);
        Rectangle r = this.getBounds();
        Graphics2D g = (Graphics2D)grphcs;
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.3f));
        if (this.toPaint != null) {
            g.drawImage((Image)this.toPaint, r.width - this.toPaint.getWidth(), r.height - this.toPaint.getHeight(), null);
        }
        g.setPaint(Color.BLACK);
        int dist = 0;
        int w = this.getWidth() - dist;
        int h = this.getHeight() - dist;
        int L = 0;
        int T = 0;
        boolean dv = false;
        GradientPaint GP = new GradientPaint(L, T, Color.WHITE, dv ? (float)L : (float)(L + w), dv ? (float)(T + h) : (float)T, Color.DARK_GRAY, true);
        g.setPaint(GP);
        r = new Rectangle(r.x, r.y, r.width, r.height);
        g.fill(r);
        g.setComposite(originalComposite);
    }

    public void setDiagramas(Diagrama origem, Diagrama destino) {
        this.origem = origem;
        this.destino = destino;
    }

    public void setObjAtivo(FormaElementar obj, BufferedImage dig_img) {
        if (obj == null) {
            this.toPaint = null;
        } else {
            Rectangle r = obj.getBounds();
            int x = Math.max(0, r.x - 50);
            int y = Math.max(0, r.y - 50);
            int w = this.getWidth() / 2;
            int h = this.getHeight() / 2;
            BufferedImage tmp = dig_img;
            if (x + w > tmp.getWidth()) {
                w -= x + w - tmp.getWidth();
            }
            if (y + h > tmp.getHeight()) {
                h -= y + h - tmp.getHeight();
            }
            this.toPaint = tmp.getSubimage(x, y, w, h);
        }
        this.repaint();
    }

    public void Escreve(conversorOpcoes Opcoes) {
        this.Grp = new ButtonGroup();
        Opcoes.Textos.forEach(s -> {
            JLabel lbl = new JLabel((String)s);
            lbl.setFont(new Font(lbl.getFont().getName(), 1, lbl.getFont().getSize()));
            this.add(lbl);
        });
        this.add(new JLabel(" "));
        Opcoes.Questoes.forEach(s -> {
            JRadioButton rd = new JRadioButton((String)s);
            rd.setOpaque(false);
            int i = this.listaRD.size();
            this.Grp.add(rd);
            this.listaRD.add(rd);
            this.add(rd);
            if (Opcoes.Disables.indexOf(i) > -1) {
                rd.setEnabled(false);
            }
            if (i == Opcoes.opcDefault) {
                rd.setSelected(true);
            }
        });
        if (Opcoes.Observacoes.size() > 0) {
            this.add(new JLabel("Observa\u00e7\u00e3o:"));
        }
        Opcoes.Observacoes.forEach(s -> this.add(new JLabel((String)s)));
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.listaRD.size(); ++i) {
            if (!this.listaRD.get(i).isSelected()) continue;
            return i;
        }
        return -1;
    }
}

