/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.HashMap;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.pattern.ReplacementFormatUtil;
import org.jfugue.theory.Chord;
import org.staccato.Preprocessor;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;

public class BrokenChordPreprocessor
implements Preprocessor {
    private static BrokenChordPreprocessor instance;

    public static BrokenChordPreprocessor getInstance() {
        if (instance == null) {
            instance = new BrokenChordPreprocessor();
        }
        return instance;
    }

    @Override
    public String preprocess(String incomingString, StaccatoParserContext context) {
        String[] splitsville;
        StringBuilder retVal = new StringBuilder();
        for (String s : splitsville = incomingString.split(" ")) {
            int posColon = 0;
            posColon = s.indexOf(58);
            if (posColon != -1 && posColon > 0) {
                String candidateChord = s.substring(0, posColon);
                if (Chord.isValidChord(candidateChord)) {
                    String dynamics;
                    Chord chord = new Chord(candidateChord);
                    int posColon2 = StaccatoUtil.findNextOrEnd(s, ':', posColon + 1);
                    String replacementDescription = s.substring(posColon + 1, posColon2);
                    String string = dynamics = posColon2 == s.length() ? "" : s.substring(posColon2 + 1, s.length());
                    if (replacementDescription.charAt(0) == '[') {
                        String replacementLookup = replacementDescription.substring(1, replacementDescription.length() - 1);
                        replacementDescription = (String)context.getDictionary().get(replacementLookup);
                    }
                    HashMap<String, PatternProducer> specialReplacers = new HashMap<String, PatternProducer>();
                    specialReplacers.put("ROOT", chord.getRoot());
                    specialReplacers.put("BASS", chord.getBassNote());
                    specialReplacers.put("NOTROOT", this.wrapInParens(chord.getPatternWithNotesExceptRoot()));
                    specialReplacers.put("NOTBASS", this.wrapInParens(chord.getPatternWithNotesExceptBass()));
                    Pattern result = ReplacementFormatUtil.replaceDollarsWithCandidates(replacementDescription, chord.getNotes(), this.wrapInParens(chord.getPatternWithNotes()), specialReplacers, ",", " ", dynamics);
                    retVal.append(result.toString());
                } else {
                    retVal.append(s);
                }
            } else {
                retVal.append(s);
            }
            retVal.append(" ");
        }
        return retVal.toString().trim();
    }

    private Pattern wrapInParens(Pattern s) {
        return new Pattern("(" + s.toString() + ")");
    }
}

