/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.theory;

import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.provider.NoteProviderFactory;
import org.staccato.DefaultNoteSettingsManager;
import org.staccato.NoteSubparser;

public class Note
implements PatternProducer {
    private byte value;
    private double duration;
    private boolean wasOctaveExplicitlySet;
    private boolean wasDurationExplicitlySet;
    private byte onVelocity;
    private byte offVelocity;
    private boolean isRest;
    private boolean isStartOfTie;
    private boolean isEndOfTie;
    private boolean isFirstNote = true;
    private boolean isMelodicNote;
    private boolean isHarmonicNote;
    private boolean isPercussionNote;
    public String originalString;
    public static final String[] NOTE_NAMES_COMMON = new String[]{"C", "C#", "D", "Eb", "E", "F", "F#", "G", "G#", "A", "Bb", "B"};
    public static final String[] NOTE_NAMES_SHARP = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    public static final String[] NOTE_NAMES_FLAT = new String[]{"C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B"};
    public static final String[] PERCUSSION_NAMES = new String[]{"ACOUSTIC_BASS_DRUM", "BASS_DRUM", "SIDE_STICK", "ACOUSTIC_SNARE", "HAND_CLAP", "ELECTRIC_SNARE", "LO_FLOOR_TOM", "CLOSED_HI_HAT", "HIGH_FLOOR_TOM", "PEDAL_HI_HAT", "LO_TOM", "OPEN_HI_HAT", "LO_MID_TOM", "HI_MID_TOM", "CRASH_CYMBAL_1", "HI_TOM", "RIDE_CYMBAL_1", "CHINESE_CYMBAL", "RIDE_BELL", "TAMBOURINE", "SPLASH_CYMBAL", "COWBELL", "CRASH_CYMBAL_2", "VIBRASLAP", "RIDE_CYMBAL_2", "HI_BONGO", "LO_BONGO", "MUTE_HI_CONGA", "OPEN_HI_CONGA", "LO_CONGA", "HI_TIMBALE", "LO_TIMBALE", "HI_AGOGO", "LO_AGOGO", "CABASA", "MARACAS", "SHORT_WHISTLE", "LONG_WHISTLE", "SHORT_GUIRO", "LONG_GUIRO", "CLAVES", "HI_WOOD_BLOCK", "LO_WOOD_BLOCK", "MUTE_CUICA", "OPEN_CUICA", "MUTE_TRIANGLE", "OPEN_TRIANGLE"};
    public static final Note REST = new Note(0).setRest(true);
    public static final byte OCTAVE = 12;
    public static final byte MIN_OCTAVE = 0;
    public static final byte MAX_OCTAVE = 10;

    public Note() {
        this.onVelocity = DefaultNoteSettingsManager.getInstance().getDefaultOnVelocity();
        this.offVelocity = DefaultNoteSettingsManager.getInstance().getDefaultOffVelocity();
    }

    public Note(String note) {
        this(NoteProviderFactory.getNoteProvider().createNote(note));
    }

    public Note(Note note) {
        this.value = note.value;
        this.duration = note.duration;
        this.wasOctaveExplicitlySet = note.wasOctaveExplicitlySet;
        this.wasDurationExplicitlySet = note.wasDurationExplicitlySet;
        this.onVelocity = note.onVelocity;
        this.offVelocity = note.offVelocity;
        this.isRest = note.isRest;
        this.isStartOfTie = note.isStartOfTie;
        this.isEndOfTie = note.isEndOfTie;
        this.isFirstNote = note.isFirstNote;
        this.isMelodicNote = note.isMelodicNote;
        this.isHarmonicNote = note.isHarmonicNote;
        this.isPercussionNote = note.isPercussionNote;
        this.originalString = note.originalString;
    }

    public Note(int value) {
        this((byte)value);
    }

    public Note(byte value) {
        this();
        this.value = value;
        this.setOctaveExplicitlySet(false);
        this.useDefaultDuration();
    }

    public Note(int value, double duration) {
        this((byte)value, duration);
    }

    public Note(byte value, double duration) {
        this();
        this.value = value;
        this.setDuration(duration);
    }

    public Note setValue(byte value) {
        this.value = value;
        return this;
    }

    public byte getValue() {
        return this.isRest() ? (byte)0 : this.value;
    }

    public Note changeValue(int delta) {
        this.setValue((byte)(this.getValue() + delta));
        return this;
    }

    public Note setOctaveExplicitlySet(boolean set) {
        this.wasOctaveExplicitlySet = set;
        return this;
    }

    public byte getOctave() {
        return this.isRest() ? (byte)0 : (byte)(this.getValue() / 12);
    }

    public double getDuration() {
        return this.duration;
    }

    public Note setDuration(double d) {
        this.duration = d;
        this.wasDurationExplicitlySet = true;
        return this;
    }

    public Note useDefaultDuration() {
        this.duration = DefaultNoteSettingsManager.getInstance().getDefaultDuration();
        return this;
    }

    public Note useSameDurationAs(Note note2) {
        this.duration = note2.duration;
        this.wasDurationExplicitlySet = note2.wasDurationExplicitlySet;
        return this;
    }

    public Note useSameExplicitOctaveSettingAs(Note note2) {
        this.wasOctaveExplicitlySet = note2.wasOctaveExplicitlySet;
        return this;
    }

    public Note setDuration(String duration) {
        return this.setDuration(NoteProviderFactory.getNoteProvider().getDurationForString(duration));
    }

    public boolean isDurationExplicitlySet() {
        return this.wasDurationExplicitlySet;
    }

    public boolean isOctaveExplicitlySet() {
        return this.wasOctaveExplicitlySet;
    }

    public Note setImplicitDurationForTestingOnly(double d) {
        this.duration = d;
        return this;
    }

    public Note setRest(boolean rest) {
        this.isRest = rest;
        return this;
    }

    public boolean isRest() {
        return this.isRest;
    }

    public Note setPercussionNote(boolean perc) {
        this.isPercussionNote = perc;
        return this;
    }

    public boolean isPercussionNote() {
        return this.isPercussionNote;
    }

    public Note setOnVelocity(byte velocity) {
        this.onVelocity = velocity;
        return this;
    }

    public byte getOnVelocity() {
        return this.onVelocity;
    }

    public Note setOffVelocity(byte velocity) {
        this.offVelocity = velocity;
        return this;
    }

    public byte getOffVelocity() {
        return this.offVelocity;
    }

    public Note setStartOfTie(boolean isStartOfTie) {
        this.isStartOfTie = isStartOfTie;
        return this;
    }

    public Note setEndOfTie(boolean isEndOfTie) {
        this.isEndOfTie = isEndOfTie;
        return this;
    }

    public boolean isStartOfTie() {
        return this.isStartOfTie;
    }

    public boolean isEndOfTie() {
        return this.isEndOfTie;
    }

    public Note setFirstNote(boolean isFirstNote) {
        this.isFirstNote = isFirstNote;
        return this;
    }

    public boolean isFirstNote() {
        return this.isFirstNote;
    }

    public Note setMelodicNote(boolean isMelodicNote) {
        this.isMelodicNote = isMelodicNote;
        return this;
    }

    public boolean isMelodicNote() {
        return this.isMelodicNote;
    }

    public Note setHarmonicNote(boolean isHarmonicNote) {
        this.isHarmonicNote = isHarmonicNote;
        return this;
    }

    public boolean isHarmonicNote() {
        return this.isHarmonicNote;
    }

    public Note setOriginalString(String originalString) {
        this.originalString = originalString;
        return this;
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public double getMicrosecondDuration(double mpq) {
        return this.duration * 4.0 * mpq;
    }

    public byte getPositionInOctave() {
        return this.isRest() ? (byte)0 : (byte)(this.getValue() % 12);
    }

    public static boolean isSameNote(String note1, String note2) {
        if (note1.equalsIgnoreCase(note2)) {
            return true;
        }
        for (int i = 0; i < NOTE_NAMES_COMMON.length; ++i) {
            if (note1.equalsIgnoreCase(NOTE_NAMES_FLAT[i]) && note2.equalsIgnoreCase(NOTE_NAMES_SHARP[i])) {
                return true;
            }
            if (!note1.equalsIgnoreCase(NOTE_NAMES_SHARP[i]) || !note2.equalsIgnoreCase(NOTE_NAMES_FLAT[i])) continue;
            return true;
        }
        return false;
    }

    public static void sortNotesBy(Note[] notes, SortingCallback callback) {
        for (int i = 0; i < notes.length - 1; ++i) {
            for (int j = 1; j < notes.length - i; ++j) {
                if (callback.getSortingValue(notes[j - 1]) <= callback.getSortingValue(notes[j])) continue;
                Note temp = notes[j - 1];
                notes[j - 1] = notes[j];
                notes[j] = temp;
            }
        }
    }

    public static Note createRest(double duration) {
        return new Note().setRest(true).setDuration(duration);
    }

    public static String getToneString(byte noteValue) {
        StringBuilder buddy = new StringBuilder();
        buddy.append(Note.getToneStringWithoutOctave(noteValue));
        buddy.append(noteValue / 12);
        return buddy.toString();
    }

    public static String getToneStringWithoutOctave(byte noteValue) {
        return NOTE_NAMES_COMMON[noteValue % 12];
    }

    public static String getDispositionedToneStringWithoutOctave(int dispose, byte noteValue) {
        if (dispose == -1) {
            return NOTE_NAMES_FLAT[noteValue % 12];
        }
        return NOTE_NAMES_SHARP[noteValue % 12];
    }

    public static String getPercussionString(byte noteValue) {
        StringBuilder buddy = new StringBuilder();
        buddy.append("[");
        buddy.append(PERCUSSION_NAMES[noteValue - 35]);
        buddy.append("]");
        return buddy.toString();
    }

    public static double getFrequencyForNote(String note) {
        return note.toUpperCase().startsWith("R") ? 0.0 : Note.getFrequencyForNote(NoteProviderFactory.getNoteProvider().createNote(note).getValue());
    }

    public static double getFrequencyForNote(int noteValue) {
        return Note.truncateTo3DecimalPlaces(Note.getPreciseFrequencyForNote(noteValue));
    }

    private static double truncateTo3DecimalPlaces(double preciseNumber) {
        return Math.rint(preciseNumber * 10000.0) / 10000.0;
    }

    private static double getPreciseFrequencyForNote(int noteValue) {
        return Note.getFrequencyAboveBase(8.1757989156, (double)noteValue / 12.0);
    }

    private static double getFrequencyAboveBase(double baseFrequency, double octavesAboveBase) {
        return baseFrequency * Math.pow(2.0, octavesAboveBase);
    }

    public static boolean isValidNote(String candidateNote) {
        return NoteSubparser.getInstance().matches(candidateNote);
    }

    public static boolean isValidQualifier(String candidateQualifier) {
        return true;
    }

    public static String getDurationString(double decimalDuration) {
        double originalDecimalDuration = decimalDuration;
        StringBuilder buddy = new StringBuilder();
        if (decimalDuration >= 1.0) {
            int numWholeDurations = (int)Math.floor(decimalDuration);
            buddy.append("w");
            if (numWholeDurations > 1) {
                buddy.append(numWholeDurations);
            }
            decimalDuration -= (double)numWholeDurations;
        }
        if (decimalDuration == 0.75) {
            buddy.append("h.");
        } else if (decimalDuration == 0.5) {
            buddy.append("h");
        } else if (decimalDuration == 0.375) {
            buddy.append("q.");
        } else if (decimalDuration == 0.25) {
            buddy.append("q");
        } else if (decimalDuration == 0.1875) {
            buddy.append("i.");
        } else if (decimalDuration == 0.125) {
            buddy.append("i");
        } else if (decimalDuration == 0.09375) {
            buddy.append("s.");
        } else if (decimalDuration == 0.0625) {
            buddy.append("s");
        } else if (decimalDuration == 0.046875) {
            buddy.append("t.");
        } else if (decimalDuration == 0.03125) {
            buddy.append("t");
        } else if (decimalDuration == 0.0234375) {
            buddy.append("x.");
        } else if (decimalDuration == 0.015625) {
            buddy.append("x");
        } else if (decimalDuration == 0.01171875) {
            buddy.append("o.");
        } else if (decimalDuration == 0.0078125) {
            buddy.append("o");
        } else if (decimalDuration != 0.0) {
            return "/" + originalDecimalDuration;
        }
        return buddy.toString();
    }

    public static String getDurationStringForBeat(int beat) {
        switch (beat) {
            case 2: {
                return "h";
            }
            case 4: {
                return "q";
            }
            case 8: {
                return "i";
            }
            case 16: {
                return "s";
            }
        }
        return "/" + 1.0 / (double)beat;
    }

    public String getVelocityString() {
        StringBuilder buddy = new StringBuilder();
        if (this.onVelocity != DefaultNoteSettingsManager.getInstance().getDefaultOnVelocity()) {
            buddy.append("a" + this.getOnVelocity());
        }
        if (this.offVelocity != DefaultNoteSettingsManager.getInstance().getDefaultOffVelocity()) {
            buddy.append("d" + this.getOffVelocity());
        }
        return buddy.toString();
    }

    @Override
    public Pattern getPattern() {
        StringBuilder buddy = new StringBuilder();
        buddy.append(this.toStringWithoutDuration());
        buddy.append(this.getDecoratorString());
        return new Pattern(buddy.toString());
    }

    public Pattern getPercussionPattern() {
        if (this.getValue() < 35 || this.getValue() > 81) {
            return this.getPattern();
        }
        StringBuilder buddy = new StringBuilder();
        buddy.append(Note.getPercussionString(this.getValue()));
        buddy.append(this.getDecoratorString());
        return new Pattern(buddy.toString());
    }

    public String toString() {
        return this.getPattern().toString();
    }

    public String toStringWithoutDuration() {
        if (this.isRest()) {
            return "R";
        }
        if (this.isPercussionNote()) {
            return Note.getPercussionString(this.getValue());
        }
        return this.originalString != null ? this.originalString : Note.getToneString(this.getValue());
    }

    public String getToneString() {
        if (this.isRest) {
            return "R";
        }
        StringBuilder buddy = new StringBuilder();
        buddy.append(Note.getToneStringWithoutOctave(this.getValue()));
        if (this.wasOctaveExplicitlySet) {
            buddy.append(this.getOctave());
        }
        return buddy.toString();
    }

    public String getDecoratorString() {
        StringBuilder buddy = new StringBuilder();
        if (this.isDurationExplicitlySet()) {
            buddy.append(Note.getDurationString(this.duration));
        }
        buddy.append(this.getVelocityString());
        return buddy.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Note)) {
            return false;
        }
        Note n2 = (Note)o;
        boolean originalStringsMatchSufficientlyWell = n2.originalString == null || this.originalString == null ? true : n2.originalString.equalsIgnoreCase(this.originalString);
        return n2.value == this.value && n2.duration == this.duration && n2.wasOctaveExplicitlySet == this.wasOctaveExplicitlySet && n2.wasDurationExplicitlySet == this.wasDurationExplicitlySet && n2.isEndOfTie == this.isEndOfTie && n2.isStartOfTie == this.isStartOfTie && n2.isMelodicNote == this.isMelodicNote && n2.isHarmonicNote == this.isHarmonicNote && n2.isPercussionNote == this.isPercussionNote && n2.isFirstNote == this.isFirstNote && n2.isRest == this.isRest && n2.onVelocity == this.onVelocity && n2.offVelocity == this.offVelocity && originalStringsMatchSufficientlyWell;
    }

    public String toDebugString() {
        StringBuilder buddy = new StringBuilder();
        buddy.append("Note:");
        buddy.append(" value=").append(this.getValue());
        buddy.append(" duration=").append(this.getDuration());
        buddy.append(" wasOctaveExplicitlySet=").append(this.isOctaveExplicitlySet());
        buddy.append(" wasDurationExplicitlySet=").append(this.isDurationExplicitlySet());
        buddy.append(" isEndOfTie=").append(this.isEndOfTie());
        buddy.append(" isStartOfTie=").append(this.isStartOfTie());
        buddy.append(" isMelodicNote=").append(this.isMelodicNote());
        buddy.append(" isHarmonicNote=").append(this.isHarmonicNote());
        buddy.append(" isPercussionNote=").append(this.isPercussionNote());
        buddy.append(" isFirstNote=").append(this.isFirstNote());
        buddy.append(" isRest=").append(this.isRest());
        buddy.append(" onVelocity=").append(this.getOnVelocity());
        buddy.append(" offVelocity=").append(this.getOffVelocity());
        buddy.append(" originalString=").append(this.getOriginalString());
        return buddy.toString();
    }

    static interface SortingCallback {
        public int getSortingValue(Note var1);
    }
}

