/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.temporal;

import org.jfugue.parser.Parser;
import org.jfugue.temporal.DurationTemporalEvent;
import org.jfugue.temporal.TemporalEvent;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;

public class TemporalEvents {

    public class ChordEvent
    implements DurationTemporalEvent {
        private Chord chord;

        public ChordEvent(Chord chord) {
            this.chord = chord;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireChordParsed(this.chord);
        }

        @Override
        public double getDuration() {
            return this.chord.getNotes()[0].getDuration();
        }
    }

    public class NoteEvent
    implements DurationTemporalEvent {
        private Note note;

        public NoteEvent(Note note) {
            this.note = note;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireNoteParsed(this.note);
        }

        @Override
        public double getDuration() {
            return this.note.getDuration();
        }
    }

    public class UserEvent
    implements TemporalEvent {
        private String id;
        private Object message;

        public UserEvent(String id, Object message) {
            this.id = id;
            this.message = message;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireFunctionParsed(this.id, this.message);
        }
    }

    public class MarkerEvent
    implements TemporalEvent {
        private String marker;

        public MarkerEvent(String marker) {
            this.marker = marker;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireMarkerParsed(this.marker);
        }
    }

    public class LyricEvent
    implements TemporalEvent {
        private String lyric;

        public LyricEvent(String lyric) {
            this.lyric = lyric;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireLyricParsed(this.lyric);
        }
    }

    public class ControllerEvent
    implements TemporalEvent {
        private byte controller;
        private byte value;

        public ControllerEvent(byte controller, byte value) {
            this.controller = controller;
            this.value = value;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireControllerEventParsed(this.controller, this.value);
        }
    }

    public class SystemExclusiveEvent
    implements TemporalEvent {
        private byte[] bytes;

        public SystemExclusiveEvent(byte ... bytes) {
            this.bytes = bytes;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireSystemExclusiveParsed(this.bytes);
        }
    }

    public class PolyphonicPressureEvent
    implements TemporalEvent {
        private byte key;
        private byte pressure;

        public PolyphonicPressureEvent(byte key, byte pressure) {
            this.key = key;
            this.pressure = pressure;
        }

        @Override
        public void execute(Parser parser) {
            parser.firePolyphonicPressureParsed(this.key, this.pressure);
        }
    }

    public class ChannelPressureEvent
    implements TemporalEvent {
        private byte pressure;

        public ChannelPressureEvent(byte pressure) {
            this.pressure = pressure;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireChannelPressureParsed(this.pressure);
        }
    }

    public class PitchWheelEvent
    implements TemporalEvent {
        private byte lsb;
        private byte msb;

        public PitchWheelEvent(byte lsb, byte msb) {
            this.lsb = lsb;
            this.msb = msb;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireKeySignatureParsed(this.lsb, this.msb);
        }
    }

    public class BarEvent
    implements TemporalEvent {
        private long barId;

        public BarEvent(long barId) {
            this.barId = barId;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireBarLineParsed(this.barId);
        }
    }

    public class TimeSignatureEvent
    implements TemporalEvent {
        private byte numerator;
        private byte powerOfTwo;

        public TimeSignatureEvent(byte numerator, byte powerOfTwo) {
            this.numerator = numerator;
            this.powerOfTwo = powerOfTwo;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireTimeSignatureParsed(this.numerator, this.powerOfTwo);
        }
    }

    public class KeySignatureEvent
    implements TemporalEvent {
        private byte key;
        private byte scale;

        public KeySignatureEvent(byte key, byte scale) {
            this.key = key;
            this.scale = scale;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireKeySignatureParsed(this.key, this.scale);
        }
    }

    public class TempoEvent
    implements TemporalEvent {
        private int tempoBPM;

        public TempoEvent(int tempoBPM) {
            this.tempoBPM = tempoBPM;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireTempoChanged(this.tempoBPM);
        }
    }

    public class InstrumentEvent
    implements TemporalEvent {
        private byte instrument;

        public InstrumentEvent(byte instrument) {
            this.instrument = instrument;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireInstrumentParsed(this.instrument);
        }
    }

    public class LayerEvent
    implements TemporalEvent {
        private byte layer;

        public LayerEvent(byte layer) {
            this.layer = layer;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireLayerChanged(this.layer);
        }
    }

    public class TrackEvent
    implements TemporalEvent {
        private byte track;

        public TrackEvent(byte track) {
            this.track = track;
        }

        @Override
        public void execute(Parser parser) {
            parser.fireTrackChanged(this.track);
        }
    }
}

