/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.midi;

import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import org.jfugue.midi.TrackTimeManager;
import org.jfugue.theory.Note;

final class MidiEventManager
extends TrackTimeManager {
    private Sequence sequence;
    private Track[] track;
    private float divisionType;
    private int resolutionTicksPerBeat;
    private int tempoBeatsPerMinute;
    private float mpqn;
    private byte metronomePulse;
    private byte thirtysecondNotesPer24MidiClockSignals;
    private Logger logger = Logger.getLogger("org.jfugue");

    public MidiEventManager() {
        this.setDefaults();
    }

    public MidiEventManager(float divisionType, int resolution) {
        this.divisionType = divisionType;
        this.resolutionTicksPerBeat = resolution;
    }

    private void setDefaults() {
        this.sequence = null;
        this.track = new Track[16];
        this.divisionType = 0.0f;
        this.resolutionTicksPerBeat = 128;
        this.tempoBeatsPerMinute = 120;
        this.mpqn = 500000.0f;
        this.metronomePulse = (byte)24;
        this.thirtysecondNotesPer24MidiClockSignals = (byte)8;
    }

    public void reset() throws InvalidMidiDataException {
        this.setDefaults();
        this.sequence = new Sequence(this.divisionType, this.resolutionTicksPerBeat);
        this.createTrack((byte)0);
        this.tempoBeatsPerMinute = 120;
    }

    @Override
    protected void createTrack(byte track) {
        super.createTrack(track);
        this.track[track] = this.sequence.createTrack();
    }

    public void setDivisionType(float divisionType) {
        this.divisionType = divisionType;
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public void setResolution(int resolution) {
        this.resolutionTicksPerBeat = resolution;
    }

    public void setTempo(int tempoBPM) {
        this.tempoBeatsPerMinute = tempoBPM;
        this.mpqn = 60000000 / tempoBPM;
        byte[] bytes = new byte[]{(byte)((int)this.mpqn >> 16), (byte)((int)this.mpqn >> 8), (byte)this.mpqn};
        this.addMetaMessage(81, bytes);
    }

    public void setTimeSignature(byte beatsPerMeasure, byte durationForBeat) {
        byte d2 = (byte)(Math.log(durationForBeat) / Math.log(2.0));
        this.addMetaMessage(88, new byte[]{beatsPerMeasure, d2, this.getMetronomePulse(), this.get32ndNotesPer24MidiClockSignals()});
    }

    public void setMetronomePulse(byte metronomePulse) {
        this.metronomePulse = metronomePulse;
    }

    public byte getMetronomePulse() {
        return this.metronomePulse;
    }

    public void set32ndNotesPer24MidiClockSignals(byte t) {
        this.thirtysecondNotesPer24MidiClockSignals = t;
    }

    public byte get32ndNotesPer24MidiClockSignals() {
        return this.thirtysecondNotesPer24MidiClockSignals;
    }

    public void setSequenceResolution(float divisionType, int resolution) {
        this.setDivisionType(divisionType);
        this.setResolution(resolution);
    }

    public float getSequenceDivisionType() {
        return this.divisionType;
    }

    public int getSequenceResolution() {
        return this.resolutionTicksPerBeat;
    }

    public void finishSequence() {
        MetaMessage message = new MetaMessage();
        try {
            message.setMessage(47, null, 0);
            for (byte i = 0; i < this.getLastCreatedTrackNumber(); i = (byte)(i + 1)) {
                if (this.track[i] == null) continue;
                this.track[i].add(new MidiEvent(message, this.convertBeatsToTicks(this.getLatestTrackBeatTime(i))));
            }
        }
        catch (InvalidMidiDataException e) {
            this.logger.warning(e.getMessage());
        }
    }

    public Track getCurrentTrack() {
        if (this.track[this.getCurrentTrackNumber()] == null) {
            this.track[this.getCurrentTrackNumber()] = this.sequence.createTrack();
        }
        return this.track[this.getCurrentTrackNumber()];
    }

    public void addMetaMessage(int type, byte[] bytes) {
        try {
            MetaMessage message = new MetaMessage();
            message.setMessage(type, bytes, bytes.length);
            MidiEvent event = new MidiEvent(message, this.convertBeatsToTicks(this.getTrackBeatTime()));
            this.getCurrentTrack().add(event);
        }
        catch (InvalidMidiDataException e) {
            this.logger.warning(e.getMessage());
        }
    }

    public void addSystemExclusiveEvent(byte[] bytes) {
        try {
            SysexMessage message = new SysexMessage();
            message.setMessage(bytes, bytes.length);
            MidiEvent event = new MidiEvent(message, this.convertBeatsToTicks(this.getTrackBeatTime()));
            this.getCurrentTrack().add(event);
        }
        catch (InvalidMidiDataException e) {
            this.logger.warning(e.getMessage());
        }
    }

    public void addEvent(int command, int data1) {
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(command, this.getCurrentTrackNumber(), data1);
            this.getCurrentTrack().add(new MidiEvent(message, this.convertBeatsToTicks(this.getTrackBeatTime())));
        }
        catch (InvalidMidiDataException e) {
            this.logger.warning(e.getMessage());
        }
    }

    public void addEvent(int command, int data1, int data2) {
        try {
            this.getCurrentTrack().add(new MidiEvent(this.createShortMessage(command, data1, data2), this.convertBeatsToTicks(this.getTrackBeatTime())));
        }
        catch (InvalidMidiDataException e) {
            this.logger.warning(e.getMessage());
        }
    }

    private ShortMessage createShortMessage(int status, int data1, int data2) throws InvalidMidiDataException {
        ShortMessage message = new ShortMessage();
        message.setMessage(status, this.getCurrentTrackNumber(), data1, data2);
        return message;
    }

    public void addNote(Note note) {
        if (note.getDuration() == 0.0) {
            note.useDefaultDuration();
        }
        if (note.isFirstNote()) {
            this.setInitialNoteBeatTimeForHarmonicNotes(this.getTrackBeatTime());
        }
        if (note.isHarmonicNote()) {
            this.setTrackBeatTime(this.getInitialNoteBeatTimeForHarmonicNotes());
        }
        if (note.isRest()) {
            this.advanceTrackBeatTime(note.getDuration());
            return;
        }
        if (!note.isEndOfTie()) {
            this.addEvent(144, note.getValue(), note.getOnVelocity());
        }
        this.advanceTrackBeatTime(note.getDuration());
        if (!note.isStartOfTie()) {
            this.addEvent(128, note.getValue(), note.getOffVelocity());
        }
    }

    private long convertBeatsToTicks(double beats) {
        return (long)((double)this.resolutionTicksPerBeat * beats * 4.0);
    }

    public Sequence getSequence() {
        return this.sequence;
    }
}

