/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.integration;

import org.jfugue.integration.LilyPondNoteDurationHelper;
import org.jfugue.theory.Note;

class NoteWindow {
    private Note currentNote = null;
    private Note previousNote = null;
    private Note secondPreviousNote = null;
    private StringBuffer currentNoteLy = new StringBuffer();
    private String currentNoteDuration = null;
    private String previousNoteLy = null;
    private String previousNoteDuration = null;
    private String secondPreviousNoteLy = null;
    private String secondPreviousNoteDuration = null;
    private int currentOctave = 4;
    private char lastNote = (char)99;
    private int lastOctave = 4;
    boolean isDebug = false;

    NoteWindow() {
    }

    void log(String message) {
        if (this.isDebug) {
            System.out.println(message);
        }
    }

    void empty() {
        this.secondPreviousNote = null;
        this.previousNote = null;
    }

    void emptyAll() {
        this.secondPreviousNote = null;
        this.previousNote = null;
        this.currentNote = null;
        this.currentNoteLy = new StringBuffer();
        this.currentNoteDuration = null;
    }

    void addNote(Note note) {
        this.log(note.toDebugString());
        this.secondPreviousNote = this.previousNote;
        this.secondPreviousNoteLy = this.previousNoteLy;
        this.previousNote = this.currentNote;
        this.previousNoteLy = this.currentNoteLy.toString();
        this.currentNoteLy = new StringBuffer();
        this.currentNote = note;
        if (!note.isRest()) {
            int i;
            int octaveChange;
            String firstLetter = note.originalString.substring(0, 1).toLowerCase();
            this.currentNoteLy.append(firstLetter);
            this.currentOctave = note.getOctave();
            if (note.originalString.length() > 1) {
                String secondLetter = note.originalString.substring(1, 2).toLowerCase();
                this.log("Second letter: " + secondLetter);
                if (secondLetter.equals("b")) {
                    this.currentNoteLy.append("es");
                } else if (secondLetter.equals("#")) {
                    this.currentNoteLy.append("is");
                }
            }
            if ((octaveChange = this.getOctaveChange(firstLetter.charAt(0))) > 0) {
                for (i = 0; i < octaveChange; ++i) {
                    this.log("Add octave change");
                    this.currentNoteLy.append("'");
                }
            }
            if (octaveChange < 0) {
                for (i = 0; i > octaveChange; --i) {
                    this.log("Add octave change");
                    this.currentNoteLy.append(",");
                }
            }
            this.lastNote = firstLetter.charAt(0);
        } else {
            this.currentNoteLy.append("r");
        }
        this.secondPreviousNoteDuration = this.previousNoteDuration;
        this.previousNoteDuration = this.currentNoteDuration;
        this.currentNoteDuration = LilyPondNoteDurationHelper.getDuration2(Double.toString(note.getDuration()));
    }

    void addChordOctave(Note rootNote) {
        this.log("chord rootnote: " + rootNote.toDebugString());
        this.currentOctave = rootNote.getOctave();
        this.log("Chord octave: " + this.currentOctave);
    }

    int getOctaveChange(char currentNoteChar) {
        int octaveChange = this.currentOctave - this.lastOctave;
        this.log("Current octave: " + this.currentOctave + ", last octave: " + this.lastOctave);
        int lilypondChange = 0;
        lilypondChange = this.previousNote != null && !this.previousNote.isRest() ? this.lilypondRelativeDirection(this.previousNote.originalString.toLowerCase().charAt(0), currentNoteChar) : this.lilypondRelativeDirection(this.lastNote, currentNoteChar);
        this.log("LilyPond change: " + lilypondChange);
        int jfugueChange = 0;
        jfugueChange = this.previousNote != null && !this.previousNote.isRest() ? this.jfugueOctaveChange(this.previousNote.originalString.toLowerCase().charAt(0), currentNoteChar, lilypondChange) : this.jfugueOctaveChange(this.lastNote, currentNoteChar, lilypondChange);
        this.lastOctave = this.currentOctave;
        return octaveChange += jfugueChange;
    }

    private int lilypondRelativeDirection(char firstNote, char secondNote) {
        int i;
        int curChar = firstNote;
        if (firstNote == secondNote) {
            return 0;
        }
        for (i = 1; i < 4; ++i) {
            if ((curChar = (char)(curChar + '\u0001')) > 103) {
                curChar = 97;
            }
            if (curChar != secondNote) continue;
            return i;
        }
        curChar = firstNote;
        for (i = 1; i < 4; ++i) {
            if ((curChar = (char)(curChar - 1)) < 97) {
                curChar = 103;
            }
            if (curChar != secondNote) continue;
            return -i;
        }
        return 0;
    }

    private int jfugueOctaveChange(char firstNote, char secondNote, int lilypondDirection) {
        this.log("jfugue change: firstNote: " + (char)firstNote + ", secondNote: " + secondNote);
        int curChar = firstNote;
        int steps = Math.abs(lilypondDirection) + 1;
        int i = 1;
        while (Math.abs(i) < steps) {
            if (lilypondDirection > 0) {
                if ((curChar = (char)(curChar + '\u0001')) > 103) {
                    curChar = 97;
                }
                if ((firstNote < 99 || firstNote >= 103) && curChar > 98) {
                    return -1;
                }
            } else {
                if ((curChar = (char)(curChar - '\u0001')) < 97) {
                    curChar = 103;
                }
                if (firstNote >= 99 && firstNote < 102 && curChar < 99) {
                    return 1;
                }
            }
            ++i;
        }
        return 0;
    }

    void print() {
        this.log("Note window: " + this.secondPreviousNoteLy + "&" + this.secondPreviousNoteDuration + "&" + this.previousNoteLy + "&" + this.previousNoteDuration + "&" + this.currentNoteLy + "&" + this.currentNoteDuration);
    }

    Note getCurrentNote() {
        return this.currentNote;
    }

    Note getPreviousNote() {
        return this.previousNote;
    }

    Note getSecondPreviousNote() {
        return this.secondPreviousNote;
    }

    public StringBuffer getCurrentNoteLy() {
        return this.currentNoteLy;
    }

    public String getPreviousNoteLy() {
        return this.previousNoteLy;
    }

    public String getSecondPreviousNoteLy() {
        return this.secondPreviousNoteLy;
    }

    public String getCurrentNoteDuration() {
        return this.currentNoteDuration;
    }

    public String getPreviousNoteDuration() {
        return this.previousNoteDuration;
    }

    public String getSecondPreviousNoteDuration() {
        return this.secondPreviousNoteDuration;
    }

    public int getCurrentOctave() {
        return this.currentOctave;
    }

    public void setCurrentOctave(int currentOctave) {
        this.currentOctave = currentOctave;
    }

    public char getLastNote() {
        return this.lastNote;
    }

    public void setLastNote(char lastNote) {
        this.lastNote = lastNote;
    }

    public int getLastOctave() {
        return this.lastOctave;
    }

    public void setLastOctave(int lastOctave) {
        this.lastOctave = lastOctave;
    }
}

