/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.integration;

import java.util.StringTokenizer;
import org.jfugue.integration.LilyPondNoteDurationHelper;
import org.jfugue.integration.NoteWindow;
import org.jfugue.midi.MidiDictionary;
import org.jfugue.parser.ParserListenerAdapter;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;

public class LilyPondParserListener
extends ParserListenerAdapter {
    boolean closeStaff = false;
    boolean handleChord = false;
    private boolean closeChord = false;
    private boolean handlePolyphony = false;
    private boolean closePolyphony = false;
    private NoteWindow noteWindow = new NoteWindow();
    private StringBuffer lyString = new StringBuffer(" ");
    private boolean isDebug = false;

    private void log(String message) {
        if (this.isDebug) {
            System.out.println(message);
        }
    }

    @Override
    public void onTrackChanged(byte track) {
        this.log("Track change: " + track);
        if (this.lyString.length() > 1) {
            this.save(true);
            this.handleLastNote();
            this.noteWindow.emptyAll();
            this.lyString.append("}\n");
        } else {
            this.lyString = new StringBuffer();
        }
        this.closeStaff = true;
        this.lyString.append("\\new Staff { ");
    }

    @Override
    public void onInstrumentParsed(byte instrument) {
        this.log("Instrument change");
        String id = Byte.toString(instrument);
        String instrument2 = "\\set Staff.instrumentName = \"" + MidiDictionary.INSTRUMENT_BYTE_TO_STRING.get(Byte.parseByte(id)) + "\" ";
        this.lyString.append(instrument2);
    }

    @Override
    public void onNoteParsed(Note note2) {
        this.noteWindow.addNote(note2);
        if (note2.isFirstNote()) {
            this.handleChord = false;
            if (this.handlePolyphony) {
                this.handlePolyphony = false;
            }
        } else if (note2.isHarmonicNote()) {
            this.handleChord = true;
            this.handlePolyphony = false;
        } else {
            this.handleChord = false;
            this.handlePolyphony = true;
        }
        if (this.noteWindow.getSecondPreviousNote() != null) {
            this.save(false);
        }
    }

    private void printChord(Chord chord) {
        this.log("Chord parsed: rootnote = " + chord.getRoot().getValue() + "  intervals = " + chord.getIntervals().toString() + "  duration = " + chord.getRoot().getDuration() + "  attack = " + chord.getRoot().getOnVelocity() + "  decay = " + chord.getRoot().getOffVelocity());
        this.log(chord.getPatternWithNotes().toString());
        for (Note note : chord.getNotes()) {
            this.printNote(note);
        }
    }

    private void printNote(Note note) {
        this.log(note.toDebugString());
    }

    @Override
    public void onChordParsed(Chord chord) {
        this.printChord(chord);
        this.noteWindow.addChordOctave(chord.getRoot());
        String musicString = chord.getPatternWithNotes().toString();
        String duration = LilyPondNoteDurationHelper.getDuration2(Double.toString(chord.getRoot().getDuration()));
        this.parallelNoteEvent(musicString, duration, chord.getRoot().originalString);
        this.lyString.append(">");
        this.lyString.append(duration);
        this.lyString.append(" ");
    }

    private void parallelNoteEvent(String musicString, String duration, String rootNote) {
        boolean isFirst = true;
        this.lyString.append("<");
        StringTokenizer tokenizer = new StringTokenizer(musicString, "+");
        while (tokenizer.hasMoreElements()) {
            String note = tokenizer.nextToken();
            String firstLetter = note.substring(0, 1).toLowerCase();
            this.lyString.append(firstLetter);
            if (isFirst) {
                int i;
                int octaveChange = this.noteWindow.getOctaveChange(firstLetter.charAt(0));
                if (octaveChange > 0) {
                    for (i = 0; i < octaveChange; ++i) {
                        this.log("Add octave change");
                        this.lyString.append("'");
                    }
                }
                if (octaveChange < 0) {
                    for (i = 0; i > octaveChange; --i) {
                        this.log("Add octave change");
                        this.lyString.append(",");
                    }
                }
                isFirst = false;
                this.noteWindow.setLastNote(firstLetter.charAt(0));
            }
            if (!tokenizer.hasMoreElements()) continue;
            this.lyString.append(" ");
        }
    }

    public String getLyString() {
        this.noteWindow.print();
        this.save(true);
        this.handleLastNote();
        this.lyString.append("}");
        return this.lyString.toString();
    }

    private void handleLastNote() {
        this.log("Current note: " + this.noteWindow.getCurrentNote());
        if (this.noteWindow.getCurrentNoteLy().length() > 0 && !this.closeChord) {
            this.lyString.append(this.noteWindow.getCurrentNoteLy());
        }
        if (this.noteWindow.getCurrentNoteDuration() != null && !this.closeChord) {
            this.lyString.append(this.noteWindow.getCurrentNoteDuration());
        }
        if (this.noteWindow.getCurrentNote() != null && !this.closeChord) {
            this.lyString.append(" ");
        }
        if (!this.lyString.toString().contains("new Staff")) {
            this.closeStaff = true;
            StringBuffer lyBuffer = new StringBuffer();
            lyBuffer.append("\\new Staff {");
            lyBuffer.append(this.lyString);
            this.lyString = lyBuffer;
        }
        if (this.closeChord) {
            this.closeChord = false;
            this.lyString.append(this.noteWindow.getCurrentNoteLy());
            this.lyString.append(">");
            this.lyString.append(this.noteWindow.getCurrentNoteDuration());
            this.lyString.append(" ");
        }
        if (this.closePolyphony) {
            this.lyString.append("} >> ");
        }
    }

    private void save(boolean isLastSave) {
        this.log("==> Save called, lyString before: " + this.lyString + ", last save: " + isLastSave);
        this.noteWindow.print();
        if (!isLastSave) {
            this.log("secondPreviousNote: " + this.noteWindow.getSecondPreviousNote().originalString);
            if (this.noteWindow.getSecondPreviousNote().isFirstNote() && this.noteWindow.getPreviousNote().isHarmonicNote() && !this.noteWindow.getCurrentNote().isMelodicNote()) {
                this.lyString.append("<");
                this.lyString.append(this.noteWindow.getSecondPreviousNoteLy());
                this.lyString.append(" ");
                this.closeChord = true;
            } else if (this.noteWindow.getSecondPreviousNote().isFirstNote() && this.handlePolyphony) {
                if (this.closePolyphony) {
                    this.closePolyphony = false;
                    this.lyString.append("} >>");
                }
                this.lyString.append("<< { ");
                this.closePolyphony = true;
                this.lyString.append(this.noteWindow.getSecondPreviousNoteLy());
                this.lyString.append(this.noteWindow.getSecondPreviousNoteDuration());
                if (this.noteWindow.getPreviousNote().isHarmonicNote()) {
                    this.lyString.append(" } \\\\ { ");
                }
            } else if (this.noteWindow.getSecondPreviousNote().isHarmonicNote() && this.noteWindow.getPreviousNote().isFirstNote()) {
                this.lyString.append(this.noteWindow.getSecondPreviousNoteLy());
                this.lyString.append(">");
                this.lyString.append(this.noteWindow.getPreviousNoteDuration());
                this.lyString.append(" ");
                this.closeChord = false;
            } else {
                this.lyString.append(this.noteWindow.getSecondPreviousNoteLy());
                if (!this.noteWindow.getSecondPreviousNote().isHarmonicNote()) {
                    this.lyString.append(this.noteWindow.getSecondPreviousNoteDuration());
                }
                this.lyString.append(" ");
            }
            if (this.noteWindow.getSecondPreviousNote().isStartOfTie()) {
                this.lyString.append("~ ");
            }
        }
        if (!isLastSave && this.noteWindow.getPreviousNote() != null && this.noteWindow.getPreviousNote().isFirstNote() && this.noteWindow.getCurrentNote().isHarmonicNote()) {
            this.log("We don't know yet");
            return;
        }
        if (!(this.noteWindow.getSecondPreviousNote() == null || this.noteWindow.getCurrentNote().isHarmonicNote() || this.noteWindow.getPreviousNote() == null && this.noteWindow.getCurrentNote() == null)) {
            this.lyString.append(this.noteWindow.getPreviousNoteLy());
        }
        if (this.noteWindow.getPreviousNote() != null) {
            this.log("previousnote: " + this.noteWindow.getPreviousNote().originalString);
            if (isLastSave && this.noteWindow.getPreviousNote().isFirstNote() && this.noteWindow.getCurrentNote().isHarmonicNote()) {
                this.lyString.append("<");
                this.lyString.append(this.noteWindow.getPreviousNoteLy());
                this.lyString.append(" ");
                this.closeChord = true;
            }
            if (this.noteWindow.getPreviousNote().isHarmonicNote() && this.noteWindow.getCurrentNote().isHarmonicNote()) {
                this.lyString.append(this.noteWindow.getPreviousNoteLy());
                this.lyString.append(" ");
            }
            if (this.noteWindow.getPreviousNote().isHarmonicNote() && this.noteWindow.getCurrentNote().isFirstNote()) {
                this.lyString.append(">");
                this.lyString.append(this.noteWindow.getPreviousNoteDuration());
                this.lyString.append(" ");
                this.closeChord = false;
            } else if (!this.noteWindow.getCurrentNote().isHarmonicNote()) {
                if (this.noteWindow.getSecondPreviousNote() == null) {
                    this.lyString.append(this.noteWindow.getPreviousNoteLy());
                }
                this.lyString.append(this.noteWindow.getPreviousNoteDuration());
                this.lyString.append(" ");
            }
            if (this.noteWindow.getPreviousNote().isStartOfTie()) {
                this.lyString.append("~ ");
            }
        }
        this.log("Current note not handled: " + this.noteWindow.getCurrentNoteLy());
        this.log("==> Save called, lyString after: " + this.lyString);
        this.noteWindow.empty();
    }
}

