/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.provider.KeyProviderFactory;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;
import org.staccato.FunctionSubparser;
import org.staccato.functions.ChannelPressureFunction;
import org.staccato.functions.ControllerFunction;
import org.staccato.functions.PitchWheelFunction;
import org.staccato.functions.PolyPressureFunction;
import org.staccato.functions.SysexFunction;

public class StaccatoUtil {
    public static int findNextOrEnd(String s, char charToFind, int startIndex) {
        return StaccatoUtil.findNextOrEnd(s, new char[]{charToFind}, startIndex);
    }

    public static int findNextOrEnd(String s, char[] charsToFind, int startIndex) {
        int position = Integer.MAX_VALUE;
        for (char ch : charsToFind) {
            int x = s.indexOf(ch, startIndex);
            if (x == -1 || x >= position) continue;
            position = x;
        }
        if (position == Integer.MAX_VALUE) {
            position = s.length();
        }
        return position;
    }

    public static String createTrackElement(byte track) {
        return Character.toString('V') + track;
    }

    public static String createLayerElement(byte layer) {
        return Character.toString('L') + layer;
    }

    public static String createInstrumentElement(byte instrument) {
        return Character.toString('I') + instrument;
    }

    public static String createTempoElement(int tempoBPM) {
        return Character.toString('T') + tempoBPM;
    }

    public static String createKeySignatureElement(byte notePositionInOctave, byte scale) {
        return "KEY:" + KeyProviderFactory.getKeyProvider().createKeyString(notePositionInOctave, scale);
    }

    public static String createTimeSignatureElement(byte numerator, byte powerOfTwo) {
        return "TIME:" + numerator + "/" + (int)Math.pow(2.0, powerOfTwo);
    }

    public static String createBarLineElement(long time) {
        return Character.toString('|');
    }

    public static String createTrackBeatTimeBookmarkElement(String timeBookmarkId) {
        return Character.toString('#') + timeBookmarkId;
    }

    public static String createTrackBeatTimeBookmarkRequestElement(String timeBookmarkId) {
        return Character.toString('@') + Character.toString('#') + timeBookmarkId;
    }

    public static String createTrackBeatTimeRequestElement(double time) {
        return Character.toString('@') + time;
    }

    public static String createPitchWheelElement(byte lsb, byte msb) {
        return FunctionSubparser.generateFunctionCall(PitchWheelFunction.getInstance().getNames()[0], lsb, msb);
    }

    public static String createChannelPressureElement(byte pressure) {
        return FunctionSubparser.generateFunctionCall(ChannelPressureFunction.getInstance().getNames()[0], (Object)pressure);
    }

    public static String createPolyphonicPressureElement(byte key, byte pressure) {
        return FunctionSubparser.generateFunctionCall(PolyPressureFunction.getInstance().getNames()[0], key, pressure);
    }

    public static String createSystemExclusiveElement(byte ... bytes) {
        return FunctionSubparser.generateFunctionCall(SysexFunction.getInstance().getNames()[0], bytes);
    }

    public static String createControllerEventElement(byte controller, byte value) {
        return FunctionSubparser.generateFunctionCall(ControllerFunction.getInstance().getNames()[0], controller, value);
    }

    public static String createLyricElement(String lyric) {
        return FunctionSubparser.generateParenParamIfNecessary(Character.toString('\''), lyric);
    }

    public static String createMarkerElement(String marker) {
        return FunctionSubparser.generateParenParamIfNecessary(Character.toString('#'), marker);
    }

    public static String createFunctionElement(String id, Object message) {
        return FunctionSubparser.generateFunctionCall(id, message);
    }

    public static String createNoteElement(Note note) {
        return note.getPattern().toString();
    }

    public static String createNoteElement(Note note, byte track) {
        return track == 9 ? note.getPercussionPattern().toString() : StaccatoUtil.createNoteElement(note);
    }

    public static String createChordElement(Chord chord) {
        return chord.getPattern().toString();
    }
}

