/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

public class DefaultNoteSettingsManager {
    private static DefaultNoteSettingsManager instance;
    private byte defaultOctave = (byte)5;
    private byte defaultBassOctave = (byte)4;
    private double defaultDuration = 0.25;
    private byte defaultOnVelocity = (byte)64;
    private byte defaultOffVelocity = (byte)64;
    private boolean adjustNotesByKeySignature = true;
    public static final byte DEFAULT_DEFAULT_OCTAVE = 5;
    public static final byte DEFAULT_DEFAULT_BASS_OCTAVE = 4;
    public static final double DEFAULT_DEFAULT_DURATION = 0.25;
    public static final byte DEFAULT_DEFAULT_ON_VELOCITY = 64;
    public static final byte DEFAULT_DEFAULT_OFF_VELOCITY = 64;
    public static final boolean DEFAULT_ADJUST_NOTES_BY_KEY_SIGNATURE = true;

    public static DefaultNoteSettingsManager getInstance() {
        if (instance == null) {
            instance = new DefaultNoteSettingsManager();
        }
        return instance;
    }

    private DefaultNoteSettingsManager() {
    }

    public void setDefaultOctave(byte octave) {
        assert (octave >= 0 && octave <= 10);
        this.defaultOctave = octave;
    }

    public byte getDefaultOctave() {
        return this.defaultOctave;
    }

    public void setDefaultBassOctave(byte octave) {
        assert (octave >= 0 && octave <= 10);
        this.defaultBassOctave = octave;
    }

    public byte getDefaultBassOctave() {
        return this.defaultBassOctave;
    }

    public void setDefaultDuration(double duration) {
        this.defaultDuration = duration;
    }

    public double getDefaultDuration() {
        return this.defaultDuration;
    }

    public void setDefaultOnVelocity(byte attack) {
        assert (attack >= 0 && attack <= 127);
        this.defaultOnVelocity = attack;
    }

    public byte getDefaultOnVelocity() {
        return this.defaultOnVelocity;
    }

    public void setDefaultOffVelocity(byte decay) {
        assert (decay >= 0 && decay <= 127);
        this.defaultOffVelocity = decay;
    }

    public byte getDefaultOffVelocity() {
        return this.defaultOffVelocity;
    }

    public boolean getAdjustNotesByKeySignature() {
        return this.adjustNotesByKeySignature;
    }

    public void setAdjustNotesByKeySignature(boolean b) {
        this.adjustNotesByKeySignature = b;
    }
}

