/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.realtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiUnavailableException;
import org.jfugue.midi.TrackTimeManager;
import org.jfugue.parser.ParserListener;
import org.jfugue.realtime.RealtimeInterpolator;
import org.jfugue.realtime.RealtimePlayer;
import org.jfugue.realtime.ScheduledEvent;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;

public class RealtimeMidiParserListener
extends TrackTimeManager
implements ParserListener {
    private boolean endDaemon;
    private int bpm = 120;
    private long originalClockTimeInMillis;
    private long activeTimeInMillis;
    private Map<Long, List<Command>> millisToScheduledCommands;
    private Map<Long, List<ScheduledEvent>> millisToScheduledEvents;
    private List<RealtimeInterpolator> interpolators;
    private RealtimePlayer realtimePlayer;

    public RealtimeMidiParserListener(RealtimePlayer player) throws MidiUnavailableException {
        this.realtimePlayer = player;
        this.millisToScheduledCommands = new HashMap<Long, List<Command>>();
        this.millisToScheduledEvents = new HashMap<Long, List<ScheduledEvent>>();
        this.interpolators = new ArrayList<RealtimeInterpolator>();
        this.originalClockTimeInMillis = System.currentTimeMillis();
        this.startDaemon();
    }

    private long getDeltaClockTimeInMillis() {
        return System.currentTimeMillis() - this.originalClockTimeInMillis;
    }

    public long getCurrentTime() {
        return this.getDeltaClockTimeInMillis();
    }

    private void startDaemon() {
        Runnable daemon = new Runnable(){
            private long lastMillis = 0L;

            @Override
            public void run() {
                while (!RealtimeMidiParserListener.this.endDaemon) {
                    RealtimeMidiParserListener.this.setAllTrackBeatTime(RealtimeMidiParserListener.this.getDeltaClockTimeInMillis());
                    long deltaMillis = RealtimeMidiParserListener.this.getDeltaClockTimeInMillis() - this.lastMillis;
                    if (deltaMillis > 0L) {
                        for (long time = this.lastMillis; time < this.lastMillis + deltaMillis; ++time) {
                            RealtimeMidiParserListener.this.setActiveTimeInMillis(time);
                            RealtimeMidiParserListener.this.executeScheduledCommands(time);
                            RealtimeMidiParserListener.this.executeScheduledEvents(time);
                            RealtimeMidiParserListener.this.updateInterpolators(time);
                        }
                    }
                    this.lastMillis += deltaMillis;
                }
            }
        };
        Thread t = new Thread(daemon);
        t.start();
    }

    private void executeScheduledCommands(long time) {
        if (this.millisToScheduledCommands.containsKey(time)) {
            List<Command> commands = this.millisToScheduledCommands.get(time);
            for (Command command : commands) {
                command.execute();
            }
        }
    }

    private void executeScheduledEvents(long time) {
        if (this.millisToScheduledEvents.containsKey(time)) {
            List<ScheduledEvent> scheduledEvents = this.millisToScheduledEvents.get(time);
            for (ScheduledEvent event : scheduledEvents) {
                event.execute(this.realtimePlayer, time);
            }
        }
    }

    private void updateInterpolators(long time) {
        for (RealtimeInterpolator interpolator : this.interpolators) {
            if (!interpolator.isStarted()) {
                interpolator.start(time);
            }
            if (!interpolator.isActive()) continue;
            long elapsedTime = time - interpolator.getStartTime();
            double percentComplete = elapsedTime / interpolator.getDurationInMillis();
            interpolator.update(this.realtimePlayer, elapsedTime, percentComplete);
            if (elapsedTime != interpolator.getDurationInMillis()) continue;
            interpolator.end();
        }
    }

    public void finish() {
        this.endDaemon = true;
    }

    public RealtimePlayer getRealtimePlayer() {
        return this.realtimePlayer;
    }

    private void setActiveTimeInMillis(long timeInMillis) {
        this.activeTimeInMillis = timeInMillis;
    }

    private long getNextAvailableTimeInMillis(long timeInMillis) {
        if (timeInMillis <= this.activeTimeInMillis) {
            timeInMillis += this.activeTimeInMillis + 1L;
        }
        return timeInMillis;
    }

    public void scheduleCommand(long timeInMillis, Command command) {
        List<Command> commands = this.millisToScheduledCommands.get(timeInMillis = this.getNextAvailableTimeInMillis(timeInMillis));
        if (commands == null) {
            commands = new ArrayList<Command>();
            this.millisToScheduledCommands.put(timeInMillis, commands);
        }
        commands.add(command);
    }

    public void scheduleEvent(long timeInMillis, ScheduledEvent event) {
        List<ScheduledEvent> events = this.millisToScheduledEvents.get(timeInMillis = this.getNextAvailableTimeInMillis(timeInMillis));
        if (events == null) {
            events = new ArrayList<ScheduledEvent>();
            this.millisToScheduledEvents.put(timeInMillis, events);
        }
        events.add(event);
    }

    public void unscheduleEvent(long timeInMillis, ScheduledEvent event) {
        List<ScheduledEvent> events = this.millisToScheduledEvents.get(timeInMillis);
        if (events == null) {
            return;
        }
        events.remove(event);
    }

    @Override
    public void beforeParsingStarts() {
    }

    @Override
    public void afterParsingFinished() {
    }

    @Override
    public void onTrackChanged(final byte track) {
        this.setCurrentTrack(track);
        this.scheduleCommand((long)this.getTrackBeatTime(), new Command(){

            @Override
            public void execute() {
                RealtimeMidiParserListener.this.getRealtimePlayer().changeTrack(track);
            }
        });
    }

    @Override
    public void onLayerChanged(byte layer) {
        this.setCurrentLayerNumber(layer);
    }

    @Override
    public void onInstrumentParsed(final byte instrument) {
        this.scheduleCommand((long)this.getTrackBeatTime(), new Command(){

            @Override
            public void execute() {
                RealtimeMidiParserListener.this.getRealtimePlayer().changeInstrument(instrument);
            }
        });
    }

    @Override
    public void onTempoChanged(int tempoBPM) {
        this.bpm = tempoBPM;
    }

    @Override
    public void onKeySignatureParsed(byte key, byte scale) {
    }

    @Override
    public void onTimeSignatureParsed(byte numerator, byte powerOfTwo) {
    }

    @Override
    public void onBarLineParsed(long time) {
    }

    @Override
    public void onTrackBeatTimeBookmarked(String timeBookmarkID) {
    }

    @Override
    public void onTrackBeatTimeBookmarkRequested(String timeBookmarkID) {
    }

    @Override
    public void onTrackBeatTimeRequested(double time) {
    }

    @Override
    public void onPitchWheelParsed(final byte lsb, final byte msb) {
        this.scheduleCommand((long)this.getTrackBeatTime(), new Command(){

            @Override
            public void execute() {
                RealtimeMidiParserListener.this.getRealtimePlayer().setPitchBend(lsb + (msb << 7));
            }
        });
    }

    @Override
    public void onChannelPressureParsed(final byte pressure) {
        this.scheduleCommand((long)this.getTrackBeatTime(), new Command(){

            @Override
            public void execute() {
                RealtimeMidiParserListener.this.getRealtimePlayer().changeChannelPressure(pressure);
            }
        });
    }

    @Override
    public void onPolyphonicPressureParsed(final byte key, final byte pressure) {
        this.scheduleCommand((long)this.getTrackBeatTime(), new Command(){

            @Override
            public void execute() {
                RealtimeMidiParserListener.this.getRealtimePlayer().changePolyphonicPressure(key, pressure);
            }
        });
    }

    @Override
    public void onSystemExclusiveParsed(byte ... bytes) {
    }

    @Override
    public void onControllerEventParsed(final byte controller, final byte value) {
        this.scheduleCommand((long)this.getTrackBeatTime(), new Command(){

            @Override
            public void execute() {
                RealtimeMidiParserListener.this.getRealtimePlayer().changeController(controller, value);
            }
        });
    }

    @Override
    public void onLyricParsed(String lyric) {
    }

    @Override
    public void onMarkerParsed(String marker) {
    }

    @Override
    public void onFunctionParsed(String id, Object message) {
    }

    @Override
    public void onNotePressed(Note note) {
    }

    @Override
    public void onNoteReleased(Note note) {
    }

    @Override
    public void onNoteParsed(final Note note) {
        if (note.getDuration() == 0.0) {
            note.useDefaultDuration();
        }
        if (note.isFirstNote()) {
            this.setInitialNoteBeatTimeForHarmonicNotes(this.getTrackBeatTime());
        }
        if (note.isHarmonicNote()) {
            this.setTrackBeatTime(this.getInitialNoteBeatTimeForHarmonicNotes());
        }
        if (note.isRest()) {
            this.advanceTrackBeatTime(this.convertBeatsToMillis(note.getDuration()));
            return;
        }
        if (!note.isEndOfTie()) {
            this.scheduleCommand((long)this.getTrackBeatTime(), new Command(){

                @Override
                public void execute() {
                    RealtimeMidiParserListener.this.getRealtimePlayer().startNote(note);
                }
            });
        }
        this.advanceTrackBeatTime(this.convertBeatsToMillis(note.getDuration()));
        if (!note.isStartOfTie()) {
            this.scheduleCommand((long)this.getTrackBeatTime(), new Command(){

                @Override
                public void execute() {
                    RealtimeMidiParserListener.this.getRealtimePlayer().stopNote(note);
                }
            });
        }
    }

    @Override
    public void onChordParsed(Chord chord) {
        for (Note note : chord.getNotes()) {
            this.onNoteParsed(note);
        }
    }

    public void onEventScheduled(long timeInMillis, ScheduledEvent event) {
        this.scheduleEvent(timeInMillis, event);
    }

    public void onEventUnscheduled(long timeInMillis, ScheduledEvent event) {
        this.unscheduleEvent(timeInMillis, event);
    }

    public void onInterpolatorStarted(RealtimeInterpolator interpolator, long durationInMillis) {
        interpolator.setDurationInMillis(durationInMillis);
        this.interpolators.add(interpolator);
    }

    public void onInterpolatorStopping(RealtimeInterpolator interpolator) {
        this.interpolators.remove(interpolator);
    }

    private long convertBeatsToMillis(double beats) {
        return (long)(beats / (double)this.bpm * 60000.0 * 4.0);
    }

    static interface Command {
        public void execute();
    }
}

