/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfugue.pattern.ElementWithSeparator;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;

public class ReplacementFormatUtil {
    public static Pattern replaceDollarsWithCandidates(String sequence, PatternProducer[] candidates, PatternProducer underscoreReplacement) {
        return ReplacementFormatUtil.replaceDollarsWithCandidates(sequence, candidates, underscoreReplacement, null, " ", " ", null);
    }

    public static Pattern replaceDollarsWithCandidates(String sequence, PatternProducer[] candidates, PatternProducer underscoreReplacement, Map<String, PatternProducer> specialReplacers, String inputSeparator, String outputSeparator, String finalThingToAppend) {
        StringBuilder buddy = new StringBuilder();
        int maxSpecialReplacerKeyLength = 0;
        if (specialReplacers != null) {
            for (String replacerKey : specialReplacers.keySet()) {
                if (replacerKey.length() <= maxSpecialReplacerKeyLength) continue;
                maxSpecialReplacerKeyLength = replacerKey.length();
            }
        }
        for (ElementWithSeparator elementWithSeparator : ReplacementFormatUtil.splitElementsWithSeparators(sequence)) {
            String element = elementWithSeparator.element;
            String innerSeparator = String.valueOf(elementWithSeparator.separator);
            String distributionNeeded = null;
            String appender = "";
            boolean replacementFound = false;
            if (element.startsWith("$")) {
                int indexForAppender = element.length();
                for (int len = Math.min(maxSpecialReplacerKeyLength + 1, element.length()); len > 1 && !replacementFound; --len) {
                    String selectionString = element.substring(1, len);
                    if (!specialReplacers.containsKey(selectionString)) continue;
                    distributionNeeded = specialReplacers.get(selectionString).toString();
                    indexForAppender = len;
                    replacementFound = true;
                }
                if (!replacementFound) {
                    if (element.charAt(1) >= '0' && element.charAt(1) <= '9') {
                        int index = Integer.parseInt(element.substring(1, 2));
                        distributionNeeded = candidates[index].toString();
                        indexForAppender = 2;
                        replacementFound = true;
                    } else if (element.charAt(1) == '!') {
                        distributionNeeded = underscoreReplacement.toString();
                        indexForAppender = 2;
                        replacementFound = true;
                    }
                }
                if (indexForAppender < element.length()) {
                    appender = element.substring(indexForAppender, element.length());
                    replacementFound = true;
                }
            } else {
                distributionNeeded = element;
                replacementFound = true;
            }
            if (replacementFound) {
                if (finalThingToAppend != null) {
                    appender = appender + finalThingToAppend;
                }
                ReplacementFormatUtil.distribute(buddy, distributionNeeded, appender);
            }
            buddy.append(innerSeparator.equals(",") ? " " : innerSeparator);
        }
        buddy.deleteCharAt(buddy.length() - 1);
        return new Pattern(buddy.toString());
    }

    private static void distribute(StringBuilder buddy, String elements, String appender) {
        for (String element : elements.split(" ")) {
            buddy.append(element);
            buddy.append(appender);
            buddy.append(" ");
        }
        buddy.deleteCharAt(buddy.length() - 1);
    }

    private static List<ElementWithSeparator> splitElementsWithSeparators(String sequence) {
        char[] separators = new char[]{' ', '+', '_', ','};
        ArrayList<ElementWithSeparator> retVal = new ArrayList<ElementWithSeparator>();
        int startingPos = 0;
        int cursor = 0;
        int which = -1;
        while (cursor < sequence.length()) {
            char separator;
            String element;
            if (++cursor < sequence.length()) {
                which = ReplacementFormatUtil.inWhich(sequence.charAt(cursor), separators);
                if (which == -1) continue;
                element = sequence.substring(startingPos, cursor);
                separator = separators[which];
                retVal.add(new ElementWithSeparator(element, separator));
                startingPos = cursor + 1;
                continue;
            }
            if (startingPos >= sequence.length()) continue;
            element = sequence.substring(startingPos, sequence.length());
            separator = ' ';
            retVal.add(new ElementWithSeparator(element, separator));
        }
        return retVal;
    }

    private static int inWhich(char ch, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (ch != chars[i]) continue;
            return i;
        }
        return -1;
    }
}

