/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.midi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

public class MidiTools {
    public static final Map<Long, List<MidiMessage>> sortMessagesByTick(Sequence sequence) {
        HashMap<Long, List<MidiMessage>> sortedMessages = new HashMap<Long, List<MidiMessage>>();
        for (Track track : sequence.getTracks()) {
            for (int i = 0; i < track.size(); ++i) {
                MidiEvent event = track.get(i);
                List<MidiMessage> messagesAtTick = null;
                if (sortedMessages.containsKey(event.getTick())) {
                    messagesAtTick = (List)sortedMessages.get(event.getTick());
                } else {
                    messagesAtTick = new ArrayList();
                    sortedMessages.put(event.getTick(), messagesAtTick);
                }
                messagesAtTick.add(event.getMessage());
            }
        }
        return sortedMessages;
    }

    public static <K extends Comparable<K>, V> K getLargestKey(Map<K, V> map) {
        Comparable currentLargestKey = null;
        for (Comparable key : map.keySet()) {
            if (currentLargestKey != null && key.compareTo(currentLargestKey) <= 0) continue;
            currentLargestKey = key;
        }
        return (K)currentLargestKey;
    }

    private static int calculateTicksPerSecondFromMidiSetTempoMessageData(byte[] data, float sequenceResolution) {
        int microsecondsPerQuarterNote = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
        int bpm = (int)(6.0E7 / (double)microsecondsPerQuarterNote);
        return (int)((double)(sequenceResolution * (float)bpm) / 60.0);
    }

    private static int calculateTime(long deltaTick, int ticksPerSecond) {
        return (int)((double)deltaTick * 1000.0 / (double)ticksPerSecond);
    }

    public static void sendSortedMidiMessagesToReceiver(Map<Long, List<MidiMessage>> sortedMidiMessages, float sequenceDivisionType, int sequenceResolution, Receiver receiver) {
        int ticksPerSecond;
        int bpm = 120;
        long prevTick = 0L;
        long msTime = 0L;
        long largestTick = MidiTools.getLargestKey(sortedMidiMessages);
        if (sequenceDivisionType == 0.0f) {
            ticksPerSecond = (int)((double)(sequenceResolution * bpm) / 60.0);
        } else {
            double framesPerSecond = sequenceDivisionType == 24.0f ? 24.0 : (sequenceDivisionType == 25.0f ? 25.0 : (sequenceDivisionType == 30.0f ? 30.0 : (sequenceDivisionType == 29.97f ? 29.97 : 24.0)));
            ticksPerSecond = (int)((double)sequenceResolution * framesPerSecond);
        }
        for (long tick = 0L; tick <= largestTick; ++tick) {
            if (!sortedMidiMessages.containsKey(tick)) continue;
            msTime = MidiTools.calculateTime(tick - prevTick, ticksPerSecond);
            List<MidiMessage> messages = sortedMidiMessages.get(tick);
            for (MidiMessage message : messages) {
                if (message instanceof MetaMessage && sequenceDivisionType == 0.0f && ((MetaMessage)message).getType() == 81) {
                    ticksPerSecond = MidiTools.calculateTicksPerSecondFromMidiSetTempoMessageData(((MetaMessage)message).getData(), sequenceResolution);
                    msTime = MidiTools.calculateTime(tick - prevTick, ticksPerSecond);
                    continue;
                }
                receiver.send(message, msTime);
            }
            try {
                Thread.sleep(msTime);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            prevTick = tick;
        }
    }

    public static void sendSequenceToReceiver(Sequence sequence, Receiver receiver) {
        MidiTools.sendSortedMidiMessagesToReceiver(MidiTools.sortMessagesByTick(sequence), sequence.getDivisionType(), sequence.getResolution(), receiver);
    }

    public static byte getLSB(int value) {
        return (byte)(value & 0x7F);
    }

    public static byte getMSB(int value) {
        return (byte)(value >> 7 & 0x7F);
    }
}

