/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.midi;

import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Sequence;
import org.jfugue.midi.MidiEventManager;
import org.jfugue.parser.ParserListener;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;

public class MidiParserListener
implements ParserListener {
    private MidiEventManager eventManager;
    private Logger logger = Logger.getLogger("org.jfugue");

    public MidiParserListener() {
        this.eventManager = new MidiEventManager();
    }

    public Sequence getSequence() {
        return this.eventManager.getSequence();
    }

    @Override
    public void beforeParsingStarts() {
        try {
            this.eventManager.reset();
        }
        catch (InvalidMidiDataException e) {
            this.logger.warning(e.getMessage());
        }
    }

    @Override
    public void afterParsingFinished() {
        this.eventManager.finishSequence();
    }

    @Override
    public void onTrackChanged(byte track) {
        this.eventManager.setCurrentTrack(track);
    }

    @Override
    public void onLayerChanged(byte layer) {
        this.eventManager.setCurrentLayerNumber(layer);
    }

    @Override
    public void onInstrumentParsed(byte instrument) {
        this.eventManager.addEvent(192, instrument, 0);
    }

    @Override
    public void onTempoChanged(int tempoBPM) {
        this.eventManager.setTempo(tempoBPM);
    }

    @Override
    public void onKeySignatureParsed(byte key, byte scale) {
        this.eventManager.addMetaMessage(89, new byte[]{key, scale});
    }

    @Override
    public void onTimeSignatureParsed(byte numerator, byte powerOfTwo) {
        this.eventManager.setTimeSignature(numerator, powerOfTwo);
    }

    @Override
    public void onBarLineParsed(long time) {
    }

    @Override
    public void onTrackBeatTimeBookmarked(String timeBookmarkID) {
        this.eventManager.addTrackTickTimeBookmark(timeBookmarkID);
    }

    @Override
    public void onTrackBeatTimeBookmarkRequested(String timeBookmarkID) {
        double time = this.eventManager.getTrackBeatTimeBookmark(timeBookmarkID);
        this.eventManager.setTrackBeatTime(time);
    }

    @Override
    public void onTrackBeatTimeRequested(double time) {
        this.eventManager.setTrackBeatTime(time);
    }

    @Override
    public void onPitchWheelParsed(byte lsb, byte msb) {
        this.eventManager.addEvent(224, lsb, msb);
    }

    @Override
    public void onChannelPressureParsed(byte pressure) {
        this.eventManager.addEvent(208, pressure);
    }

    @Override
    public void onPolyphonicPressureParsed(byte key, byte pressure) {
        this.eventManager.addEvent(160, key, pressure);
    }

    @Override
    public void onSystemExclusiveParsed(byte ... bytes) {
        this.eventManager.addSystemExclusiveEvent(bytes);
    }

    @Override
    public void onControllerEventParsed(byte controller, byte value) {
        this.eventManager.addEvent(176, controller, value);
    }

    @Override
    public void onLyricParsed(String lyric) {
        this.eventManager.addMetaMessage(5, lyric.getBytes());
    }

    @Override
    public void onMarkerParsed(String marker) {
        this.eventManager.addMetaMessage(6, marker.getBytes());
    }

    @Override
    public void onFunctionParsed(String id, Object message) {
    }

    @Override
    public void onNotePressed(Note note) {
    }

    @Override
    public void onNoteReleased(Note note) {
    }

    @Override
    public void onNoteParsed(Note note) {
        this.eventManager.addNote(note);
    }

    @Override
    public void onChordParsed(Chord chord) {
        for (Note note : chord.getNotes()) {
            this.eventManager.addNote(note);
        }
    }
}

