package br.com.alura.forum.controller.dto;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import br.com.alura.forum.model.StatusTopico;
import br.com.alura.forum.model.Topico;

public class TopicoDto {

	private Long id;
	private LocalDateTime data;
	private String titulo;
	private String mensagem;
	private String nomeCurso;
	private String nomeDono;
	private StatusTopico status;
	private List<RespostaDto> respostas = new ArrayList<>();

	public TopicoDto(Topico topico) {
		this.id = topico.getId();
		this.data = topico.getData();
		this.titulo = topico.getTitulo();
		this.mensagem = topico.getMensagem();
		this.nomeCurso = topico.getCurso().getNome();
		this.nomeDono = topico.getDono().getNome();
		this.status = topico.getStatus();
		this.respostas.addAll(topico.getRespostas().stream().map(RespostaDto::new).collect(Collectors.toList()));
	}

	public static List<TopicoDto> converter(List<Topico> topicos) {
		return topicos.stream().map(TopicoDto::new).collect(Collectors.toList());
	}

	// getters
	public Long getId() {
		return id;
	}

	public LocalDateTime getData() {
		return data;
	}

	public String getTitulo() {
		return titulo;
	}

	public String getMensagem() {
		return mensagem;
	}

	public String getNomeCurso() {
		return nomeCurso;
	}

	public String getNomeDono() {
		return nomeDono;
	}

	public StatusTopico getStatus() {
		return status;
	}

	public List<RespostaDto> getRespostas() {
		return respostas;
	}

}
