package br.com.alura.forum.controller.dto;

import java.time.LocalDateTime;

import br.com.alura.forum.model.Resposta;

public class RespostaDto {

	private Long id;
	private LocalDateTime data;
	private String mensagem;
	private Boolean solucao;
	private String nomeDono;

	public RespostaDto(Resposta resposta) {
		this.id = resposta.getId();
		this.data = resposta.getData();
		this.mensagem = resposta.getMensagem();
		this.solucao = resposta.getSolucao();
		this.nomeDono = resposta.getDono().getNome();
	}

	// getters
	public Long getId() {
		return id;
	}

	public LocalDateTime getData() {
		return data;
	}

	public String getMensagem() {
		return mensagem;
	}

	public Boolean getSolucao() {
		return solucao;
	}

	public String getNomeDono() {
		return nomeDono;
	}

}
