﻿/*  
//  v4 2020.MAR.24
//
//  Nifty script to adjust the space before and after
//  of quotation blocks automatically to match exact
//  line counts of the main text leading. 
//
//  SCRIPTEAM by A Academia Tipográfica
//  2020 . academiatipografica.com
//  Gustavo Soares . suporte@academiatipografica.com
//
//
//
//  SCRIPTEAM is a closed community for collective development
//  and aprenticeship of scripts for InDesign, Illustrator and Photoshop
//
//  This script is not free and must not be distributed.
//  Please respect.
//
//
//  The script started as a request from Brazilian designer Guilherme Bueno
*/



//Check for open documents
if (app.documents.length != 0) {
    

    //ref to active document
    var currentDoc = app.activeDocument;
    
    //check for valid seletion
    //must be at least 3 paragraphs (text + quotation + text)
    if (app.selection.length == 1) {
        
        //ref to selection
        var currentSelection = app.selection[0];
        var lineCount, mainLines, mainLeading, mainTotal, quotationLines, quotationLeading, quotationTotal, threshold;
        
        
        //get leading references
        //first and last paragraphs of selection must always be the main text
        mainLeading = currentSelection.paragraphs[0].leading;
        quotationLeading = currentSelection.paragraphs[1].leading;
        
        
        //initate quotationLines
        quotationLines = 0;
        
        //i = item
        
        //get total lines in quotation block
        for (var i=1; i<currentSelection.paragraphs.length-1; i++) {
            lineCount = currentSelection.paragraphs[i].lines.count();
            quotationLines = quotationLines + lineCount;   
        }
        
        
        //print line count for quotation block
        $.writeln("—————————————");
        $.writeln("Quotation lines: " + quotationLines);
        

        //consider total line count for the main block as quotation block +1
        mainLines = quotationLines +1;
        

        //define the limit of lines on the quotation block
        //this means that above this count no "fake line"
        //will be added to make space
        threshold = 10;
        

        //if the quotation block has more than 10 lines (customizable)
        //there is no need to add one like we do for fewer lines
        if (quotationLines >= threshold) {
            mainLines = quotationLines;
            
        }
        
        
        //get total count in pts for both blocks
        mainTotal = mainLines * mainLeading;
        quotationTotal = quotationLines * quotationLeading;
        
        
        //print totals
        $.writeln("Total space as main text: " + mainTotal + "pt" + " (" + mainLines + " lines)");
        $.writeln("Total space as quotation text: " + quotationTotal + "pt" + " (" + quotationLines + " lines)");
        
        
        //get the space left available
        //measured by the difference of mainTotal and quotationTotal
        var spaceAvailable = mainTotal - quotationTotal;
        
        
        //print space available and main text leading
        $.writeln("Space available: " + spaceAvailable + "pt");
        $.writeln("Main leading: " + mainLeading + "pt");
        
        
        //initiate optical compensation values
        //this will only used if the main text
        //is aligned to the baseline grid
        var compensation = 1;
        var opticalComp = 0;
            
            
        //split the difference between space before and space after
        //this should be the solution to all problems...
        var halfSpace = spaceAvailable/2;


        //initiate a variable to define if the main
        //text is aligned to the baseline grid
        //initial value is set to "no"
        var blgStatus = "no";
        

        //if main text is aligned to baseline grid
        //account for half baseline increments
        if (currentSelection.paragraphs[0].alignToBaseline == true) {

            //change baseline grid indicator to "yes"
            blgStatus = "yes";

            //account for baselines /2
            //ie. increments of 7pt instead of 14pt
            spaceAvailable = spaceAvailable - mainLeading/4;
            halfSpace = spaceAvailable/2;
            
            //redefine optical compensation
            //this is needed because of the shift
            //cause by aligning text to the baseline
            compensation = 0.2; //20%, you can customize to your typesizes
            opticalComp = halfSpace * compensation;
            
            $.writeln("Optical compensation: " + opticalComp);

         }

        
        
        //define spaceBefore and spaceAfter
        var quoteSpaceBefore = halfSpace + opticalComp;
        var quoteSpaceAfter = halfSpace - opticalComp;
        
        //sum all values to check in the end
        var sum = quoteSpaceAfter + quoteSpaceBefore + quotationTotal;
        
        
        //print final SB and SA
        $.writeln("Space Before: " + quoteSpaceBefore + "pt");
        $.writeln("Space After: " + quoteSpaceAfter + "pt");
        $.writeln("Checking: "  + quoteSpaceBefore + " + "
                                + quotationTotal + " + "
                                + quoteSpaceAfter + " = " 
                                + sum + "(" + mainTotal + ")");
        $.writeln("Main text on baseline grid: " + blgStatus);
        
        
        //apply the spaces in the quotation paragraphs
        //account for one or more
        if (currentSelection.paragraphs.length == 3) {
            
            with (currentSelection.paragraphs[1]) {
                spaceBefore = quoteSpaceBefore + "pt";
                spaceAfter = quoteSpaceAfter + "pt";
            }
        
        } else {
            //first quotation paragraph
            currentSelection.paragraphs[1].spaceBefore = quoteSpaceBefore + "pt";
            
            //last quotation paragraph
            currentSelection.paragraphs[-2].spaceAfter = quoteSpaceAfter + "pt";
        }
    

        
        //**********************************************************//
        //                       OPTIONAL                           //
        //**********************************************************//
        /*
        //
        //Uncomment and change paragraph style names
        //
        //
        //apply a no indentation p style after the quotation block
        //get a ref to the first paragraph after the quotation block
        var pAfterBlock = currentSelection.paragraphs[-1];

        
        //use this if the p style is not inside a style group
        if (blgStatus == "yes"){
            pAfterBlock.appliedParagraphStyle = currentDoc.paragraphStyles.itemByName("Main - Body BLG NI"); //change to your p style name
        }
        else {
            pAfterBlock.appliedParagraphStyle = currentDoc.paragraphStyles.itemByName("Main - Body NI"); //change to your p style name
        }
        

        //use this if the p style is inside a group
        //duplicate part of the code if inside multiple groups
        //pAfterBlock.appliedParagraphStyle = currentDoc.paragraphStyleGroups.itemByName("Main").paragraphStyles.itemByName("Body BLG NI"); //change to your group and p style name
        */
    }

    else {
        alert ("Selecione ao menos 3 parágrafos, sendo um deles o de citação");
    }    
}

else {
    alert ("Abra um documento");
}