/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.jpa;

import br.com.caelum.vraptor.AroundCall;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.http.MutableResponse;
import br.com.caelum.vraptor.interceptor.SimpleInterceptorStack;
import br.com.caelum.vraptor.validator.Validator;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

@Intercepts
public class JPATransactionInterceptor {
    private final EntityManager manager;
    private final Validator validator;
    private final MutableResponse response;

    protected JPATransactionInterceptor() {
        this(null, null, null);
    }

    @Inject
    public JPATransactionInterceptor(EntityManager manager, Validator validator, MutableResponse response) {
        this.manager = manager;
        this.validator = validator;
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundCall
    public void intercept(SimpleInterceptorStack stack) {
        this.addRedirectListener();
        EntityTransaction transaction = null;
        try {
            transaction = this.manager.getTransaction();
            transaction.begin();
            stack.next();
            this.commit(transaction);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
    }

    private void commit(EntityTransaction transaction) {
        if (!this.validator.hasErrors() && transaction.isActive()) {
            transaction.commit();
        }
    }

    private void addRedirectListener() {
        this.response.addRedirectListener(new MutableResponse.RedirectListener(){

            public void beforeRedirect() {
                JPATransactionInterceptor.this.commit(JPATransactionInterceptor.this.manager.getTransaction());
            }
        });
    }
}

