local function generate()
dgeomtrimesh = {type='class',description="Triangle mesh collision.",childs={["raytrisresult"] = {type='function', description = " You can get precise ray test results, such as index of which triangle was hit and which barycentric coordinates the hitpoint had.", args="(dgeomtrimesh,[boolean])", returns="([boolean])"},
["triarrayresult"] = {type='function', description = " You can get all intersecting triangles with the geoms when using triarraycollide command. Outside of calling that function you should disable manually, else there will be a slight slowdown.", args="(dgeomtrimesh,[boolean])", returns="([boolean])"},
["new"] = {type='function', description = " creates a trimesh geom, ready for collision. ==new prevents gc of dgeomtrimeshdata", args="(dgeomtrimeshdata,[dspace space])", returns="(dgeomtrimesh)"}}}
ContainerResizer = {type='class',description="A component that is resizing its parent frame if clicked and dragged.",childs={["new"] = {type='function', description = " \
	Creates a ContainerResizer, which is initially not visible", args="(table class, int x,y,w,h)", returns="(ContainerResizer)"}}}
UtilFunctions = {type='class',description="The UtilFunctions class is a collection of miscellanous useful lua functions.",childs={["luafilename"] = {type='function', description = " retrieves the filename of a luafunction,\
	if possible.\
	The level is the functioncallerstack and should be >=1\
	returns filename and level of the found path.\
	", args="(int level)", returns="(string filename)"},
["luaDoFile"] = {type='value', description = "original lua dofile function"},
["checkargtable"] = {type='function', description = " This function provides a system to check table keys\
for values. This is useful if a functions is taking a table containing \
various \"named\" function arguments. The return value of this function is a\
table which provides sophisticated functionalities. If the table is\
called with a string as argument, it expects that a key in the table\
is to be checked and returns a table with possible value checking functions:\
\
* type: checks if the value of this key is of a certain type\
* optional: if the value is nil, the passed optional value is returned (may be nil)\
* translate: expects an table to be passed. That table contains values that substitue the value of the key. A 2nd optional value is used if no value was found \
* oneofthis: like translate, but doesn't substitute the original value\
\
If the field \"finish\" is called, the collected arguments will be returned in the order\
they've been checked\
\
  local x,y,vx,vy,type = UtilFunctions.checkargtable(info) \
    \"x\":type \"number\" \
    \"y\":type \"number\"\
    \"vx\":optional(0)\
    \"vy\":optional(0)\
    \"type\":oneofthis{[\"player\"]=true, [\"AI\"]=true}\
    :finish()\
\
", args="(table)", returns="(table)"},
["loadFontFile"] = {type='function', description = " loads a font generated by the Font Bitmap Generator. The fontname must not contain\
	a suffix (.lua). The function trys to load a fontfile that must reside in a 'fonts' directory. You must not delete\
	the fontset yourself. All characters in the fontset that are not set by the font itself are mapped to the glyphid 0 (lefttopmost glyph)", args="(string fontname)", returns="(fontset,texture)"},
["getModelColMesh"] = {type='function', description = " Creates a geom trimeshdata from the given model. Optionally transforms vertices.<br>\
	tableBase : {data = dgeomtrimeshdata, aabox = {min{x,y,z},max{x,y,z}, center = {x,y,z}} <br>\
	tableHit : {table similar to base, but for every \"hitmesh\" = meshes that contain \"hitzone\" in the material name <br>\
	tableRaw : { inds = indices{}, verts = vertices{}, tris = tridata{{mesh=meshid,orig=original index}...} }, table with all indices/vertices and a table with the tridata for every face in the model\
	", args="(model,[boolean needrawtable],[matrix4x4],[boolean visibleonly],[boolean neednotrimeshdata])", returns="(tableBase,tableHit,[tableRaw])"},
["pairsByKeys"] = {type='function', description = " returns an iterator function to traverse the table in\
	sorted order. The comperator function can be used to use another ordering for traversion.\
	The returned function returns three values if it is called: the key, the value, a\
	number that tells the current index and another number that tells how many indeces\
	are left to be be iterated. The comperator should take care about both\
	values it gets - these could either be numbers, functions, strings, tables, etc.\
\
	!!!!Example:\
\
	 for key,value in UtilFunctions.pairsByKeys({cde=1, abc=2})\
	 	do print(key,value) end\
\
	!!!!Output:\
\
	 abc  2\
	 cde  3\
", args="(table,[comperator])", returns="(function)"},
["projectpathabs"] = {type='function', description = " returns the current projectpath as absolute path. Useful for opening\
	files.\
", args="()", returns="(string)"},
["setTableValue"] = {type='function', description = " searches a val in the given table.\
	The first hit is replaced by newvalue, which removes the tableentry if\
	it is nil. You can use it therefore to remove a value from a table.\
	The index of the removed element and the value is then returned.\
\
	If no match was found, nothing is returned.\
", args="(table,value,[newvalue])", returns="([index,oldvalue])"},
["luafilepath"] = {type='function', description = " like luafilename,\
	but removes the filename itself", args="(int level)", returns="(string filepath)"},
["loadfile"] = {type='function', description = " similiar to original loadfile except that this\
	function trys to find the file in different locations relative to all\
	loaded luafiles. This function replaces the original loadfile function.", args="(string path,...)", returns="()"},
["dofile"] = {type='function', description = " similiar to original dofile except that this\
	function trys to find the file in different locations relative to all\
	loaded luafiles. This function replaces the original dofile function.", args="(string path,...)", returns="()"},
["smallLogoPos"] = {type='function', description = " Sets the position of the small Luxinia Logo at one of the four\
	corners (whatever you like more). Topright = 1, rightbottom = 2, bottomleft = 3,\
	topleft = 4.\
", args="(int n)", returns="()"},
["serialize"] = {type='function', description = " Serializes a given table into a string that allows\
	the reconstruction of the given table. It returns a string that describes the table's content\
	with lua code. To deserialize the string, it must only be executed:\
	\
	 mytable = {1,2,3}\
	 serial = UtilFunctions.serialize(mytable)\
	 \
	 mytable = nil\
	 reconstructed = loadstring(serial)()\
	 \
	 for i,v in ipairs(reconstructed) do print(v) end\
	  -- prints out 1,2,3 - converted first to string and then \
	  -- to a table again successfully\
	\
	The table may contain self cycles:\
	\
	 mytable = {1,2,3}\
	 mytable.self = mytable\
	 mytable[mytable] = \"self index\"\
	 serial = UtilFunctions.serialize(mytable)\
	 \
	 mytable = nil\
	 reconstructed = loadstring(serial)()\
	 \
	 print(reconstructed[reconstructed])\
	 for i,v in ipairs(reconstructed.self) do print(v) end\
	   -- prints out \"self index\" \\n 1,2,3\
	\
	If the table contains function, the serilizing function will try to compile the \
	function in its binary representation using string.dump - which may fail if the \
	function is using local values from outside. \
	\
	If the table has a metatable function entry named __serialize, this function \
	is being called and the return value is further serialized if it is a table value.\
	However, if the function returns a string, the string is directly written \
	in the place where the serialisation takes place! You can inject lua code this way:\
	\
	 mytable = {}\
	 setmetatable(mytable, {__serialize = \
	   function (self, idx)\
	     return \"function () return true end\"\
	   end\
	 end\
	 })\
	 \
	 print (UtilFunctions.serialize({ mytable }))\
	 \
	Output result:\
	\
	 local refs = {}\
	 local fns = {}\
	 for i=1,1 do refs[i] = {} end\
	 		\
	 refs[1][1] = function () return true end\
	 \
	 return refs[1]\
	\
	Important: don't serialize tables with __serialize metatables directly!\
	Include them in a table instead, like in the example above.\
	\
	The serialisation function receives two arguments: the own table as \
	argument 1 and an index value as argument 2. The indexvalue represents \
	the id where the table data is stored (the refs table includes all \
	required values and other values must reference them as well, building \
	the cyclic tables and so on). The serialize function can return a \
	second value which tells the serializer how many reference table you \
	require - i.e. if you return 1 as second argument, an additional table\
	is stored in refs. \
	\
	You could also return a table, which is then serialized too, or a \
	string of a serialisation included in a function that is executed:\
	\
	 (function () UtilFunctions.serialize({1,2,3}) end)() \
	  -- creates a table {1,2,3}\
	\
	Since you can modify the output result, you can write inject any code you \
	want to save, meaning loops, functions and so on.\
	\
	The way the serialisation is stored is given in the output result above:\
	A list of tables stored in refs is used to fill the data of the tables \
	one after another without breaking the consistence due to cyclic references.\
	The fns table contains functions that are created with the string.dump functions.\
	The loop creates all required tables so we can easily use them later.\
	After this initialisation, the tables in refs are filled with all values. \
	At last, the first table value (which was passed to the serialize function) \
	is returned. You can either write this string in a file or make a lua \
	function of it by prepending \"function serializedstuff () \" and adding \
	\"end\" to the string returned by the serializing function.\
	\
", args="(table input)", returns="(string serialized)"},
["fileexists"] = {type='function', description = " tries out if the given file exists.\
	This is not very clean since it only trys to open and close the file and\
	if it doesn't throw an error it is assumed that the file exists.\
	", args="(string path)", returns="(boolean exists)"},
["color3rgb2hsv"] = {type='function', description = " converts the rgb color to a hsv color value", args="(float r,g,b)", returns="(float h,s,v)"},
["printf"] = {type='function', description = " prints out a formated  string as the rules of string.format describe. This\
	function is also stored in the global variable named printf\
", args="(string format, ...)", returns="()"},
["color3byte"] = {type='function', description = " converts the incoming color values 0-255, to 0-1 floats", args="(float r,g,b)", returns="(float r,g,b)"},
["freelook"] = {type='function', description = " enables/disables freelook of current \
	default l3dcamera. Useful for debugging, \
	FreeLook.invert .movemulti .shiftmulti let you modify behavior. \
	Controls are WASD,C,SPACE + Mouse. \
	Optionally installed as drag listener into guicomp.", args="(boolean,Component guicomp)", returns="(boolean)"},
["simplerenderqueue"] = {type='function', description = " sets up a standard renderqueue for the view (which is also returned).\
	The l3dview has equivalent rcmds in its table. The order is: \
	* rClear\
	* rDepth\
	* rDrawbg\
	* rLayers[1..16]\
	** stencil\
	** drawlayer\
	** drawprt\
	* rDrawdebug\
	\
	Each rLayer contains: stencil,drawlayer,drawprt for the equivalent l3dlayerids-1. Sorting is enabled and material-based.<br>\
	ignorelayers should contain 'true' at layer+1 field. Ie {true,true} will disable layer 0 & 1.\
	", args="([l3dview],[boolean noempty],[tab ignorelayers])", returns="(l3dview)"},
["luaLoadFile"] = {type='value', description = "original lua loadfile function"},
["removeWindowResizeListener"] = {type='function', description = " removes the given function from being called on window resize events", args="(function)", returns="()"},
["color3hsv"] = {type='function', description = " converts the incoming hsv to color to 0-1 rgb floats", args="(float h,s,v)", returns="(float r,g,b)"},
["loadCollisionDataFile"] = {type='function', description = " loads dgeoms from the collision data lua file. extratable can contain the tables: \"original\" and/or \"visual\".Currently exported by 3dsmax.\
	", args="([string path,table],[boolean needoriginaltable],[boolean createl3ds])", returns="(dgeom table,[extratable])"},
["color4byte"] = {type='function', description = " converts the incoming color values 0-255, to 0-1 floats", args="(float r,g,b,a)", returns="(float r,g,b,a)"},
["picktest"] = {type='function', description = "\
	This function will test the given space with a ray and returns, if a hit was generated, the geom, the coordinate of the\
	nearest hit and the hitnormal. The ray is in line with the x,y pair (or the mouse coordinates if not given)\
	on the camera projection plane and through the last known camera worldposition (this worldposition can be one frame behind, so\
	you might have to call camera:forceupdate() to update to the currently set position if this is important, which is not in most cases).\
	The maxlength can be optionally set and is per default set to 1000000. If no camera is specified, the default camera is used.\
\
	This function handles also orthogonal camera fovs, which requires a different\
	raysetting code.\
\
	!!Example:\
\
	[img utilfunctions.picktest.png]\
\
	 UtilFunctions.simplerenderqueue()\
\
	 input.showmouse(true) -- so we can see the mouse\
	 space = dspacehash.new() -- our space with our objects\
	 box = actornode.new(\"box\")  -- our box location\
	 box.geom = dgeombox.new(1,1,1,space) -- the geom, placed in 0,0,0\
	 box.geom.l3d = l3dprimitive.newbox(\"box\",1,1,1) -- the l3d for our box\
	 box.geom.l3d:linkinterface(box) -- link it\
	 cam = actornode.new(\"cam\",5,4,3) -- our cameranode so we can view\
	 l3dcamera.default():linkinterface(cam) -- link it with defaultcamera\
	 cam:lookat(0,0,0,0,0,1) -- and look at 0,0,0 (the box location)\
\
	 highlight = actornode.new(\"highlight\") -- a simple highlighter\
	 highlight.l3d = l3dprimitive.newsphere(\"hightlight\",0.05)\
	 highlight.l3d:color(1,0,0,1) -- make sphere red\
	 highlight.l3d:linkinterface(highlight) -- link it\
\
	 local function test () -- our testing function\
	 	 local g,pos = UtilFunctions.picktest(space)  -- test it\
	 	 highlight.l3d:rfNodraw(not pos) -- don't highlight if no hit\
\
	 	 if pos then  -- if we have a hit\
	     highlight:pos(pos[1],pos[2],pos[3]) -- move the highlighter\
	     g.l3d:color(1,math.sin(os.clock()*5)/2+.5,1,1)\
	     	-- ^^ make the hit object do something\
	 	 end\
	 end\
\
	 Timer.set(\"picker\", test,20) -- run the test every 20ms\
	", args="(dspace space,[x=mousex],[y=mousey],[maxlength=1000000],[l3dcamera camera = l3dcamera.default])", returns="([geom,{x,y,z},{nx,ny,nz}])"},
["tabletotalcount"] = {type='function', description = " returns the number of elements in that table and all of its childs\
	it also traverses into the metatables, but ignores tables that are weak typed. It also counts metatables as element.\
\
	This function should help to find memory leaks, which can occure if table references\
	are not removed.\
", args="(table)", returns="(n)"},
["addWindowResizeListener"] = {type='function', description = " will call function after window was resized (directly after window.update or with a few milliseconds delay if thru window.resizemode > 0.", args="(function)", returns="()"}}}
window = {type='class',description="The graphics window luxinia runs in. Setters only have effect after update is called. Do not call setters without ever calling update.",childs={["bpp"] = {type='function', description = " returns or sets bits per pixel (16,24,32)", args="([int])", returns="(int)"},
["fullscreen"] = {type='function', description = " gets or sets if window will be fullscreen", args="([boolean])", returns="([boolean])"},
["resizepixelscale"] = {type='function', description = " sets or returns pixelsize ratio (pixels/mm) for resizemode 3. outref = scale * screenpixels_per_mm. Queries screenpixels_per_mm automatically via window.screensizemm and window.screensize in the resize event.", args="([x,y])", returns="([x,y])"},
["resizemode"] = {type='function', description = " allows to get or set how the window should be resized if a user changes window size in windowed mode.		* 0 size is not changed (default)<br>		* 1 size is changed<br>		* 2 size and refsize are changed to new window size.<br>		* 3 size is changed and refsize will be changed according to window.resizeratio.", args="([int mode])", returns="([int])"},
["depthbits"] = {type='function', description = " returns or sets depthbits. After update this reflects the actual window value", args="([int])", returns="(int)"},
["update"] = {type='function', description = " if you have changed resolution or fullscreen state this function makes changes active", args="()", returns="()"},
["screensize"] = {type='function', description = " returns primary display resolution.", args="()", returns="(int w,h)"},
["readdepth"] = {type='function', description = " returns depth value at window coordinate (in refsystem)", args="(float x,y)", returns="(float)"},
["pos"] = {type='function', description = " sets or returns window position", args="([x,y])", returns="([x,y])"},
["resstring"] = {type='function', description = " gets or sets window resolution string=WIDTHxHEIGHTxBPP:DEPTH:STENCIL:FSAASAMPLES  BPP should be 16,24 or 32. Only 32 has forced alpha buffer support. You can check colorbits what kind of bits per pixel are used.", args="([string])", returns="([string])"},
["minsize"] = {type='function', description = " returns or sets minimum size of window. Only has effect in windowed mode.", args="([int w,h])", returns="([int w,h])"},
["screen2ref"] = {type='function', description = " converts screen pixel to reference coords (origin top left in both).", args="(x,y)", returns="(x,y)"},
["res"] = {type='function', description = " sets window resolution 0 = 640x480x16, 1 = 800x600x16, 2 = 1024x768x16, 3 = 640x480x32, 4 = 800x600x32, 5 = 1024x768x32", args="([int])", returns="([int])"},
["restore"] = {type='function', description = " restores the window if iconified.", args="()", returns="()"},
["size"] = {type='function', description = " returns or sets size of window. Needs window.update to show effect", args="([int w,h])", returns="([int w,h])"},
["stencilbits"] = {type='function', description = " returns or sets stencilbits. After update this reflects the actual window value", args="([int])", returns="(int)"},
["screensizemm"] = {type='function', description = " returns size in millimeters for current primary display (e.g monitor).", args="()", returns="(int w,h)"},
["multisamples"] = {type='function', description = " returns or sets samples for fullscreen anti-aliasing. After update this reflects the actual window value", args="([int])", returns="(int)"},
["readcolor"] = {type='function', description = " returns color value at window coordinate (in refsystem)", args="(float x,y)", returns="(float r,g,b,a)"},
["ontop"] = {type='function', description = " returns or sets if window is always on top", args="([boolean])", returns="([boolean])"},
["colorbits"] = {type='function', description = " returns actual bits used for each channel", args="()", returns="(int r,g,b,a)"},
["iconify"] = {type='function', description = " iconifies the window.", args="()", returns="()"},
["width"] = {type='function', description = " returns or sets width", args="([int])", returns="(int)"},
["refsize"] = {type='function', description = " sets reference size of screen (default=640,480). Reference size is mostly important for list2d rendering and mouse positions. It allows the window not use pixel positions but custom dimensions which gui will be stretched to.", args="([int w,h])", returns="([int w,h])"},
["client2screen"] = {type='function', description = " converts coordinates from client (luxinia) window to screen (desktop) window.", args="(x,y)", returns="([x,y])"},
["title"] = {type='function', description = " Set the title of the window", args="(string)", returns="()"},
["ref2screen"] = {type='function', description = " converts reference to screen pixel coords (origin top left in both).", args="(x,y)", returns="(x,y)"},
["height"] = {type='function', description = " returns or sets height", args="([int])", returns="(int)"},
["screen2client"] = {type='function', description = " converts coordinates from screen (desktop) window to client (luxinia) window.", args="(x,y)", returns="([x,y])"},
["texmatrix"] = {type='function', description = " returns texture matrix for 'fullwindow' textures.", args="()", returns="(matrix4x4)"},
["readstencil"] = {type='function', description = " returns stencil value at window coordinate (in refsystem)", args="(float x,y)", returns="(int)"}}}
shader = {type='class',description="shader to setup blend effects between textures.<br> See the shdscript manual for more infos.",childs={["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"},
["getparamid"] = {type='function', description = " returns id. In case param is used in multiple passes define which. (default first used).", args="(shader,string name,[int pass])", returns="([shaderparamid])"},
["annotation"] = {type='function', description = " searches and returns annotation string", args="(shader, string name)", returns="([string])"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["load"] = {type='function', description = " loads a shader. Optionally can pass compilerstrings, eg. \"-DSOMETHING;\".", args="(string filename, [compilerargs])", returns="(shader shd)"},
["param"] = {type='function', description = " returns or sets a shaderparam value, does nothing when param wasnt found. Arrayoffset only used for array parameters", args="(shader,shaderparamid,[arrayoffset],[float x,y,z,w])", returns="(float x,y,z,w)"}}}
gpuprog = {type='class',description="It contains code to be executed on the graphics card. Depending on whether your hardware is capable or not shaders will load gpuprogs automatically. There is als a set of standard gpuprograms in the base/gpuprogs folder of the application which are used internally to speed rendering up.",childs={["source"] = {type='function', description = " returns the source", args="(gpuprog)", returns="(string)"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["find"] = {type='function', description = " finds a loaded gpuprog", args="(string file,string entryname)", returns="([gpuprog])"},
["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"}}}
os = {type='class',description="This library is implemented through table os.",childs={["exit"] = {type='function', description = "\
			Calls the C function exit, with an optional code, to terminate\
			the host program. The default value for code is the success code. ", args="([code])", returns="(?)"},
["setlocale"] = {type='function', description = "\
			Sets the current locale of the program. locale is a string specifying\
			a locale; category is an optional string describing which category to\
			change: \"all\", \"collate\", \"ctype\", \"monetary\", \"numeric\", or \"time\";\
			the default category is \"all\". The function returns the name of\
			the new locale, or nil if the request cannot be honored. ", args="(locale [, category])", returns="(?)"},
["date"] = {type='value', description = "(string date)([format [, time] ]) -\
			Returns a string or a table containing date and time, formatted\
			according to the given string format.\
\
			If the time argument is present, this is the time to be formatted\
			(see the os.time function for a description of this value).\
			Otherwise, date formats the current time.\
\
			If format starts with `!Â´, then the date is formatted in Coordinated\
			Universal Time. After this optional character, if format is *t,\
			then date returns a table with the following fields: year (four digits),\
			month (1--12), day (1--31), hour (0--23), min (0--59), sec (0--61),\
			wday (weekday, Sunday is 1), yday (day of the year), and isdst\
			(daylight saving flag, a boolean).\
\
			If format is not *t, then date returns the date as a string,\
			formatted according to the same rules as the C function strftime.\
\
			When called without arguments, date returns a reasonable date and\
			time representation that depends on the host system and on the\
			current locale (that is, os.date() is equivalent to os.date(\"%c\"))."},
["getenv"] = {type='function', description = "\
			Returns the value of the process environment variable varname, or\
			nil if the variable is not defined.", args="(varname)", returns="(?)"},
["difftime"] = {type='function', description = "\
			Returns the number of seconds from time t1 to time t2. In POSIX,\
			Windows, and some other systems, this value is exactly t2-t1. ", args="(t2, t1)", returns="(?)"},
["remove"] = {type='function', description = "\
			Deletes the file or directory with the given name. Directories must\
			be empty to be removed. If this function fails, it returns nil,\
			plus a string describing the error. ", args="(filename)", returns="(?)"},
["time"] = {type='function', description = "\
			Returns the current time when called without arguments, or a time\
			representing the date and time specified by the given table. This\
			table must have fields year, month, and day, and may have fields\
			hour, min, sec, and isdst (for a description of these fields,\
			see the os.date function).\
\
			The returned value is a number, whose meaning depends on your system.\
			In POSIX, Windows, and some other systems, this number counts the\
			number of seconds since some given start time (the \"epoch\"). In\
			other systems, the meaning is not specified, and the number returned\
			by time can be used only as an argument to date and difftime. ", args="([table])", returns="(int time)"},
["clock"] = {type='function', description = "\
			Returns an approximation of the amount in seconds of CPU time\
			used by the program.", args="()", returns="(int seconds)"},
["execute"] = {type='function', description = "\
			This function is equivalent to the C function system. It passes\
			command to be executed by an operating system shell. It returns a\
			status code, which is system-dependent. If command is absent, then\
			it returns nonzero if a shell is available and zero otherwise. ", args="([command])", returns="(?)"},
["rename"] = {type='function', description = "\
			Renames file or directory named oldname to newname. If this\
			function fails, it returns nil, plus a string describing the error.", args="(oldname, newname)", returns="(?)"},
["tmpname"] = {type='function', description = "\
			Returns a string with a file name that can be used for a\
			temporary file. The file must be explicitly opened before its use\
			and explicitly removed when no longer needed. ", args="()", returns="(string)"}}}
stencilcommand = {type='class',description="Stencilcommand allows discarding pixels based on stencil buffer. Here you can define the test and the write operations. l2dflag will ignore twosided stenciling and use front for both, else twosided stenciling is only done when the rfNoCull flag is forced. Other than that we use same operations (front) for front and back faces. Be aware that if system does not support twosided stenciling, we need to multipass, and we cannot guarantee that the result is exactly like with twosided support.",childs={["scOperation"] = {type='function', description = " returns or sets what to do when depth/stencil fails or passes. side 0 = frontface, 1 = backface. It defines how the value is combined with the old stencilbuffer value.", args="(stencilcommand,int side,[operationmode fail, operationmode zfail, operationmode zpass])", returns="([operationmode fail, operationmode zfail, operationmode zpass])"},
["scEnabled"] = {type='function', description = " returns or sets if command should be enabled. Which side should be affected can also be set 0 = front, 1 = back, -1 both modes active (needs capability).", args="(stencilcommand,[boolean state,[int side]])", returns="([boolean])"},
["scFunction"] = {type='function', description = " returns or sets how the stencil test should be done, and the binary mask for before writing is done.", args="(stencilcommand,[comparemode front,comparemode back,int threshold, int mask])", returns="([comparemode front,comparemode back,int threshold, int mask])"}}}
testsys = {type='class',description="The testsys class is for testing purpose such as testing 		implementations during development of the luxinia core. 		It is not meant to be published in the release versions of Luxinia.",childs={}}
renderfbo = {type='class',description="The framebufferobject (fbo) can be used for advanced off-screen rendering effects. For this class you need special capability. When not using fbos rendering is done to the windows's backbuffer. The 'fbo' rcmds can be used to make use of it.",childs={["resetattach"] = {type='function', description = " resets the attach bind cache. Useful if you reloaded assigned textures. l3dlist.fbotest calls this as well.", args="(renderfbo)", returns="()"},
["check"] = {type='function', description = " checks for completeness and returns error string if issue was found with current attaches.", args="(renderfbo)", returns="([string error])"},
["applyattach"] = {type='function', description = " runs the rcmds and applies there attach information (run resetattach before to enforce setting). Passing a illegal type will ignore either.", args="(renderfbo,[rcmdfbotex],[rcmdfborb])", returns="()"},
["size"] = {type='function', description = " returns or sets fbo size. All attachments must have equal size.", args="(renderfbo,[int width,height,[boolean windowsized ]])", returns="([int width,height, boolean windowsized])"},
["new"] = {type='function', description = " returns the new created fbo. If windowsized is true width and height are ignored and current window resolution is taken and fbo is resized on window.size changes, too.", args="(int width,height,[boolean windowsized])", returns="(renderfbo)"}}}
debug = {type='class',description="This library provides the functionality of the debug interface to Lua programs.\
You should exert care when using this library. The functions provided here should\
be used exclusively for debugging and similar tasks, such as profiling. Please\
resist the temptation to use them as a usual programming tool: They can be very\
slow. Moreover, several of its functions violate some assumptions about Lua code\
(e.g., that variables local to a function cannot be accessed from outside or that\
userdata metatables cannot be changed by Lua code) and therefore can compromise\
otherwise secure code.\
\
All functions in this library are provided inside the debug table. ",childs={["getupvalue"] = {type='function', description = "\
				This function returns the name and the value of the upvalue with\
				index up of the function func. The function returns nil if there\
				is no upvalue with the given index. ", args="(func, up)", returns="(?)"},
["debug"] = {type='function', description = "\
			Enters an interactive mode with the user, running each string that\
			the user enters. Using simple commands and other debug facilities,\
			the user can inspect global and local variables, change their values,\
			evaluate expressions, and so on. A line containing only the word\
			cont finishes this function, so that the caller continues its\
			execution.\
\
			Note that commands for debug.debug are not lexically nested\
			within any function, and so have no direct access to\
			local variables. ", args="()", returns="()"},
["getfenv"] = {type='function', description = " Returns the environment of object o.", args="(o)", returns="(table)"},
["getmetatable"] = {type='function', description = "\
				Returns the metatable of the given object or nil if it does\
				not have a metatable. ", args="(object)", returns="(table)"},
["gethook"] = {type='function', description = "\
				Returns the current hook settings, as three values:\
				the current hook function, the current hook mask, and\
				the current hook count (as set by the debug.sethook function).", args="()", returns="(?)"},
["setmetatable"] = {type='function', description = "\
				Sets the metatable for the given object to the given table\
				(which can be nil). ", args="(object, table)", returns="(?)"},
["setfenv"] = {type='function', description = "\
				Sets the environment of the given object to the given table. ", args="(object, table)", returns="(?)"},
["traceback"] = {type='function', description = " Returns a string with a traceback of the call\
				stack. An optional message string is appended at the beginning\
				of the traceback. This function is typically used with xpcall\
				to produce better error messages. ", args="([message])", returns="(?)"},
["getinfo"] = {type='function', description = "\
				Returns a table with information about a function. You can\
				give the function directly, or you can give a number as the\
				value of function, which means the function running at level\
				function of the call stack: Level 0 is the current function\
				(getinfo itself); level 1 is the function that called getinfo;\
				and so on. If function is a number larger than the number of\
				active functions, then getinfo returns nil.\
\
				The returned table contains all the fields returned by\
				lua_getinfo, with the string what describing which fields to\
				fill in. The default for what is to get all information available.\
				If present, the option `fÂ´ adds a field named func with\
				the function itself.\
\
				For instance, the expression debug.getinfo(1,\"n\").name returns a\
				name of the current function, if a reasonable name can be found,\
				and debug.getinfo(print) returns a table with all available\
				information about the print function. ", args="(function [, what])", returns="(?)"},
["setlocal"] = {type='function', description = "\
				This function assigns the value value to the local variable\
				with index local of the function at level level of the stack.\
				The function returns nil if there is no local variable with the\
				given index, and raises an error when called with a level out of\
				range. (You can call getinfo to check whether the level is valid.)\
				Otherwise, it returns the name of the local variable. ", args="(level, local, value)", returns="(?)"},
["setupvalue"] = {type='function', description = "\
				This function assigns the value value to the upvalue with\
				index up of the function func. The function returns nil if\
				there is no upvalue with the given index. Otherwise, it\
				returns the name of the upvalue. ", args="(func, up, value)", returns="(?)"},
["sethook"] = {type='function', description = "\
				Sets the given function as a hook. The string mask and the\
				number count describe when the hook will be called. The string\
				mask may have the following characters, with the given meaning:\
				* \"c\" --- The hook is called every time Lua calls a function;\
				* \"r\" --- The hook is called every time Lua returns from a function;\
				* \"l\" --- The hook is called every time Lua enters a new line of code.\
				With a count different from zero, the hook is called after every\
				count instructions.\
\
				When called without arguments, debug.sethook turns off the hook.\
\
				When the hook is called, its first parameter is a string\
				describing the event that has triggered its call: \"call\",\
				\"return\" (or \"tail return\"), \"line\", and \"count\". For line\
				events, the hook also gets the new line number as its second\
				parameter. Inside a hook, you can call getinfo with level 2 to\
				get more information about the running function (level 0 is the\
				getinfo function, and level 1 is the hook function), unless the\
				event is \"tail return\". In this case, Lua is only simulating the\
				return, and a call to getinfo will return invalid data. ", args="(hook, mask [, count])", returns="(?)"},
["getregistry"] = {type='function', description = " Returns the registry table (see 3.5). ", args="()", returns="(table)"},
["getlocal"] = {type='function', description = "\
				This function returns the name and the value of the local\
				variable with index local of the function at level level of\
				the stack. (The first parameter or local variable has index 1,\
				and so on, until the last active local variable.) The function\
				returns nil if there is no local variable with the given index,\
				and raises an error when called with a level out of range.\
				(You can call debug.getinfo to check whether the level is valid.)\
\
				Variable names starting with `(Â´ (open parentheses) represent\
				internal variables (loop control variables, temporaries, and C\
				function locals). ", args="(level, local)", returns="(?)"}}}
particleforceid = {type='class',description="Particle forces within particlesys allow greater control of the dynamic beahvior. You can create general effects such as  wind and gravity within the prt-script itself. However for location based effects you must add particle forces with this  class. You can also get access to the orginal prt scripts. The number of total forces per particlesys is limited to 32 and name must be shorter than 16 characters.  The more you add, the slower it will be.",childs={["linkworldref"] = {type='function', description = " sets the reference for magnet,target or agedvelocity.", args="(particleforceid,[actornode/scenenode])", returns="()"},
["activate"] = {type='function', description = " force is activated.", args="(particleforceid)", returns="()"},
["range"] = {type='function', description = " returns or sets range for magnet.", args="(particleforceid,[float])", returns="([float])"},
["linkbone"] = {type='function', description = " sets the reference for magnet,target or agedvelocity. Be aware that if the linked l3dmodel is not visible then the used boneposition will be the last when it was visible.", args="(particleforceid,[l3dmodel, boneid])", returns="()"},
["deactivate"] = {type='function', description = " force is deactivated.", args="(particleforceid)", returns="()"},
["vector"] = {type='function', description = " returns or sets the vector (must not be normalized). For wind and gravity this serves as direction and strength. For magnet and target it is an offset to the linked node.", args="(particleforceid,[float x,y,z])", returns="([float x,y,z])"},
["airresistance"] = {type='function', description = " returns or sets airresistance for wind.", args="(particleforceid,[float])", returns="([float])"},
["createagedvelocity"] = {type='function', description = " returns a new particleforceid if particlesys had an empty slot. Aged velocity means that velocity of the particle will be interpolated to based on its age. The age velocities must be set by the user and will be rotated by the node it is linked to", args="(particlesys,string name)", returns="([particleforceid])"},
["delete"] = {type='function', description = " force is deleted.", args="(particleforceid)", returns="()"},
["createwind"] = {type='function', description = " returns a new particleforceid if particlesys had an empty slot.		Wind is acceleration if slower than wind, or deceleration if faster.", args="(particlesys,string name)", returns="([particleforceid])"},
["turbulence"] = {type='function', description = " returns or sets turbulence for the effect.", args="(particleforceid,[float])", returns="([float])"},
["strength"] = {type='function', description = " returns or sets strength (positive attraction, negative repulsion) for target,magnet, agedvelocity.", args="(particleforceid,[float])", returns="([float])"},
["createtarget"] = {type='function', description = " returns a new particleforceid if particlesys had an empty slot. Target means that particles will be attracted or repulsed by target.", args="(particlesys,string name)", returns="([particleforceid])"},
["time"] = {type='function', description = " returns or sets start- and endtime for force. A particle must be at least starttime (ms) old and younger than endtime to be affected. Set either to 0 to disable the check for start/endtime.", args="(particleforceid,[int start,end])", returns="([int start,end])"},
["agevec3"] = {type='function', description = " returns or sets the vector3 at the particle interpolator step. (for aged forces)", args="(particleforceid,int index,[float x,y,z])", returns="([float x,y,z])"},
["createmagnet"] = {type='function', description = " returns a new particleforceid if particlesys had an empty slot. Magnet is similar to target but a ranged effect, only within range particles are affected and the strenght falloff is quadratic with distance", args="(particlesys,string name)", returns="([particleforceid])"},
["creategravity"] = {type='function', description = " returns a new particleforceid if particlesys had an empty slot. Gravity is constant acceleration.", args="(particlesys,string name)", returns="([particleforceid])"}}}
KeyEvent = {type='class',description="Keyevents are produced if the use types a key.",childs={["keycode"] = {type='value', description = "{[int]} - code of the key that was typed"},
["KEY_RELEASED"] = {type='value', description = "[int] - constant if key was released"},
["KEY_TYPED"] = {type='value', description = "[int] - constant if key was typed"},
["STATENAMES"] = {type='value', description = "[table] - a list with names for constants"},
["state"] = {type='value', description = "{[int]} - state of the button (KEY_PRESSED,...)"},
["KEY_PRESSED"] = {type='value', description = "[int] - constant if key was pressed"},
["toString"] = {type='function', description = " returns simple string representation", args="(KeyEvent)", returns="(string)"},
["since"] = {type='value', description = "{[int]} - frameid since when the key is hold down"},
["key"] = {type='value', description = "{[string]} - key that was typed"},
["new"] = {type='function', description = "\
			creates a new KeyEvent with the given parameters.", args="(string key, int keycode, int since, int state)", returns="(KeyEvent)"}}}
l3dprimitive = {type='class',description="Primitives such as cubes, boxes and user meshes.",childs={["newbox"] = {type='function', description = " creates new l3dnode", args="(string name,|l3dlayerid|,float w,d,h)", returns="([l3dprimitive])"},
["originalmesh"] = {type='function', description = " deletes the usermesh and uses the original mesh again.", args="(l3dprimitive)", returns="()"},
["newquadcentered"] = {type='function', description = " creates new l3dnode. origin of the quad is center point", args="(string name,|l3dlayerid|,float w,d)", returns="([l3dprimitive])"},
["newquad"] = {type='function', description = " creates new l3dnode. origin of the quad is lower left corner", args="(string name,|l3dlayerid|,float w,d)", returns="([l3dprimitive])"},
["matsurface"] = {type='function', description = " returns or sets material", args="(l3dprimitive,[matsurface])", returns="([matsurface])"},
["usermesh"] = {type='function', description = " creates inplace custom rendermesh (see rendermesh for details) Note that polygon winding is CCW.", args="(l3dprimitive, vertextype, int numverts, numindices, [vidbuffer vbo], [int vbooffset], [vidbuffer ibo], [int ibooffset])", returns="()"},
["rendermesh"] = {type='function', description = " gets or sets rendermesh. Get only works if a usermesh was created before or another rendermesh passed for useage.", args="(l3dprimitive,[rendermesh])", returns="([rendermesh])"},
["newcylinder"] = {type='function', description = " creates new l3dnode", args="(string name,|l3dlayerid|,float size)", returns="([l3dprimitive])"},
["newsphere"] = {type='function', description = " creates new l3dnode", args="(string name,|l3dlayerid|,float size)", returns="([l3dprimitive])"},
["size"] = {type='function', description = " returns or sets size (modifies l3d's visbbox as well). Visual size will be overriden by calls to renderscale.", args="(l3dprimitive,[float radius/float x,y,z])", returns="([float radius/float x,y,z])"}}}
l3dlayerid = {type='class',description="l3dlayerid used to assign l3dnodes directly, get it from l3dset. Only needed for manual assign. You can manually multipass render a single layer using the opcode commandstring.",childs={}}
scalarop = {type='class',description="Defines operations between scalararrays / values. Operations are performed componentwise per 		vector. That means output array and input can be same. Scalartypes must match. Vectorsizes must match, except that last operand may have vectorsize of 1, as well. Non-saturated operations may cause 'wrap' 		values, ie truncation happening post operation. For example a uint8 operation may yield 300 as result, 		which means 44 (300 mod 256) is written. The saturated operations would clamp to 255 in that case.",childs={["mul2"] = {type='function', description = " out = arg1 * arg2.", args="()", returns="([scalarop])"},
["min2"] = {type='function', description = " out = min(arg1,arg2).", args="()", returns="([scalarop])"},
["clear0"] = {type='function', description = " out = 0 (zero)", args="()", returns="([scalarop])"},
["div2sat"] = {type='function', description = " out = saturate(arg1 / arg2).", args="()", returns="([scalarop])"},
["madd3"] = {type='function', description = " out = arg1 + (arg2 * arg3).", args="()", returns="([scalarop])"},
["sub2sat"] = {type='function', description = " out = saturate(arg1 - arg2).", args="()", returns="([scalarop])"},
["div2"] = {type='function', description = " out = arg1 / arg2.", args="()", returns="([scalarop])"},
["lerp3"] = {type='function', description = " out = lerp(arg1 to arg2 via arg3).", args="()", returns="([scalarop])"},
["lerpinv3"] = {type='function', description = " out = lerp(arg1 to arg2 via 1-arg3).", args="()", returns="([scalarop])"},
["madd3sat"] = {type='function', description = " out = saturate(arg1 + (arg2 * arg3)).", args="()", returns="([scalarop])"},
["copy1"] = {type='function', description = " out = arg1.", args="()", returns="([scalarop])"},
["max2"] = {type='function', description = " out = max(arg1,arg2).", args="()", returns="([scalarop])"},
["sub2"] = {type='function', description = " out = arg1 - arg2.", args="()", returns="([scalarop])"},
["mul2sat"] = {type='function', description = " out = saturate(arg1 * arg2).", args="()", returns="([scalarop])"},
["add2sat"] = {type='function', description = " out = saturate(arg1 + arg2).", args="()", returns="([scalarop])"},
["add2"] = {type='function', description = " out = arg1 + arg2.", args="()", returns="([scalarop])"}}}
http = {type='class',description="HTTP (Hyper Text Transfer Protocol) is the protocol used to exchange \
information between web-browsers and servers. The http namespace offers \
full support for the client side of the HTTP protocol (i.e., the facilities \
that would be used by a web-browser implementation). The implementation \
conforms to the HTTP/1.1 standard, RFC 2616.\
\
The module exports functions that provide HTTP functionality in different \
levels of abstraction. From the simple string oriented requests, through \
generic LTN12 based, down to even lower-level if you bother to look through \
the source code.\
\
URLs must conform to RFC 1738, that is, an URL is a string in the form:\
\
 [http://][<user>[:<password>]@]<host>[:<port>][/<path>] \
\
MIME headers are represented as a Lua table in the form:\
\
 headers = {\
   field-1-name = field-1-value,\
   field-2-name = field-2-value,\
   field-3-name = field-3-value,\
   ...\
   field-n-name = field-n-value\
 }\
\
Field names are case insensitive (as specified by the standard) and all \
functions work with lowercase field names. Field values are left unmodified.\
\
Note: MIME headers are independent of order. Therefore, there is no problem \
in representing them in a Lua table.\
\
The following constants can be set to control the default behavior of the \
HTTP module:\
\
* PORT: default port used for connections;\
* PROXY: default proxy used for connections;\
* TIMEOUT: sets the timeout for all I/O operations;\
* USERAGENT: default user agent reported to server. \
\
 http.request(url [, body])\
 http.request{\
  url = string,\
  [sink = LTN12 sink,]\
  [method = string,]\
  [headers = header-table,]\
  [source = LTN12 source],\
  [step = LTN12 pump step,]\
  [proxy = string,]\
  [redirect = boolean,]\
  [create = function]\
 }\
\
The request function has two forms. The simple form downloads a URL using the \
GET or POST method and is based on strings. The generic form performs any HTTP \
method and is LTN12 based.\
\
If the first argument of the request function is a string, it should be an url. \
In that case, if a body is provided as a string, the function will perform a \
POST method in the url. Otherwise, it performs a GET in the url\
\
If the first argument is instead a table, the most important fields are the \
url and the simple LTN12 sink that will receive the downloaded content. Any \
part of the url can be overridden by including the appropriate field in the \
request table. If authentication information is provided, the function uses \
the Basic Authentication Scheme (see note) to retrieve the document. If sink \
is nil, the function discards the downloaded data. The optional parameters \
are the following:\
\
* method: The HTTP request method. Defaults to \"GET\";\
* headers: Any additional HTTP headers to send with the request;\
* source: simple LTN12 source to provide the request body. If there is a body, \
you need to provide an appropriate \"content-length\" request header field, or \
the function will attempt to send the body as \"chunked\" (something few servers \
support). Defaults to the empty source;\
* step: LTN12 pump step function used to move data. Defaults to the LTN12 \
pump.step function.\
* proxy: The URL of a proxy server to use. Defaults to no proxy;\
* redirect: Set to false to prevent the function from automatically following \
301 or 302 server redirect messages;\
* create: An optional function to be used instead of socket.tcp when the \
communications socket is created. \
\
In case of failure, the function returns nil followed by an error message. \
If successful, the simple form returns the response body as a string, followed \
by the response status code, the response headers and the response status line. \
The complex function returns the same information, except the first return value \
is just the number 1 (the body goes to the sink).\
\
Even when the server fails to provide the contents of the requested URL (URL not \
found, for example), it usually returns a message body (a web page informing the \
URL was not found or some other useless page). To make sure the operation was \
successful, check the returned status code. For a list of the possible values \
and their meanings, refer to RFC 2616.\
\
Here are a few examples with the simple interface:\
\
 -- connect to server \"www.cs.princeton.edu\" and retrieves this manual\
 -- file from \"~diego/professional/luasocket/http.html\" and print it to stdout\
 http.request{ \
    url = \"http://www.cs.princeton.edu/~diego/professional/luasocket/http.html\", \
    sink = ltn12.sink.file(io.stdout)\
 }\
\
 -- connect to server \"www.example.com\" and tries to retrieve\
 -- \"/private/index.html\". Fails because authentication is needed.\
 b, c, h = http.request(\"http://www.example.com/private/index.html\")\
 -- b returns some useless page telling about the denied access, \
 -- h returns authentication information\
 -- and c returns with value 401 (Authentication Required)\
 \
 -- tries to connect to server \"wrong.host\" to retrieve \"/\"\
 -- and fails because the host does not exist.\
 r, e = http.request(\"http://wrong.host/\")\
 -- r is nil, and e returns with value \"host not found\"\
\
And here is an example using the generic interface:\
\
 -- load the http module\
 http = require(\"socket.http\")\
\
 -- Requests information about a document, without downloading it.\
 -- Useful, for example, if you want to display a download gauge and need\
 -- to know the size of the document in advance\
 r, c, h = http.request {\
  method = \"HEAD\",\
  url = \"http://www.tecgraf.puc-rio.br/~diego\"\
 }\
 -- r is 1, c is 200, and h would return the following headers:\
 -- h = {\
 --   date = \"Tue, 18 Sep 2001 20:42:21 GMT\",\
 --   server = \"Apache/1.3.12 (Unix)  (Red Hat/Linux)\",\
 --   [\"last-modified\"] = \"Wed, 05 Sep 2001 06:11:20 GMT\",\
 --   [\"content-length\"] = 15652,\
 --   [\"connection\"] = \"close\",\
 --   [\"content-Type\"] = \"text/html\"\
 -- }\
\
Note: Some URLs are protected by their servers from anonymous download. For \
those URLs, the server must receive some sort of authentication along with the \
request or it will deny download and return status \"401 Authentication Required\".\
\
The HTTP/1.1 standard defines two authentication methods: the Basic \
Authentication Scheme and the Digest Authentication Scheme, both explained \
in detail in RFC 2068.\
\
The Basic Authentication Scheme sends <user> and <password> unencrypted to the \
server and is therefore considered unsafe. Unfortunately, by the time of this \
implementation, the wide majority of servers and browsers support the Basic \
Scheme only. Therefore, this is the method used by the toolkit whenever \
authentication is required.\
\
 -- load required modules\
 http = require(\"socket.http\")\
 mime = require(\"mime\")\
\
 -- Connect to server \"www.example.com\" and tries to retrieve\
 -- \"/private/index.html\", using the provided name and password to\
 -- authenticate the request\
 b, c, h = http.request(\"http://fulano:silva@www.example.com/private/index.html\")\
\
 -- Alternatively, one could fill the appropriate header and authenticate\
 -- the request directly.\
 r, c = http.request {\
  url = \"http://www.example.com/private/index.html\",\
  headers = { authentication = \"Basic \" .. (mime.b64(\"fulano:silva\")) }\
 }",childs={}}
skybox = {type='class',description="6 2d images make a cube and can be set as background of a scene.",childs={["fovfactor"] = {type='function', description = " returns or sets fovfactor, renderfov = camera.fov * fovfactor", args="(skybox,[float size])", returns="(float)"},
["delete"] = {type='function', description = " deletes skybox", args="(skybox)", returns="()"},
["worldrotation"] = {type='function', description = " sets world angle/axis for skybox cubemap rotations. Also used in shaders when skyreflectmap texgen is used.", args="([float angle,x,y,z])", returns="([float angle,x,y,z])"},
["new"] = {type='function', description = " creates a new skybox from given texture filenames or uses the given texture (must be cubemap)", args="(texture cubemap / string north,south,west,east,top,bottom)", returns="(skybox)"}}}
dgeomray = {type='class',description="A ray is different from all the other geom classes in that it does not represent a solid object. It is an infinitely thin line that starts from the geom's position and extends in the direction of the geom's local Z-axis.\
Calling dCollide between a ray and another geom will result in at most one contact point. Rays have their own conventions for the contact information in the dContactGeom structure (thus it is not useful to create contact joints from this information):\
* pos - This is the point at which the ray intersects the surface of the other geom, regardless of whether the ray starts from inside or outside the geom.\
* normal - This is the surface normal of the other geom at the contact point. if dCollide is passed the ray as its first geom then the normal will be oriented correctly for ray reflection from that surface (otherwise it will have the opposite sign).\
* depth - This is the distance from the start of the ray to the contact point. \
Rays are useful for things like visibility testing, determining the path of projectiles \
or light rays, and for object placement.",childs={["get"] = {type='function', description = " returns position and normalized direction of the ray", args="(dgeomray)", returns="(float x,y,z, dx,dy,dz)"},
["length"] = {type='function', description = " sets/gets length of ray", args="(dgeomray,[float len])", returns="([float len])"},
["set"] = {type='function', description = " set position and direction of ray in space. The length of the ray will NOT be changed by using this function.", args="(dgeomray,float x,y,z, dx,dy,dz)", returns="()"},
["new"] = {type='function', description = " Create a ray geom of the given length, and return its ID. If space is given, insert it into that space.", args="([float length],[dspace])", returns="(dgeomray)"}}}
matshdcontrolid = {type='class',description="mattexcontrolid to access material shdcontrol values in matobjects",childs={}}
djointuniversal = {type='class',description="A universal joint is like a ball and socket joint that constrains an extra degree of rotational freedom. Given axis 1 on body 1, and axis 2 on body 2 that is perpendicular to axis 1, it keeps them perpendicular. In other words, rotation of the two bodies about the direction perpendicular to the two axes will be equal.\
In the picture, the two bodies are joined together by a cross. Axis 1 is attached to body 1, and axis 2 is attached to body 2. The cross keeps these axes at 90 degrees, so if you grab body 1 and twist it, body 2 will twist as well.\
A Universal joint is equivalent to a hinge-2 joint where the hinge-2's axes are perpendicular to each other, and with a perfectly rigid connection in place of the suspension.\
Universal joints show up in cars, where the engine causes a shaft, the drive shaft, to rotate along its own axis. At some point you'd like to change the direction of the shaft. The problem is, if you just bend the shaft, then the part after the bend won't rotate about its own axis. So if you cut it at the bend location and insert a universal joint, you can use the constraint to force the second shaft to rotate about the same angle as the first shaft.\
Another use of this joint is to attach the arms of a simple virtual creature to its body. Imagine a person holding their arms straight out. You may want the arm to be able to move up and down, and forward and back, but not to rotate about its own axis.",childs={["anglerate1"] = {type='function', description = " Gets Anglerate1", args="(djointuniversal)", returns="(float)"},
["anglerate2"] = {type='function', description = " Gets Anglerate2", args="(djointuniversal)", returns="(float)"},
["angle2"] = {type='function', description = " Gets Angle2", args="(djointuniversal)", returns="(float)"},
["axis1"] = {type='function', description = " Set/gets Axis1. Axis 1 and axis 2 should be perpendicular to each other.", args="(djointuniversal,[float x,y,z])", returns="([float x,y,z])"},
["anchor"] = {type='function', description = " Sets/gets anchor.", args="(djointuniversal,[float x,y,z])", returns="([float x1,y1,z1,x2,y2,z2])"},
["axis2"] = {type='function', description = " Set/gets Axis2. Axis 1 and axis 2 should be perpendicular to each other.", args="(djointuniversal,[float x,y,z])", returns="([float x,y,z])"},
["angle1"] = {type='function', description = " Gets Angle1", args="(djointuniversal)", returns="(float)"},
["new"] = {type='function', description = " creates a new universaljoint", args="([djointgroup group])", returns="(djointuniversal)"}}}
vidtype = {type='class',description="The main purpose of the vidbuffer is described here. OpenGL allows iterchanging the useage of the buffer.",childs={["feedback"] = {type='function', description = " used for storing results of vertex transformations. Needs XFBO capability", args="()", returns="(vidtype)"},
["vertex"] = {type='function', description = " used for vertex attribute streams. Needs VBO capability", args="()", returns="(vidtype)"},
["pixelto"] = {type='function', description = " used for writing pixel data from the buffer. Needs TBO capability", args="()", returns="(vidtype)"},
["pixelinto"] = {type='function', description = " used for reading pixel data into the buffer. Needs PBO capability", args="()", returns="(vidtype)"},
["index"] = {type='function', description = " used for primitive index streams. Needs VBO capability", args="()", returns="(vidtype)"},
["pixelfrom"] = {type='function', description = " used for writing pixel data from the buffer. Needs PBO capability", args="()", returns="(vidtype)"}}}
l3dshadowmodel = {type='class',description="A volume model for stencil shadows. It takes meshdata from the original model, and renders only into the stencil buffer for the given light. Models will takeover bonelinks and skinobjects. You must use camera infinitebackplane in the view that contains the shadowmodels.",childs={["istargetvalid"] = {type='function', description = " is target model/primitive still valid, if not you should delete the node.", args="(l3dshadowmodel)", returns="(boolean)"},
["islightvalid"] = {type='function', description = " is light still valid, if not you should delete the node, or use another light", args="(l3dshadowmodel)", returns="(boolean)"},
["light"] = {type='function', description = " returns or sets the light that is used. The light should be activated or sun, else its position is not updated.", args="(l3dshadowmodel,[l3dlight])", returns="([l3dlight])"},
["extrusionlength"] = {type='function', description = " returns or sets volume extrusion length. A value of 0 (default) means infinite length.", args="(l3dshadowmodel,[float])", returns="([float])"},
["new"] = {type='function', description = " creates a new l3dshadowmodel for the given nodes. Can return nil, if sourcemesh is too complex or not closed. When a l3dmodel is used you can specify a substring that is searched for in the l3dmodel's meshes. That way you can mark some meshes with nodraw/neverdraw in the original model, but use them as shadowmeshes and they still use the original animation/skin data. However when the original model is not visible, the animation data is not further updated. For l3dprimitives have in mind that you must not change the mesh after the shadowmodel was created.", args="(string name,|l3dlayerid|,l3dlight,l3dprimitive/l3dmodel,[string meshname])", returns="([l3dshadowmodel])"}}}
package = {type='class',description="The package library provides basic facilities for loading and building\
modules in Lua. It exports two of its functions directly in the global\
environment: require and module. Everything else is exported in a table package.",childs={["preload"] = {type='value', description = "[table] - A table to store loaders for specific modules (see require)."},
["loadlib"] = {type='function', description = "\
			Dynamically links the host program with the C library libname.\
			Inside this library, looks for a function funcname and returns this\
			function as a C function. (So, funcname must follow the protocol\
			(see lua_CFunction)).\
\
			This is a low-level function. It completely bypasses the package\
			and module system. Unlike require, it does not perform any path\
			searching and does not automatically adds extensions. libname must\
			be the complete file name of the C library, including if necessary\
			a path and extension. funcname must be the exact name exported by\
			the C library (which may depend on the C compiler and linker used).\
\
			This function is not supported by ANSI C. As such, it is only\
			available on some platforms (Windows, Linux, Mac OS X, Solaris,\
			BSD, plus other Unix systems that support the dlfcn standard). ", args="(string libname, string funcname)", returns="(?)"},
["cpath"] = {type='value', description = "[string] -\
			The path used by require to search for a C loader.\
\
			Lua initializes the C path package.cpath in the same way it initializes\
			the Lua path package.path, using the environment variable LUA_CPATH\
			(plus another default path defined in luaconf.h). "},
["loaded"] = {type='value', description = "[table] -\
			A table used by require to control which modules are already loaded.\
			When you require a module modname and package.loaded[modname] is\
			not false, require simply returns the value stored there. "},
["path"] = {type='value', description = "[string] -\
			The path used by require to search for a Lua loader.\
\
			At start-up, Lua initializes this variable with the value of the\
			environment variable LUA_PATH or with a default path defined in\
			luaconf.h, if the environment variable is not defined. Any \";;\"\
			in the value of the environment variable is replaced by the default\
			path.\
\
			A path is a sequence of templates separated by semicolons. For each\
			template, require will change each interrogation mark in the\
			template by filename, which is modname with each dot replaced by a\
			\"directory separator\" (such as \"/\" in Unix); then it will try to\
			load the resulting file name. So, for instance, if the Lua path\
			is\
\
			  \"./?.lua;./?.lc;/usr/local/?/init.lua\"\
\
			the search for a Lua loader for module foo will try to load the\
			files ./foo.lua, ./foo.lc, and /usr/local/foo/init.lua,\
			in that order."},
["seeall"] = {type='function', description = " Sets a metatable for module with its __index field\
			referring to the global environment, so that this module inherits\
			values from the global environment. To be used as an option to\
			function module. ", args="(module)", returns="(?)"}}}
matobject = {type='class',description="Several classes which materials can be applied to, allow the detailed control of some material values. l3dmodels need to pass 2 arguments as matobject: l3dmodel,meshid. If you pass materials, then you will change values for the default matobject. If the node's material is changed, its old materialobject will be lost.",childs={["moTexmatrix"] = {type='function', description = " sets or returns texturematrix, pass 0 as matrix4x4 to disable.", args="(matobject,[matrix4x4])", returns="(matrix4x4)"},
["moSeqoff"] = {type='function', description = " sets or returns sequence play state", args="(matobject,[boolean])", returns="(boolean)"},
["moAutotexstage"] = {type='function', description = " sets or returns matautocontrol for a texture stage. Use texgen=true if you want to modify texgenplanes. Note that only matrix controllers are allowed. Passing a non-matautocontrol will disable it.", args="(matobject,int stage,boolean texgen,[matautocontrol])", returns="([matautocontrol])"},
["moTime"] = {type='function', description = " sets or returns time value, for automatic material values. 0 means systemtime is used.", args="(matobject,[int])", returns="(time)"},
["moControl"] = {type='function', description = " sets or returns materialcontrol value. Depending on length of control, 1..4 values are required. If the control value has length > 4, as in array values, the array offset is required. Offsets are multiplied by 4.", args="(matobject,matcontrolid,[offset],[float ...])", returns="([float ...])"},
["moTexcontrol"] = {type='function', description = " sets or returns material texcontrol value.", args="(matobject,mattexcontrolid,[texture])", returns="([texture])"},
["moShdcontrol"] = {type='function', description = " sets or returns material shdcontrol value. If material has shader parameters, the passed shader must have matching parameterids as original", args="(matobject,matshdcontrolid,[shader])", returns="([shader])"},
["moModoff"] = {type='function', description = " sets or returns modifiers active state", args="(matobject,[boolean])", returns="(boolean)"},
["moRotaxis"] = {type='function', description = " 		sets or returns rotaxis of texture matrix. Returns 1,0,0, 0,1,0, 0,0,1 if no matrix is set. May contain scaling!", args="(matobject,[float x1,y1,z1,x2,y2,z2,x3,y3,z3])", returns="([float x1,y1,z1,x2,y2,z2,x3,y3,z3])"},
["moPos"] = {type='function', description = " sets or returns position of texture matrix. Returns 0,0,0 if no matrix is set", args="(matobject,[float x,y,z])", returns="([float x,y,z])"},
["moAutocontrol"] = {type='function', description = " sets or returns matautocontrol for this control value. Note that only vector controllers are allowed. Passing a non-matautocontrol will disable it.", args="(matobject,matcontrolid,[matautocontrol])", returns="([matautocontrol])"}}}
scalartype = {type='class',description="Defines what type of scalar value is used in native C.",childs={["int32"] = {type='function', description = " 32-bit signed integer. Range: [-2147483647,2147483647] Saturate/Normalize: same as int16", args="()", returns="([scalartype])"},
["uint32"] = {type='function', description = " 32-bit unsigned integer. Range: [0,4294967295] Saturate/Normalize: same as uint16", args="()", returns="([scalartype])"},
["bin2value"] = {type='value', description = "(value):(scalartype, string) converts binary string into value."},
["uint16"] = {type='function', description = " 16-bit unsigned integer. Range: [0,65535]", args="()", returns="([scalartype])"},
["uint8"] = {type='function', description = " 8-bit unsigned integer. Range: [0,255]", args="()", returns="([scalartype])"},
["float32"] = {type='function', description = " 32-bit signed float. No range limit. Saturate: [0,1]", args="()", returns="([scalartype])"},
["float64"] = {type='function', description = " 64-bit signed float. WARNING: not useable in scalararray yet! No range limit. Saturate: [0,1]", args="()", returns="([scalartype])"},
["int16"] = {type='function', description = " 16-bit signed integer. Range: [-32767,32767]", args="()", returns="([scalartype])"},
["value2bin"] = {type='value', description = "(string):(scalartype, value) converts value into binary string."},
["int8"] = {type='function', description = " 8-bit signed integer. Range: [-127,127]", args="()", returns="([scalartype])"},
["size"] = {type='value', description = "(int bytes):(scalartype, [int count]) returns size in bytes."}}}
rcmddrawmesh = {type='class',description="Draws a mesh, be aware that mesh winding is opposite (CCW) of l2dnodes (CW). Positions and sizes are always in OpenGL coordinates (0,0) = bottom left. The l2dnodes' reference size system is not used. By default starts out as fullscreen quad, 2d mesh for orhtographic overlay drawing.",childs={["matrix"] = {type='function', description = " returns or sets. Overwrites pos and is only used in non-orthographic.", args="(rcmddrawmesh,[matrix4x4])", returns="([matrix4x4])"},
["link"] = {type='function', description = " gets or sets if matrix shall be updated from a linked node. This is a weak reference and will not prevent spatialnode from gc. Passing a non-spatialnode disables the link.", args="(rcmddrawmesh,[spatialnode])", returns="([spatialnode])"},
["color"] = {type='function', description = " returns or sets color", args="(rcmddrawmesh,[float r,g,b,a])", returns="([float r,g,b,a])"},
["orthographic"] = {type='function', description = " returns or sets whether 2d orhographic overlay mode should be used instead of the current active camera. the renderflags rfNovertexcolor,rfNodepthtest and rfNodepthmask are set to true in orthographic mode (also after matsurface change). (defualt is true).", args="(rcmddrawmesh,[boolean])", returns="([boolean])"},
["autosize"] = {type='function', description = " returns or sets. 0 off -1 viewsized. Default is -1", args="(rcmddrawmesh,[int])", returns="([int])"},
["matsurface"] = {type='function', description = " returns or sets matsurface", args="(rcmddrawmesh,[matsurface])", returns="([matsurface])"},
["pos"] = {type='function', description = " returns or sets. Overwritten by matrix. xy Only used when autosize is 0 or non-orthographic. Coordinates in OpenGL (0,0) = bottomleft of current l3dview.", args="(rcmddrawmesh,[float x,y,z])", returns="([float x,y,z])"},
["usermesh"] = {type='function', description = " creates inplace custom rendermesh (see rendermesh for details) Note that polygon winding is CCW.", args="(rcmddrawmesh, vertextype, int numverts, numindices, [vidbuffer vbo], [int vbooffset], [vidbuffer ibo], [int ibooffset])", returns="()"},
["rendermesh"] = {type='function', description = " gets or sets rendermesh. Get only works if a usermesh was created before or another rendermesh passed for useage.", args="(rcmddrawmesh,[rendermesh])", returns="([rendermesh])"},
["quadmesh"] = {type='function', description = " deletes usermesh and sets quadmesh again.", args="(rcmddrawmesh)", returns="()"},
["size"] = {type='function', description = " returns or sets. xy Only used when autosize is 0 or non-orthographic. Coordinates in OpenGL (0,0) = bottomleft of current l3dview", args="(rcmddrawmesh,[float x,y,z])", returns="([float x,y,z])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmddrawmesh)"}}}
MultiLineLabel = {type='class',description="A MultiLineLabel element for displaying longer texts. A text can be marked\
	with a special syntax (see function description at new) which allows\
	creating texts with clickable zones, similiar to a hypertext\
	document.",childs={["getPreferredSize"] = {type='function', description = " returns the preferred size, which is the longest line in width and the sum of all lineheights in height", args="(MultiLineLabel)", returns="(w,h)"},
["positionUpdate"] = {type='function', description = " description from overloaded method of Component:\
\
called when the component was moved or resized.\
	Overload this method for visual appearance. The zindex is the id to use for\
	zordering the components. Return the newz value, reserving all the values that\
	you require for your visual nodes.", args="(Component self,int zindex,Rectangle clip)", returns="(int newz)"},
["onTextChange"] = {type='function', description = " called if the text changed (ie. by user input)", args="(MultiLineLabel)", returns="()"},
["new"] = {type='function', description = "\
	creates a labelwith the\
	given dimensions. The align value can be a constant from the MultiLineLabel\
	table (MultiLineLabel_ALIGNRIGHT, ...). If highlights is true, the displayed\
	text is scanned for a special syntax that creates clickable zones on the\
	component. The bounds of the zones are fitted on the marked text passages.\
	The markers are stripped away and are not displayed. A marker can be set by\
	inserting $$link...$$ into the text, where the ... can be just any string. This\
	string is then used as zonedescription. To end a zone, a $$link$$ can be set.\
	", args="(class, int x,y,w,h, text, boolean highlights, align,fontsize)", returns="(MultiLineLabel)"},
["createVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when a Component is now displayable\
	(doesn't have to be visible)", args="(Component self,l2dnode basel2d)", returns="()"},
["setAlign"] = {type='function', description = " Sets the alignment of the text", args="(MultiLineLabel,align)", returns="()"},
["addClickZone"] = {type='function', description = " Intern function that is used for adding\
	a zone. A zone is an area on the multilinelabel that can receive mouseevents (i.e.\
	for creating hyperlinks). This function is called when the multilinelabel is made visible and\
	the l2d nodes for displaying are created. The last two values are telling the position of the\
	linked textstring.", args="(self,x,y,w,h,description,l2d,strstart,strend)", returns="()"},
["getColor"] = {type='function', description = " returns rgba for basecolor", args="(MultiLineLabel)", returns="(float r,g,b,a)"},
["testForZone"] = {type='function', description = " tests if the coordinates (local) are inside a zone - the first hit\
	is returned. The zone contains following value:\
	* rect: Rectangle info of size and position of zone\
	* description: linkstring info\
	* l2d: the l2dtext node where the line is located\
	* strstart: position where the linked string starts (including the link)\
	* strend: position where the linked string ends (excluding the link)", args="(self,x,y)", returns="([table zone])"},
["countLines"] = {type='function', description = " returns number of lines for this text for the current dimension of the textfield", args="(MultiLineLabel, text)", returns="(lines)"},
["zoneAction"] = {type='function', description = " called on mouseevent action. The 'what' value is either\
	\"exit\", \"moved\" or \"clicked\" and describe the type of action. The zone is the retrieved zone for that\
	mouseposition. If no zone was matched it is nil.", args="(self,string what,mouseevent,[zone])", returns="()"},
["setColor"] = {type='function', description = " sets color for texts", args="(float r,g,b,[a])", returns="()"}}}
bonecontrol = {type='class',description="Allows manual control of bones in bonesystems found in l3dmodels.",childs={["rotaxis"] = {type='function', description = " returns or sets rotation axis, make sure they make a orthogonal basis.", args="(bonecontrol,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])", returns="([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])"},
["activate"] = {type='function', description = " activates bonecontrol on given l3dmodel", args="(bonecontrol,l3dmodel)", returns="()"},
["iklookat"] = {type='function', description = " returns or sets if a lookat effect should be applied on the ik root as well (default is false)", args="(bonecontrol,[boolean])", returns="([boolean])"},
["newabs"] = {type='function', description = " a new abs bonecontroller. The bone will takeover the target matrix or local matrix (pos/rot)", args="(boneid)", returns="(bonecontrol)"},
["invertaxis"] = {type='function', description = " returns or sets if aim axis should be inverted", args="(bonecontrol,[boolean])", returns="([boolean])"},
["axis"] = {type='function', description = " returns or sets axis along we aim", args="(bonecontrol,[int])", returns="([int])"},
["newlookat"] = {type='function', description = " a new lookat bonecontroller. The bone will orient the defined axis in such a way that it aims at the target", args="(boneid)", returns="(bonecontrol)"},
["ikiterations"] = {type='function', description = " returns or sets iterations of IK chain. how many iterations of the full IK chain we will do if we are above threshold", args="(bonecontrol,[int])", returns="([int])"},
["target"] = {type='function', description = " sets target for ik/abs/lookat, for abs it will overwrite the matrix. If no argument is passed then it will be unlinked.", args="(bonecontrol,[actnornode]/[scenenode])", returns="()"},
["ikallchildren"] = {type='function', description = " returns or sets if all affected children should be updated. By default (false) we only update the bone's parents.", args="(bonecontrol,[boolean])", returns="([boolean])"},
["newrelative"] = {type='function', description = " a new relative bonecontroller, use pos/rot to manually rotate or move a bone", args="(boneid)", returns="(bonecontrol)"},
["rotdeg"] = {type='function', description = " returns or sets rotation in degrees", args="(bonecontrol,[float x,y,z])", returns="(float x,y,z)"},
["matrix"] = {type='function', description = " returns or sets matrix", args="(bonecontrol,[matrix4x4])", returns="(matrix4x4)"},
["ikthreshold"] = {type='function', description = " returns or sets threshold of IK chain. if square distance is below threshold we stop", args="(bonecontrol,[float])", returns="([float])"},
["newik"] = {type='function', description = " a new ik bonecontroller. The bone will try to reach the target location. The bone must have one parent.", args="(boneid)", returns="(bonecontrol)"},
["ikdepth"] = {type='function', description = " returns or sets depth of IK chain. means how many steps up in hierarchy we go. number must be smaller than the parent chain this bone has.", args="(bonecontrol,[int])", returns="([int])"},
["rotrad"] = {type='function', description = " returns or sets rotation in radians", args="(bonecontrol,[float x,y,z])", returns="(float x,y,z)"},
["delete"] = {type='function', description = " deletes the controller", args="(bonecontrol)", returns="()"},
["deactivate"] = {type='function', description = " deactivates bonecontrol", args="(bonecontrol)", returns="()"},
["pos"] = {type='function', description = " returns or sets position", args="(bonecontrol,[float x,y,z])", returns="(float x,y,z)"}}}
l3dlight = {type='class',description="Lights illuminate models that have the lit renderflag set. There is one sunlight either global default or l3dset specific, just like cameras.Additionally there can be multiple FX lights in the world. All lights are pointlights without shadowing.The FX lights should have a smaller effective range, so that the engine can pick closest light to a node, becausethe number of lights at the same time is limited to 4 (1 sun, 3 fxlights).<br> Priority of FX lights will make no influence yet.<br>Lighting is done in hardware and uses following attenation formula:<br>1/(const+linear*distance+quadratic*distance*distance).<br>All lights' intensities are summed up and then multiplied with the vertexcolor.",childs={["fxnonsunlit"] = {type='function', description = " returns or sets if the fxlight should affect nodes that are not sunlit (default is true). Can be useful to split lights into 2 categories: one affect all nodes (static scenery & moveable), and the other just fully dynamic lit nodes (moveable nodes). Be aware that l3dnodes will pick the lights per full node, not on a per mesh basis, if the first drawnode is just fxlit, we will use the nonsun lights.", args="(l3dlight,[boolean])", returns="([boolean])"},
["activate"] = {type='function', description = " adds light to FX light list, if duration is passed it will get auto deactivated. Priority is unused for now", args="(l3dlight,int priority,float range,int duration)", returns="()"},
["attenuateconst"] = {type='function', description = " returns or sets constant attenuation", args="(l3dlight,[float])", returns="([float])"},
["makesun"] = {type='function', description = " makes it the default sun light", args="(l3dlight)", returns="()"},
["deactivate"] = {type='function', description = " removes light from FX light list", args="(l3dlight)", returns="()"},
["attenuatequadratic"] = {type='function', description = " returns or sets quadratic attenuation", args="(l3dlight,[float])", returns="([float])"},
["ambient"] = {type='function', description = " returns or sets ambient intensity. Intensities can be negative and exceed 0-1. This way you can creater steeper falloffs. ", args="(l3dlight,[float r,g,b,[a]])", returns="([float r,g,b,a])"},
["attenuatelinear"] = {type='function', description = " returns or sets linear attenuation", args="(l3dlight,[float])", returns="([float])"},
["rangeattenuate"] = {type='function', description = " returns or sets state of automatic range based attenuation", args="(l3dlight,[boolean])", returns="([boolean])"},
["diffuse"] = {type='function', description = " returns or sets diffuse intensity. Intensities can be negative and exceed 0-1. This way you can creater steeper falloffs.", args="(l3dlight,[float r,g,b,[a]])", returns="([float r,g,b,a])"},
["new"] = {type='function', description = " creates new light", args="(string name,l3dlayerid layer)", returns="([l3dlight])"}}}
rcmddrawl3d = {type='class',description="Draws a single l3dnode (l3dmodels allow single or sub series of meshids), only when l3dnode is visible. Useful for greater control over mesh rendering.",childs={["forcedraw"] = {type='function', description = " returns or sets whether the l3dnode shall be drawn even if wasnt updated (visible) this frame (default false).", args="(rcmddrawl3d,[boolean])", returns="([boolean])"},
["submeshes"] = {type='function', description = " for l3dmodels returns or sets which sub meshid is used as start, as well as how many meshes are drawn (default 1). l3dmodels default to all meshes being drawn. Has no affect on non-l3dmodels.", args="(rcmddrawl3d,[meshid,[int cnt]])", returns="([meshid, int cnt])"},
["node"] = {type='function', description = " returns or sets which l3dnode is used. l3dmodels default to all meshes being drawn. Passing a non-l3dnode disables it. l3dlevelmodels are not allowed", args="(rcmddrawl3d,[l3dnode])", returns="([l3dnode])"},
["new"] = {type='function', description = " returns the rcmd.", args="()", returns="(rcmddrawl3d)"}}}
djointamotor = {type='class',description="An angular motor (AMotor) allows the relative angular velocities of two bodies to be controlled. The angular velocity can be controlled on up to three axes, allowing torque motors and stops to be set for rotation about those axes. This is mainly useful in conjunction will ball joints (which do not constrain the angular degrees of freedom at all), but it can be used in any situation where angular control is needed. To use an AMotor with a ball joint, simply attach it to the same two bodies that the ball joint is attached to.",childs={["numaxes"] = {type='function', description = " Sets/gets the number of angular axes that will be controlled by the AMotor. The argument num can range from 0 (which effectively deactivates the joint) to 3. This is automatically set to 3 in eulermode", args="([int])", returns="([int])"},
["usermode"] = {type='function', description = " If usermode is true, the user directly sets the axes that the AMotor controls. If it is false, eulermode is active which means that the AMotor computes the euler angles corresponding to the relative rotation, allowing euler angle torque motors and stops to be set.", args="(djointamotor,[boolean])", returns="([boolean])"},
["anglerate"] = {type='function', description = " Return the current angle rate for axis anum. In usermode this is always zero, as not enough information is available. In euler mode this is the corresponding euler angle rate.", args="(djointamotor,int anum)", returns="(float)"},
["angle"] = {type='function', description = " Tell the AMotor what the current angle is along axis anum. This function should only be called in user mode, because in this mode the AMotor has no other way of knowing the joint angles. The angle information is needed if stops have been set along the axis, but it is not needed for axis motors.\
If no angle is passed, it return the current angle for axis anum. In user mode this is simply the value that was set with. In euler mode this is the corresponding euler angle.", args="(djointamotor,int anum, [float angle])", returns="([float angle])"},
["axis"] = {type='function', description = " Sets/gets the AMotor axes. The anum argument selects the axis to change (0,1 or 2). Each axis can have one of three 'relative orientation' modes, selected by rel:\
* 0: The axis is anchored to the world frame.\
* 1: The axis is anchored to the first body.\
* 2: The axis is anchored to the second body. \
The axis vector (x,y,z) is always specified in world coordinates regardless of the setting of rel. There are two GetAMotorAxis functions, one to return the axis and one to return the relative mode.\
For dAMotorEuler mode:\
* Only axes 0 and 2 need to be set. Axis 1 will be determined automatically at each time step.\
* Axes 0 and 2 must be perpendicular to each other.\
* Axis 0 must be anchored to the first body, axis 2 must be anchored to the second body. \
", args="(djointamotor,[int anum,rel, float x,y,z])", returns="([int,float x,y,z])"},
["new"] = {type='function', description = " creates a new amotorjoint", args="([djointgroup group])", returns="(djointamotor)"}}}
ImageComponent = {type='class',description="A ImageComponent element for displaying simple images (textures, material, plain colors).",childs={["deleteVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when a Component is no longer displayed", args="(Component self)", returns="()"},
["onGainedFocus"] = {type='function', description = " simply forwards the focus to the next element.", args="(from)", returns="()"},
["positionUpdate"] = {type='function', description = " description from overloaded method of Component:\
\
called when the component was moved or resized.\
	Overload this method for visual appearance. The zindex is the id to use for\
	zordering the components. Return the newz value, reserving all the values that\
	you require for your visual nodes.", args="(Component self,int zindex,Rectangle clip)", returns="(int newz)"},
["color"] = {type='function', description = " color for imagecomponent", args="(ImageComponent,float r,g,b,a)", returns="()"},
["blendmode"] = {type='function', description = " blendmode for imagecomponent", args="(ImageComponent,blendmode)", returns="()"},
["getUVRotRad"] = {type='function', description = " gets uv rotation angle", args="(ImageComponent)", returns="(phi)"},
["mouseClicked"] = {type='function', description = " description from overloaded method of Component:\
\
called if the mouse was clicked on the component.", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["getL2DImage"] = {type='function', description = " returns the used imagecomponent", args="(ImageComponent)", returns="(l2dimage)"},
["new"] = {type='function', description = ".", args="(class, int x,y,w,h, matsurface, [autofocus],[blendmode],[matrix4x4 texmatrix])", returns="(ImageComponent)"},
["setL2DImage"] = {type='function', description = " sets the used l2dimage", args="(ImageComponent,l2d)", returns="()"},
["getUVPos"] = {type='function', description = " gets uv translation", args="(ImageComponent,x,y)", returns="()"},
["isFocusable"] = {type='function', description = " returns true if visible", args="(ImageComponent)", returns="(boolean)"},
["toString"] = {type='function', description = " returns simple component representation", args="(ImageComponent)", returns="(string)"},
["texmatrix"] = {type='function', description = " texturematrix for imagecomponent, pass a non matrix4x4 to disable", args="(ImageComponent,matrix4x4)", returns="(matrix4x4)"},
["matsurface"] = {type='function', description = " matsurface for imagecomponent", args="(ImageComponent,matsurface)", returns="(matsurface)"},
["setUVScale"] = {type='function', description = " sets scaling for uv", args="(ImageComponent,x,y)", returns="()"},
["setUVRotRad"] = {type='function', description = " sets uv rotation angle", args="(ImageComponent,phi)", returns="()"},
["createVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when a Component is now displayable\
	(doesn't have to be visible)", args="(Component self,l2dnode basel2d)", returns="()"},
["setUVPos"] = {type='function', description = " sets uv translation", args="(ImageComponent,x,y)", returns="()"},
["getUVScale"] = {type='function', description = " gets scaling for uv", args="(ImageComponent)", returns="(x,y)"}}}
rcmdlogicop = {type='class',description="Allows bitwise framebuffer operations (not legal for float rendertargets), overrides blendmodes when active.",childs={["logic"] = {type='function', description = " returns or sets logicmode used for logicop.", args="(rcmdlogicop,[logicmode])", returns="([logicmode])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdlogicop)"}}}
DebugOutput = {type='class',description="A few helpers to print text on screen quickly.\
			The output has 10 slots that you can use to print text out. \
			\
			Example:\
			 DebugOutput.enable(true)\
			 DebugOutput.set(1,string.format(\"a = %.2f\",math.pi))\
			\
			This will print pi as text on the screen. This is useful i.e. if\
			you try to figure out good values for angles, rotations, velocities, \
			etc. during runtime. ",childs={}}
l3dlevelmodel = {type='class',description="A model that is very large and contains static geometry. The model will be split into a subdivided visibility cubes. Meshes that contain 'lightmap_' in their texture string will get those auto-loaded and applied.",childs={["lightmapcount"] = {type='function', description = " returns how many lightmaps are used.", args="(l3dlevelmodel)", returns="(int)"},
["lightmap"] = {type='function', description = " returns ith lightmap.", args="(l3dlevelmodel,int i)", returns="(texture)"},
["new"] = {type='function', description = " creates new l3dlevelmodel. Visibility cubes are generated with the given separations (>=1).", args="(string name,|l3dlayerid|,model,int separatorsx,y,z, [int minpolys],[float mergemargin])", returns="([l3dlevelmodel])"}}}
rcmddrawdbg = {type='class',description="Draws the debug helpers. (see render class)",childs={["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmddrawdbg)"}}}
floatarray = {type='class',description="Floatarray in Luxinia for array operations.",childs={["v3"] = {type='function', description = " returns or sets ith vector3, make sure count is 3*maxindex.", args="(floatarray,int index, [float x,y,z])", returns="([float x,y,z])"},
["v3all"] = {type='function', description = " returns or sets all values of the floatarray, optionally can set from which float to start and how many vectors. Vectorsize is 3+stride.", args="(floatarray,float x,y,z,[int startfloat, vectorcount, stride])", returns="()"},
["v4all"] = {type='function', description = " returns or sets all values of the floatarray, optionally can set from which float to start and how many vectors. Vectorsize is 4+stride.", args="(floatarray,float x,y,z,w,[int startfloat, vectorcount, stride])", returns="()"},
["v3lerp"] = {type='function', description = " does linear interpolation based on the n vectors (eventimed), and interpolates using i steps.", args="(floatarray interpolated(3i), floatarray splinepos(3n),[int noverride])", returns="()"},
["v4spline"] = {type='function', description = " does spline interpolation based on the n splinepos vectors (eventimed), and interpolates using i steps.", args="(floatarray interpolated(4i), floatarray splinepos(4n),[int noverride])", returns="()"},
["new"] = {type='function', description = " creates a new staticarray. Count must be >0.", args="(int count)", returns="(floatarray)"},
["sub"] = {type='function', description = " self-=a or self = a - b", args="(floatarray self,floatarray / value a, [floatarray b])", returns="()"},
["set"] = {type='function', description = " self = a (copy an array or set value to all)", args="(floatarray self,floatarray / value a)", returns="()"},
["max"] = {type='function', description = " self = max(self,a) or self = max(a,b)", args="(floatarray self,floatarray / value a, [floatarray b])", returns="()"},
["div"] = {type='function', description = " self/=a or self = a / b", args="(floatarray self,floatarray / value a, [floatarray b])", returns="()"},
["v4"] = {type='function', description = " returns or sets ith vector4, make sure count is 4*maxindex.", args="(floatarray,int index, [float x,y,z,w])", returns="([float x,y,z,w])"},
["v3tonext"] = {type='function', description = " for every vector we do (next-self)", args="(floatarray out(3n))", returns="()"},
["mul"] = {type='function', description = " self*=a or self = a * b", args="(floatarray self,floatarray / value a, [floatarray b])", returns="()"},
["v4lerp"] = {type='function', description = " does linear interpolation based on the n vectors (eventimed), and interpolates using i steps.", args="(floatarray interpolated(4i), floatarray splinepos(4n),[int noverride])", returns="()"},
["v4lit"] = {type='function', description = " computes per vertex lighting intensities for n vertices into the given array. The given light position, attenuation and color values are used. Note that light position must be in same coordinate system as vertices (local).", args="(floatarray outputintensities(4n), floatarray vertexpos(3n), floatarray vertexnormal(3n), float lightpos x,y,z ,float diffuse r,g,b ,float ambient r,g,b ,float attconst, float attlin, float attsq)", returns="()"},
["lerp"] = {type='function', description = " does linear interpolation based on the n floats (eventimed), and interpolates using i steps.", args="(floatarray interpolated(i), floatarray splinepos(n),[int noverride])", returns="()"},
["min"] = {type='function', description = " self = min(self,a) or self = min(a,b)", args="(floatarray self,floatarray / value a, [floatarray b])", returns="()"},
["v3spline"] = {type='function', description = " does spline interpolation based on the n splinepos vectors (eventimed), and interpolates using i steps.", args="(floatarray interpolated(3i), floatarray splinepos(3n),[int noverride])", returns="()"},
["add"] = {type='function', description = " self+=a or self = a + b", args="(floatarray self,floatarray / value a, [floatarray b])", returns="()"}}}
comparemode = {type='class',description="For some rendering operations you can set compare behavior. eg. GREATER means a value passes when greater than a given user threshold.",childs={["lequal"] = {type='function', description = " less or equal", args="()", returns="(comparemode)"},
["always"] = {type='function', description = " any value passes", args="()", returns="(comparemode)"},
["never"] = {type='function', description = " no value passes", args="()", returns="(comparemode)"},
["run"] = {type='function', description = " runs the comparemode and returns result", args="(comparemode,float value, float ref)", returns="(boolean)"},
["gequal"] = {type='function', description = " greater or equal", args="()", returns="(comparemode)"},
["equal"] = {type='function', description = " ", args="()", returns="(comparemode)"},
["greater"] = {type='function', description = " ", args="()", returns="(comparemode)"},
["less"] = {type='function', description = " ", args="()", returns="(comparemode)"},
["disable"] = {type='function', description = " removes setting the compare, warning if rfAlphatest is still true you will get undefined behavior", args="()", returns="(comparemode)"},
["notequal"] = {type='function', description = " ", args="()", returns="(comparemode)"}}}
matsurface = {type='class',description="Most renderable items allow their material to be changed. A materialsurface can either be just color, a texture or a material.",childs={["vertexcolor"] = {type='function', description = " removes any previous materialinfo and makes the surface just vertexcolored", args="()", returns="(matsurface)"},
["contains"] = {type='function', description = " checks if one matsurface contains another or is equal", args="(matsurface self, matsurface other)", returns="(boolean)"}}}
rcmdupdatetex = {type='class',description="Upload the texture data from a vidbuffer.",childs={["buffer"] = {type='function', description = " returns or sets vidbuffer used for reading.", args="(rcmdupdatetex,[vidbuffer,[int offset]])", returns="([vidbuffer,offset])"},
["pos"] = {type='function', description = " returns or sets the data position.", args="(rcmdupdatetex,[int x,y,z,[mip]])", returns="([int x,y,z,mip])"},
["tex"] = {type='function', description = " returns or sets texture used.", args="(rcmdupdatetex,[texture])", returns="([texture])"},
["format"] = {type='function', description = " sets datatype.", args="(rcmdupdatetex,texdatatype)", returns="()"},
["size"] = {type='function', description = " returns or sets the data dimensions.", args="(rcmdupdatetex,[int w,h,d])", returns="([int w,h,d])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdupdatetex)"}}}
ComboBox = {type='class',description="A ComboBox combines multiple strings that can be selected in a\
	small rectangle. The current state is very simple but is capable of mimic the\
	basics of a normal ComboBox.",childs={["getSelected"] = {type='function', description = "\
	returns information on the currently selected item.", args="(ComboBox)", returns="([int index, string caption, string command])"},
["select"] = {type='function', description = "\
	selects the specified item by its name, number or commandstring", args="(ComboBox, string/int something, [boolean iscommand])", returns="(int selected)"},
["getItems"] = {type='function', description = " returns a table with all items (copy).\
	Each tableelement is a table containing following keys:\
	* caption\
	* command\
	* icon\
	* iconname\
	The values are all optional except for the caption.", args="(ComboBox)", returns="(table)"},
["addItem"] = {type='function', description = " \
	adds an item to the combobox. It returns a function that can be called again:\
	 mycombobox:addItem(\"Hello\")(\"World\") -- adds hello and world \
	 ", args="(ComboBox, string caption, [string cmd,[icon, iconskinselection] ])", returns="(function add)"},
["onSelected"] = {type='function', description = " this function\
	can be overloaded without calling this function. It is called each time the\
	user selects an item - which does not have to be different from the previously\
	selected item.", args="(ComboBox,int index, string caption, string command)", returns="()"},
["new"] = {type='function', description = " creates a combobox\
	at the given coordinates with the given skin.", args="(table class, int x,y,w,h,[Skin2D skin])", returns="(ComboBox)"},
["removeItem"] = {type='function', description = " Removes an item from the list. The id refers to the \
	index of the item in the list.", args="(ComboBox, int id)", returns="()"},
["setItems"] = {type='function', description = " sets (and clears previous) all items. Table must be built like the one\
	retrieved by getItems.", args="(ComboBox,table)", returns="()"},
["clearItems"] = {type='function', description = " removes all items from the list", args="(ComboBox)", returns="()"}}}
Timer = {type='class',description="Luxinia does automaticly call a function named 'think' in a table called 'luxinia'\
		each frame. The Timer class registers this function and provides a mechanism\
		to add additional function that should be called each frame.\
\
		The function is being disabled if it throws an error.\
\
		The timer has been changed during 0.93 to use coroutines. This is quite useful:\
		you can yield a function at any point of time during execution if it is\
		called by a timer or timertask. The execution is then continued later.\
		For timers, this is the next period, for TimerTasks, please read the documentation\
		on the TimerTask class. You can create endless loops just as this:\
\
		 Timer.set(\"endless loop\",\
		 	function ()\
		 		while true do\
		 			print \"tick\"\
		 			coroutine.yield()\
		 		end\
		 	end, 50)\
\
		The code sample above will create a timertask that is executed about every\
		50 ms and will always print \"tick\" out.\
\
		Coroutines are useful utilities to create AIs, agents or gameloops.\
		You do not have to change a state of a game function for example:\
\
		 Timer.set(\"game\",\
		 	function ()\
		 		local gamestarts,gamefinished\
		 		repeat\
		 			-- do something about intro menu etc. stuff\
		 			coroutine.yield()\
		 		until gamestarts\
\
		 		repeat\
		 			-- make some gamelogic stuff, spawing actors, etc\
		 			-- set gamefinished to true or break loop if game is finished\
		 			coroutine.yield()\
		 		until gamefinished\
		 	end, 1000/30)\
\
		The code sample above will be executed every 30 fps. You can also nest the\
		loops in loops, for example for each level. Instead of writing different\
		functions that represent your state of game and that are selected for\
		execution, you can use this method to create a linear way of writing a\
		game.\
		",childs={["remove"] = {type='function', description = " removes a timer function from the Timer list.", args="(string/function key)", returns="()"},
["think"] = {type='function', description = " Function that is called each frame. If you switch to\
				manual frame processing within lua, you should call this\
				function each frame you do, since other modules are dependent\
				on the timer function (i.e. the Keyboard class).\
			", args="()", returns="()"},
["set"] = {type='function', description = "\
				set a function to be called each frame if interval is not passed.\
				If interval is a number (minimum 1), the function will be called\
				in the intervals in milliseconds. The timer automaticly repeates\
				calls if the timer is late. If the maxcnt argument is passed,\
				the timer won't be called more often than maxcnt per frame -\
				if a timer is behind time, this prevents the system too freeze\
				if the timerfunction is taking longer than its given interval.\
\
				fn will be called with the local time of the function as first\
				argument and the number of the repeated calls within\
				this frame as second argument (@@fn(int localtime, int repeatedcalls)@@).\
				The localtime is increased by the value of interval each time\
				a call is done.\
\
				The description string can be used to remove a timer. The timer\
				is identified by the function value and multiple timers can share\
				the same description string (and can all be removed with one remove\
				call this way).\
\
				Returns the passed function.", args="(string description,function fn[, int interval], [int maxcnt])", returns="(function fn)"},
["enable"] = {type='function', description = " enables a disabled timerfunction again\
			", args="(string/function key)", returns="()"},
["frame"] = {type='function', description = " returns the frame (or the number of thinkcycles)", args="()", returns="(int)"},
["finally"] = {type='function', description = " the finally function is a list of\
				functions that should be executed when all timers are finished.\
				The timer and the finish functions are called in no particular\
				order so this is just a method to do some stuff at the end\
				of the timer calls (the timertasks are finished till then too).\
				A key can\
				only be registered one time, after that it will overwrite the\
				previous function.\
\
				The finally function registrations are only valid for the\
				current frame, so you must reregister it if required.\
\
				This functionality exists to provide help on optimized updating\
				- you may want to collect information on for the real update\
				function of an object that can then update all information\
				alltogether instead of doing the same again and again updating\
				ony tiny changes.\
\
				Registering finally functions in a finally function call works.\
				The new registered function is called once all previously\
				registered functions have been executed.\
				If you keep on registering finally functions, this means that\
				the finally calls will never stop!\
			", args="(key,function)", returns="()"}}}
dcollider = {type='class',description="Subclasses can perform collision detection.",childs={["delete"] = {type='function', description = " deletes a dcollider", args="(dcollider)", returns="()"}}}
rcmdfbobind = {type='class',description="Binds a renderfbo (if capability exists). Fbos allow enhanced render-to-texture operation, and off-screen rendering to large buffers. Once you start using renderfbos it is heavily recommended to check your setup for the whole l3dlist with l3dlist.fbotest. An fbo setup consists of rcmdfbobind (for binding), rcmdfbotex or rcmdfborb for attaching renderbuffers/textures and finally the rcmdfbodrawto command which specifies which assignment the color is rendered to.",childs={["setup"] = {type='function', description = " returns or sets renderfbo, must be defined before use. Viewportchange means that active viewport dimensions are changed to fbo dimension (0,0, fbowidth, fboheight) and is by default true. l3dviews viewport dimensions become active again once fbo is unbound.", args="(rcmdfbobind,[renderfbo,[boolean viewportchange]])", returns="([renderfbo, boolean viewportchange])"},
["readbuffer"] = {type='function', description = " returns or sets whether target is readbuffer binding, or drawbuffer. Readbuffer functionality requires extra capability and by default is off. Viewportchange is ignored when readbuffer is true.", args="(rcmdfbobind, [boolean readbuffer])", returns="([boolean readbuffer])"},
["new"] = {type='function', description = " returns the rcmd for fbo binding. Make sure to setup the fbo to bind.", args="()", returns="(rcmdfbobind)"}}}
l2dnode3d = {type='class',description="list2d node that links to a l3d node (l3dmodel,l3dprimitive,l3dtrail). ==The l3dnode is prevented from gc, as long as l2dnode is not gc'ed.",childs={["l3d"] = {type='function', description = " returns or sets l3dnode", args="(l2dnode3d,[l3dnode])", returns="([l3dnode])"},
["new"] = {type='function', description = " returns a new l2dlinkedl3d", args="(string name,l3dnode)", returns="(l2dnode3d)"}}}
mathlib = {type='class',description="provides some accelerated functions dealing with vector/matrix math or array operations",childs={["rotdeg2quat"] = {type='function', description = " converts euler angles (degrees) to quaternion", args="(float ax,ay,az)", returns="(float qx,qy,qz,qw)"},
["quatslerpqt"] = {type='function', description = " returns quaternion spherical quadratic tangent interpolation bettween a and b", args="(float fracc,px,py,pz,pw,ax,ay,az,aw,bx,by,bz,bw,nx,ny,nz,nw)", returns="(float qx,qy,qz,qw)"},
["quat2rotdeg"] = {type='function', description = " converts quaternion to euler angles (degrees)", args="(float qx,qy,qz,qw)", returns="(float ax,ay,az)"},
["rotrad2quat"] = {type='function', description = " converts euler angles (radians) to quaternion", args="(float ax,ay,az)", returns="(float qx,qy,qz,qw)"},
["quatslerp"] = {type='function', description = " returns quaternion spherical interpolation bettween a and b", args="(float fracc,ax,ay,az,aw,bx,by,bz,bw)", returns="(float qx,qy,qz,qw)"},
["quatslerpq"] = {type='function', description = " returns quaternion spherical quadratic interpolation bettween a and b", args="(float fracc,px,py,pz,pw,ax,ay,az,aw,bx,by,bz,bw,nx,ny,nz,nw)", returns="(float qx,qy,qz,qw)"},
["quat2rotrad"] = {type='function', description = " converts quaternion to euler angles (radians)", args="(float qx,qy,qz,qw)", returns="(float ax,ay,az)"}}}
string = {type='class',description="From the official Lua Reference (http://www.lua.org):\
\
This library provides generic functions for string manipulation, such as\
finding and extracting substrings, and pattern matching. When indexing a\
string in Lua, the first character is at position 1 (not at 0, as in C).\
Indices are allowed to be negative and are interpreted as indexing backwards,\
from the end of the string. Thus, the last character is at position -1, and so on.\
\
The string library provides all its functions inside the table string. It\
also sets a metatable for strings where the __index field points to the\
metatable itself. Therefore, you can use the string functions in\
object-oriented style. For instance, string.byte(s, i) can be written as\
s:byte(i).\
\
!!Patterns\
\
A character class is used to represent a set of characters. The following\
combinations are allowed in describing a character class:\
\
* x (where x is not one of the magic characters ^$()%.[]*+-?) --- represents the\
character x itself.\
* . --- (a dot) represents all characters.\
* %a --- represents all letters.\
* %c --- represents all control characters.\
* %d --- represents all digits.\
* %l --- represents all lowercase letters.\
* %p --- represents all punctuation characters.\
* %s --- represents all space characters.\
* %u --- represents all uppercase letters.\
* %w --- represents all alphanumeric characters.\
* %x --- represents all hexadecimal digits.\
* %z --- represents the character with representation 0.\
* %x (where x is any non-alphanumeric character) --- represents the character x.\
This is the standard way to escape the magic characters. Any punctuation character\
(even the non magic) can be preceded by a `%Â´ when used to represent itself in a pattern.\
\
* [set] --- represents the class which is the union of all characters in set. A\
range of characters may be specified by separating the end characters of the range\
with a `-Â´. All classes %x described above may also be used as components in set.\
All other characters in set represent themselves. For example, [%w_] (or [_%w])\
represents all alphanumeric characters plus the underscore, [0-7] represents the\
octal digits, and [0-7%l%-] represents the octal digits plus the lowercase letters\
plus the `-Â´ character.\
\
The interaction between ranges and classes is not defined. Therefore, patterns\
like [%a-z] or [a-%%] have no meaning.\
\
* [^set] --- represents the complement of set, where set is interpreted as above.\
\
For all classes represented by single letters (%a, %c, etc.), the corresponding\
uppercase letter represents the complement of the class. For instance, %S represents\
all non-space characters.\
\
The definitions of letter, space, and other character groups depend on the current\
locale. In particular, the class [a-z] may not be equivalent to %l.\
\
A pattern item may be\
\
* a single character class, which matches any single character in the class;\
* a single character class followed by `*Â´, which matches 0 or more repetitions\
of characters in the class. These repetition items will always match the longest\
possible sequence;\
* a single character class followed by `+Â´, which matches 1 or more repetitions\
of characters in the class. These repetition items will always match the longest\
possible sequence;\
* a single character class followed by `-Â´, which also matches 0 or more repetitions\
of characters in the class. Unlike `*Â´, these repetition items will always match the\
shortest possible sequence;\
* a single character class followed by `?Â´, which matches 0 or 1 occurrence of a\
character in the class;\
* %n, for n between 1 and 9; such item matches a substring equal to the n-th\
captured string (see below);\
* %bxy, where x and y are two distinct characters; such item matches strings\
that start with x, end with y, and where the x and y are balanced. This means\
that, if one reads the string from left to right, counting +1 for an x and -1\
for a y, the ending y is the first y where the count reaches 0. For instance,\
the item %b() matches expressions with balanced parentheses.\
\
A pattern is a sequence of pattern items. A `^Â´ at the beginning of a pattern\
anchors the match at the beginning of the subject string. A `$Â´ at the end of\
a pattern anchors the match at the end of the subject string. At other positions,\
`^Â´ and `$Â´ have no special meaning and represent themselves.\
\
A pattern may contain sub-patterns enclosed in parentheses; they describe\
captures. When a match succeeds, the substrings of the subject string that\
match captures are stored (captured) for future use. Captures are numbered\
according to their left parentheses. For instance, in the pattern \"(a*(.)%w(%s*))\",\
the part of the string matching \"a*(.)%w(%s*)\" is stored as the first\
capture (and therefore has number 1); the character matching \".\" is captured\
with number 2, and the part matching \"%s*\" has number 3.\
\
As a special case, the empty capture () captures the current string position\
(a number). For instance, if we apply the pattern \"()aa()\" on the string \"flaaap\",\
there will be two captures: 3 and 5.\
\
A pattern cannot contain embedded zeros. Use %z instead. ",childs={["match"] = {type='function', description = "\
				Looks for the first match of pattern in the string s.\
				If it finds one, then match returns the captures from the pattern;\
				otherwise it returns nil. If pattern specifies no captures, then\
				the whole match is returned. A third, optional numerical argument\
				init specifies where to start the search; its default value is 1\
				and may be negative.", args="(string s, string pattern, [int init])", returns="([string ...])"},
["gmatch"] = {type='function', description = "\
Returns an iterator function that, each time it is called, returns the next\
captures from pattern over string s.\
\
If pattern specifies no captures, then the whole match is produced in each call.\
\
As an example, the following loop\
\
  s = \"hello world from Lua\"\
  for w in string.gmatch(s, \"%a+\") do\
    print(w)\
  end\
\
will iterate over all the words from string s, printing one per line. The next\
example collects all pairs key=value from the given string into a table:\
\
  t = {}\
  s = \"from=world, to=Lua\"\
  for k, v in string.gmatch(s, \"(%w+)=(%w+)\") do\
    t[k] = v\
  end\
", args="(string s, string pattern)", returns="(function iterator)"},
["upper"] = {type='function', description = " Receives a string and returns a\
				copy of this string with all lowercase letters changed to\
				uppercase. All other characters are left unchanged.\
				The definition of what a lowercase letter is depends on\
				the current locale.", args="(string str)", returns="(string lower)"},
["gsub"] = {type='function', description = "\
Returns a copy of s in which all occurrences of the pattern have been replaced\
by a replacement string specified by repl, which may be a string, a table, or\
a function. gsub also returns, as its second value, the total number of\
substitutions made.\
\
If repl is a string, then its value is used for replacement. The character %\
works as an escape character: Any sequence in repl of the form %n, with n\
between 1 and 9, stands for the value of the n-th captured substring (see below).\
The sequence %0 stands for the whole match. The sequence %% stands for a single %.\
\
If repl is a table, then the table is queried for every match, using the first\
capture as the key; if the pattern specifies no captures, then the whole match\
is used as the key.\
\
If repl is a function, then this function is called every time a match occurs,\
with all captured substrings passed as arguments, in order; if the pattern\
specifies no captures, then the whole match is passed as a sole argument.\
\
If the value returned by the table query or by the function call is a string or\
a number, then it is used as the replacement string; otherwise, if it is false\
or nil, then there is no replacement (that is, the original match is kept in\
the string).\
\
The optional last parameter n limits the maximum number of substitutions\
to occur. For instance, when n is 1 only the first occurrence of pattern\
is replaced.\
\
Here are some examples:\
\
   x = string.gsub(\"hello world\", \"(%w+)\", \"%1 %1\")\
   --> x=\"hello hello world world\"\
\
   x = string.gsub(\"hello world\", \"%w+\", \"%0 %0\", 1)\
   --> x=\"hello hello world\"\
\
   x = string.gsub(\"hello world from Lua\", \"(%w+)%s*(%w+)\", \"%2 %1\")\
   --> x=\"world hello Lua from\"\
\
   x = string.gsub(\"home = $HOME, user = $USER\", \"%$(%w+)\", os.getenv)\
   --> x=\"home = /home/roberto, user = roberto\"\
\
   x = string.gsub(\"4+5 = $return 4+5$\", \"%$(.-)%$\", function (s)\
         return loadstring(s)()\
       end)\
   --> x=\"4+5 = 9\"\
\
   local t = {name=\"lua\", version=\"5.1\"}\
   x = string.gsub(\"$name%-$version.tar.gz\", \"%$(%w+)\", t)\
   --> x=\"lua-5.1.tar.gz\"\
", args="()", returns="()"},
["format"] = {type='function', description = "\
Returns a formatted version of its variable number of arguments following the\
description given in its first argument (which must be a string). The format\
string follows the same rules as the printf family of standard C functions.\
The only differences are that the options/modifiers *, l, L, n, p, and h are\
not supported and that there is an extra option, q. The q option formats a\
string in a form suitable to be safely read back by the Lua interpreter: The\
string is written between double quotes, and all double quotes, newlines,\
embedded zeros, and backslashes in the string are correctly escaped when\
written. For instance, the call\
\
 string.format('%q', 'a string with \"quotes\" and \\n new line')\
\
will produce the string:\
\
\"a string with \\\"quotes\\\" and \\\
 new line\"\
\
The options c, d, E, e, f, g, G, i, o, u, X, and x all expect a number as\
argument, whereas q and s expect a string.\
\
This function does not accept string values containing embedded zeros. ", args="(string format, e1, e2 ...)", returns="(string formatted)"},
["lower"] = {type='function', description = " Receives a string and returns a\
				copy of this string with all uppercase letters changed to\
				lowercase. All other characters are left unchanged. The definition\
				of what an uppercase letter is depends on the current locale.", args="(string s)", returns="(string lowered)"},
["sub"] = {type='function', description = " Returns the substring\
				of s that starts at i and continues\
				until j; i and j may be negative. If j is absent, then it is\
				assumed to be equal to -1 (which is the same as the string length).\
				In particular, the call string.sub(s,1,j) returns a prefix of s\
				with length j, and string.sub(s, -i) returns a suffix of s with length i.", args="(string s, int i, [int j])", returns="(string str)"},
["l2dheight"] = {type='function', description = " returns number of \\ns in text", args="(string)", returns="(height)"},
["find"] = {type='function', description = "\
Looks for the first match of pattern in the string s.\
\
If it finds a match, then find returns the indices of s where this occurrence\
starts and ends; otherwise, it returns nil. A third, optional numerical argument\
init specifies where to start the search; its default value is 1 and may be\
negative. A value of true as a fourth, optional argument plain turns off the\
pattern matching facilities, so the function does a plain \"find substring\"\
operation, with no characters in pattern being considered \"magic\". Note that\
if plain is given, then init must be given as well.\
\
If the pattern has captures, then in a successful match the captured values\
are also returned, after the two indices. ", args="(string s, string pattern, [int init[, plain] ])", returns="([int start, int end, string captures,...])"},
["char"] = {type='function', description = "\
Receives 0 or more integers. Returns a string with length equal to the number of\
arguments, in which each character has the internal numerical code equal to its\
corresponding argument.\
\
Note that numerical codes are not necessarily portable across platforms.\
", args="(int i1, int i2, ...)", returns="(string str)"},
["dump"] = {type='function', description = "\
Returns a string containing a binary representation of the given function,\
so that a later loadstring on this string returns a copy of the function.\
function must be a Lua function without upvalues.", args="(function f)", returns="(string binarybytecode)"},
["len"] = {type='function', description = " Receives a string and returns its length. The empty\
				string \"\" has length 0. Embedded zeros are counted, so \"a\\000bc\\000\"\
				has length 5.", args="(string s)", returns="(int n)"},
["reverse"] = {type='function', description = " Returns a string that is the\
				string s reversed.", args="(string s)", returns="(string reversed)"},
["byte"] = {type='function', description = "\
Returns the internal numerical codes of the characters s[i], s[i+1], ..., s[j].\
The default value for i is 1; the default value for j is i.\
\
Note that numerical codes are not necessarily portable across platforms. ", args="(string str, [int i [,int j] ])", returns="(int c1,...)"},
["exec"] = {type='function', description = "\
				executes the given cmd string and returns true if it was\
				successful plus the return values from the function.\
				Otherwise the compilation error is returned as\
				second argument. ", args="(string cmd, [table env,[table param] ])", returns="(boolean success,...)"},
["rep"] = {type='function', description = " Returns a string that is the\
				concatenation of n copies of the string s.", args="(string s, int n)", returns="(string repeated)"},
["l2dlen"] = {type='function', description = " returns length of string without invisible characters to l2dstring - in case of multiline\
					the longes line count is returned", args="(string)", returns="(len)"}}}
resource = {type='class',description="Resources are files that are typically loaded from the harddisk and are not managed with dynamic memory management, but stored within a reschunk. Unloading of a loaded resources is not trivial, but possible. Unloading of resources is done by the reschunk class.<br><br>The load function will try to load the file or return the first instance of the same name. The forceload function will make sure a new copy of this resourcetype (not other resourcetypes) will be loaded.All create functions behave similar to load, they first look for the instance name being loaded/created before, and return that resource, or run the creation process. Therefore make sure to have unique identifier names when you want create multiple unique resources.",childs={["getresshortname"] = {type='function', description = " returns the resource filename without paths and optional second argname", args="(resource)", returns="(string,[string])"},
["getresname"] = {type='function', description = " returns the resource filename and optional second argname", args="(resource)", returns="(string,[string])"},
["condition"] = {type='function', description = " Some resources allow sort of preprocessor settings for setups. Here you can set the values that you can query in shader,particlesys,material scripts.", args="(string name,[boolean])", returns="([boolean])"},
["resuserstring"] = {type='function', description = " returns or sets a user string that is permanent for each resource. String must be shorter than 256 characters.", args="(resource,[string])", returns="([string])"}}}
Skin2D = {type='class',description="The Skin2D class is a two dimensional graphical representation for\
	abstract information. It defines the look and feel of components.\
\
	I.e. this information could be a button. A skin does only have to provide some\
	mechanisms for hiding, creating and deleting. Any class that requires a\
	twodimensional representation (x,y,width,height) can use a skin to display\
	itself. The skin takes only care about its graphical representation, its\
	position and dimensions.\
\
	Skins can provide multiple \"surfaces\". Surfaces are variations of a skin.\
	Components may request certain surfacetypes for a skin (i.e. mouseover\
	event) to change the visual appearance of the skin.\
\
	A Skin can also provide mechanisms to show text on the label.\
	",childs={["getIconSkinSelection"] = {type='function', description = " returns current iconskinselection preference", args="(Skin2D)", returns="([id])"},
["iconalignhorizontal"] = {type='value', description = "[float/string]=ALIGN.ICONTOLEFT - alignment for icon"},
["iconalignvertical"] = {type='value', description = "[float/string]=ALIGN.CENTER - alignment for icon"},
["setIcon"] = {type='function', description = "\
	sets the Icon to be used for this skin.\
	The second parameter denotes the name of the skin that should be used for\
	the icon when displayed. If it is nil, the currently set skinname for the\
	icon (that can be nil) is not overwritten. If it is false, it will be\
	set to nil, otherwise it is set to the given value. If the\
	3rd and 4th parameter is not nil, the icon alignment is set to these values.", args="(Skin2D,Icon,[iconskinname, [alignh,[alignv] ] ])", returns="()"},
["textvertical"] = {type='value', description = "[float/string]=ALIGN.CENTER - alignment for text"},
["ALIGN.TOP"] = {type='value', description = "{[string]} - position information for label"},
["icon"] = {type='value', description = "[Icon]=nil - the icon for this skin"},
["setClip"] = {type='function', description = " Sets clipping for skin. If no value is passed,\
	the clipping is disabled. ", args="(Skin2D,[x,y,w,h])", returns="()"},
["REASON.ICONCHANGED"] = {type='value', description = "{[string]}=iconchanged - changed icon reason"},
["defaultfont"] = {type='value', description = "[string]=arial11-16x16 - fontname to be used as default"},
["setIconMargin"] = {type='function', description = " margin arount the icon", args="(Skin2D,float margin)", returns="()"},
["setTextAlignment"] = {type='function', description = " sets alignment for text. If number is passed\
	it is used as coordinate from the top left corner.", args="(Skin2D,string/number horizontal, vertical)", returns="()"},
["setAutowidth"] = {type='function', description = " Autowidth will change the *visual* appearance of the\
	component to a width that is chosen depending on the current size of\
	the caption and/or icon. ", args="(Skin2D, on)", returns="()"},
["bound.y"] = {type='value', description = "[float] - position y"},
["REASON.DELETEDVIS"] = {type='value', description = "{[string]}=deletedvis - vischange reason"},
["z"] = {type='value', description = "[float]=0 - z position in space"},
["setIconSkinSelection"] = {type='function', description = " if a skiniconselection is present, it is preferred if\
	the skin of the Skin2D object is changed, otherwise, the icon's selection is\
	using the same name as the current skinname.\
	", args="(Skin2D, [id])", returns="()"},
["ALIGN.RIGHT"] = {type='value', description = "{[string]} - position information for label"},
["getIconMargin"] = {type='function', description = " returns margin arount the icon", args="(Skin2D)", returns="(float margin)"},
["getPadding"] = {type='function', description = " returns current padding values", args="(Skin2D)", returns="(float top,right,bottom,left)"},
["getPreferredLocation"] = {type='function', description = " Returns position which is preferred by the skin.\
	Since most textures are drawn filtered, a component might like to be\
	positionend at an integer position.", args="(Skin2D,x,y)", returns="(x,y)"},
["bound.h"] = {type='value', description = "[float] - height"},
["pright"] = {type='value', description = "[float] - current padding to right"},
["ALIGN.ICONTOTOP"] = {type='value', description = "{[string]} - position information for icon"},
["setClipping"] = {type='function', description = " Enables or disables clipping. ", args="(Skin2D,on)", returns="()"},
["getSkinColor"] = {type='function', description = " Primary RGBA Color for the skin", args="(Skin2D)", returns="(float r,g,b,a)"},
["setBounds"] = {type='function', description = " sets location and dimension of skin.\
	Calls sizechanged (\"resize\") - only if the size and position was truly changed!", args="(Skin2D,x,y,w,h)", returns="()"},
["setPadding"] = {type='function', description = "\
	padding of text and icon to the sides, sets default valueif the key is not\
	present. The key is used when a different skin is selected. The key\
	can be a table of keys that should be assigned with the given padding values. ", args="(Skin2D,float top,right,bottom,left,[string/table key=default])", returns="()"},
["bound.w"] = {type='value', description = "[float] - width"},
["setVisibility"] = {type='function', description = " sets visibility of the skin. Won't create\
	visibles, call createvisibles. Calls update function", args="(Skin2D,boolean visible)", returns="()"},
["delete"] = {type='function', description = " deletes the skin. This function might get called multiple\
	times so flag your skin once it got deleted. Per default it calls\
	the deleteVisibles method. ", args="(Skin2D)", returns="()"},
["texthorizontal"] = {type='value', description = "[float/string]=ALIGN.CENTER - alignment for text"},
["getSelectedSkin"] = {type='function', description = " Returns the currently selected skin.", args="(Skin2D)", returns="(string)"},
["bounds"] = {type='value', description = "[table] - contains bounds of image"},
["REASON.SKINCHANGE"] = {type='value', description = "{[string]}=skinchange - skinchange reason"},
["getIcon"] = {type='function', description = " gets the Icon to be used for this skin.", args="(Skin2D)", returns="([Icon])"},
["update"] = {type='function', description = " called if the visual appearance changed.\
	The reason contains the source which caused the modification. Depending\
	on your implementation, it might be useful to collect modifications until\
	the frame is finaly really drawn.", args="(Skin2D, string reason)", returns="()"},
["getFontset"] = {type='function', description = " returns currently fontset", args="(Skin2D)", returns="(fontset)"},
["bound.x"] = {type='value', description = "[float] - position x"},
["setLabelFontSize"] = {type='function', description = " size of the font for the label. 1 = 100%, 2 = 200% etc. Default value: 1", args="(Skin2D, size)", returns="()"},
["ALIGN.ICONTOBOTTOM"] = {type='value', description = "{[string]} - position information for icon"},
["setSortID"] = {type='function', description = " sets sortid for l2d sorting. Returns the\
	next id that can be used without interfering the l2delements of the\
	skin. Per default it reserves 4 elements.", args="(Skin2D,int id)", returns="(nextid)"},
["pleft"] = {type='value', description = "[float] - current padding to left"},
["pbottom"] = {type='value', description = "[float] - current padding to bottom"},
["getFontColor"] = {type='function', description = " RGBA Color for the label", args="(Skin2D)", returns="(float r,g,b,a)"},
["onDestroy"] = {type='function', description = " called by garbagecollecter. Calls delete.", args="(Skin2D)", returns="()"},
["getLabelSize"] = {type='function', description = " Returns the current size of the label.", args="(Skin2D)", returns="(w,h)"},
["REASON.NEWTEXT"] = {type='value', description = "{[string]}=newtext - new label text"},
["paddings"] = {type='value', description = "[table] - table containing paddings for different skins"},
["clone"] = {type='function', description = " returns a copy of the skin. This function MUST be\
	overloaded, otherwise an error is thrown.", args="(Skin2D)", returns="(Skin2D)"},
["getLabelText"] = {type='function', description = " gets the text for the skin. ", args="(Skin2D)", returns="([text])"},
["getBounds"] = {type='function', description = " returns location and dimension of skin", args="(Skin2D)", returns="(x,y,w,h)"},
["ALIGN.CENTER"] = {type='value', description = "{[string]} - position information for label"},
["REASON.VISCHANGE"] = {type='value', description = "{[string]}=vischange - vischange reason"},
["setSkinColor"] = {type='function', description = " sets Primary RGBA Color for the skin", args="(Skin2D, float r,g,b,a)", returns="()"},
["setLabelTabWidth"] = {type='function', description = " tab spacing of font for the label. 0 means spacing * 4 is used.", args="(Skin2D, spacing)", returns="()"},
["setIconAlignment"] = {type='function', description = " sets alignment for icon. If number is passed\
	it is used as coordinate from the top left corner.", args="(Skin2D,string/number horizontal, vertical)", returns="()"},
["REASON.COLORCHANGED"] = {type='value', description = "{[string]}=colorchanged - changed color (Skin/font) reason"},
["REASON.RESIZED"] = {type='value', description = "{[string]}=resized - resized skin"},
["getPreferredSize"] = {type='function', description = " Returns preferred size of the skin. A skin may have a\
	minimum or maximum size - or wants to be sized in multiplies of a certain\
	size.", args="(Skin2D,w,h)", returns="(w,h)"},
["ptop"] = {type='value', description = "[float] - current padding to top"},
["createVisibles"] = {type='function', description = " restores resources for visual representation", args="(Skin2D,l2dnode parent)", returns="()"},
["getClipping"] = {type='function', description = " returns clipping value", args="(Skin2D)", returns="(boolean)"},
["copystylefrom"] = {type='function', description = " copies style of another skin (padding and iconmargin)", args="(Skin2D to,Skin2D from)", returns="()"},
["setFontColor"] = {type='function', description = " sets RGBA Color for the label", args="(Skin2D, float r,g,b,a)", returns="()"},
["setLabelFontSpacing"] = {type='function', description = " spacing of the font for the label", args="(Skin2D, size)", returns="()"},
["ALIGN.LEFT"] = {type='value', description = "{[string]} - position information for label"},
["setLocation"] = {type='function', description = " sets 2D location of skin (calls directly setBounds)", args="(Skin2D,x,y)", returns="()"},
["getPreferredBounds"] = {type='function', description = " returns preferred bounds for this skin.\
	Calls getPreferredSize and getPreferredLocation per default.", args="(Skin2D,x,y,w,h)", returns="(x,y,w,h)"},
["currentskin"] = {type='value', description = "[string]=default - current key of used skin"},
["new"] = {type='function', description = " Sets\
	metatable index to class. Per default, a skin does not create any visual\
	objects during start. These must be created by calling createVisibles. ", args="(class)", returns="(Skin2D)"},
["REASON.CREATEDVIS"] = {type='value', description = "{[string]}=createdvis - vischange reason"},
["ALIGN.ICONTOLEFT"] = {type='value', description = "{[string]} - position information for icon"},
["setLabelPosition"] = {type='function', description = " sets position of label. The position\
	can be a string as described in Skin2D.ALIGN or a number. ", args="(Skin2D,horizontal,vertical)", returns="()"},
["getClip"] = {type='function', description = " Gets clipping for skin. If no value is returned,\
	the clipping is disabled. ", args="(Skin2D)", returns="([x,y,w,h])"},
["id"] = {type='value', description = "[int]=0 - sortid for l2dlistset"},
["setFont"] = {type='function', description = " Name of font to be used, pass nil (or nothing) if the defaultfont should be used", args="(Skin2D,[string fontname])", returns="()"},
["selectSkin"] = {type='function', description = " returns currently selected skin", args="(Skin2D)", returns="(skin)"},
["ALIGN.ICONTORIGHT"] = {type='value', description = "{[string]} - position information for icon"},
["setZ"] = {type='function', description = " sets z offset in l2d system - 0 per default", args="(Skin2D,float z)", returns="()"},
["toString"] = {type='function', description = " returns simple text representation of the skin. It is\
	called whenever the tostring function is called.", args="(Skin2D)", returns="(string)"},
["setLabelText"] = {type='function', description = " sets the text for the skin. If no argument is nil\
	or is missing the text is removed.", args="(Skin2D, [text])", returns="()"},
["setDimensions"] = {type='function', description = " sets width and height of skin (calls directly setBounds)", args="(Skin2D,w,h)", returns="()"},
["deleteVisibles"] = {type='function', description = " deletes resources for visual representation", args="(Skin2D)", returns="()"},
["contains"] = {type='function', description = " returns true (default) if the skin contains a\
	certain pixel in local coordinates. This method can be overloaded to\
	let the mouse pointing reject transparent areas on the skin.", args="(Skin2D, x,y)", returns="(boolean)"},
["setPaddingAll"] = {type='function', description = " Sets padding of all padding keys. If nil is passed, the given value (top,right,bottom,left) isnot modified. If incremental is true, the values are added to the current values.", args="(Skin2D,[float top],[right],[bottom],[left],boolean incremental=false)", returns="()"},
["ALIGN.BOTTOM"] = {type='value', description = "{[string]} - position information for label"}}}
capability = {type='class',description="Certain system (hardware related) capabilites can be queried for support here.",childs={["dot3normalmap"] = {type='function', description = " returns support for VID_NORMAL combiner in shader system.", args="()", returns="(boolean)"},
["texcomb_dot3"] = {type='function', description = " returns support for dot3 in texcombiners", args="()", returns="(boolean)"},
["texarraylayers"] = {type='function', description = " returns how many texture layers in array textures are available.", args="()", returns="(int)"},
["hwshadow"] = {type='function', description = " returns support for shadow map comparison and depth textures", args="()", returns="(boolean)"},
["texbgr"] = {type='function', description = " returns support for BGR,BGRA texture data", args="()", returns="(boolean)"},
["renderbuffermsaa"] = {type='function', description = " returns number of maximum samples of multisampled renderbuffers, or nil if no support is given.", args="()", returns="([int])"},
["pointsprites"] = {type='function', description = " returns if particle points can be rendered as sprites (quad-like textured).", args="()", returns="(boolean)"},
["texautomipmap"] = {type='function', description = " returns support for automatic mipmaps", args="()", returns="(boolean)"},
["r2vb"] = {type='function', description = " returns support for render 2 vertexbuffer functionality, useful to capture vertex stream output.", args="()", returns="(boolean)"},
["texnp2"] = {type='function', description = " returns support for non power of two texture dimensions. Currently only supported for 3d textures. For 2d textures use rectangle capability.", args="()", returns="(boolean)"},
["texcompress"] = {type='function', description = " returns support for texture compression", args="()", returns="(boolean)"},
["vbo"] = {type='function', description = " returns support for vbo", args="()", returns="(boolean)"},
["texbarrir"] = {type='function', description = " returns support texbarrier functionality (read and write same texture once, ie. custom blending). allows 'texbarrier' keyword in shader files.", args="()", returns="(boolean)"},
["texrectangle"] = {type='function', description = " returns support for rectangle textures", args="()", returns="(boolean)"},
["texcopy"] = {type='function', description = " returns support for texture.copy.", args="()", returns="(boolean)"},
["pbo"] = {type='function', description = " returns support for pixel buffer objects, useful for loading/retrieven image data asynchronously.", args="()", returns="(boolean)"},
["texcomb_combine4"] = {type='function', description = " returns support for combine4 in texcombiners", args="()", returns="(boolean)"},
["fbo"] = {type='function', description = " returns support for framebufferobjects (fbo), allow enhanced rendertotexture. Especially rendering to multiple drawbuffers or textures with larger size than window. renderfbo, renderbuffer, rcmdfbobind ... need this capability.", args="()", returns="(boolean)"},
["texdepthstencil"] = {type='function', description = " returns support for a packed format of 24bit depth and 8bit stencil texture.", args="()", returns="(boolean)"},
["texrg"] = {type='function', description = " returns support for R and RG textures.", args="()", returns="(boolean)"},
["texvertex"] = {type='function', description = " returns number of textures that can be accessed in vertex shader", args="()", returns="(int)"},
["tex3d"] = {type='function', description = " returns support for 3d textures", args="()", returns="(boolean)"},
["texcomb_modadd"] = {type='function', description = " returns support for modulated add functions in texcombiners", args="()", returns="(boolean)"},
["texsize"] = {type='function', description = " returns maximum texture side length (1d or 2d).", args="()", returns="(int)"},
["texinteger"] = {type='function', description = " returns support for integer textures, typically requires capability.cg_sm4 as well.", args="()", returns="(boolean)"},
["stenciltwosided"] = {type='function', description = " returns support for two-sided stencil testing", args="()", returns="(boolean)"},
["texfloat"] = {type='function', description = " returns support for float16 and float32 textures", args="()", returns="(boolean)"},
["tex3dsize"] = {type='function', description = " returns maximum dimension of 3d texture", args="()", returns="(int)"},
["vramsize"] = {type='function', description = " returns video ram (can be 0 if query did not work)", args="()", returns="(int)"},
["texcomb_subtract"] = {type='function', description = " returns support for subtract in texcombiners", args="()", returns="(boolean)"},
["texcube"] = {type='function', description = " returns support for cubemap textures", args="()", returns="(boolean)"},
["texanisotropic"] = {type='function', description = " returns maximum anisotropic value for texture filtering, if supported.", args="()", returns="([float])"},
["texarray"] = {type='function', description = " returns support for array textures, typically requires capability.cg_sm4 as well.", args="()", returns="(boolean)"},
["drawbuffers"] = {type='function', description = " returns maximum number of multiple render targets for color drawbuffers", args="()", returns="(int)"},
["texdds"] = {type='function', description = " returns support for dds texture loading", args="()", returns="(boolean)"},
["texabgr"] = {type='function', description = " returns support for ABGR texture data", args="()", returns="(boolean)"},
["texcomb_crossbar"] = {type='function', description = " returns support for access to all texture units in texcombiners", args="()", returns="(boolean)"},
["bufferblit"] = {type='function', description = " returns support for blitting from one to another renderfbo/backbuffer via rcmdbufferblit", args="()", returns="(boolean)"},
["stencilwrap"] = {type='function', description = " returns support for wrapped increment and decrement", args="()", returns="(boolean)"},
["texbuffer"] = {type='function', description = " returns support for buffer textures, typically requires capability.cg_sm4 as well.", args="()", returns="(boolean)"}}}
soundlistener = {type='class',description="The soundlistener represents the position, velocity and orientation 		of the 'microphone' in space.",childs={["vel"] = {type='function', description = " sets or gets velocity of listener", args="([float x,y,z])", returns="([float x,y,z])"},
["orientation"] = {type='function', description = " sets/gets orientation of listener", args="([float x,y,z,upx,upy,upz])", returns="([float x,y,z,upx,upy,upz])"},
["velscale"] = {type='function', description = " scaling factor for velocity vector", args="([float scale])", returns="([float scale])"},
["posscale"] = {type='function', description = " scaling factor for position vector", args="([float scale])", returns="([float scale])"},
["pos"] = {type='function', description = " sets or gets position of listener", args="([float x,y,z])", returns="([float x,y,z])"}}}
Component = {type='class',description="A Component is a 2D object on the screen that allows interaction with\
	the mouse and keyboard of the user.\
\
	All coordinates are always relative to the parent's Component.\
\
	All components will propagate mouseevents to its parents! If the mouse is\
	moved on a child, the parent that cannot \"see\" the mouse will receive\
	events, too. This change was done in 0.93a. The reason is, that it is easier\
	for the parent components to trace the mouse actions (i.e. mousewheel)\
	in an easy manner. Most mouse actions are now receiving a second argument\
	that tells, if the component is the owner of the mouse, which means that it\
	is the topmost component at the mouse cursor's position.\
	",childs={["onDisplayChange"] = {type='function', description = " called whenever the\
	displaystate is changed, i.e. if the component was made invisible,\
	or it's parent was removed from the rootpane etc.\
\
	A component that is displayed has not to be visible.", args="(Component self, boolean isDisplayed)", returns="()"},
["local2world"] = {type='function', description = " returns world coordinates", args="(int localx,localy)", returns="(int worldx,worldy)"},
["index"] = {type='value', description = "{[int]} - index id of the component"},
["mouseEntered"] = {type='function', description = "\
	called if the mouse is entered the Component", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["transferFocusOnArrows"] = {type='function', description = " returns true if the component transfers the\
	focus if an arrow is pressed is pressed", args="(Component)", returns="(boolean)"},
["mouseClicked"] = {type='function', description = "\
	called if the mouse was clicked on the component.", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["onVisibilityChange"] = {type='function', description = " called whenever\
	the component is made visible / invisible.", args="(Component self, boolean isVisible)", returns="()"},
["setClip"] = {type='function', description = " Disables/Enables the clipping of the component(s).\
	If no Component is passed, this is used as a GLOBAL parameter, not per component.\
	It will affect only components that are going to be created.\
	Clipping is done using the scissortest of OpenGL.\
	These areas however can only be rectangular and may produce unwanted sideeffects\
	if you use a different window.refsize than the screen resolution or if\
	you want to rotate the components (which is possible but yet supported).\
	Setting the clip to nil for a component will make it use the global parameter\
	value. Currently, this parameter is only working correctly if disabled globally. ", args="([Component],boolean on)", returns="()"},
["isVisible"] = {type='function', description = " returns true if the component\
	is displayable and visible, otherwise false", args="(Component self)", returns="(boolean)"},
["setLocation"] = {type='function', description = " sets location of the Component", args="(Component self, float x,y)", returns="()"},
["moveToRect"] = {type='function', description = "\
	moves a component animated to a certain target. The given x,y, w,h are the target\
	bounds. The speed must be a factor between 0 and 1, where 1 is the fastest while\
	0 will never reach the target. The delay is the amount of milliseconds to be\
	waited after each step (it is using a TimerTask to perform the animation).\
	The onfinish function is the function to be called if the target is reached.\
\
	If the animation is interupted by another animation call, the oncancel function\
	will be called.", args="(Component self, x,y,w,h,speed,[delay],[onfinish],[oncancel])", returns="()"},
["getTooltip"] = {type='function', description = " returns the\
	set tooltip information or nil if not present", args="(Component self)", returns="([string text / Component component])"},
["hideVisibles"] = {type='function', description = " called when visible objects (l2ds) are no longer visible", args="(Component self)", returns="()"},
["toString"] = {type='function', description = " returns a simple string representation of this component", args="(Component self)", returns="(string)"},
["setTooltip"] = {type='function', description = " Sets tooltip\
	information for this component, which is shown if the mouse holding its position.\
	Passing nil will delete the tooltip information, setting a string will show the\
	string as a simple textlabel, which is multilinecapable. If a component is\
	passed, this component will be shown in the quickinfobox or whatever is\
	showing the results. Setting the tooltip while it is shown will not affect the\
	way it is displayed", args="(Component self, [nil / string text / Component component])", returns="()"},
["getSkin"] = {type='function', description = " returns the skin used for this component", args="(Component)", returns="([Skin2D])"},
["mouseExited"] = {type='function', description = "\
	called if the mouse is exited the component", args="(Component self, MouseEvent e)", returns="()"},
["createVisibles"] = {type='function', description = " called when a Component is now displayable\
	(doesn't have to be visible)", args="(Component self,l2dnode basel2d)", returns="()"},
["white"] = {type='value', description = "[texture] - a 2x2 sized white texture for general purpose"},
["getBounds"] = {type='function', description = " returns a copy of the current bounds, EVEN\
	if the component hasn't been validated yet.", args="()", returns="(Rectangle rect)"},
["isClipped"] = {type='function', description = " returns state of clipping, is the global or of the\
	component", args="([Component])", returns="(boolean)"},
["skinnames.focusedskin"] = {type='value', description = "{[string]} = component_focus - default skin-string for focused cases"},
["mouseWheeled"] = {type='function', description = "\
	called if the mousewheel was moved on the component", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["fadeTo"] = {type='function', description = "\
\
	", args="(Component self, table skincolor,table labelcololor, table iconcolor, speed,delay,onfinish,oncancel)", returns="()"},
["hasFocus"] = {type='function', description = " returns true if the element is focused", args="(Component)", returns="(boolean)"},
["transferFocus"] = {type='function', description = " call this to transfer the focus in a direction\
	relative to the component (forward/backward", args="(Component self, int direction)", returns="()"},
["focus"] = {type='function', description = " registers an element as\
	the new focusowner.", args="(Component self)", returns="()"},
["setBounds"] = {type='function', description = " sets bounds of the Component. Changes\
	will be done when validate is called, which is done every frame once for\
	all (drawn) components.", args="(Component self, float x,y,w,h)", returns="()"},
["focuscolors"] = {type='value', description = "[table] - array containing all defaultcolors on focus"},
["getSize"] = {type='function', description = " gets size of the Component", args="(Component self)", returns="(float w,h)"},
["delete"] = {type='function', description = " deletes the component. Removes the component from\
	any parent object and calls Component.onDestroy, that is also called when\
	the Component is garbagecollected. Never overload delete, use onDestroy for custom actions instead.", args="(Component self)", returns="()"},
["zorderoffset"] = {type='value', description = "[int] - sortid offset for l2dnodes"},
["keyEvent"] = {type='function', description = " called if a keyevent occurred and the component\
	has the focus. If a tab was pressed and transferFocusOnTab returns true,\
	the focus is transfered. If enter was pressed and a onAction function is\
	present, onAction is called. Otherwise the components keylisteners are\
	called. ", args="([Component],KeyEvent)", returns="()"},
["lockMouse"] = {type='function', description = " locks the mouse to this component. As long as the\
	mouse is locked, no other component will receive mouseevents. This\
	does not affect MouseListeners that are attached to the MouseCursor. The current\
	MouseCursor coordinates are stored and can be queried later with Component.getMouseLockPos.", args="(Component)", returns="()"},
["onLostFocus"] = {type='function', description = " event if the component lost the\
	focus to tocomponent.", args="(Component,Component tocomponent)", returns="()"},
["mouselisteners"] = {type='value', description = "{[table]} - list of mouselisteners"},
["setDefaultUI"] = {type='function', description = " sets the skin and iconset to be used as default.\
	this will not affect existing GUI components, only new GUI elements are\
	affected.", args="([skin],[icons])", returns="()"},
["world2local"] = {type='function', description = " returns local coordinates", args="(int worldx,worldy)", returns="(int localx,localy)"},
["getX"] = {type='function', description = " returns current local x origin", args="()", returns="(int)"},
["unlockMouse"] = {type='function', description = " releases the mouselock,\
	but only if the Component is also the locker of the mouse.", args="(Component)", returns="()"},
["getMinSize"] = {type='function', description = " returns minimum size of component", args="(Component self)", returns="(Rectangle)"},
["skinnames.defaultskin"] = {type='value', description = "{[string]} = component - default skin-string for default cases"},
["removeKeyListener"] = {type='function', description = " removes kl from the list of keylisteners", args="(Component self, KeyListener kl)", returns="()"},
["remove"] = {type='function', description = " removes the Component from its parent\
	object.", args="(Component self)", returns="()"},
["think"] = {type='function', description = " called each frame if the component is visible and\
	inserted in the rootpane or one of its ancestors. Overload this method\
	to perform your own operations here", args="(Component self)", returns="()"},
["removeTooltipListener"] = {type='function', description = " removes all functions that are equal\
	to entries in the tooltiplistener list", args="(Component self, function)", returns="()"},
["setSize"] = {type='function', description = " sets size of the Component", args="(Component self, float w,h)", returns="()"},
["validateFocus"] = {type='function', description = " Called once a frame and build a list of focusable components\
	", args="(Component self)", returns="()"},
["getParent"] = {type='function', description = " returns parent container if exists", args="()", returns="(Container)"},
["isDisplayedFlag"] = {type='value', description = "{[boolean]} - true if the component is on the rootpane"},
["setDisabled"] = {type='function', description = " disabled components won't generate mouse or keyevents.\
	The Component's skin is set to half transparent, storing the previous alpha value and\
	keeping the current rgb value.\
	", args="(Component,boolean yes)", returns="()"},
["newFocusOrder"] = {type='function', description = "\
	Sets a new focus order list as given in the passed table.\
	It returns the old focuslist then and sets the current focuselement to nil.\
	This method can be used to create modal dialogs, though you have to\
	watch out to restore the list again, once the old elements should be\
	accesible again. ", args="(table new)", returns="(table old)"},
["skinnames.hoveredskin"] = {type='value', description = "{[string]} = component_hover - default skin-string for hovered cases"},
["addKeyListener"] = {type='function', description = " add a keylistener to the component", args="(Component self, KeyListener kl)", returns="()"},
["onDestroy"] = {type='function', description = " called if the garbage collector collects the\
	object or if the component was deleted. Overload this method for\
	custom actions, i.e. deleting all l2dnodes etc.", args="(Component self)", returns="()"},
["getClipRect"] = {type='function', description = " returns clipping of the component. The function\
	traverses to the root to find out the clipping region until the component\
	has no parent any more.", args="(Component)", returns="(Rectangle)"},
["acceptSkinBounds"] = {type='function', description = " sets or gets behaviour of sizing.\
	A skin may have other preferred sizes than chosen by the component. In\
	that case, the component may have different preferred sizes than expected.\
	Per default, this value is true.\
\
	If no skin is set, this value has no meaning", args="(Component,[accepts])", returns="([accepts])"},
["removeMouseListener"] = {type='function', description = " removes ml from the list of mouselisteners", args="(Component self, MouseListener ml)", returns="()"},
["getY"] = {type='function', description = " returns current local y origin", args="()", returns="(int)"},
["getMouseLockPos"] = {type='function', description = " returns the coordinates of the MouseCursor when lock occured in component's space or nil.", args="([Component])", returns="([x,y])"},
["deleteVisibles"] = {type='function', description = " called when a Component is no longer displayed", args="(Component self)", returns="()"},
["clipinsets"] = {type='value', description = "[table] - top, right, bottom, left inset values, default = 0,0,0,0"},
["setVisibility"] = {type='function', description = " returns true if the component is\
	displayed (is actually on the rootpane) and is visible.", args="(Component self)", returns="(boolean)"},
["getMouseLock"] = {type='function', description = " returns the Component that is currently locking the mouse.", args="()", returns="(Component)"},
["showVisibles"] = {type='function', description = " called when visible objects (l2ds) are now visible", args="(Component self)", returns="()"},
["setColor"] = {type='function', description = "\
\
	", args="(Component self, table skincolor,table labelcololor, table iconcolor, [mix a=0], [mix b=1])", returns="()"},
["onGainedFocus"] = {type='function', description = " event if the component\
	gained the focus from fromcomponent.", args="(Component,Component fromcomponent)", returns="()"},
["setDisplayable"] = {type='function', description = "\
	a displayable component should create all it needs to be displayed\
	(l2dnodes & stuff).", args="(Component self, boolean displayable)", returns="()"},
["showTooltipInformation"] = {type='function', description = " triggers displaying the tooltip information.\
	It will look if the component has a function set named ", args="(Component self)", returns="()"},
["mouseEvent"] = {type='function', description = "\
	called if a mouseevent occurred\
	that is interesting to this component. It will informa all mouselisteners\
	of the component of this action. ", args="(Component self, MouseEvent e)", returns="()"},
["isMouseLocker"] = {type='function', description = " returns true if the component is locking the mouse", args="(Component)", returns="(boolean)"},
["updateSkin"] = {type='function', description = " updates skin information ", args="(Component self)", returns="()"},
["getLocation"] = {type='function', description = " returns current Location", args="()", returns="(int x,y)"},
["mousePressed"] = {type='function', description = "\
	called if the mouse was pressed on the component. If mouseover is true,\
	the mouse is actually on THIS component and not on one of its childs,\
	which will create events too.", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["getHeight"] = {type='function', description = " returns current height", args="()", returns="(int)"},
["validate"] = {type='function', description = " validates the new position of the component.\
	don't call this method during a mouseevent or strange things may happen.\
	If the Component's bounds were changed, positionUpdate will be called.\
	The z parameter is the z-sort order and the component should return an\
	incremented z value, reserving the z-values it needs for its own\
	(validation is down in z-sorted order). If no z is given, no reordering\
	is done.", args="(Component self, [int z])", returns="([int z])"},
["addMouseListener"] = {type='function', description = " add a mouselistener to the component", args="(Component self, MouseListener ml)", returns="()"},
["positionUpdate"] = {type='function', description = " called when the component was moved or resized.\
	Overload this method for visual appearance. The zindex is the id to use for\
	zordering the components. Return the newz value, reserving all the values that\
	you require for your visual nodes.", args="(Component self,int zindex,Rectangle clip)", returns="(int newz)"},
["invalidate"] = {type='function', description = " marks component to be updated on next validation", args="(Component self)", returns="()"},
["getRight"] = {type='function', description = " returns x+width, which is the rightmostline of the component", args="()", returns="(int)"},
["getWidth"] = {type='function', description = " returns current width", args="()", returns="(int)"},
["new"] = {type='function', description = "\
	creates a component with the given bounds of type class.\
	A Component may optionally be initialized with a Skin2D skin, a visual\
	representation of the Component. ", args="(table class, int x,y,w,h, [Skin2D skin])", returns="(Component)"},
["skinnames.pressedskin"] = {type='value', description = "{[string]} = component_pressed - default skin-string for pressed cases"},
["mouseMoved"] = {type='function', description = "\
	called if the mouse actually moved over the Component. ", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["getFocusIndex"] = {type='function', description = " returns absolute index of the focusorder", args="(Component self)", returns="()"},
["addTooltipListener"] = {type='function', description = " adds a tooltiplistener. The\
	function will receive a Tooltipevent as only argument when fired.", args="(Component self, function)", returns="(function)"},
["getFocusElement"] = {type='function', description = " returns the current element of focus if available", args="()", returns="([Component])"},
["setFont"] = {type='function', description = " sets fontname to be used. Pass noting if\
	you want to use the defaultfont again.", args="(Component,[string font])", returns="()"},
["keylisteners"] = {type='value', description = "{[table]} - list of keylisteners"},
["getFocusComponentAt"] = {type='function', description = "\
	returns focuselement. If Component is given, the direction is relative\
	to the component, if not, the absolute focuselement is returned.\
	Only elements that return true on isFocusable are counted. ", args="([Component], int direction)", returns="(Component)"},
["transferFocusOnTab"] = {type='function', description = " returns true if the component transfers the\
	focus if tab is pressed", args="(Component)", returns="(boolean)"},
["getBottom"] = {type='function', description = " returns y+height, which is the bottomline of the component", args="()", returns="(int)"},
["colors"] = {type='value', description = "[table] - array containing all defaultcolors"},
["isFocusable"] = {type='function', description = " returns true if the component can be focused.\
	If you overload this method, please remember that you should return false\
	if your element is current not focusable, ie. if not visible or not enabled.\
\
	For example:\
	 function TextField.isFocusable()\
	   return true and self:isVisible()\
	 end\
	", args="(Component)", returns="(boolean)"},
["setSkin"] = {type='function', description = " sets a skin to be used for displaying this\
	component. If no value is set, the skin is removed. Invalidates the\
	Component.\
\
	If then skin is a string named \"default\" a default skin is used.\
\
	If copy is true, the skin's cloning function is called to create a copy of\
	that skin.\
\
	The Component class is using following skin surface mappings:\
	* component - simple default surface\
	* component_hover - highlighted surface if mouse is over the component\
	* component_pressed - if the mouse is clicked on the component\
	", args="(Component, [Skin2D,[boolean copy] ])", returns="()"},
["contains"] = {type='function', description = " checks if the given point is\
	inside the component. Overload this method if you need more specific\
	hittests than a rectangletest. Coordinates are relative.", args="(Component self, float x,y)", returns="(boolean)"},
["isVisibleFlag"] = {type='value', description = "{[boolean]} - true if the component is visible"},
["mouseReleased"] = {type='function', description = "\
	 called if the mouse was released on the component", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"}}}
texcombcolor = {type='class',description="The texcombiner for rgb values. The functions return a texcombiner or overwrite the combiner with same name. They may return an error when a conflict with default names exists.",childs={["addsigned"] = {type='function', description = "  OUT = arg0 + arg1 - 0.5", args="(string name)", returns="([texcombcolor])"},
["interpolate"] = {type='function', description = "  OUT = arg0 * arg2 + arg1 * (1-arg2)", args="(string name)", returns="([texcombcolor])"},
["setarg"] = {type='function', description = "  sets argument of the function. Check the function descriptor for which arg index does what.", args="(texcombcolor,int arg,texcombsrc,texcombop)", returns="()"},
["modaddsigned"] = {type='function', description = "  OUT = arg0 * arg2 + arg1 - 0.5. You should query for capability.", args="(string name)", returns="([texcombcolor])"},
["combine4signed"] = {type='function', description = "  OUT = arg0*arg1 + arg2*arg3 - 0.5  You should query for capability.", args="(string name)", returns="([texcombcolor])"},
["dot3alpha"] = {type='function', description = "  OUT = arg0 dotproduct arg1. (args as signed vector -1,+1). Also sets alpha. You should query for capability", args="(string name)", returns="([texcombcolor])"},
["modadd"] = {type='function', description = "  OUT = arg0 * arg2 + arg1. You should query for capability.", args="(string name)", returns="([texcombcolor])"},
["subtract"] = {type='function', description = "  OUT = arg0 - arg1. You should query for capability. When used modadd/combine4 for alpha at the same time is not allowed for cards with combine4 support", args="(string name)", returns="([texcombcolor])"},
["combine4"] = {type='function', description = "  OUT = arg0*arg1 + arg2*arg3. You should query for capability.", args="(string name)", returns="([texcombcolor])"},
["modulate"] = {type='function', description = "  OUT = arg0 * arg1", args="(string name)", returns="([texcombcolor])"},
["test"] = {type='function', description = " tests the combiner (binds it). Returns GL Error string (might have other errors not bound to this problem)", args="(texcombcolor)", returns="([string])"},
["replace"] = {type='function', description = "  OUT = arg0", args="(string name)", returns="([texcombcolor])"},
["add"] = {type='function', description = "  OUT = arg0 + arg1", args="(string name)", returns="([texcombcolor])"},
["dot3"] = {type='function', description = "  OUT = arg0 dotproduct arg1. (args as signed vector -1,+1). You should query for capability", args="(string name)", returns="([texcombcolor])"}}}
resdata = {type='class',description="resdata holds all resources that are supposedly static, like models, textures, and are often reused, as those use different memory than the dynamic nodes that are normally created.<br> ResData is sepearted in ResourceChunks. The user specifies how many chunks he wants and how big those should be, ie how many resources of each type they can hold and how much memory they preallocate.<br> Resources are then loaded into the current active chunk, because of the linear memorypool they cannot be destroyed individually but only a total chunk can be destroyed. <br> A lot can go wrong when consumers of resource, that were in a chunk that was cleared, are still active. So the user should keep resources/consumer managment in unified blocks himself, to prevent this from happening, as he is totally responsible for it. You can always play safe and use only the main chunk that is automatically created.<br> <br>Overview on the restypes, and their int values:<br> 0  MODEL<br> 1  ANIMATION<br> 2  TEXTURE<br> 3  MATERIAL<br> 4  SHADER<br> 5  GPUPROG<br> 6  PARTICLECLOUD<br> 7  PARTICLESYS<br> 8  SOUND<br>",childs={["gettypescount"] = {type='function', description = " returns number of types that exist. You need to pass this many counts to reschunk new.", args="()", returns="(int)"},
["info"] = {type='function', description = " prints info about the given resource type, any resource implements the 'getrestype' function", args="(int restype)", returns="()"},
["getopencount"] = {type='function', description = " returns number of open slots available for this resource type. Useful for generating reschunks.", args="(int restype)", returns="(int)"},
["filltonext"] = {type='function', description = " when the active reschunk is full, we will load the resource in the next one, and make that active.", args="()", returns="()"},
["fillonlyself"] = {type='function', description = " when the active reschunk is full, resources will not be created. (default)", args="()", returns="()"},
["print"] = {type='function', description = " prints loaded resources, and reschunks to os console", args="()", returns="()"},
["getloadcount"] = {type='function', description = " returns number of loaded resources.", args="(int restype)", returns="(int)"}}}
djointcontact = {type='class',description="The contact joint prevents body 1 and body 2 from inter-penetrating at the contact point. It does this by only allowing the bodies to have an 'outgoing' velocity in the direction of the contact normal. Contact joints typically have a lifetime of one time step. They are created and deleted in response to collision detection.\
Contact joints can simulate friction at the contact by applying special forces in the two friction directions that are perpendicular to the normal.",childs={["normal"] = {type='function', description = " returns normal of contact", args="(djointcontact)", returns="(float x,y,z)"},
["motion2"] = {type='function', description = " Surface velocity in friction directions 2 (in m/s).", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["motion1"] = {type='function', description = " Surface velocity in friction directions 1 (in m/s).", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["approx1"] = {type='function', description = " Use the friction pyramid approximation for friction direction 1. If this is not specified then the constant-force-limit approximation is used (and mu is a force limit).", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["softerp"] = {type='function', description = " Contact normal 'softness' parameter.", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["bouncevel"] = {type='function', description = " The minimum incoming velocity necessary for bounce (in m/s). Incoming velocities below this will effectively have a bounce parameter of 0.", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["bounce"] = {type='function', description = " Restitution parameter (0..1). 0 means the surfaces are not bouncy at all, 1 is maximum bouncyness.", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["pos"] = {type='function', description = " returns point of contact", args="(djointcontact)", returns="(float x,y,z)"},
["slip2"] = {type='function', description = " The coefficients of force-dependent-slip (FDS) for friction directions 2 (read the ode-doc).", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["slip1"] = {type='function', description = " The coefficients of force-dependent-slip (FDS) for friction directions 1 (read the ode-doc).", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["approx2"] = {type='function', description = " Use the friction pyramid approximation for friction direction 2. If this is not specified then the constant-force-limit approximation is used (and mu is a force limit).", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["fdir"] = {type='function', description = "\"first friction direction\" vector that defines a direction along which frictional force is applied. It must be of unit length and perpendicular to the contact normal (so it is typically tangential to the contact surface). The \"second friction direction\" is a vector computed to be perpendicular to both the contact normal and fdir1.", args="(djointcontact,[boolean on],[float x,y,z])", returns="([boolean,float x,y,z])"},
["softcfm"] = {type='function', description = " Contact normal 'softness' parameter.", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"},
["mu"] = {type='function', description = " Coulomb friction coefficient. This must be in the range 0 to dInfinity. 0 results in a frictionless contact, and dInfinity results in a contact that never slips. Note that frictionless contacts are less time consuming to compute than ones with friction, and infinite friction contacts can be cheaper than contacts with finite friction.", args="(djointcontact,[float])", returns="([boolean,float])"},
["depth"] = {type='function', description = " returns depth of contact", args="(djointcontact)", returns="(float x,y,z)"},
["mu2"] = {type='function', description = " Coulomb friction coefficient for friction direction 2 (0..dInfinity).", args="(djointcontact,[boolean on],[float])", returns="([boolean,float])"}}}
GuiHelpers = {type='class',description="GuiHelpers contain a few functions to aid application development. Can be accessed via GH as well.\
	",childs={["frameminmax"] = {type='function', description = "\
	creates a button \"Hide\"/\"Show\" which sets bounds based on the returns of\
	fnmaxbounds and fnminbounds, which use fninput as input. All functions return x,y,w,h. If\
	fninput is not specified current window dimensions are taken.\
	When minimized all children are removed. Once minimized btn.oldcomponents will be set and\
	hold all temporarily removed Components.\
	When spaceable is set, focus and space bar will not cause the button to act.\
	", args="(Container frame, fnminbounds, fnmaxbounds, [fninput], [boolean spaceable])", returns="(Button btn)"},
["getIconUVs"] = {type='function', description = "\
	returns u,v position and scalings for an icon inside a texture (top =0,0) for setting texture\
	matrices. Takes rectangle textures into account. Grid and icon dimensions default to 24.\
	", args="(texture,x,y,[iconwidth],[iconheight],[gridwidth],[gridheight])", returns="(float u,v,uscale,vscale)"},
["popupYesNo"] = {type='function', description = "\
	creates a modal popup with description label string, and two buttons for \"yes\" and \"no\".", args="(int w,h, string title, question, function fnyes, [fnno], [string yes], [no], [int buttonwidth])", returns="(GroupFrame)"},
["sldLabelval"] = {type='value', description = "[int] - default width for value label for addlsider"},
["popupInfo"] = {type='function', description = "\
	creates a modal popup with a description label string, and a \"okay\" button.", args="(int w,h, string title, text, [function fnok], [string ok], [int buttonwidth])", returns="(GroupFrame)"},
["createcolormenu"] = {type='function', description = "\
	creates a container with a graphical color menu. Initilized with the table value.<br>\
	Function: onchange(upvalue,r,g,b,alpha)", args="(int x,y,w,h, string title, table colorHSVA, fn onchange, [upvalue], [string alphaname])", returns="(Container)"},
["modaldialog"] = {type='function', description = "\
	creates a modal titleframe on top of everything, and normally darkens the background (unless nomodal is true). All arguments are optional. x,y,w,h default to 0,0 and window size.\
	fw/fh are the dimensions of the TitleFrame created. Returns the empty titleframe, mostly used for pop-up menus.", args="([titlename], [int x,y,w,h], [int fw,fh], [boolean nomodal])", returns="(TitleFrame)"},
["filedialog"] = {type='function', description = "\
	creates and file dialog as popup menu.<br>\
	Functions: onsave(fileframe,filepath,filetext), oncancel(fileframe). Both must return true if dialog should be destroyed.<br>\
	addedframe(fileframe) allows to add custom frame to the modal dialog which must be returned by the function.<br><br>\
	warnonoverwrite will cause yes/no popup and can contain <br>\
	* width: int <br>\
	* height: int <br>\
	* title: string <br>\
	* descr: string <br>\
	* yes: string <br>\
	* no: string <br>", args="(string title,oktext,canceltext,[initpath],[fn onsave], [oncancel], [table strings extensions], [string startname], [fn addedframe], [table warnonoverwrite])", returns="(GroupFrame)"},
["addcolorbutton"] = {type='function', description = "\
	creates a color button which on execution pops up a colormenu dialog. returns a function, which\
	can be used to change preview button color, and new y value which is y + h.<br>\
	Function: setcolor(table colorRGBA, [boolean noevent]. Returned button contains .lbl<br>\
	Parameters table contains:<br>\
	* initvalue: table, color HSVA<br>\
	* initrgba: table, color RGBA<br>\
	* callback: function, callback(obj,r,g,b,a)<br>\
	* [obj]: upvalue for function callback<br>\
	* [alphaname]: string, Alphaname if alpha slider should be available<br>\
	* [nomodal]: boolean, no darkening modal dialog<br>\
	* [noalpha]: boolean, no alpha in the preview button color<br>\
	* [titleicon]: Icon, instead of button label.<br>\
	* [ok]: string, okay text<br>\
	* [cancel]: string, cancel text<br>\
	", args="(Container frame,int x,y,w,h, string title, table parameters)", returns="(int newy, fn setcolor, Button)"},
["makeLayoutFunc"] = {type='function', description = "\
	returns a function that computes new rectangles according to \
	rescaling / repositioning behavior. x,y,w,h returned by fnlayouter (nx,ny,nw,nh).\
	On call of makeLayoutFunc the current Rectangles and their relative \
	positions to refbounds are stored.<br>\
	The params table contains:<br>\
	* bottom: boolean for anchor.y\
	* right: boolean for anchor.x\
	* relscale: {boolean w,h}, required\
	* relpos: {boolean x,y}, required\
	<br>\
	When relscale is true for a dimension the size is changed according to the ratio of \
	original refsize and newsize. When relpos is true, the position of top left corner\
	of the component changes relatively to scaling, when false it will keep its original\
	distance to the anchor point. Anchor point is made from reference dimension of\
	hostframes and is created from \"right\" and \"bottom\".\
	", args="(Rectangle hostref, Rectangle ref, table params)", returns="(fnlayouter)"},
["addslider"] = {type='function', description = "\
	creates a slider with leading description label (slider.lbl) and following value label (slider.lblval). New y value which is y + h.<br>\
	slidervalue = sliderpos * scale + offset<br>\
	Parameters table contains:<br>\
	* initvalue: float, 0-1 position along slider\
	* callback: function, (outvalue, sliderpos) : callback (slidervalue,numericinput,sliderpos). When allowinput is true and callback is called with \"nil,numericinput,nil\" it must return sliderpos as well. Otherwise only outvalue is taken and (slidervalue, nil, sliderpos) are passed.\
	* [scale]: float\
	* [offset]: float\
	* [increment]: float, Slider increment\
	* [intmode]: boolean, Slider IntegerMode\
	\
	* [labelw]: int, name label widht, defaults to GH.sldLabelwidth\
	* [valw]: int, value label width, defaults to GH.sldLabelval\
	* [formatstr]: string, argument to string.format for value label\
	* [allowinput]: boolean, allows manual popup dialog input, when clicking on value label\
	", args="(Container frame,int x,y,w,h, string title, table parameters)", returns="(int newy, Slider)"},
["addcheckbox"] = {type='function', description = "\
	adds CheckBox to frame.<br>\
	Parameters table contains:<br>\
	* initvalue: boolean\
	* callback: function, callback(state).\
	", args="(Container frame,int x,y,w,h, string title, table parameters)", returns="(int newy, CheckBox)"},
["sldLabelwidth"] = {type='value', description = "[int] - width of description label for addslider"},
["scrollfield"] = {type='function', description = "\
	creates and returns groupframe, which gets a vertically scroll slider if content is out of bounds. \".area\" of returned frame should be used to add components to. \".area\" also contains the function \"scrollto(itemY,itemHeight)\" with which you can set the scroll pos (if slider exists, otherwise ignored).", args="(int x,y,w,h)", returns="(GroupFrame)"}}}
l2dlist = {type='class',description="The List2D is drawn after the List3D and orthogonally. It is mainly used for HUD rendering text and buttons.		The origin 0,0 is top left, the width and height is independently of the current resolution, but defined in window.refsize. New nodes start unlinked and wont be drawn, unless linked to root or another root child. Drawing of l2dnodes is also possible via the rcmddrawl2d part of l3dview rendercommand system.",childs={["getroot"] = {type='function', description = " returns l2dlist master root node. Root doesn't inherit its position info.", args="()", returns="(l2dnode)"},
["getrcmdclear"] = {type='function', description = " returns rcmdclear of the List2D.", args="()", returns="(rcmdclear)"}}}
CheckBox = {type='class',description="A CheckBox component. Basicly it is a slightly modified Button and\
	works in the same ways like the Button. The checkbox class is using the icon\
	to display the checkbox next to the text.\
\
	You can create and use a checkbox in this way:\
\
	 ck = CheckBox:new(10,90,200,24,\"Check me out!\")\
	 function ck:onClicked(state)\
	   if (state) then print(\"I am checked\")\
	   else print(\"I am unchecked\") end\
	 end\
	 Container.getRootContainer():add(ck)\
\
	The following skinssurface names are used by the checkbox class:\
\
	* checkedcheckbox_pressed\
	* checkedcheckbox\
	* checkedcheckbox_hovered\
	* checkedcheckbox_hovered_pressed\
	* checkedcheckbox_focused\
	* checkedcheckbox_focused_hovered\
	* checkedcheckbox_focused_pressed\
	* checkedcheckbox_focused_hovered_pressed\
\
	* checkbox_pressed\
	* checkbox\
	* checkbox_hovered\
	* checkbox_hovered_pressed\
	* checkbox_focused\
	* checkbox_focused_hovered\
	* checkbox_focused_pressed\
	* checkbox_focused_hovered_pressed\
	",childs={["skinnamesunchecked"] = {type='value', description = "{[table]} - skinnames in case the element is not checked"},
["skinnameschecked"] = {type='value', description = "{[table]} - skinnames in case the element is checked"},
["new"] = {type='function', description = "\
	Creates a checkbox at given location and with given size. The caption\
	is automaticly set to be aligned left on the skin and vertically centered.\
	It also activates the autowidth parameter of the skin and makes the\
	button it was derived from pushable.\
	", args="(class, float x,y,w,h, string caption, [Skin2D skin,Icon] ])", returns="(CheckBox)"}}}
l2dimage = {type='class',description="a quad with the given material (or plain color) will be rendered on screen.",childs={["fullscreen"] = {type='function', description = " sets pos and scale for fullscreen", args="(l2dimage)", returns="()"},
["matsurface"] = {type='function', description = " returns or sets matsurface", args="(l2dimage,[matsurface])", returns="([material/texture])"},
["quadcenteredmesh"] = {type='function', description = " deletes the usermesh and uses the centered quadmesh again.", args="(l2dimage)", returns="()"},
["usermesh"] = {type='function', description = " creates inplace custom rendermesh (see rendermesh for details) Polygonwinding is CW (not CCW like the others!).", args="(l2dimage, vertextype, int numverts, numindices, [vidbuffer vbo], [int vbooffset], [vidbuffer ibo], [int ibooffset])", returns="()"},
["rendermesh"] = {type='function', description = " gets or sets rendermesh. Get only works if a usermesh was created before or another rendermesh passed for useage.", args="(l2dimage,[rendermesh])", returns="([rendermesh])"},
["quadmesh"] = {type='function', description = " unrefs the rendermesh and uses the quadmesh again (default).", args="(l2dimage)", returns="()"},
["new"] = {type='function', description = " returns a new l2dimage", args="(string name,matsurface)", returns="(l2dimage)"}}}
rcmdignoreflag = {type='class',description="Sets ignored renderflag",childs={["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdignoreflag)"}}}
rcmdbufferblit = {type='class',description="Blits a rectangle from current read to drawbuffer. Also allows stretching and flipping the rectangle specified. When no fbo is bound backbuffer is used for read or draw.",childs={["linear"] = {type='function', description = " returns or sets whether linear filtering shall be applied when sizes mismatch. Not allowed when depth or stencil are involved in copy.", args="(rcmdbufferblit,[boolean])", returns="([boolean])"},
["from"] = {type='function', description = " returns or sets rectangle to copy from. OpenGL pixel coordinates", args="(rcmdbufferblit,[int x,y,w,h])", returns="([int x,y,w,h])"},
["to"] = {type='function', description = " returns or sets rectangle to copy to. OpenGL pixel coordinates. Negative width and height means flipping along these axis.", args="(rcmdbufferblit,[int x,y,w,h])", returns="([int x,y,w,h])"},
["content"] = {type='function', description = " returns or sets which buffers are copied.", args="(rcmdbufferblit,[boolean color,depth,stencil])", returns="([boolean color,depth,stencil])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdbufferblit)"}}}
l3dview = {type='class',description="l3dview is used to render a l3dset. You can specify camera, background and fog for each l3dview.Every l3dset has one default l3dview, which cannot be deleted. Additionally you can register more l3dviews which are processed before/after the default views.The l3dnodes can be made visible only to certain cameras. By default they are visible to the default camera and windowsized.<br> Another special purpose of l3dviews is rendering to a texture.",childs={["fogstart"] = {type='function', description = " returns or sets", args="(l3dview,[float])", returns="([float])"},
["activate"] = {type='function', description = " activates the l3dview in the given set. Activate inserts the l3dview before (or after if set) reference view (or listhead if none given) in the list. Has no effect on defaultviews", args="(l3dview,l3dset,[l3dview ref,boolean after])", returns="()"},
["rcmdremove"] = {type='function', description = " removes the rcmd from the list. Occurance value treated as in rcmdadd.", args="(l3dview,rcmd,[int occurance])", returns="(boolean success)"},
["rcmdflag"] = {type='function', description = " sets rcmd process bit flag. If rcmdflag of view AND the own flag bitwise return true, then the rcmd will be processed. id = 0..31", args="(l3dview,int id,[boolean])", returns="([boolean])"},
["fogcolor"] = {type='function', description = " returns or sets", args="(l3dview,[float r,g,b,a])", returns="([float r,g,b,a])"},
["windowsized"] = {type='function', description = " returns or sets if the viewport should use the full window size (default true).", args="(l3dview,[boolean])", returns="([boolean])"},
["deactivate"] = {type='function', description = " deactivates the l3dview. Has no effect on defaultviews", args="(l3dview)", returns="()"},
["filldrawlayers"] = {type='function', description = " enable/disable filling of drawlayers (l3dtrails, l3dmodels, l3dprimitives, l3dlevelmodel, l3dtext, l3dshadowmodel), particlelayers remain active. Default is true. Useful when a pure fx/l2dnode/particle view is being rendered, or layers are organized to be spread over different l3dviews. When set to false the layerstate of previous l3dview remains active (first l3dview of each l3dset always does a clear). That way you can reuse the data, but it only makes sense if camera visibility stays identical. The layer filling is a rather costly operation, so avoid it when possible.", args="(l3dview,[boolean])", returns="([boolean])"},
["defaultcamvisflag"] = {type='function', description = " sets camera visibility bit flag if a default camera is used for this view. It overrides the visflag of the camera itself, however culling is done before and based on the original camera bitid.", args="(l3dview,int id,[boolean])", returns="([boolean])"},
["drawnow"] = {type='function', description = " if the l3dview is not active, it can be drawn directly, ie unrelated of the l3dset. This is mostly meant for immediate/one-time modifications of textures via renderfbo useage. Due to lack of an l3dset layer and particle drawing will show no effect.", args="(l3dview,[l3dlight sun])", returns="()"},
["fogend"] = {type='function', description = " returns or sets", args="(l3dview,[float])", returns="([float])"},
["new"] = {type='function', description = " returns a new l3dview. rcmdbias (default 0) allows you to allow more (>0) or less (<0) than 255 rcmds in this view.", args="([int rcmdbias])", returns="(l3dview)"},
["usepolygonoffset"] = {type='function', description = " returns or sets if depth values are changed depending on slope and constant factors when depth testing occurs.", args="(l3dview,[boolean])", returns="([boolean])"},
["delete"] = {type='function', description = " deletes the l3dview. Has no effect on defaultviews", args="(l3dview)", returns="()"},
["bgskybox"] = {type='function', description = " returns or sets skybox, disabled when 2nd arg is not a skybox", args="(l3dview,[skybox])", returns="([skybox])"},
["fogstate"] = {type='function', description = " returns or sets", args="(l3dview,[boolean])", returns="([boolean])"},
["fogdensity"] = {type='function', description = " returns or sets", args="(l3dview,[float])", returns="([float])"},
["viewdepth"] = {type='function', description = " returns or sets range of depthbuffer (0-1).", args="(l3dview,[float min,max])", returns="([float min,max])"},
["rcmdadd"] = {type='function', description = " adds the rcmd to the rcmd queue list of this l3dview. You can add a maximum of 255 rcmds to default views, and for custom views you can modify this limit. They are processed in the order they are added. If there are no commands, the l3dview will do nothing cept debug drawing. As long as rcmd is assigned it won't be garbagecollected.<br><br>You can insert after a another rcmd, which is searched in the list. When occurance is negative we will search the rcmd from the back first. An absolute value of 1 will be first occurance, 2 second and so on. 0 or passing no occurance value is same as +1. If before is true we will insert before the given rcmd (default is false).<br><br>When only before == true is passed and no ref&occurance, we will insert the command as first.", args="(l3dview,rcmd,|rcmd ref,int occurance|,[boolean before])", returns="(boolean success)"},
["depthonly"] = {type='function', description = " returns or sets if a pure Z write should be done.", args="(l3dview,[boolean])", returns="([boolean])"},
["drawcamaxis"] = {type='function', description = " draws camera orientation", args="(l3dview,[boolean])", returns="([boolean])"},
["camera"] = {type='function', description = " returns or sets camera, disabled when 2nd arg is not a camera. If disabled we will use default camera.", args="(l3dview,[l3dcamera])", returns="(l3dcamera)"},
["viewpos"] = {type='function', description = " returns or sets the viewport starting position in GLpixels. 0,0 is bottom left, which is not as in list2d. only used when windowsized is false", args="(l3dview,[int x,y])", returns="([int x,y])"},
["polygonoffset"] = {type='function', description = " returns or sets the polygonoffset values..", args="(l3dview,[float scale,bias])", returns="([float scale,bias])"},
["rcmdget"] = {type='function', description = "  gets the current rcmd from a specified index, nil if out of bounds. Useful for debugging.", args="(l3dview,int index)", returns="([rcmd])"},
["viewrefbounds"] = {type='function', description = " returns or sets the viewport size and position in reference coordinates. only used when windowsized is false. Warning: viewsize must always be smaller than current window refsize.", args="(l3dview,[float  refx,refy,refwidth,refheight])", returns="([float refx,refy,refwidth,refheight])"},
["viewsize"] = {type='function', description = " returns or sets the viewport size in pixels. only used when windowsized is false. Warning: viewsize must always be smaller than current window resolution (unless FBO rendering is used).", args="(l3dview,[int width,height])", returns="([int width,height])"},
["rcmdempty"] = {type='function', description = " empties the rcmd list of this l3dview.", args="(l3dview)", returns="()"}}}
dgeomplane = {type='class',description="Planes are infinite and so non-placeable geoms. This means that, unlike placeable geoms, planes do not have an assigned position and rotation. This means that the parameters (a,b,c,d) are always in world coordinates. In other words it is assumed that the plane is always part of the static environment and not tied to any movable object.",childs={["normal"] = {type='function', description = " sets the normal vector of the plane. Luxinia normalizes this vector automaticly for you.", args="(dgeomplane,[float x,y,z])", returns="([float x,y,z])"},
["distance"] = {type='function', description = " sets the distance of the plane to the origin (0,0,0)", args="(dgeomplane,[float d])", returns="([float d])"},
["new"] = {type='function', description = " Create a plane geom of the given parameters, and return its ID. If space is given, insert it into that space. The plane equation is a*x+b*y+c*z = d \
The plane's normal vector is (a,b,c), is normalized automaticly. ", args="([float a,b,c,d],[dspace])", returns="(dgeomplane)"}}}
primitivetype = {type='class',description="Graphics hardware supports rendering of different primitive types. The way indices are interpreted will depend on the indexprimitivetype.",childs={["trianglefan"] = {type='function', description = " triangle fan. First index becomes center, all others are connected to it and previous index.", args="()", returns="(primitivetype)"},
["linestrip"] = {type='function', description = " line strip. Each index is a line point connected to previous index, not closed. Rendersurface interface can be used to influence appearance.", args="()", returns="(primitivetype)"},
["quadstrip"] = {type='function', description = " quad strip. After the first 2 indices, each 2 new indices creat a quad with last 4 indices.", args="()", returns="(primitivetype)"},
["trianglestrip"] = {type='function', description = " triangle strip. After the first 2 indices, each new index spans a triangle with last 3 indices.", args="()", returns="(primitivetype)"},
["quads"] = {type='function', description = " quad list. Every four indices make a quad.", args="()", returns="(primitivetype)"},
["lineloop"] = {type='function', description = " closed line loop. Each index is a line point connected to previous index, a last line segment is added automatically to first index. Rendersurface interface can be used to influence appearance.", args="()", returns="(primitivetype)"},
["polygon"] = {type='function', description = " polygon. All indices create the outer closed line of a polygon, which becomes triangulated by the driver internally, undefined behavior for non-convex polygons.", args="()", returns="(primitivetype)"},
["points"] = {type='function', description = " points. Each index will be a point. Using vertexshaders pointsize can be influenced.", args="()", returns="(primitivetype)"},
["lines"] = {type='function', description = " line list. Every two indices make a line. Rendersurface interface can be used to influence appearance.", args="()", returns="(primitivetype)"},
["triangles"] = {type='function', description = " triangle list. Every 3 indices make a triangle.", args="()", returns="(primitivetype)"}}}
L3DIcon = {type='class',description="L3DIcon are displaing l3dmodels.",childs={["l3dScale"] = {type='function', description = " sets scaling of the l3d icon", args="(class, float x,y,z)", returns="()"},
["l3dPos"] = {type='function', description = " sets position of the l3d icon", args="(class, float x,y,z)", returns="()"},
["l3dRotdeg"] = {type='function', description = " sets rotation of the l3d icon", args="(class, float x,y,z)", returns="()"},
["new"] = {type='function', description = "\
	", args="(class,)", returns="()"}}}
MouseListener = {type='class',description="A mouselistener reacts on certain type of events and call a eventfunction.",childs={["1"] = {type='value', description = "{[function]} - listener function"},
["onEnter"] = {type='value', description = "{[boolean]} - true if the mouselistener reacts on enterings"},
["onWheel"] = {type='value', description = "{[boolean]} - true if the mouselistener reacts on wheelmoves"},
["onDragged"] = {type='value', description = "{[boolean]} - true if the mouselistener reacts on dragging"},
["onPressed"] = {type='value', description = "{[boolean]} - true if the mouselistener reacts on presses"},
["onExit"] = {type='value', description = "{[boolean]} - true if the mouselistener reacts on mouseexists"},
["2"] = {type='value', description = "{[int]} - eventmask"},
["onMoved"] = {type='value', description = "{[boolean]} - true if the mouselistener reacts on moves"},
["onClicked"] = {type='value', description = "{[boolean]} - true if the mouselistener reacts on clicks"},
["eventcall"] = {type='function', description = " same as MouseListener.matches,\
	but calls the listener's function instantly.", args="(MouseListener self, MouseEvent e)", returns="(boolean)"},
["matches"] = {type='function', description = " returns true if the mouselistener's\
	eventmask matches the eventmask of the MouseEvent.", args="(MouseListener self, MouseEvent e)", returns="(boolean)"},
["onReleased"] = {type='value', description = "{[boolean]} - true if the mouselistener reacts on releases"},
["new"] = {type='function', description = "\
	creates a new MouseListener. The eventFilter is optional and can be\
	created by creating the product of the specific events of interest (i.e.\
	MouseEvent.MOUSE_MOVED*MouseEvent.MOUSE_CLICKED). If eventFilter is not\
	given, the listenerfunction will be called on every mouseevent.\
\
	The callback function's signature is\
	 function listener (mouselistener, mouseevent)\
	", args="(function callback, [int eventFilter])", returns="(MouseListener)"}}}
frustumobject = {type='class',description="l3dcameras can use multiple user defined frustumobjects instead of the automatically created frustum. The latter is based on the projection settings. A frusutmobject is user defined and consists of 6 planes defining the frustum and the 8 points of the corners. At runtime all assoicated frustumobjects are used for the visibility test of that camera. frustumobjects are stored in world space.",childs={["corner"] = {type='function', description = " returns or sets ith 0-7 corner.", args="(frustumobject,int index,[float x,y,z])", returns="([float x,y,z])"},
["update"] = {type='function', description = " updates vice versa from planes or corners (default is true).", args="(frustumobject, [boolean fromcorners])", returns="()"},
["frommatrix"] = {type='function', description = " updates planes from given projection matrix.", args="(frustumobject, matrix44 mat)", returns="()"},
["plane"] = {type='function', description = " returns or sets ith 0-5 plane. Plane normals point to inside.", args="(frustumobject,int index,[float x,y,z,-d])", returns="([float x,y,z,-d])"},
["new"] = {type='function', description = " returns self", args="()", returns="(frustumobject)"}}}
Button = {type='class',description="A Button is a Component that reacts on mouseclicks and other mouseactions.\
\
	Creating a simple button that reacts on mouseclicks is as easy as this:\
	 btn = Button:new(10,10,80,30,\"Hello\") -- create button\
	 function btn:onClicked()  -- function that is called on click events\
	   print(\"Hello\") -- do whatever you like\
	 end\
	   -- put the button now on the root container\
	 Container.getRootContainer():add(btn)\
	   -- otherwise it won't be visible",childs={["setPushState"] = {type='function', description = " pass true if the button should be pushed. Setting \
	The pushstate won't affect actionlisteners and click functions.", args="(Button,boolean)", returns="()"},
["positionUpdate"] = {type='function', description = " updates all the position info", args="(Button self)", returns="()"},
["mouseEntered"] = {type='function', description = " sets mouseinside to true", args="(Button self)", returns="()"},
["actionListeners"] = {type='value', description = "{[table]} - a list of all actionlisteners"},
["dataButton.mouseover"] = {type='value', description = "{[boolean]} - true if the mouse is over the button"},
["setIcon"] = {type='function', description = "\
	sets icon for the button. This is only a forwarder on the Skin2D.setIcon\
	function and will throw an error if no skin is set for this button.\
	The default blendmode is decal. If false is passed as blendmode, no\
	blend is used.", args="(texture/string icon, width,height,uvx,uvy,uvw,uvh, [blendmode])", returns="()"},
["setDoubleClickTriggerOnly"] = {type='function', description = " If set to true, the button reacts only on double clicks", args="(Button self, boolean on)", returns="()"},
["isFocusable"] = {type='function', description = " description from overloaded method of Component:\
\
returns true if the component can be focused.\
	If you overload this method, please remember that you should return false\
	if your element is current not focusable, ie. if not visible or not enabled.\
\
	For example:\
	 function TextField.isFocusable()\
	   return true and self:isVisible()\
	 end\
	", args="(Component)", returns="(boolean)"},
["hideVisibles"] = {type='function', description = " called when visible objects (l2ds) are no longer visible", args="(Button self)", returns="()"},
["toString"] = {type='function', description = " returns simple string representation of the button", args="(Button self)", returns="()"},
["dataButton.pressedMouseButton"] = {type='value', description = "{[int]} - the mousebuttonid that holds the button down"},
["removeActionListener"] = {type='function', description = " removes the actionlistener from the\
	object where the key can be the function or the description itself.", args="(function/any key)", returns="([function,description])"},
["mouseExited"] = {type='function', description = " sets mouseinside and mousedown to false", args="(Button self)", returns="()"},
["dataButton.isFocusable"] = {type='value', description = "{[boolean=true]} - can gain focus if true"},
["addActionListener"] = {type='function', description = "\
	Adds a function that is called when the button is clicked. The\
	description is optionial. The action function\
	signature:\
	 function actionfunction (buttonobject,datatable)\
	the datatable contains at index 1 the function and at index 2\
	the description. You can change the datatable in any way you want -\
	however, the function at index 1 will be the function that is being\
	called if an action occurs.", args="(function action,[string/any description])", returns="()"},
["deleteVisibles"] = {type='function', description = " called when a Component is no longer displayed", args="(Button self)", returns="()"},
["onClicked"] = {type='function', description = " simple callback function that can be overloaded without\
	calling the superclass etc. Is called after all ActionListeners has been\
	processed. The state boolean flag is true if the button is currently pushed,\
	which matters only for pushable buttons - otherwise it is always false.", args="(Button self, boolean state, wasmouse,wasdoubleclick)", returns="()"},
["dataButton"] = {type='value', description = "{[table]} - the current state info of the button."},
["setText"] = {type='function', description = " sets text of button", args="()", returns="()"},
["mousePressed"] = {type='function', description = " called if the mouse was pressed on the button", args="(Button self, MouseEvent e)", returns="()"},
["setPushable"] = {type='function', description = " Makes the button pushable. A pushbutton switches\
	between the normal and pressed state. You can use a third optional parameter\
	to set the state to an initial value.", args="(Button, pushable, [state])", returns="()"},
["isPushed"] = {type='function', description = " returns true if the Button is pushed", args="(Button)", returns="(boolean)"},
["isPushButton"] = {type='function', description = " returns true if the Button is a pushbutton", args="(Button)", returns="(boolean)"},
["new"] = {type='function', description = "\
	creates a new Button object.\
\
	The Skin should have 8 states:\
	* button\
	* button_hover\
	* button_pressed\
	* button_hover_pressed\
	* button_focus\
	* button_focus_hover\
	* button_focus_pressed\
	* button_focus_hover_pressed\
\
	If no skin is passed the default skin is cloned.\
	", args="(table class, float x,y,w,h, string caption, [Skin2D skin])", returns="(Button)"},
["setVisibility"] = {type='function', description = " description from overloaded method of Component:\
\
returns true if the component is\
	displayed (is actually on the rootpane) and is visible.", args="(Component self)", returns="(boolean)"},
["mouseMoved"] = {type='function', description = " called if the mouse actually moved over the button", args="(Button self, MouseEvent e)", returns="()"},
["getDoubleClickTriggerOnly"] = {type='function', description = " returns true if the button is reacting only on double clicks", args="(Button self)", returns="(boolean)"},
["mouseReleased"] = {type='function', description = " called if the mouse was released on the button", args="(Button self, MouseEvent e)", returns="()"},
["dataButton.pressedSince"] = {type='value', description = "{[int]} - if button is pressed, this value stores the frame when the\
			mousebutton was pressed"},
["setCustomL2d"] = {type='function', description = "\
	set a custom l2dnode for own purpose. The previously set custom l2dnode is\
	deleted. The new customl2dnode ist also deleted if the button is deleted.\
	The new customl2dnode is returned by this function. If no l2dnode is given,\
	the old customl2dnode is deleted.", args="(Component self,[l2dnode, float x, y,z])", returns="([l2dnode])"},
["dataButton.pressed"] = {type='value', description = "{[boolean]} - true if the button is hold down"},
["clicked"] = {type='function', description = " called if the button was actually clicked. Is called\
	if the mouse is clicked, but can be called by other sources, too. Calls\
	all actionlistener functions. This method calls the actionlisteners.\
	Overload onClicked instead for simple use.", args="(Button self,wasmouse,wasdoubleclicked)", returns="()"},
["setDisplayable"] = {type='function', description = " description from overloaded method of Component:\
\
a displayable component should create all it needs to be displayed\
	(l2dnodes & stuff).", args="(Component self, boolean displayable)", returns="()"},
["onAction"] = {type='function', description = " calls directly clicked (invoked by actioncommands such\
	as ENTER on focused buttons", args="(Button self)", returns="()"}}}
rcmddepth = {type='class',description="Sets depthtest environment.",childs={["compare"] = {type='function', description = " returns or sets comparemode used for depthtest. Passing any non-comparemode will disable setting and current state remains unchanged (default).", args="(rcmddepth,[comparemode/anything])", returns="([comparemode/false])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmddepth)"}}}
rcmddrawlayer = {type='class',description="Draws a l3dlayer",childs={["layer"] = {type='function', description = " returns or sets which layer 0..15", args="(rcmddrawlayer,[int])", returns="([int])"},
["sort"] = {type='function', description = " returns or sets sorting mode for layer. 0 none 1 material -1 front-to-back -2 back-to-front. Be aware that once camera order is used, the material sortkey is overwritten. Also if you draw the same layer multiple times, you only need to sort it once.", args="(rcmddrawlayer,[int])", returns="([int])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmddrawlayer)"}}}
ButtonGroup = {type='class',description="A ButtonGroup is a list of Buttons that are informed when another button \
	was pressed. A ButtonGroup has only one active button per time. The \
	ButtonGroup is assigning ActionListeners to the buttons to receive calls \
	on clickactions. ",childs={["remove"] = {type='function', description = " removes the button from the buttongroup", args="(button)", returns="()"},
["onClicked"] = {type='function', description = " function that is called when\
	a clickevent occured. This method does nothing and can be overloaded without \
	consequence.", args="([theclickedbutton],[previousbutton])", returns="()"},
["addButton"] = {type='function', description = " adds a button to the list. \
	If this button is pushed or released (because another button was pressed),\
	the corresponding functions are being called. The signature of the functions\
	is: \
	 function react ([theclickedbutton], [previousbutton])\
	You can use this functions to react on changes in the Buttongroup. Note that\
	if the currently active button is pressed again, no event is generated here.\
	\
	If toggle is true, clicking the active element will deselect the group.\
	\
	This function makes the given button automaticly pushable.\
	 button:setPushable(true)\
	", args="(Button, [fnOnPush], [fnOnRelease], [boolean toggle])", returns="(Button)"},
["new"] = {type='function', description = " creates a new Buttongroup", args="()", returns="(ButtonGroup)"},
["delete"] = {type='function', description = " deltes the group removing all the actionlisteners and so on", args="()", returns="()"},
["click"] = {type='function', description = " called by the actionlisteners. Calls automaticly the \
	assigned functiosn from the addButton function. Does nothing if the \
	button is currently marked as active (and is pushed). Calling the click \
	function with nil will deselect any button (except if you added the button as toggleable).", args="(button)", returns="()"}}}
djointgroup = {type='class',description="djoints can be organized in groups",childs={}}
Container = {type='class',description="A container is a collection of Components.",childs={["onDisplayChange"] = {type='function', description = " called whenever the\
	displaystate is changed, i.e. if the component was made invisible,\
	or it's parent was removed from the rootpane etc.\
\
	A component that is displayed has not to be visible.", args="(Container self, boolean isDisplayed)", returns="()"},
["mouseEvent"] = {type='function', description = " processes the mouseevent and\
	delegates it to it's children and mouselisteners. If exit is true, the mouse is now\
	on another component", args="(Container self, MouseEvent event, boolean exit)", returns="()"},
["isChildOf"] = {type='function', description = " returns true if a parent\
	of the ancestors is equal to parent", args="(Container, parent)", returns="(boolean)"},
["invalidate"] = {type='function', description = " description from overloaded method of Component:\
\
marks component to be updated on next validation", args="(Component self)", returns="()"},
["setBounds"] = {type='function', description = " Sets the bounds of the container and calls 'doLayout'.", args="(Container,x,y,w,h)", returns="()"},
["onVisibilityChange"] = {type='function', description = " called whenever\
	the container is made visible / invisible. Calls onVisibilityChange\
	of all child components. ", args="(Container self, boolean isVisible)", returns="()"},
["new"] = {type='function', description = " creates a container with the given bounds", args="(table class, int x,y,w,h)", returns="(Container)"},
["delete"] = {type='function', description = " description from overloaded method of Component:\
\
deletes the component. Removes the component from\
	any parent object and calls Component.onDestroy, that is also called when\
	the Component is garbagecollected. Never overload delete, use onDestroy for custom actions instead.", args="(Component self)", returns="()"},
["getRootContainer"] = {type='function', description = " returns the rootcontainer which is the main frame.", args="()", returns="(Container)"},
["removeComponent"] = {type='function', description = " removes the component from the container", args="(Container, Component)", returns="()"},
["validate"] = {type='function', description = " validates the container and all its childs.\
	Is called once per frame for containers that are visible,\
	don't call it unless you really need it.", args="(Container self)", returns="()"},
["removeChildren"] = {type='function', description = " removes all children of the container", args="(Container)", returns="()"},
["moveZ"] = {type='function', description = " deletes all childs of the container", args="(Container,Component a/ number index,toindex)", returns="()"},
["getComponentAt"] = {type='function', description = " returns container at the\
	specific position. Returns self if no child is found that matches and\
	if the point is contained in the component.", args="(Container self, float x,y)", returns="([Component])"},
["deleteChilds"] = {type='function', description = " deletes all childs of the container", args="(Container)", returns="()"},
["isRootContainer"] = {type='function', description = " returns true if the container is the rootcontainer", args="(Container)", returns="(boolean)"},
["doLayout"] = {type='function', description = " Called if the size of the container was changed. Can be overloaded (does nothing per default) to change bounds of child elements.", args="(Container)", returns="()"},
["toString"] = {type='function', description = " returns a simple string representation of self", args="(Container self)", returns="()"},
["components"] = {type='value', description = "{[table]} - list of child components on the container. Sorted from top to bottom. Be aware that the table is changed if childs are inserted / removed, which means that it that this should be avoided while iterating the list. Additionally, the table should not be modified, or behaviour is undefined."},
["add"] = {type='function', description = " adds the component to the list of components.\
	If Index is passed, it will be inserted at a certain z-position. The lower indexes are\
	on the foreground, higher numbers are on the background. Returns the added Component", args="(Container, Component,[int index])", returns="(Component)"}}}
djointslider = {type='class',description="Slider joint will limit the movement between two bodies to a axis.",childs={["position"] = {type='function', description = " Get the slider linear position (i.e. the slider's 'extension') and the time derivative of this value.", args="(djointslider)", returns="([float position,positionrate])"},
["axis"] = {type='function', description = " sets/gets axis of slider. Must be attached first, else crash is likely", args="([float x,y,z])", returns="([float x,y,z])"},
["new"] = {type='function', description = " When the axis is set, the current position of the attached bodies is examined and that position will be the zero position.", args="([djointgroup])", returns="(djointslider)"}}}
ImageIcon = {type='class',description="ImageIcon objects are using textures to display little icons in GUIs.\
	A texture can be used for multiple different icons.",childs={["new"] = {type='function', description = "\
	Creates image icon from texture. The texture can be either a string\
	or a loaded textures. If a string is passed the texture is being loaded\
	without texture compression (if it is on anyway).\
\
	The width and height is going to be used as size for the icon.\
	The blendmode is going to be used for the the icon.\
\
	The iconpositions is an associative array contiaining values with the\
	x,y coordinates and widths and heights of the parts of the texture to be used.\
	The default entry is used if no value for the selected icon is found. Components\
	will use names to load certain icons in different states (hovered, pressed,\
	etc.) and you can specify here where the correct icon is to be found on\
	the image. If no iconposition is passed, the whole texture is used as\
	icon.\
\
	All coordinates are in pixel coordinates.\
\
	Per default, the filtering of the icon texture is deactivated if the\
	size of the window is the same as the refsize for the drawn objects.\
	Otherwise the filtering value is not touched. Be aware that the\
	icons will look best if they are drawn in the same size as they really are.", args="(class,string/texture tex, width, height, blendmode, [table iconpositions], [table color])", returns="()"}}}
l2dview3d = {type='class',description="list2d node that executes a direct l3dview draw (see l3dview.drawnow limitations). Never use recursive processing of l2d and l3d viewing, i.e. it will cause crashes if the linked l3dview contains an rcmddrawl2d. ==The l3dview (optional l3dlight) is prevented from gc, as long as l2dnode is not gc'ed.",childs={["view"] = {type='function', description = " returns or sets l3dview", args="(l2dnode3d,[l3dview])", returns="([l3dview])"},
["sun"] = {type='function', description = " returns or sets l3dlight used as sun", args="(l2dnode3d,[l3dlight])", returns="([l3dlight])"},
["new"] = {type='function', description = " returns a new l2dview3d", args="(string name,l3dview)", returns="(l2dview3d)"}}}
ContainerMover = {type='class',description="A component that is moving its parent frame if clicked and dragged.",childs={["new"] = {type='function', description = " \
	Creates a ContainerMover, which is initially not visible", args="(table class, int x,y,w,h)", returns="(ContainerMover)"}}}
rcmddrawprt = {type='class',description="Draws the particles of an l3dlayer",childs={["layer"] = {type='function', description = " returns or sets which layer 0..15", args="(rcmddrawprt,[int])", returns="([int])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmddrawprt)"}}}
indexarray = {type='class',description="meshes contain indices for rendering their primitives, with this interface you can modify them. Always make sure that the corresponding vertices exist and always run indexMinmax once you set all indices. If you use display lists or vbos, changes to a loaded model will not be visible.",childs={["indexMinmax"] = {type='function', description = " computes minimum and maximum index used within indexCount, or you can manually set them. This is required for an indexarray to work, call this after all indices are set.", args="(indexarray,[min,max])", returns="(int min,max)"},
["indexCopy"] = {type='function', description = " copies indices from one indexarray into self, starting at given index and optionally offsetting the copied.", args="(indexarray,int start,indexarray from,int fromstart, int size,[int vertexoffset])", returns="([int])"},
["indexTrianglecount"] = {type='function', description = " returns and updates the internal number of triangles based on current indexCount. This is only needed for statistics and should be called at least once after all indices were written.", args="(indexarray)", returns="([int])"},
["indexType"] = {type='function', description = " returns the scalartype of the indices.", args="(indexarray)", returns="(scalartype)"},
["indexPtrs"] = {type='function', description = " returns C pointers for begin and end of array. [start,end[", args="(indexarray)", returns="(pointer start,end])"},
["indexUpdateVBO"] = {type='function', description = " if possible resubmits array using indexAllocatedcount or [from,to] range to VBO, returns true on success else false (no VBO or non compatible indexarray).", args="(indexarray,[int fromidx, count])", returns="(boolean)"},
["vertexAllocState"] = {type='function', description = " can create or remove the local data copy of the vertices. Only allowed if mesh is a VBO usermesh.", args="(indexarray,[boolean])", returns="([boolean])"},
["indexPrimitivetype"] = {type='function', description = " set or return the primitive type.", args="(indexarray, [primitivetype])", returns="([primitivetype])"},
["indexPrimitive"] = {type='function', description = " set or returns the primitive at given position. The function will return/need 1 index for points, 2 for lines, 3 indices for triangles, 4 indices for quads and can only return indices for any strips/loops/fan. Polygons are not supported, since the whole indexarray always contains only one.", args="(indexarray,primindex,[int a,b,c...])", returns="([int a,b,c...])"},
["indexPrimitivecount"] = {type='function', description = " returns the number of primitives based on indexCount", args="(indexarray)", returns="([int])"},
["indexCount"] = {type='function', description = " set or return the number of indices to be used on rendering. This value must always be smaller than Allocatedcount.", args="(indexarray,[int cnt])", returns="([int])"},
["vertexFromVBO"] = {type='function', description = " if possible retrieves array using vertexAllocatedcount or [from,to] range from VBO, returns true on success else false (no VBO or non compatible vertexarray).", args="(indexarray,[int fromidx, count])", returns="(boolean)"},
["indexAllocatedcount"] = {type='function', description = " return indices count. This is the number of indices that can be used in this indexarray, index must always be smaller than this.", args="(indexarray)", returns="([int cnt])"},
["indexMeshtype"] = {type='function', description = " returns what type of mesh the indices/vertices are stored for display.", args="(indexarray)", returns="([meshtype])"},
["indexVidbuffer"] = {type='function', description = " if stored as VBO returns vidbuffer and offset bytes.", args="(indexarray)", returns="([vidbuffer,int ibooffset])"},
["indexValue"] = {type='function', description = " set or returns value at the given index. Make sure the corresponding vertex exists", args="(indexarray,index,[int value])", returns="([int value])"}}}
rcmdfbooff = {type='class',description="Unbinds bound fbo, and returns to window backbuffer again.",childs={["readbuffer"] = {type='function', description = " returns or sets whether target is readbuffer binding, or drawbuffer. Readbuffer functionality requires extra capability and by default is off.", args="(rcmdfbobind, [boolean readbuffer])", returns="([boolean readbuffer])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdfbooff)"}}}
rendersurface = {type='class',description="For most renderable nodes you can define how their surface are blend with the framebuffer, or how alpha-based rejection should be done. Enabling/disabling those effects is done with renderflags. l3dmodel is treated similar as in renderflag",childs={["rsBlendinvert"] = {type='function', description = " returns or sets blend invert of alpha-based blend types", args="(rendersurface,[boolean])", returns="([boolean])"},
["rsLinestipple"] = {type='function', description = " returns or sets stipple pattern, is used if rfWireframe is on and rsLinefactor is greater 0. The string should contain 16 0s or 1s which define the linestyle.", args="(rendersurface,[string])", returns="([string])"},
["rsBlendmode"] = {type='function', description = " only effective if rfBlend is set", args="(rendersurface,[blendmode])", returns="([blendmode])"},
["rsAlphavalue"] = {type='function', description = " returns or sets alpha threshold", args="(rendersurface,[float])", returns="([float])"},
["rsLinefactor"] = {type='function', description = " returns or sets stipple factor, is used if rfWireframe and is value is greater 0. Linestyle is define in rsLinestipple.", args="(rendersurface,[int 0-255])", returns="([int])"},
["rsAlphacompare"] = {type='function', description = " returns or sets alpha compare mode - only effective if rfAlphatest is set", args="(rendersurface,[comparemode])", returns="([comparemode])"},
["rsLinewidth"] = {type='function', description = " returns or sets linewidth for wireframes. When not set it will use whatever linewidth is currently active.", args="(rendersurface,[float])", returns="([float])"}}}
Rectangle = {type='class',description="A 2D rectangle for hittests. 2D Rectangles are used as bounding\
	boxes for the Component class.",childs={["getClosestSide"] = {type='function', description = " returns closest side to a given point, 1 top edge, 2... clockwise", args="(Rectangle,x,y)", returns="(side)"},
["new"] = {type='function', description = " creates a rectangle object with the \
	given values as attributes. If a parameter is not specified, 0 is used as\
	default value.", args="([table class, [float x,y,width,height]/[Rectangle rect] ])", returns="()"},
["3"] = {type='value', description = "{[int]} - width"},
["2"] = {type='value', description = "{[int]} - y component"},
["merged"] = {type='function', description = " returns new Rectangle containing both.", args="(Rectangle a, Rectangle b)", returns="(Rectangle)"},
["4"] = {type='value', description = "{[int]} - height"},
["add"] = {type='function', description = " adds a point or \
	rectangle to the rectangle.", args="(Rectangle self, Rectangle r / float x,float y)", returns="()"},
["toString"] = {type='function', description = " returns a simple string representing this rectangle.", args="(Rectangle self)", returns="(string)"},
["getCorners"] = {type='function', description = " returns top left and bottom right coordinates", args="(Rectangle)", returns="(x1,y1,x2,y2)"},
["intersection"] = {type='function', description = " returns intersection of both rectangles\
	or nil if a and b do not intersect. If a or b is nil, nil is returned.", args="(Rectangle a,b)", returns="([Rectangle])"},
["intersects"] = {type='function', description = " returns true if both\
	rectangles do intersect", args="(Rectangle self, Rectangle other)", returns="(boolean)"},
["translate"] = {type='function', description = " translates the rectangle", args="(Rectangle,x,y)", returns="()"},
["setBounds"] = {type='function', description = " sets bounds of the Rectangle", args="(Rectangle self, float x,y,w,h)", returns="()"},
["contains"] = {type='function', description = " returns true if the given point is \
	inside the rectangle. The borders of the rectangle are included.", args="(Rectangle r, float x,y)", returns="(boolean)"},
["1"] = {type='value', description = "{[int]} - x component"},
["area"] = {type='function', description = " area of rectangle (width*height)", args="(Rectangle self)", returns="(area)"}}}
rcmddrawl2d = {type='class',description="Draws a l2dnode with its children. Useful for render-to-texture GUIs",childs={["root"] = {type='function', description = " allows l2dnode drawing in this viewport. The given node will be unlinked from rest and made the master root for this view. Previous root becomes unlinked. Passing a non-l2dnode disables it.", args="(rcmddrawl2d,[l2dnode])", returns="([l2dnode])"},
["refsize"] = {type='function', description = " The refscreensize width/height while rendering l2droot and its children.", args="(rcmddrawl2d,[float w,h])", returns="([float w,h])"},
["new"] = {type='function', description = " returns the rcmdt", args="()", returns="(rcmddrawl2d)"}}}
l3dbatchbuffer = {type='class',description="l3dbatchbuffer contains precompiled models. It is meant for efficient rendering of static geometry. Every model affected is transformed using the current hierarchy informatons and its vertices and indices are modified, so that the models are stored in big chunks. Meshes then can be batched to minimize drawcalls.",childs={["delete"] = {type='function', description = " destroys the batchbuffer and all content in it. All linked drawnodes will revert back to their models' meshes and become fully operational again.", args="(l3dbatchbuffer)", returns="()"},
["new"] = {type='function', description = " returns a new l3dbatchbuffer for the given l3dset and scenenode. All models, that are part of the given l3dset and either directly or indirectly linked to the given scenenode or its children, will be added to the batchbuffer and get their vertex and index data from it. Animateable models or those marked as nonbatchable will not be added, neither those with unsupported primitive types (triangle fans,line loop,line strip, polygon). Properties such as color and renderscale will be ignored and reset. Note that the matrices are calculated with the latest information for affected l3dnodes and scenenodes, that means make sure the scene is properly set up before. l3dnodes that are linked to bones, will not be added, nor their children, as they are considered animated. You can still modify the resulting worldspace vertexdata via vertexarray/indexarray interface from the affected l3dmodels. <br>It is important that you do not change the models position/rotation after batchcompiling, as visibility culling is still based on those.<br> Avoid using matobject interfaces on batchcompiled geometry.", args="(l3dset,scenenode root)", returns="(l3dbatchbuffer)"}}}
ftp = {type='class',description="FTP (File Transfer Protocol) is a protocol used to transfer files between hosts. \
The ftp namespace offers thorough support to FTP, under a simple interface. The \
implementation conforms to RFC 959.\
\
High level functions are provided supporting the most common operations. These \
high level functions are implemented on top of a lower level interface. Using \
the low-level interface, users can easily create their own functions to access \
any operation supported by the FTP protocol. For that, check the implementation.\
\
To really benefit from this module, a good understanding of LTN012, Filters \
sources and sinks is necessary.\
\
URLs MUST conform to RFC 1738, that is, an URL is a string in the form:\
\
    [ftp://][<user>[:<password>]@]<host>[:<port>][/<path>][type=a|i] \
\
The following constants in the namespace can be set to control the \
default behavior of the FTP module:\
\
* PASSWORD: default anonymous password.\
* PORT: default port used for the control connection;\
* TIMEOUT: sets the timeout for all I/O operations;\
* USER: default anonymous user; \
\
 ftp.get(url)\
 ftp.get{\
  host = string,\
  sink = LTN12 sink,\
  argument or path = string,\
  [user = string,]\
  [password = string]\
  [command = string,]\
  [port = number,]\
  [type = string,]\
  [step = LTN12 pump step,]\
  [create = function]\
 }\
\
The get function has two forms. The simple form has fixed functionality: it \
downloads the contents of a URL and returns it as a string. The generic form \
allows a lot more control, as explained below.\
\
If the argument of the get function is a table, the function expects at least \
the fields host, sink, and one of argument or path (argument takes precedence). \
Host is the server to connect to. Sink is the simple LTN12 sink that will \
receive the downloaded data. Argument or path give the target path to the \
resource in the server. The optional arguments are the following:\
\
* user, password: User name and password used for authentication. \
Defaults to \"ftp:anonymous@anonymous.org\";\
* command: The FTP command used to obtain data. Defaults to \"retr\", but see example below;\
* port: The port to used for the control connection. Defaults to 21;\
* type: The transfer mode. Can take values \"i\" or \"a\". Defaults to \
whatever is the server default;\
* step: LTN12 pump step function used to pass data from the server to \
the sink. Defaults to the LTN12 pump.step function;\
* create: An optional function to be used instead of socket.tcp when \
the communications socket is created. \
\
If successful, the simple version returns the URL contents as a string, and \
the generic function returns 1. In case of error, both functions return nil \
and an error message describing the error.\
\
 -- Log as user \"anonymous\" on server \"ftp.tecgraf.puc-rio.br\",\
 -- and get file \"lua.tar.gz\" from directory \"pub/lua\" as binary.\
 f, e = ftp.get(\"ftp://ftp.tecgraf.puc-rio.br/pub/lua/lua.tar.gz;type=i\")\
\
 -- load needed modules\
 local ftp = require(\"socket.ftp\")\
 local ltn12 = require(\"ltn12\")\
 local url = require(\"socket.url\")\
\
 -- a function that returns a directory listing\
 function nlst(u)\
    local t = {}\
    local p = url.parse(u)\
    p.command = \"nlst\"\
    p.sink = ltn12.sink.table(t)\
    local r, e = ftp.get(p)\
    return r and table.concat(t), e\
 end\
\
 ftp.put(url, content)\
 ftp.put{\
  host = string,\
  source = LTN12 sink,\
  argument or path = string,\
  [user = string,]\
  [password = string]\
  [command = string,]\
  [port = number,]\
  [type = string,]\
  [step = LTN12 pump step,]\
  [create = function]\
 }\
\
The put function has two forms. The simple form has fixed functionality: \
it uploads a string of content into a URL. The generic form allows a lot more \
control, as explained below.\
\
If the argument of the put function is a table, the function expects at least \
the fields host, source, and one of argument or path (argument takes precedence). \
Host is the server to connect to. Source is the simple LTN12 source that will \
provide the contents to be uploaded. Argument or path give the target path to \
the resource in the server. The optional arguments are the following:\
\
* user, password: User name and password used for authentication. \
Defaults to \"ftp:anonymous@anonymous.org\";\
* command: The FTP command used to send data. Defaults to \"stor\", but see example below;\
* port: The port to used for the control connection. Defaults to 21;\
* type: The transfer mode. Can take values \"i\" or \"a\". Defaults to \
whatever is the server default;\
* step: LTN12 pump step function used to pass data from the server to the sink. \
Defaults to the LTN12 pump.step function;\
* create: An optional function to be used instead of socket.tcp when the \
communications socket is created. \
\
Both functions return 1 if successful, or nil and an error message \
describing the reason for failure.\
\
 -- Log as user \"fulano\" on server \"ftp.example.com\",\
 -- using password \"silva\", and store a file \"README\" with contents \
 -- \"wrong password, of course\"\
 f, e = ftp.put(\"ftp://fulano:silva@ftp.example.com/README\", \
    \"wrong password, of course\")\
\
 -- load the ftp support\
 local ftp = require(\"socket.ftp\")\
 local ltn12 = require(\"ltn12\")\
\
 -- Log as user \"fulano\" on server \"ftp.example.com\",\
 -- using password \"silva\", and append to the remote file \"LOG\", sending the\
 -- contents of the local file \"LOCAL-LOG\"\
 f, e = ftp.put{\
  host = \"ftp.example.com\", \
  user = \"fulano\",\
  password = \"silva\",\
  command = \"appe\",\
  argument = \"LOG\",\
  source = ltn12.source.file(io.open(\"LOCAL-LOG\", \"r\"))\
 }\
",childs={}}
MouseCursor = {type='class',description="	The mousecursor is a visual representation of the mouse. The graphical\
	appearance can be customized.\
	",childs={["showMouse"] = {type='function', description = " same as input.showMouse. If the mouse is visible,\
	MouseCursor.enable will be true.", args="([boolean])", returns="([boolean])"},
["enable"] = {type='function', description = " enables or disables or\
	returns current state of mousecursor. Only a enabled mouse produces\
	clickevents and movementevents. If the mousecursor of the operating\
	system is not shown (see MouseCursor.showMouse), a custom mousecursor\
	is shown instead.", args="([boolean enable])", returns="([boolean enabled])"},
["removeMouseListener"] = {type='function', description = " removes a mouselistener", args="(MouseListener ml)", returns="()"},
["addMouseListener"] = {type='function', description = " adds a mouselistener which will be called\
	if the eventmask fits the mouselistener's eventmask.", args="(MouseListener ml)", returns="()"},
["mouseL2D"] = {type='function', description = " returns the l2d that is used as\
	mousecursor. If a l2dnode is passed as argument, the current\
	mousecursor is replaced by the argument and the old l2dnode is\
	returned. This might be the defaultmousecursor.", args="([l2dnode],[hotspotx,hotspoty])", returns="(l2dnode)"},
["wasButtonPressed"] = {type='function', description = " returns true if the button (0-2)\
	was pressed during the last frame", args="(int button)", returns="(boolean)"},
["pos"] = {type='function', description = " returns or sets current mouse cursor position.\
	Generates a mouseevent that is delegated to the mousecursor's mouselistener list.\
	If nomove is true, input.mousepos(x,y) is NOT called, leaving the OS cursor where it is.\
	", args="([int x,y],[boolean nomove])", returns="([int x,y])"},
["prevpos"] = {type='function', description = " Mouseposition in previous frame", args="()", returns="(int x,y)"},
["pollOnce"] = {type='function', description = " instead of using the mouse event queue, \
	the state of the mouse is polled only once per frame and appropriate MouseEvents are generated.", args="(boolean state)", returns="()"}}}
bit = {type='class',description="Allows bit-wise operations (32 bit) on numbers.\
",childs={["band"] = {type='function', description = "\
Returns the bitwise and of all of its arguments. Note that more than two arguments are allowed.", args="(number,number,...)", returns="(number)"},
["rshift"] = {type='function', description = "\
see lshift", args="(number,number n)", returns="(number)"},
["bor"] = {type='function', description = "\
Returns the bitwise or of all of its arguments. Note that more than two arguments are allowed.", args="(number,number,...)", returns="(number)"},
["bnot"] = {type='function', description = "\
Returns the bitwise not of its argument.", args="(number)", returns="(number)"},
["bswap"] = {type='function', description = "\
Swaps the bytes of its argument and returns it. This can be used to convert little-endian 32 bit \
numbers to big-endian 32 bit numbers or vice versa", args="(number)", returns="(number)"},
["bxor"] = {type='function', description = "\
Returns the bitwise xor of all of its arguments. Note that more than two arguments are allowed.", args="(number,number,...)", returns="(number)"},
["tobit"] = {type='function', description = " Normalizes a number to the numeric range for \
bit operations and returns it. This function is usually not needed since all bit\
operations already normalize all of their input arguments. Check the operational semantics for details.", args="(number)", returns="(number)"},
["arshift"] = {type='function', description = "\
see lshift", args="(number,number n)", returns="(number)"},
["lshift"] = {type='function', description = "\
Returns either the bitwise logical left-shift, bitwise logical right-shift, or bitwise arithmetic right-shift of its first argument by the number of bits given by the second argument.\
\
Logical shifts treat the first argument as an unsigned number and shift in 0-bits. Arithmetic right-shift treats the most-significant bit as a sign bit and replicates it.\
Only the lower 5 bits of the shift count are used (reduces to the range [0..31]).", args="(number,number n)", returns="(number)"},
["tohex"] = {type='function', description = "\
Converts its first argument to a hex string. The number of hex digits is given by the absolute value \
of the optional second argument. Positive numbers between 1 and 8 generate lowercase hex digits. \
Negative numbers generate uppercase hex digits. Only the least-significant 4*|n| bits are used. \
The default is to generate 8 lowercase hex digits.", args="(number,[number])", returns="(string)"},
["brol"] = {type='function', description = "\
Returns either the bitwise left rotation of its first argument by the number of bits given by the second argument. Bits shifted out on one side are shifted back in on the other side.\
Only the lower 5 bits of the rotate count are used (reduces to the range [0..31]).", args="(number,number n)", returns="(number)"},
["bror"] = {type='function', description = "\
Returns either the bitwise right rotation of its first argument by the number of bits given by the second argument. Bits shifted out on one side are shifted back in on the other side.\
Only the lower 5 bits of the rotate count are used (reduces to the range [0..31]).", args="(number,number n)", returns="(number)"}}}
StretchedSkinnedImage = {type='class',description="A skinned image is an image that uses a special texture to create a\
	2D rectangle visual surface.\
\
	The skin is created from 9 areas on the texture:\
\
	 1 2 3\
	 4 5 6\
	 7 8 9\
\
	The areas 1,3,7 and 9 (the corners) are not stretched, while\
	2 and 8 are stretched horizontaly while 4 and 6 are stretched\
	vertically. Area 5 is stretched in both dimensions, depending\
	on the chosen dimension of the image.\
\
	The SkinnedImage class can handle multiple verticaly aligned\
	skins on one texture that can be displayed one per time.",childs={["new"] = {type='function', description = "\
	creates new object of given class and initializes the stretchedimageskin\
	specific variables of this object.\
\
	If the texture is a string, the texture is being loaded without compression.\
	This has no effect if the image was loaded before with compression. This\
	affects only configurations where compression is enabled.\
\
	The 4 integer arguments top, right, bottom and left are the widths of\
	the borders which are used in the way as the class description.\
\
	The uvs are optional and can be used to specify regions on the texture to\
	be used for a certain surface. The table must contain named arrays of\
	coordinates, i.e. @@{default = {x,y,width,height}}@@ where the coordinates\
	specify the regions to be used. Creating a single texture with multiple\
	GUI components to be used is more efficient and easier to be created.\
	The uvs must be named to provide different surfaces for instance, if assigned\
	to a button, the button will ask for different surfaces if the button is\
	clicked, hovered and so on. Look up the documentation on the components\
	that are using skins for a detailed overview on the surfaces for skins.\
\
	If no uvs are passed, the skin will stretch out for the whole image.\
	If a requested surface in a skin is not specified in the uvs table, the\
	whole image will be used also. Additionally the uvpositions can overload\
	the margin widths. The format for the uvpositions is\
	 {x, y, width, height, [top, left, right, bottom]}\
\
	All coordinates are in absolute pixel coordinates.\
\
	Per default, the filtering of the skin texture is deactivated if the\
	size of the window is the same as the refsize for the drawn objects.\
	Otherwise the filtering value is not touched. Be aware that the\
	skins will look best if they are drawn in the same size as they really are.\
	", args="(class,string/texture tex,float top,right,bottom,left, [table uvs])", returns="()"}}}
ListBox = {type='class',description="A scrollable listbox.",childs={["itemCount"] = {type='function', description = " returns the number of items in the list.", args="(table class)", returns="(n)"},
["getSelected"] = {type='function', description = " returns the currently selected item", args="(ListBox)", returns="([int indx, string caption, command])"},
["select"] = {type='function', description = "\
	selects the specified item by its name, number or commandstring", args="(ListBox, string/int something, [boolean iscommand])", returns="(int selected)"},
["find"] = {type='function', description = " returns index of element in list that matches the \
	search. If what is 'command', id is compared with the commands, if what is 'caption', the\
	id is compared with the captions.", args="(ListBox, id, string what)", returns="([index,caption,command])"},
["addItem"] = {type='function', description = " ", args="(ListBox, string caption, [string cmd,[icon, iconskinselection] ])", returns="()"},
["onSelected"] = {type='function', description = " this function\
	can be overloaded without calling this function. It is called each time the\
	user selects an item - which does not have to be different from the previously\
	selected item.", args="(ListBox,int index, string caption, string command)", returns="()"},
["new"] = {type='function', description = " creates a listbox\
	at the given coordinates with the given skin.", args="(table class, int x,y,w,h,[Skin2D skin])", returns="(ListBox)"},
["removeItem"] = {type='function', description = " removes item at given index. If what is 'command' then the \
	index is searched of an item whichs command is equal to id, if what is 'caption' the id is compared \
	with the caption.", args="(ListBox, int index, [string what])", returns="()"},
["renameItem"] = {type='function', description = " renames an item at the given index", args="(ListBox, int index, [caption],[command],[icon],[iconname])", returns="()"},
["clearItems"] = {type='function', description = " deletes all items in the list ", args="(ListBox)", returns="()"}}}
math = {type='class',description="This library is an interface to the standard C math library. It provides all\
its functions inside the table math. The library provides the following functions:\
\
       math.abs     math.acos    math.asin    math.atan    math.atan2\
       math.ceil    math.cos     math.cosh    math.deg     math.exp\
       math.floor   math.fmod    math.frexp   math.ldexp   math.log\
       math.log10   math.max     math.min     math.modf    math.pow\
       math.rad     math.random  math.randomseed           math.sin\
       math.sinh    math.sqrt    math.tan     math.tanh\
\
plus a variable math.pi and a variable math.huge, with the value HUGE_VAL.\
Most of these functions are only interfaces to the corresponding functions in\
the C library. All trigonometric functions work in radians. The functions\
math.deg and math.rad convert between radians and degrees.\
\
The function math.max returns the maximum value of its numeric arguments.\
Similarly, math.min computes the minimum. Both can be used with 1, 2, or\
more arguments.\
\
The function math.modf corresponds to the modf C function. It returns two\
values: The integral part and the fractional part of its argument. The\
function math.frexp also returns 2 values: The normalized fraction and the\
exponent of its argument.\
\
The functions math.random and math.randomseed are interfaces to the simple\
random generator functions rand and srand that are provided by ANSI C.\
(No guarantees can be given for their statistical properties.) When called\
without arguments, math.random returns a pseudo-random real number in the\
range [0,1). When called with a number n, math.random returns a pseudo-random\
integer in the range [1,n]. When called with two arguments, l and u,\
math.random returns a pseudo-random integer in the range [l,u].\
The math.randomseed function sets a \"seed\" for the pseudo-random generator:\
Equal seeds produce equal sequences of numbers. ",childs={}}
matrix4x4 = {type='class',description="4x4 matrices are used for position and rotational transformations. They are saved column-major.",childs={["lookat"] = {type='function', description = " sets rotation axis, so that axis (0:x 1:y 2:z default is y) aims at given target pos from current matrix position.", args="(matrix4x4 a, float toX,toY,toZ, upX,upY,upZ, [int axis 0..2])", returns="()"},
["transform"] = {type='function', description = " transforms the three given coordinates", args="(matrix4x4 m,float x,y,z)", returns="(float x,y,z)"},
["viewmatrix"] = {type='function', description = " turns self into a viewmatrix usable for cameras", args="(matrix4x4)", returns="(matrix4x4)"},
["scale"] = {type='function', description = " sets/gets scale factors of matrix", args="(matrix4x4 m,[float x,y,z])", returns="([float x,y,z])"},
["tostring"] = {type='function', description = " returns matrix as string", args="(matrix4x4 vec)", returns="(string str)"},
["identity"] = {type='function', description = " sets diagonal of matrix to 1, rest to 0", args="(matrix4x4)", returns="(matrix4x4)"},
["component"] = {type='function', description = " returns or sets single matrix entry.", args="(matrix4x4,int index [0..15],[float])", returns="([float])"},
["copy"] = {type='function', description = " copys from other to itself", args="(matrix4x4 to,matrix4x4 from)", returns="(matrix4x4 to)"},
["compressed4x3"] = {type='function', description = " copies and compresses the storage and returns new, for shadercgparamhost:value useage.", args="(matrix4x4)", returns="(matrix4x4)"},
["compressed3x3"] = {type='function', description = " copies and compresses the storage and returns new, for shadercgparamhost:value useage.", args="(matrix4x4)", returns="(matrix4x4)"},
["new"] = {type='function', description = " constructs identity matrix or uses lua table or other matrix4x4 to fill values. If a table 		with 16 elements is passed, the values are interpreted as a matrix and will 		The OpenGL matrixstyle (column-major) is used so the x,y,z translation is found at element index 12,13,14 (or 13,14,15 as lua arrays start at 		index 1, while C arrays start at index 0)", args="([table float16]/[matrix4x4])", returns="(matrix4x4 m)"},
["rotdeg"] = {type='function', description = " returns or sets rotation in degrees", args="(matrix4x4 m,[float x,y,z])", returns="([float x,y,z])"},
["transformrotate"] = {type='function', description = " rotate the three given coordinates", args="(matrix4x4 m,float x,y,z)", returns="(float x,y,z)"},
["setaxisangle"] = {type='function', description = " sets rotation around angle", args="(matrix4x4 a, float axisX,axisY,axisZ ,rotation)", returns="()"},
["projmatrix"] = {type='function', description = " turns self into a projection matrix usable for cameras and projectors. negative fov means 'size' for orthographic projection. aspect is width/height.", args="(matrix4x4, nearplane, farplane, fov, aspect)", returns="(matrix4x4)"},
["rotrad"] = {type='function', description = " returns or sets rotation in radians", args="(matrix4x4 m,[float x,y,z])", returns="([float x,y,z])"},
["rotaxis"] = {type='function', description = " returns or sets rotation axis, make sure they make a orthogonal basis.", args="(matrix4x4 m,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])", returns="([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])"},
["rotquat"] = {type='function', description = " sets/gets rotation as quaternion", args="(matrix4x4 m,[float x,y,z,w])", returns="([float x,y,z,w])"},
["invert"] = {type='function', description = " inverts m, or m = invert of inv", args="(matrix4x4 m,[matrix4x4 inv])", returns="(matrix4x4 m)"},
["mul"] = {type='function', description = " multiplys: a = b*c or a = a*b. faster but sets W coordinate of each colum to 0, cept last to 1", args="(matrix4x4 a, b ,[c])", returns="(matrix4x4 a)"},
["affineinvert"] = {type='function', description = " inverts m, or m = invert of inv. Affine invert is faster and more robust than regular invert, but will only work on non-scaled orthogonal matrices.", args="(matrix4x4 m,[matrix4x4 inv])", returns="(matrix4x4 m)"},
["transpose"] = {type='function', description = " transposes m, or m = transpose of inv", args="(matrix4x4 m,[matrix4x4 inv])", returns="(matrix4x4 m)"},
["column"] = {type='function', description = " sets/gets column (0-3) vector.", args="(matrix4x4 m,int column,[float x,y,z,w])", returns="([float x,y,z,w])"},
["mulfull"] = {type='function', description = " multiplys: a = b*c or a = a*b. accurately takes all 16 values into account.", args="(matrix4x4 a, b ,[c])", returns="(matrix4x4 a)"},
["row"] = {type='function', description = " sets/gets row (0-3) vector.", args="(matrix4x4 m,int column,[float x,y,z,w])", returns="([float x,y,z,w])"},
["pos"] = {type='function', description = " sets/gets position of matrix", args="(matrix4x4 m,[float x,y,z])", returns="([float x,y,z])"}}}
coroutine = {type='class',description="The operations related to coroutines comprise a sub-library of the basic\
library and come inside the table coroutine. See 2.11 for a general description\
of coroutines.",childs={["resume"] = {type='function', description = "\
			Starts or continues the execution of coroutine co. The first time\
			you resume a coroutine, it starts running its body. The values val1,\
			..., valn are passed as the arguments to the body function. If the\
			coroutine has yielded, resume restarts it; the values val1, ...,\
			valn are passed as the results from the yield.\
\
			If the coroutine runs without any errors, resume returns true plus\
			any values passed to yield (if the coroutine yields) or any values\
			returned by the body function (if the coroutine terminates). If\
			there is any error, resume returns false plus the error message. ", args="(co [, val1, ..., valn])", returns="(?)"},
["yield"] = {type='function', description = "\
			Suspends the execution of the calling coroutine. The coroutine cannot\
			be running a C function, a metamethod, or an iterator. Any arguments\
			to yield are passed as extra results to resume. ", args="([val1, ..., valn])", returns="(?)"},
["status"] = {type='function', description = " Returns the status of coroutine co, as a string:\
			\"running\", if the coroutine is running (that is, it called status);\
			\"suspended\", if the coroutine is suspended in a call to yield, or\
			if it has not started running yet; \"normal\" if the coroutine is\
			active but not running (that is, it has resumed another coroutine);\
			and \"dead\" if the coroutine has finished its body function, or if\
			it has stopped with an error. ", args="(co)", returns="(?)"},
["wrap"] = {type='function', description = "\
			Creates a new coroutine, with body f. f must be a Lua function.\
			Returns a function that resumes the coroutine each time it is called.\
			Any arguments passed to the function behave as the extra arguments\
			to resume. Returns the same values returned by resume, except the\
			first boolean. In case of error, propagates the error. ", args="(f)", returns="(?)"},
["create"] = {type='function', description = "\
			Creates a new coroutine, with body f. f must be a Lua function.\
			Returns this new coroutine, an object with type \"thread\". ", args="(function f)", returns="(?)"},
["running"] = {type='function', description = " Returns the running coroutine, or nil when\
			called by the main thread. ", args="()", returns="(?)"}}}
djoint = {type='class',description="Joints are connecting bodies. They simulate contacts, varius hinges and slider joints. For example if a chair stands on the floor, each of his foots are connected with a djointcontact to the floor or if a car steers with the wheels, ODE uses a jointhinge2 to simulate this. Ragdoll physics is also a typical example.",childs={["cfm2"] = {type='function', description = " same as cfm but for the 2nd axis (if exists)", args="(djoint,[float])", returns="([float])"},
["stoperp3"] = {type='function', description = " same as stoperp", args="(djoint,[float])", returns="([float])"},
["geom1"] = {type='function', description = " returns geom1 of the joint it has collided with", args="(djoint)", returns="([dgeom])"},
["fmax3"] = {type='function', description = " same as fmax but for axis 3", args="(djoint,[float])", returns="([float])"},
["fmax2"] = {type='function', description = " same as fmax but for axis 2", args="(djoint,[float])", returns="([float])"},
["lostop2"] = {type='function', description = " same as lostop but for the 2nd axis (if exists)", args="(djoint,[float])", returns="([float])"},
["fudgefactor3"] = {type='function', description = " same as fudgefactor but for axis 3", args="(djoint,[float])", returns="([float])"},
["lostop"] = {type='function', description = " Low stop angle or position. Setting this to -dInfinity (the default value) turns off the low stop. For rotational joints, this stop must be greater than - pi to be effective.", args="(djoint,[float])", returns="([float])"},
["velocity2"] = {type='function', description = " Desired motor velocity axis 2", args="(djoint,[float])", returns="([float])"},
["feedback"] = {type='function', description = " returns force and torque applied to the connected bodies of the joint. Since some joints must not be connected to two bodies, either the force and torque of body1 or body2 may not be valid. ", args="(djoint)", returns="([float xf1,yf1,zf1, xt1,yt1,zt1, xf2,yf2,zf2, xt2,yt2,zt2)"},
["histop"] = {type='function', description = " High stop angle or position. Setting this to dInfinity (the default value) turns off the high stop. For rotational joints, this stop must be less than pi to be effective. If the high stop is less than the low stop then both stops will be ineffective.", args="(djoint,[float])", returns="([float])"},
["stopcfm2"] = {type='function', description = " same as stopcfm", args="(djoint,[float])", returns="([float])"},
["stopcfm"] = {type='function', description = " The constraint force mixing (CFM) value used by the stops. Together with the ERP value this can be used to get spongy or soft stops. Note that this is intended for unpowered joints, it does not really work as expected when a powered joint reaches its limit.", args="(djoint,[float])", returns="([float])"},
["velocity3"] = {type='function', description = " Desired motor velocity axis 3", args="(djoint,[float])", returns="([float])"},
["fudgefactor2"] = {type='function', description = " same as fudgefactor but for axis 2", args="(djoint,[float])", returns="([float])"},
["histop2"] = {type='function', description = " same as histop but for the 2nd axis (if exists)", args="(djoint,[float])", returns="([float])"},
["velocity"] = {type='function', description = " Desired motor velocity axis 1(this will be an angular or linear velocity).", args="(djoint,[float])", returns="([float])"},
["bounce"] = {type='function', description = " The bouncyness of the stops. This is a restitution parameter in the range 0..1. 0 means the stops are not bouncy at all, 1 means maximum bouncyness.", args="(djoint,[float])", returns="([float])"},
["fmax"] = {type='function', description = " The maximum force or torque that the motor will use to achieve the desired velocity. This must always be greater than or equal to zero. Setting this to zero (the default value) turns off the motor.", args="(djoint,[float])", returns="([float])"},
["cfm3"] = {type='function', description = " same as cfm but for the 3rd axis (if exists)", args="(djoint,[float])", returns="([float])"},
["body1"] = {type='function', description = " returns body1 of the joint or nil if not connected", args="(djoint)", returns="([dbody])"},
["bounce3"] = {type='function', description = " same as bounce but for the 3rd axis (if exits)", args="(djoint,[float])", returns="([float])"},
["body2"] = {type='function', description = " returns body2 of the joint or nil if not connected", args="(djoint)", returns="([dbody])"},
["attach"] = {type='function', description = " connects the joint to one or two bodies. Some joints may need two bodies while other joints will merely accept anything. If nothing is passed, the joint is removed from the bodies it was attached to.", args="(djoint,[dbody],[dbody])", returns="()"},
["geom2"] = {type='function', description = " returns geom2 of the joint it has collided with", args="(djoint)", returns="([dgeom])"},
["stopcfm3"] = {type='function', description = " same as stopcfm", args="(djoint,[float])", returns="([float])"},
["stoperp2"] = {type='function', description = " same as stoperp", args="(djoint,[float])", returns="([float])"},
["histop3"] = {type='function', description = " same as histop but for the 3rd axis (if exists)", args="(djoint,[float])", returns="([float])"},
["cfm"] = {type='function', description = " The constraint force mixing (CFM) value used when not at a stop.", args="(djoint,[float])", returns="([float])"},
["bounce2"] = {type='function', description = " same as bounce but for the 2nd axis (if exits)", args="(djoint,[float])", returns="([float])"},
["delete"] = {type='function', description = " deletes the joint, making it invalid.", args="(djoint)", returns="()"},
["lostop3"] = {type='function', description = " same as lostop but for the 3rd axis (if exists)", args="(djoint,[float])", returns="([float])"},
["fudgefactor"] = {type='function', description = " The current joint stop/motor implementation has a small problem: when the joint is at one stop and the motor is set to move it away from the stop, too much force may be applied for one time step, causing a 'jumping' motion. This fudge factor is used to scale this excess force. It should have a value between zero and one (the default value). If the jumping motion is too visible in a joint, the value can be reduced. Making this value too small can prevent the motor from being able to move the joint away from a stop.", args="(djoint,[float])", returns="([float])"},
["stoperp"] = {type='function', description = " The error reduction parameter (ERP) used by the stops.", args="(djoint,[float])", returns="([float])"}}}
GarbageCollector = {type='class',description="The GarbageCollector is a wrapper for the collectgarbage function for simplification.",childs={["count"] = {type='function', description = " returns the total memory in use by Lua (in Kbytes).", args="()", returns="(double mem)"},
["stop"] = {type='function', description = " stops the garbage collector.", args="()", returns="()"},
["restart"] = {type='function', description = " restarts the garbage collector.", args="()", returns="()"},
["collect"] = {type='function', description = " performs a full garbage-collection cycle.", args="()", returns="()"},
["step"] = {type='function', description = " performs a garbage-collection step. The step \"size\" is\
			controlled by arg (larger values mean more steps) in a non-specified\
			way. If you want to control the step size you must tune experimentally\
			the value of arg. Returns true if the step finished a collection cycle.", args="(int n)", returns="(boolean)"},
["setStepMul"] = {type='function', description = " sets arg/100 as the\
			new value for the step multiplier of the collector.", args="(float mulstepsize)", returns="(float previous)"},
["setPause"] = {type='function', description = " sets arg/100 as the new value\
			for the pause of the collector", args="(float pause)", returns="(float previous)"}}}
l3dprojector = {type='class',description="a projector allows textures to be		projected on models, orthogonally and perspectively. There is a special texture type that can fix 		backprojection errors for perpective projection, but shouldnt be used on orthogonal, or if no errors with normal textures appear.",childs={["projmatrix"] = {type='function', description = " returns or sets projection matrix. Using frontplane,aspect and so on will override manually set matrices.", args="(l3dprojector,[matrix4x4])", returns="([matrix4x4])"},
["activate"] = {type='function', description = " adds projector to the active list with given id (0-31)", args="(l3dprojector,int id)", returns="()"},
["frontplane"] = {type='function', description = " returns or sets projection frontplane distance", args="(l3dprojector,[float])", returns="(float)"},
["attenuate"] = {type='function', description = " returns or sets attenuation, this is quite heavy effect but will perform a per pixel distance attenuation that causes the projector to fade out towards its backplane.", args="(l3dprojector,[boolean])", returns="(boolean)"},
["blend"] = {type='function', description = " returns or sets blendmode of projector", args="(l3dprojector,[blendmode])", returns="(blendmode)"},
["backplane"] = {type='function', description = " returns or sets projection backplane distance", args="(l3dprojector,[float])", returns="(float)"},
["deactivate"] = {type='function', description = " removes projector from active list", args="(l3dprojector)", returns="()"},
["fov"] = {type='function', description = " returns or sets projection fov, when negative it will be orthogonal projection with abs(fov) rectangular size", args="(l3dprojector,[float])", returns="(float)"},
["textureid"] = {type='function', description = " returns or sets projected texture", args="(l3dprojector,[texture])", returns="(texture)"},
["aspect"] = {type='function', description = " returns or sets projection aspect ratio = width/height", args="(l3dprojector,[float])", returns="(float)"},
["new"] = {type='function', description = " creates new projector", args="(string name,|l3dlayerid layer|)", returns="(l3dprojector)"}}}
renderbuffer = {type='class',description="The renderbuffer is for storing results of rendering processes for fbo attachments using rcmdfborb. It cannot be used as texture directly, but allows faster and more complex (multi-sampled) internal storage. Using rcmdbufferblit you can blit the result of a renderbuffer to a texture or backbuffer.",childs={["setup"] = {type='function', description = " returns self if the renderbuffer could be set to the given attributes. Windowsized means width and height are ignored and automatically set to window size, also when changing window resolution. Multisamples can be set to a value >0 if hardware capability for multisample renderbuffers exists.", args="(renderbuffer,textype,int width,height,[boolan windowsized],[int multisamples])", returns="([renderbuffer])"},
["new"] = {type='function', description = " returns a new renderbuffer. You must setup its attributes prior use or pass directly. When setting failed no rb is returend.", args="([textype,int width,height,[boolan windowsized],[int multisamples]])", returns="([renderbuffer])"}}}
OO = {type='class',description="The objectoriented class provides two functions which\
		allows a more objectoriented like design using lua functions.\
\
		It implements a simple inheritance model. An object is a table\
		with a metatable which includes all class information.\
\
		All functions from this class are available as global variables\
		with the same name.\
\
		!!Examples:\
\
		 class \"Foo\" -- a simple class\
		 print (Foo)\
		   -- output: [Class: Foo]\
		 fobj = new(Foo) -- creates a new object of type foo\
		 print(fobj) -- print out our class object\
		   -- output: [Object: Foo 3]\
\
		 -- overfloating printing function now\
		 function Foo:toString()\
		   return \"Foo object printout!\"\
		 end\
		 print(fobj) -- will print \"Foo object printout!\"\
\
		 -- creating a class that is derived from Foo\
		 class \"Test\" : extends \"Foo\"\
		 tobj = new(Test)\
		 print(tobj) -- will also print \"Foo object printout!\",\
		   -- because the toString function is derived from \"Foo\"\
\
		!!Constructors\
\
		The constructors have the same name as the class has.\
		The default constructor will delegate its call to the\
		parent's constructor, however not so if the constructor\
		is overloaded.\
\
		Calling the parent constructor is being done by calling\
		its classname like a method.\
\
		 class \"Foo\"\
		 function Foo:Foo (v1,v2)\
		   print(\"Foo constructor\",v1,v2)\
		 end\
\
		 class \"Bar\" : extends \"Foo\"\
		 new(Bar,1,2)  -- will delegate the constructor call to\
		   -- Foo:Foo, passing the arguments 1,2 as v1 and v2,\
		   -- resulting in a printout which looks like this:\
		   -- Foo constructor 1 2\
\
		Calling the constructors is done by calling the parent's\
		method. This can be problematic in some situations, but\
		these are not real world examples (i.e. if the object has a\
		variable with a name of a parent's class). Such situations\
		can also be avoided either by not using capital letters\
		for object variables while saving them for class names\
		(which is similiar to Java's naming convention).\
\
		 class \"Foo\"\
		 function Foo:Foo ()\
		   Foo:Object () -- call the constructor of Object\
		     -- as every object is derived from this class\
		 end\
\
		!!Compatibility\
\
		The function 'new', which acts as a constructor is\
		compatible with older code - if a table that is passed as class\
		has a field named 'new', it will accept it as argument\
		and will call this function with the passed table as first argument\
		and returns its return.\
\
		This allows us to use the 'new' constructor also for\
		GUI code:\
\
		 btn = new(Button,10,30,20,100,\"Button\")\
\
		!!Default parent class: Object\
\
		The default parent class is the Object class, a class\
		that implements some basic operations.\
\
		The classes are also derived from the Object type - extending\
		the Object class with additional functions (which is always possible)\
		will also result in changing the class objects.\
\
		!!Variables\
\
		Any variable (functions are variables) can be defined any time.\
		If a request on an object for a variable is made, it will return\
		its variable value or will look in the class (or parent class and so on)\
		if the variable is defined there. Accessing nil values is the worst case,\
		since the whole class tree is looked up. Avoid nil value access by setting\
		a variable value to false, if it is looked up more than once and turns out\
		to be a performance bottleneck.\
\
		Example:\
\
		 class \"Foo\"\
		 obj = new (Foo)\
\
		 print(obj.x) -- prints nothing or nil\
		 Foo.x = 10\
		 print(obj.x) -- prints 10\
		 obj.x = \"bar\"\
		 print(obj.bar) -- prints \"bar\"\
		 obj.x = nil\
		 print(obj.x) -- prints 10\
		 Foo.x = nil\
		 print(obj.x) -- prints nothing again\
\
		Variables in classes can be used as default values, as\
		any object that has no such variable defined will automaticly\
		return the value of the class' variable. Variables are\
		inherited to all its child classes, also to objects that\
		have been defined earlier.\
\
		!!Overloading\
\
		When a class is extended by another class, it can always redefine\
		a function, i.e.\
\
		 class \"Foo\"\
		 function Foo:dosomething () print \"do something foo\" end\
\
		 class \"Bar\" : extends \"Foo\"\
		 function Bar:dosomehting() print \"do something bar\" end\
\
		We can also overload or redefine functions when objects have already\
		been created. All objects will call automaticly the new function code.\
\
		However, objects can also overload functions or variables:\
\
		 class \"Foo\"\
		 function Foo:dosomething () print \"do something foo\" end\
\
		 o = new (Foo)\
		 function o:dosomething() print \"Object code\" end\
		 print(o:dosomething) -- prints out \"Object code\"\
\
		!!Spaces\
\
		Classes can be defined inside other tables:\
\
		 somewhere = {}\
		 class (\"Foo\",somewhere)\
		 obj = new (somewhere.Foo)\
\
		 class (\"Bar\",somewhere) : extends (somewhere.Foo)\
\
		The default space is _G, which is why every class is\
		automaticly available in the global table.\
		",childs={["class"] = {type='function', description = "\
				creates a clase in the given space (default _G) and\
				returns a table, which contains a function named\
				\"extends\", which accepts a class to be extended, i.e.\
\
				 class \"Foo\" : extends \"Object\"\
\
				per default, every class is derived from Object.\
			", args="(name,space = _G)", returns="(table)"},
["classparent"] = {type='function', description = " returns the parent\
				of the class or none if it is the Object class.\
			", args="(class)", returns="([class parent])"},
["new"] = {type='function', description = " creates an object and calls\
				class[classname](obj,...)\
			", args="(class,...)", returns="(object)"}}}
table = {type='class',description="This library provides generic functions for table manipulation. It provides\
all its functions inside the table table.\
\
Most functions in the table library assume that the table represents an array\
or a list. For these functions, when we talk about the \"length\" of a table we\
mean the result of the length operator. ",childs={["keyintersection"] = {type='function', description = " returns a table that is a copy of table1\
			without keys that are missing in the following tables.", args="(table1,table2,...)", returns="(table)"},
["insert"] = {type='function', description = "\
			Inserts element value at position pos in table, shifting up\
			other elements to open space, if necessary. The default value\
			for pos is n+1, where n is the length of the table,\
			so that a call table.insert(t,x) inserts x at the end of table t. ", args="(table, [pos,] value)", returns="(?)"},
["print"] = {type='function', description = " prints out all keys and their values - useful for debugging", args="(table)", returns="()"},
["count"] = {type='function', description = " returns total number of elements via complete traversion", args="(table)", returns="(int)"},
["maxn"] = {type='function', description = " Returns the largest positive numerical index of\
			the given table, or zero if the table has no positive numerical\
			indices. (To do its job this function does a linear traversal of\
			the whole table.) ", args="(table)", returns="(int n)"},
["remove"] = {type='function', description = "\
			Removes from table the element at position pos, shifting down other\
			elements to close the space, if necessary. Returns the value of the\
			removed element. The default value for pos is n, where n is the length\
			of the table, so that a call table.remove(t) removes the last\
			element of table t. ", args="(table [, pos])", returns="(value)"},
["concat"] = {type='function', description = "\
			Returns table[i]..sep..table[i+1] ... sep..table[j]. The default\
			value for sep is the empty string, the default for i is 1, and\
			the default for j is the length of the table. If i is greater than\
			j, returns the empty string.", args="(table [, sep [, i [, j] ] ])", returns="(string)"},
["reverse"] = {type='function', description = " reverses the indexes of the table (inplace).\
			Returns the same table that was passed.", args="(table)", returns="(table)"},
["copy"] = {type='function', description = " makes a simple copy of that table, without respect to refered\
			tables or values inside of that table", args="(table)", returns="(table)"},
["removen"] = {type='function', description = "\
			removes n elements from. If 'at' is given, the function removes all\
			values from that index on, decrementing the at index with each remove.\
			The order of the removed objects is \"normal\", which means that it is\
			not changed.", args="(table,int n[, int at)", returns="(value1, value2, ...)"},
["sort"] = {type='function', description = "\
			Sorts table elements in a given order, in-place, from table[1] to\
			table[n], where n is the length of the table. If comp is given,\
			then it must be a function that receives two table elements, and\
			returns true when the first is less than the second (so that not\
			comp(a[i+1],a[i]) will be true after the sort). If comp is not\
			given, then the standard Lua operator < is used instead.\
\
			The sort algorithm is not stable; that is, elements considered equal\
			by the given order may have their relative positions changed by the\
			sort.", args="(table [, comp])", returns="(?)"},
["merge"] = {type='function', description = " copies all passed tables in one table one after each other,\
			overwriting previous keys with new values.", args="(table1,table2,...)", returns="(table)"}}}
rcmdstencil = {type='class',description="Sets stenciltest environment.",childs={["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdstencil)"}}}
socket = {type='class',description="The socket namespace contains the core functionality of LuaSocket.\
",childs={["protect"] = {type='function', description = "\
Converts a function that throws exceptions into a safe function. This function \
only catches exceptions thrown by the try and newtry functions. It does not \
catch normal Lua errors.\
\
Func is a function that calls try (or assert, or error) to throw exceptions.\
\
Returns an equivalent function that instead of throwing exceptions, returns nil \
followed by an error message.\
\
Note: Beware that if your function performs some illegal operation that raises \
an error, the protected function will catch the error and return it as a string. \
This is because the try function uses errors as the mechanism to throw exceptions. ", args="(func)", returns="()"},
["source"] = {type='function', description = "\
Creates an LTN12 source from a stream socket object.\
\
Mode defines the behavior of the source. The following options are available:\
\
* \"http-chunked\": receives data from socket and removes the chunked transfer \
coding before returning the data;\
* \"by-length\": receives a fixed number of bytes from the socket. This mode \
requires the extra argument length;\
* \"until-closed\": receives data from a socket until the other side closes \
the connection. \
\
Socket is the stream socket object used to receive the data.\
\
The function returns a source with the appropriate behavior. ", args="(mode, socket [, length])", returns="(?)"},
["gettime"] = {type='function', description = "\
Returns the time in seconds, relative to the origin of the universe. \
You should subtract the values returned by this function to get meaningful values.\
\
 t = socket.gettime()\
 -- do stuff\
 print(socket.gettime() - t .. \" seconds elapsed\")", args="()", returns="(?)"},
["select"] = {type='function', description = " \
Waits for a number of sockets to change status.\
\
Recvt is an array with the sockets to test for characters available for reading. \
Sockets in the sendt array are watched to see if it is OK to immediately write \
on them. Timeout is the maximum amount of time (in seconds) to wait for a change \
in status. A nil, negative or omitted timeout value allows the function to block \
indefinitely. Recvt and sendt can also be empty tables or nil. Non-socket values \
(or values with non-numeric indices) in the arrays will be silently ignored.\
\
The function returns a table with the sockets ready for reading, a table with the \
sockets ready for writing and an error message. The error message is \"timeout\" \
if a timeout condition was met and nil otherwise. The returned tables are \
associative, to simplify the test if a specific socket has changed status.\
\
Important note: a known bug in WinSock causes select to fail on non-blocking \
TCP sockets. The function may return a socket as writable even though the socket \
is not ready for sending.\
\
Another important note: calling select with a server socket in the receive \
parameter before a call to accept does not guarantee accept will return \
immediately. Use the settimeout method or accept might block forever. ", args="(recvt, sendt [, timeout])", returns="(?)"},
["newtry"] = {type='function', description = "\
Creates and returns a clean try function that allows for cleanup before \
the exception is raised.\
\
Finalizer is a function that will be called before try throws the exception. \
It will be called in protected mode.\
\
The function returns your customized try function.\
\
Note: This idea saved a lot of work with the implementation of protocols in LuaSocket:\
\
 foo = socket.protect(function()\
    -- connect somewhere\
    local c = socket.try(socket.connect(\"somewhere\", 42))\
    -- create a try function that closes 'c' on error\
    local try = socket.newtry(function() c:close() end)\
    -- do everything reassured c will be closed \
    try(c:send(\"hello there?\\r\\n\"))\
    local answer = try(c:receive())\
    ...\
    try(c:send(\"good bye\\r\\n\"))\
    c:close()\
 end)\
", args="(finalizer)", returns="(?)"},
["_VERSION"] = {type='value', description = "string -\
This constant has a string describing the current LuaSocket version. "},
["connect"] = {type='function', description = " \
This function is a shortcut that creates and returns a TCP client object connected \
to a remote host at a given port. Optionally, the user can also specify the \
local address and port to bind (locaddr and locport). ", args="(address, port [, locaddr, locport])", returns="(?)"},
["sink"] = {type='function', description = "\
Creates an LTN12 sink from a stream socket object.\
\
Mode defines the behavior of the sink. The following options are available:\
\
* \"http-chunked\": sends data through socket after applying the chunked transfer \
coding, closing the socket when done;\
* \"close-when-done\": sends all received data through the socket, closing the \
socket when done;\
* \"keep-open\": sends all received data through the socket, leaving it open \
when done. \
\
Socket is the stream socket object used to send the data.\
\
The function returns a sink with the appropriate behavior. ", args="(mode, socket)", returns="(?)"},
["bind"] = {type='function', description = " \
This function is a shortcut that creates and returns a TCP server \
object bound to a local address and port, ready to accept client \
connections. Optionally, user can also specify the backlog argument to the \
listen method (defaults to 32).\
\
Note: The server object returned will have the option \"reuseaddr\" set to true.", args="(address, port [, backlog])", returns="(?)"},
["skip"] = {type='value', description = "(?):(d [, ret1, ret2 ... retN])\
Drops a number of arguments and returns the remaining.\
\
D is the number of arguments to drop. Ret1 to retN are the arguments.\
\
The function returns retd+1 to retN.\
\
Note: This function is useful to avoid creation of dummy variables:\
\
 -- get the status code and separator from SMTP server reply \
 local code, sep = socket.skip(2, string.find(line, \"^(%d%d%d)(.?)\"))"},
["sleep"] = {type='function', description = "\
Freezes the program execution during a given amount of time.\
\
Time is the number of seconds to sleep for. The function truncates time down to \
the nearest integer. ", args="(time)", returns="(?)"},
["_DEBUG"] = {type='value', description = "boolean - This constant is set to true if the library was \
compiled with debug support."},
["try"] = {type='function', description = "\
Throws an exception in case of error. The exception can only be caught by \
the protect function. It does not explode into an error message.\
\
Ret1 to retN can be arbitrary arguments, but are usually the return values \
of a function call nested with try.\
\
The function returns ret1 to retN if ret1 is not nil. Otherwise, it calls \
error passing ret2.\
\
 -- connects or throws an exception with the appropriate error message\
 c = socket.try(socket.connect(\"localhost\", 80))", args="(ret1 [, ret2 ... retN])", returns="(?)"}}}
texcombalpha = {type='class',description="The texcombiner for alpha values. Make sure that texcombop are only ALPHA values.",childs={["addsigned"] = {type='function', description = "  OUT = arg0 + arg1 - 0.5", args="(string name)", returns="([texcombalpha])"},
["interpolate"] = {type='function', description = "  OUT = arg0 * arg2 + arg1 * (1-arg2)", args="(string name)", returns="([texcombalpha])"},
["setarg"] = {type='function', description = "  sets argument of the function. Check the function descriptor for which arg index does what. Make sure operand is always alpha or invalpha.", args="(texcombalpha,int arg,texcombsrc,texcombop)", returns="()"},
["combine4signed"] = {type='function', description = "  OUT = arg0*arg1 + arg2*arg3 - 0.5  You should query for capability. Color mode must be combine4/modadd at the same time", args="(string name)", returns="([texcombalpha])"},
["modadd"] = {type='function', description = "  OUT = arg0 * arg2 + arg1. You should query for capability. When used color mode must be modadd/combine4 for cards with combine4 support as well.", args="(string name)", returns="([texcombalpha])"},
["subtract"] = {type='function', description = "  OUT = arg0 - arg1. You should query for capability. When used modadd/combine4 for color at the same time is not allowed for cards with combine4 support", args="(string name)", returns="([texcombalpha])"},
["combine4"] = {type='function', description = "  OUT = arg0*arg1 + arg2*arg3. You should query for capability. Color mode must be combine4/modadd at the same time", args="(string name)", returns="([texcombalpha])"},
["modaddsigned"] = {type='function', description = "  OUT = arg0 * arg2 + arg1 - 0.5. You should query for capability. When used color mode must be modadd/combine4 for cards with combine4 support as well.", args="(string name)", returns="([texcombalpha])"},
["test"] = {type='function', description = " tests the combiner (binds it). Returns GL Error string (might have other errors not bound to this problem)", args="(texcombalpha)", returns="([string])"},
["modulate"] = {type='function', description = "  OUT = arg0 * arg1", args="(string name)", returns="([texcombalpha])"},
["replace"] = {type='function', description = "  OUT = arg0", args="(string name)", returns="([texcombalpha])"},
["add"] = {type='function', description = "  OUT = arg0 + arg1", args="(string name)", returns="([texcombalpha])"}}}
baselib = {type='class',description="All functions in this \"class\" are global values that can be used directly.\
\
The basic library provides some core functions to Lua. If you do not include\
this library in your application, you should check carefully whether you need\
to provide implementations for some of its facilities.",childs={["xpcall"] = {type='function', description = "\
			This function is similar to pcall, except that you can set a\
			new error handler.\
\
			xpcall calls function f in protected mode, using err as the error\
			handler. Any error inside f is not propagated; instead, xpcall\
			catches the error, calls the err function with the original error\
			object, and returns a status code. Its first result is the status\
			code (a boolean), which is true if the call succeeds without errors.\
			In this case, xpcall also returns all results from the call, after\
			this first result. In case of any error, xpcall returns false plus\
			the result from err. ", args="(f, err)", returns="(?)"},
["tostring"] = {type='function', description = "\
			Receives an argument of any type and converts it to a string in a\
			reasonable format. For complete control of how numbers are converted,\
			use string.format.\
\
			If the metatable of e has a \"__tostring\" field, then tostring calls\
			the corresponding value with e as argument, and uses the result of\
			the call as its result. ", args="(e)", returns="(?)"},
["_VERSION"] = {type='value', description = " [string] - A global variable (not a function) that holds a\
			string containing the current interpreter version. The current\
			contents of this variable is \"Lua 5.1\"."},
["rawset"] = {type='function', description = "\
			Sets the real value of table[index] to value, without invoking any\
			metamethod. table must be a table, index any value different from\
			nil, and value any Lua value.", args="(table, index, value)", returns="(?)"},
["error"] = {type='function', description = "\
			Terminates the last protected function called and returns message as\
			the error message. Function error never returns.\
\
			Usually, error adds some information about the error position at the\
			beginning of the message. The level argument specifies how to get\
			the error position. With level 1 (the default), the error position\
			is where the error function was called. Level 2 points the error to\
			where the function that called error was called; and so on. Passing\
			a level 0 avoids the addition of error position information to the\
			message. ", args="(string message [, int level])", returns="()"},
["unpack"] = {type='function', description = "\
			Returns the elements from the given table. This function is equivalent to\
\
			 return list[i], list[i+1], ..., list[j]\
\
			except that the above code can be written only for a fixed number of\
			elements. By default, i is 1 and j is the length of the list, as\
			defined by the length operator.", args="(list [, i [, j] ])", returns="(?)"},
["load"] = {type='function', description = "\
			Loads a chunk using function func to get its pieces. Each call to\
			func must return a string that concatenates with previous results.\
			A return of nil (or no value) signals the end of the chunk.\
\
			If there are no errors, returns the compiled chunk as a function;\
			otherwise, returns nil plus the error message. The environment of the\
			returned function is the global environment.\
\
			chunkname is used as the chunk name for error messages and debug\
			information. ", args="(func [, string chunkname])", returns="()"},
["rawget"] = {type='function', description = "\
			Gets the real value of table[index], without invoking any metamethod.\
			table must be a table and index any value different from nil.", args="(table, index)", returns="(?)"},
["pcall"] = {type='function', description = "\
			Calls function f with the given arguments in protected mode. This\
			means that any error inside f is not propagated; instead, pcall\
			catches the error and returns a status code. Its first result is the\
			status code (a boolean), which is true if the call succeeds without\
			errors. In such case, pcall also returns all results from the call,\
			after this first result. In case of any error, pcall returns false\
			plus the error message.", args="(f, arg1, arg2, ...)", returns="(?)"},
["getfenv"] = {type='function', description = " Returns the current environment in use\
			by the function. f can be a Lua function or a number that specifies\
			the function at that stack level: Level 1 is the function calling\
			getfenv. If the given function is not a Lua function, or if f is 0,\
			getfenv returns the global environment. The default for f is 1.", args="(function f)", returns="([table])"},
["dofile"] = {type='function', description = "\
			Opens the named file and executes its contents as a Lua chunk. When\
			called without arguments, dofile executes the contents of the standard\
			input (stdin). Returns all values returned by the chunk. In case of\
			errors, dofile propagates the error to its caller (that is, dofile\
			does not run in protected mode).\
\
			The original lua dofile required relative pathes to the file location.\
			This is different in Luxinia: Luxinia looks for a file recursivly in all\
			pathes relative to each file that was called. ", args="(string file, [arg1, ...])", returns="([returnvalues,...])"},
["type"] = {type='function', description = "\
			Returns the type of its only argument, coded as a string. The possible\
			results of this function are \"nil\" (a string, not the value nil),\
			\"number\", \"string\", \"boolean, \"table\", \"function\", \"thread\", and\
			\"userdata\".", args="(v)", returns="(?)"},
["pairs"] = {type='function', description = " Returns three values: the next function, the table t,\
			and nil, so that the construction\
\
			 for k,v in pairs(t) do ... end\
\
			will iterate over all key--value pairs of table t.\
\
			See next for the caveats of modifying the table during its traversal.", args="(t)", returns="(?)"},
["next"] = {type='function', description = "\
			Allows a program to traverse all fields of a table. Its first\
			argument is a table and its second argument is an index in this\
			table. next returns the next index of the table and its associated\
			value. When called with nil as its second argument, next returns\
			an initial index and its associated value. When called with the\
			last index, or with nil in an empty table, next returns nil. If\
			the second argument is absent, then it is interpreted as nil.\
			In particular, you can use next(t) to check whether a table is empty.\
\
			Lua has no declaration of fields. There is no difference between a field\
			not present in a table or a field with value nil. Therefore,\
			next only considers fields with non-nil values. The order in which\
			the indices are enumerated is not specified, even for numeric\
			indices. (To traverse a table in numeric order, use a numerical\
			for or the ipairs function.)\
\
			The behavior of next is undefined if, during the traversal, you\
			assign any value to a non-existent field in the table. You may\
			however modify existing fields. In particular, you may clear\
			existing fields. ", args="(table [, index])", returns="(?)"},
["select"] = {type='function', description = "\
			If index is a number, returns all arguments after argument number\
			index. Otherwise, index must be the string \"#\", and select returns\
			the total number of extra arguments it received.", args="(index, ...)", returns="(?)"},
["assert"] = {type='function', description = " Issues an error when the\
		value of its argument v is false (i.e., nil or false); otherwise, returns\
		all its arguments. message is an error message; when absent, it defaults\
		to \"assertion failed!\"", args="(boolean condition, [string msg])", returns="(arg1,arg2,...)"},
["ipairs"] = {type='function', description = "\
			Returns three values: an iterator function, the table t, and 0,\
			so that the construction\
\
			 for i,v in ipairs(t) do ... end\
\
			will iterate over the pairs (1,t[1]), (2,t[2]), ..., up to the first\
			integer key with a nil value in the table.\
\
			See @@next@@ for the caveats of modifying the table during its traversal.", args="(table t)", returns="(function iterator, table t, 0)"},
["tonumber"] = {type='function', description = "\
			Tries to convert its argument to a number. If the argument is\
			already a number or a string convertible to a number, then tonumber\
			returns this number; otherwise, it returns nil.\
\
			An optional argument specifies the base to interpret the numeral.\
			The base may be any integer between 2 and 36, inclusive. In bases\
			above 10, the letter `AÂ´ (in either upper or lower case) represents\
			10, `BÂ´ represents 11, and so forth, with `ZÂ´ representing 35. In\
			base 10 (the default), the number may have a decimal part, as well\
			as an optional exponent part (see 2.1). In other bases, only unsigned\
			integers are accepted. ", args="(e [, base])", returns="(?)"},
["loadstring"] = {type='function', description = "\
			Similar to load, but gets the chunk from the given string.\
\
			To load and run a given string, use the idiom\
\
			 assert(loadstring(s))()\
			", args="(string [, chunkname])", returns="(function f)"},
["print"] = {type='function', description = "\
			Receives any number of arguments, and prints their values to stdout,\
			using the tostring function to convert them to strings. print is not\
			intended for formatted output, but only as a quick way to show a\
			value, typically for debugging. For formatted output, use\
			string.format.", args="(e1, e2, ...)", returns="(?)"},
["rawequal"] = {type='function', description = "\
			Checks whether v1 is equal to v2, without invoking any metamethod.\
			Returns a boolean.", args="(v1, v2)", returns="(?)"},
["setfenv"] = {type='function', description = "\
			Sets the environment to be used by the given function. f can be a\
			Lua function or a number that specifies the function at that stack\
			level: Level 1 is the function calling setfenv. setfenv returns the\
			given function.\
\
			As a special case, when f is 0 setfenv changes the environment of\
			the running thread. In this case, setfenv returns no values. ", args="(f, table)", returns="(?)"},
["collectgarbage"] = {type='function', description = "\
			This function is a generic interface to the garbage collector.\
			It performs different\
			functions according to its first argument, opt:\
			* \"stop\" --- stops the garbage collector.\
			* \"restart\" --- restarts the garbage collector.\
			* \"collect\" --- performs a full garbage-collection cycle.\
			* \"count\" --- returns the total memory in use by Lua (in Kbytes).\
			* \"step\" --- performs a garbage-collection step. The step \"size\" is\
			controlled by arg (larger values mean more steps) in a non-specified\
			way. If you want to control the step size you must tune experimentally\
			the value of arg. Returns true if the step finished a collection cycle.\
			* \"setpause\" --- sets arg/100 as the new value for the pause of the\
			collector.\
			* \"setstepmul\" --- sets arg/100 as the new value for the step multiplier\
			of the collector. ", args="(string opt [, arg])", returns="([table/value])"},
["_G"] = {type='value', description = "[table] - A global variable (not a function) that holds the global\
			environment (that is, _G._G = _G). Lua itself does not use this\
			variable; changing its value does not affect any environment, nor\
			vice-versa. (Use setfenv to change environments.)"},
["getmetatable"] = {type='function', description = " If object does not have a metatable,\
			returns nil. Otherwise, if the object's metatable has a \"__metatable\"\
			field, returns the associated value. Otherwise, returns the metatable\
			of the given object. ", args="(object)", returns="([table])"},
["loadfile"] = {type='function', description = "\
			Similar to load, but gets the chunk from file filename or from the\
			standard input, if no file name is given.", args="([string path])", returns="(function f)"}}}
texdatatype = {type='class',description="For creating textures this defines the internal storage precision. Some may require special capabilities",childs={["int32"] = {type='function', description = " int32. -/+2147483647, 32-bit precision, local same. requires integer texture capability.", args="()", returns="(texdatatype)"},
["int16"] = {type='function', description = " int16. -/+32767, 16-bit precision, local same. requires integer texture capability.", args="()", returns="(texdatatype)"},
["uint8"] = {type='function', description = " unsigned int8. 0-255, 8-bit precision, local same. requires integer texture capability.", args="()", returns="(texdatatype)"},
["uint16"] = {type='function', description = " unsigned int16. 0-65535, 16-bit precision, local same. requires integer texture capability.", args="()", returns="(texdatatype)"},
["float32"] = {type='function', description = " float32. arbitrary, 32-bit precision, local same.", args="()", returns="(texdatatype)"},
["fixed8"] = {type='function', description = " unsigned byte. normalized 0-1. 8-bit precision, local data storage as unsigned byte.", args="()", returns="(texdatatype)"},
["fixed16"] = {type='function', description = " unsigned byte. normalized 0-1. 16-bit precision, local data storage as unsigned short.", args="()", returns="(texdatatype)"},
["uint32"] = {type='function', description = " unsigned int32. 0-4294967296, 32-bit precision, local same. requires integer texture capability.", args="()", returns="(texdatatype)"},
["int8"] = {type='function', description = " int8. -/+127, 8-bit precision, local same. requires integer texture capability.", args="()", returns="(texdatatype)"},
["float16"] = {type='function', description = " float16. arbitrary, 16-bit precision, local data storage as float32.", args="()", returns="(texdatatype)"}}}
rcmdmipmaps = {type='class',description="Generates mipmaps for the specified texture",childs={["texture"] = {type='function', description = " returns or sets texture to generate mipmaps for.", args="(rcmdmipmaps,[texture])", returns="([texture])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdmipmaps)"}}}
shaderparamid = {type='class',description="A simple vector4 within shaders, that can control gpuprogram values",childs={}}
staticarray = {type='class',description="Staticarrays are created as plain C arrays within luxinia. They can be used for operations that require lot's of calculations or are used by other C functions.<br><br>'mounted' arrays do not have their own allocated data, but directly operate on their host data. Be aware that there is no mechanism to check whether host is still vaild, you will need to do this yourself.",childs={["clamp"] = {type='function', description = " self = (self with values clamped to min,max)", args="(staticarray self, value min, value max)", returns="()"},
["fromstring"] = {type='function', description = " copies the data from a binary string. Copies as much as possible.", args="(staticarray self, binstring, [int offset])", returns="()"},
["count"] = {type='function', description = " returns maximum number of elements", args="(staticarray)", returns="(int)"},
["mounted"] = {type='function', description = " returns whether array is mounted, i.e. points to external memory.", args="(staticarray)", returns="(boolean)"},
["mountscalararray"] = {type='function', description = " returns a mounted scalararray from current array.", args="(staticarray,[int vectorsize])", returns="(scalararray)"},
["index"] = {type='function', description = " assigns index the value if given or simply returns the value at the index. Returns error in case of invalid indices.", args="(staticarray,index,[float/int value])", returns="([value])"},
["resize"] = {type='function', description = " Changes size of array. If new size is greater old size, old content is preserved.", args="(staticarray self, int size)", returns="()"},
["datapointer"] = {type='function', description = " you can access the memory directly in other lua dlls. Be aware that you must make sure to not corrupt memory, make sure you are always smaller than the 'end' pointer.", args="(staticarray self)", returns="(pointer start, int end)"}}}
trailpoint = {type='class',description="A index to point of a l3dtrail",childs={}}
operationmode = {type='class',description="Some functions need this information on what to do if certain tests fail or pass",childs={["keep"] = {type='function', description = " keeps old value", args="()", returns="(operationmode)"},
["zero"] = {type='function', description = " sets value to zero", args="()", returns="(operationmode)"},
["replace"] = {type='function', description = " replaces old with new value", args="()", returns="(operationmode)"},
["increment"] = {type='function', description = " increments old by one", args="()", returns="(operationmode)"},
["invert"] = {type='function', description = " inverts old", args="()", returns="(operationmode)"},
["decrement"] = {type='function', description = " decrements old by one", args="()", returns="(operationmode)"}}}
Slider = {type='class',description="The slider is a handle than can be moved within some limits.\
\
	You can create and use a slider in this way:\
\
	 slider = Slider:new(100,20,100,20)\
	 function slider:onValueChanged (newvalue,oldvalue)\
	   print(newvalue,oldvalue)\
	 end\
	 Container.getRootContainer():add(slider)\
\
	The following skinssurface names are used by the slider class:\
	* Vertical slider skin surfaces\
	** sliderv\
	** sliderv_pressed\
	** sliderv_hovered\
	** sliderv_focused\
	* Horizontal slider skin surfaces\
	** sliderh\
	** sliderh_pressed\
	** sliderh_hovered\
	** sliderh_focused\
\
	",childs={["setIncrement"] = {type='value', description = "(),(Slider, float inc) - Sets sliderincrement of slider. You could\
	set the value directly by assigning a new value to the sliderincrement\
	value, but you shouldn't chose values <=0 or >1 and you should update\
	the sliderposition to its new value in case that the integermode is on\
	and the value is hereby changed.\
	"},
["mouseWheeled"] = {type='function', description = " This function sets the sliderposition if the\
	mousewheel was turned.", args="(Slider,MouseEvent)", returns="()"},
["sliderincrement"] = {type='value', description = "{[float]}=0.1 - increment of sliderposition. Can be set per\
			slider. The increment value is used if the mousewheel or the arrow keys have been used."},
["setIntegerMode"] = {type='value', description = "(),(Slider, boolean on) - switches IntegerMode on and of. In integermode,\
	the values that are set are being rounded to even multiplies of the\
	sliderincrement value."},
["onValueChanged"] = {type='function', description = " called if the slider position was changed.\
	The values are always between 0 and 1. You can overload this function without\
	calling the original overloaded function. This function is only called if\
	the previous value is distinct from the new value.", args="(Slider, float newvalue,prevvalue)", returns="()"},
["getSliderPos"] = {type='function', description = " get the position of the slider 0-1.", args="(Slider)", returns="(float pos)"},
["new"] = {type='function', description = "\
	Creates Slider with given bounds. If vertical is true the slider\
	is vertical aligned.", args="(class, int x,y,w,h, [boolean vertical, [Skin2D, [Icon] ] ])", returns="(Slider)"},
["onKeyTyped"] = {type='function', description = " Attached to Slider with a keylistener.\
	Will react on arrow up/down/left/right keypresses and moves the slider.", args="(Slider,KeyEvent)", returns="()"},
["setSliderTo"] = {type='function', description = " sets the slider position nearest to a pixelposition\
	given by x and y that are in local coordinates of the component.", args="(Slider,x,y)", returns="()"},
["setSliderPos"] = {type='function', description = " set the position of the slider, calls automaticly the\
	onValueChanged method. The value is automaticly clamped to a value\
	between 0 and 1. If noevent is true, no valuechanged event is sent", args="(Slider, pos, noevent,force)", returns="()"}}}
render = {type='class',description="Rendering statistics and other data. Mostly just debugging helpers.",childs={["drawtexturesize"] = {type='function', description = " sets or gets size of the special texture draw", args="([float])", returns="([float])"},
["drawfps"] = {type='function', description = " draws FPS on top right of the screen", args="([boolean])", returns="([boolean])"},
["drawshadowvolumes"] = {type='function', description = " draw drawshadowvolumes", args="([boolean])", returns="([boolean])"},
["drawvisspace"] = {type='function', description = " draws the octree of the visspace, 0 disables, 1 dynamic, 2 is static, 3 camera, 4 projector, 5 light", args="([int])", returns="([int])"},
["drawnormals"] = {type='function', description = " draws red normals (blue tangents + green binormals) of the triangles", args="([boolean])", returns="([boolean])"},
["drawstencilbuffer"] = {type='function', description = " draws stencilbuffer", args="([boolean])", returns="([boolean])"},
["drawaxis"] = {type='function', description = " draws axis of objects", args="([boolean])", returns="([boolean])"},
["drawprojectors"] = {type='function', description = " draw projectors", args="([boolean])", returns="([boolean])"},
["drawtexture"] = {type='function', description = " draws special texture test (useful for depth or cubemap texture), if no arg is passed then drawing is disabled.", args="([texture])", returns="()"},
["visfrom"] = {type='function', description = " min depth, if you draw a visspace, you can set the min (visfrom) and max (visto) depth of the octree that should be drawn", args="(int)", returns="(int)"},
["drawbonelimits"] = {type='function', description = " draws boneaxislimits", args="([boolean])", returns="([boolean])"},
["drawall"] = {type='function', description = " draws every node independent of vistest result", args="([boolean])", returns="([boolean])"},
["drawstats"] = {type='function', description = " draws various stats", args="([boolean])", returns="([boolean])"},
["visto"] = {type='function', description = " max depth (-1 will use octree's maxdepth), if you draw a visspace, you can set the min (visfrom) and max (visto) depth of the octree that should be drawn", args="(int)", returns="(int)"},
["drawnogui"] = {type='function', description = " disables l2dnodes and other gui items", args="([boolean])", returns="([boolean])"},
["drawbones"] = {type='function', description = " draws bones", args="([boolean])", returns="([boolean])"},
["drawcamaxis"] = {type='function', description = " draws axis orientation for cameras", args="([boolean])", returns="([boolean])"},
["drawbonenames"] = {type='function', description = " draws bonenames", args="([boolean])", returns="([boolean])"},
["drawlights"] = {type='function', description = " draws lightsource origins", args="([boolean])", returns="([boolean])"},
["statscolor"] = {type='function', description = " sets color of stats", args="(float r,g,b,a)", returns="(float r,g,b,a)"},
["drawwire"] = {type='function', description = " draws everthing in wiremesh", args="([boolean])", returns="([boolean])"},
["pauseparticles"] = {type='function', description = " if true then no new spawns, and no age updates", args="([boolean])", returns="([boolean])"},
["normallength"] = {type='function', description = " sets/gets length of drawn normals if normals are drawn.", args="([float])", returns="([float])"},
["noparticles"] = {type='function', description = " deactivates particles", args="([boolean])", returns="([boolean])"}}}
spatialnode = {type='class',description="Spatialnodes contain position/rotation information in the world, and can contain data used for visibility culling. There is two kinds of nodes dynamic actornodes and static scenenodes.		The purpose of scenenodes is to provide positional information in space without 		information about visual appearance or collision behavior. The matrices of the scenenode 		can be linked against l3dnodes in order to display objects on the screen.<br>		Each spatialnode has a name and can be found by using the name. Spatialnodes with the same name are 		grouped in a ring list that can be traversed.",childs={}}
matautocontrol = {type='class',description="Some matcontrolids or matobject properties allow auotmatic value generation, such as tracking node positions. You can use a matautocontrol to do so. It is GCed by Lua, and will survive as long as it is used or referenced by lua.",childs={["newvec4posproj"] = {type='function', description = " autocontroller that transfers position of target in screenspace as vector.", args="([spatialnode/l3dnode])", returns="(matautocontrol)"},
["newmatrot"] = {type='function', description = " autocontroller that creates matrix for rotation towards target from current node (so that 0,0,1 points to target).", args="([spatialnode/l3dnode])", returns="(matautocontrol)"},
["vector"] = {type='function', description = " returns or sets a custom vector that may be used by some controllers.", args="(matautocontrol,[float x,y,z,w])", returns="([float x,y,z,w])"},
["newvec4pos"] = {type='function', description = " autocontroller that transfers target position as vector.", args="([spatialnode/l3dnode])", returns="(matautocontrol)"},
["target"] = {type='function', description = " returns or sets target to be tracked. After the matautocontrol has been assigned and the target becomes invalid, the matautocontrol is destroyed as well.", args="(matautocontrol,[spatialnode/l3dnode])", returns="([spatialnode/l3dnode])"},
["newmatprojector"] = {type='function', description = " autocontroller that creates matrix for translation of target in screenspace.", args="([l3dprojector])", returns="(matautocontrol)"},
["newvec4dir"] = {type='function', description = " autocontroller that transfers direction from current to target as vector.", args="([spatialnode/l3dnode])", returns="(matautocontrol)"},
["newmatposproj"] = {type='function', description = " autocontroller that creates matrix for translation of target in screenspace. vector.x is scale factor", args="([spatialnode/l3dnode])", returns="(matautocontrol)"}}}
MouseEvent = {type='class',description="A mouseevent is produced whenever the mouse is moved, dragged, clicked or\
	hits an object. A MouseEvent cannot be modified once it was created.\
	\
	The x=0, y=0 coordinate is top-left, positive values go down / right. The event producing\
	source might set the coordinate's origin to a different location. For example, the events that \
	come from the GUI (i.e. Component) are in local component coordinates, where the topmost-leftmost \
	corner is 0,0. The mouseevents that are created by the MouseCursor mouselisteners are in window \
	coordinates.\
	",childs={["isClicked"] = {type='function', description = " true if the mouse was clicked", args="(MouseEvent)", returns="(boolean)"},
["py"] = {type='value', description = "{[int]} - previous position of the mouse when mouseevent was produced"},
["MOUSE_CLICKED"] = {type='value', description = "[int] - eventtype if a mousebutton was pressed and released without moving"},
["getDiff"] = {type='function', description = " returns difference between the two frames", args="(MouseEvent)", returns="(int x,y)"},
["MOUSE_ENTER"] = {type='value', description = "[int] - eventtype if the mouse entered the source"},
["MOUSE_DOUBLECLICK"] = {type='value', description = "[int] - eventtype if the mouse event was a doubleclick"},
["MOUSE_MOVED"] = {type='value', description = "[int] - eventtype if the mouse was moved"},
["doubleclicksensitivity"] = {type='value', description = "[float=.275] - Minimum time for doubleclick sensitivity"},
["move"] = {type='function', description = " returns new Mouseevent\
	with translated coordinates with given x,y", args="(MouseEvent self, int x,y)", returns="(MouseEvent)"},
["set"] = {type='function', description = " returns new Mouseevent\
	with new coordinates set to x and y, respecting the previous\
	position.", args="(MouseEvent self, int x,y,[wheel])", returns="(MouseEvent)"},
["eventtype"] = {type='value', description = "{[int]} - eventtype of the occured mouseevent"},
["y"] = {type='value', description = "{[int]} - position of the mouse when mouseevent was produced. Depending on the event producer, these can be local (component) coordinates."},
["x"] = {type='value', description = "{[int]} - position of the mouse when mouseevent was produced. Depending on the event producer, these can be local (component) coordinates. (0,0) is top left, (+,+) is bottom right. "},
["MOUSE_DRAGGED"] = {type='value', description = "[int] - eventtype if the mouse was moved while holding a button"},
["isWheeled"] = {type='function', description = " true if the wheel was moved", args="(MouseEvent)", returns="(boolean)"},
["wheel"] = {type='value', description = "{[int]} - wheel position of mouse"},
["px"] = {type='value', description = "{[int]} - previous position of the mouse when mouseevent was produced"},
["isDragged"] = {type='function', description = " true if the mouse was dragged", args="(MouseEvent)", returns="(boolean)"},
["isPressed"] = {type='function', description = " true if the mouse was pressed", args="(MouseEvent)", returns="(boolean)"},
["isReleased"] = {type='function', description = " true if the mouse was released", args="(MouseEvent)", returns="(boolean)"},
["src"] = {type='value', description = "{[int]} - source object that produced the mouseevent if available"},
["time"] = {type='value', description = "{[int]} - time in seconds when event occurred"},
["MOUSE_EXIT"] = {type='value', description = "[int] - eventtype if the mouse exited the source"},
["MOUSE_WHEEL"] = {type='value', description = "[int] - eventtype if the mouse wheel was moved"},
["new"] = {type='function', description = " creates a new mouseevent object", args="(int x,y,wheel,previousx,previousy,previouswheel,button,eventtype,any src,downsince,time)", returns="(MouseEvent)"},
["pwheel"] = {type='value', description = "{[int]} - previously wheel position of mouse"},
["isDoubleClick"] = {type='function', description = " true if the mouse was doubleclicked", args="(MouseEvent)", returns="(boolean)"},
["MOUSE_RELEASED"] = {type='value', description = "[int] - eventtype if the mouse was released"},
["downsince"] = {type='value', description = "{[int]} - since which frame the mouse button was hold down"},
["wheelmove"] = {type='value', description = "{[int]} - difference between current and previous wheelposition"},
["MOUSE_PRESSED"] = {type='value', description = "[int] - eventtype if a mousebutton is pressed down"},
["isMoved"] = {type='function', description = " true if the mouse was moved", args="(MouseEvent)", returns="(boolean)"},
["button"] = {type='value', description = "{[int]} - button that produced the mouseevent"},
["toString"] = {type='value', description = "{string}:(MouseEvent e) - returns a string representing the mouseevent.\
	This function is called if the MouseEvent is converted to a string, i.e.\
	when calling 'print(mymouseevent)'."}}}
KeyListener = {type='class',description="A Keylistener receives keyevent callbacks on KeyEvents that are\
	produced by a specific component.",childs={["1"] = {type='value', description = "{[function]} - function that is called"},
["3"] = {type='value', description = "{[boolean]} - if true, function is called on pressed"},
["2"] = {type='value', description = "{[boolean]} - if true, function is called on releases"},
["4"] = {type='value', description = "{[boolean]} - if true, function is called on types"},
["new"] = {type='function', description = " creates a keylistener that calls the callback\
		function if the Keyeventtype matches the given filter.\
\
		Callbackfunction signature:\
		 function listener (KeyListener, KeyEvent)\
	", args="(function callback, boolean onType,\
		onPress, onRelease)", returns="(KeyListener)"}}}
blendmode = {type='class',description="They define how texels or pixels are blend with the destination. Sometimes you might be able to use inverted blends, those just invert the self.alpha value",childs={["sub"] = {type='function', description = " out = self - destination.", args="()", returns="(blendmode)"},
["amodadd"] = {type='function', description = " out = destination + (self * self.alpha)", args="()", returns="(blendmode)"},
["max"] = {type='function', description = " out = max(destination,self).", args="()", returns="(blendmode)"},
["modulate"] = {type='function', description = " out = destination*self", args="()", returns="(blendmode)"},
["modulate2"] = {type='function', description = " out = destination*self*2. Allows self to brigthen (>0.5) or darken (<0.5) at the same time.", args="()", returns="(blendmode)"},
["min"] = {type='function', description = " out = min(destination,self).", args="()", returns="(blendmode)"},
["amodsubrev"] = {type='function', description = " out = destination - (self * self.alpha).", args="()", returns="(blendmode)"},
["replace"] = {type='function', description = " out = self", args="()", returns="(blendmode)"},
["decal"] = {type='function', description = " out = destination * (1-self.alpha) + self * (self.alpha)", args="()", returns="(blendmode)"},
["amodsub"] = {type='function', description = " out = (self * self.alpha) - destination.", args="()", returns="(blendmode)"},
["disable"] = {type='function', description = " removes setting the blendmode, warning if rfBlend is still true you will get undefined behavior", args="()", returns="(blendmode)"},
["subrev"] = {type='function', description = " out = destination - self.", args="()", returns="(blendmode)"},
["add"] = {type='function', description = " out = destination + self", args="()", returns="(blendmode)"}}}
LuxModule = {type='class',description="LuxModules are luascripts that are\
	part of the official Luxinia distribution. LuxModules are not related to\
	the module and package system of lua. LuxModules are creating lot's of\
	global functionnames, so watch out for problems for namespaces.\
\
	LuxModules are extending the luxinia API with addtitional scripts for\
	simplified use. In difference to the native API of Luxinia, modules are implemented\
	within the scripting of Luxinia. LuxModules extend Luxinia with functions and classes\
	that are simpler to use than the native API functions. This means that you can modify\
	the modules, but you should always keep in mind that Luxinia can and should be used\
	for different projects and maybe not only for your own projects. Changing the official\
	scripts may cause problems with other projects that are not written by you into. Even\
	worse, changes on the official scripts can will need you to update your modified scripts, too.<br>\
	However, you may write your own modules that fits into the modulestructure of Luxinia.\
	By doing so, you can extend Luxinia in a way that other can easily use, too. ",childs={["getclasses"] = {type='function', description = " Returns the classes as a table. This prevents overriding previously defined global variables as described in 'load'. I.e. if a LuxModule named 'foo' is loaded and it contains the classes 'a' and 'b', the returned table contains the two classes 'a' and 'b'.", args="(string modulename)", returns="(table classes)"},
["getLuxModuleDescription"] = {type='function', description = " return description of LuxModule", args="(string modulename)", returns="([string])"},
["register"] = {type='function', description = " Registers a modulename as LuxModule. The description should explain what the whole LuxModule is good for.", args="(string modulename, string description)", returns="()"},
["registerclassfunction"] = {type='function', description = " sets a functiondescription for a function of a class.", args="(string modulename,string classname,string functionname,string description)", returns="()"},
["getclassinfo"] = {type='function', description = " returns all known information on a class of a LuxModule", args="(string modulename, string classname)", returns="()"},
["load"] = {type='function', description = " Puts all the classes that belong to the LuxModule into the global variable space. I.e. if a LuxModule has a certain class that's name is 'foo', the class can be used from now on by simply using the name 'foo'. This can of course override your own tables or even classes of other modules. If this is a problem to you, you can use getclasses instead, which returns a table of classes.", args="(string modulename)", returns="()"},
["setLuxModuleDescription"] = {type='function', description = "\
			sets description of LuxModule", args="(string modulename, string/function description)", returns="()"},
["getclasshierarchy"] = {type='function', description = " returns a hierarchy in a datastructure that is compatible to the used format in the autodoc.lua file. ", args="(string modulename)", returns="(table hierarchy, table allclasses)"},
["getClassInfo"] = {type='function', description = " returns name and modulename of the given class or object if possible. If a string was passed, the name and the modulename is returned if it is a registered class. Additionally, the description of the class and the description of the functions is returned as a table where the keys are the functionnames and the values are the functiondescriptions.", args="(table obj/string name)", returns="([string name, modulename,description, table functionhelp, string parent, table interfaces])"},
["modulenames"] = {type='function', description = " returns names and number of known modules.", args="()", returns="(table modulenames, int count)"},
["registerclass"] = {type='function', description = "\
			registers a class that is part of a certain LuxModule with a certain\
			name. The help table should describe each function of the class with\
			the functionname as key and a descriptionstring that describes the\
			arguments and functiondetails.\
			You can optionally define the name\
			of the parentclass and the names of the interfaces. This has only a\
			hierachical purpose for the documentation.\
\
			If the description is a function, the function is called with the\
			modulename and classname as argument. It may return a string or a\
			table.\
\
			If the description is a table, it is concatenated to a string.\
			", args="(string modulename,string name,\
			string/function/table description,\
			table class,\
			table help, [string parent],[table interfaces], [boolean isthreadsafe],\
			[table threadsafefunctions])", returns="()"}}}
renderflag = {type='class',description="For most renderable nodes you can define under what state conditions they are rendered. l3dmodels also allow renderflag to be meshid specific, if no meshid is given, we apply it to all.",childs={["rfNodepthtest"] = {type='function', description = " returns or sets renderflag state. When disabled only pixels that have closer or equal distance than previous pixels will be drawn.", args="(renderflag,[boolean])", returns="([boolean])"},
["rfLitFX"] = {type='function', description = " returns or sets renderflag state, only really affects l3dmodels. closest 3 l3dlights in the same l3dset will be used. If not lit by sun, but lit by fx lights we will turn ambientterm to 1, so you can use baked lighting in vertexcolors.", args="(renderflag,[boolean])", returns="([boolean])"},
["rfProjectorpass"] = {type='function', description = " returns or sets renderflag state, forces surfaces affected by projectors into a new pass. Singlepass projector outcome sometimes might differ from multipass, especially when fog is envolved. If you need same treatment you can enforce it.", args="(renderflag,[boolean])", returns="([boolean])"},
["rfFrontcull"] = {type='function', description = " returns or sets renderflag state. Frontfaces are culled (default is off which means backfaces are culled), makes no difference when rfNocull is set", args="(renderflag,[boolean])", returns="([boolean])"},
["rfNodraw"] = {type='function', description = " returns or sets renderflag state. We will not draw the node", args="(renderflag,[boolean])", returns="([boolean])"},
["rfWireframe"] = {type='function', description = " returns or sets renderflag state, specify linewidth in rendersurface", args="(renderflag,[boolean])", returns="([boolean])"},
["rfBlend"] = {type='function', description = " returns or sets renderflag state. Blending will compute outpixel as result of previous pixel and new pixel in the framebuffer (see rendersurface).", args="(renderflag,[boolean])", returns="([boolean])"},
["rfFog"] = {type='function', description = " returns or sets renderflag state", args="(renderflag,[boolean])", returns="([boolean])"},
["rfAlphatest"] = {type='function', description = " returns or sets renderflag state. Alphatest performs a test on the pixel's alpha value. Depending on the user set comparemode and alpha threshold (see rendersurface) the pixel will be drawn or not.", args="(renderflag,[boolean])", returns="([boolean])"},
["rfLitSun"] = {type='function', description = " returns or sets renderflag state. Lit by sun", args="(renderflag,[boolean])", returns="([boolean])"},
["rfNormalize"] = {type='function', description = " returns or sets renderflag state, normalization fixes lighting problems if your models are scaled, but costs a bit more. Flag is autoset if renderscale is not 1", args="(renderflag,[boolean])", returns="([boolean])"},
["rfUnlit"] = {type='function', description = " returns or sets renderflag state. LitSun and LitFX will be ignored, this is mostly used in renderflags set by shaders.", args="(renderflag,[boolean])", returns="([boolean])"},
["rfNodepthmask"] = {type='function', description = " returns or sets renderflag state. Output pixels will not write into Z-Buffer", args="(renderflag,[boolean])", returns="([boolean])"},
["rfNocolormask"] = {type='function', description = " returns or sets renderflag state. Pixel wont write into framebuffer ", args="(renderflag,[boolean])", returns="([boolean])"},
["rfNovertexcolor"] = {type='function', description = " returns or sets renderflag state. Vertex colors arent used, instead a single color for all.", args="(renderflag,[boolean])", returns="([boolean])"},
["rfStenciltest"] = {type='function', description = " returns or sets renderflag state. Stenciltest provides a mechanism to draw or discard pixel based on stencil buffer value. Detailed operations can be set with stencilcommand interface", args="(renderflag,[boolean])", returns="([boolean])"},
["rfStencilmask"] = {type='function', description = " returns or sets renderflag state. If set pixel will write into stencil buffer", args="(renderflag,[boolean])", returns="([boolean])"},
["rfNocull"] = {type='function', description = " returns or sets renderflag state. We will draw backfacing triangles too", args="(renderflag,[boolean])", returns="([boolean])"},
["rfNolightmap"] = {type='function', description = " returns or sets renderflag state. Lightmap if active for this node will not be used. Useful for disabling lightmap on permesh basis.", args="(renderflag,[boolean])", returns="([boolean])"}}}
meshid = {type='class',description="Mesh within a model. Typically contains vertices and indices, as well as material information.",childs={["init"] = {type='function', description = " only works on empty meshes that are hosted in model.create generated model. Fill with content via indexarray and vertexarray interfaces (don't forget to set indexCount and vertexCount and at the end indexMinmax!).", args="(meshid,string name, int vertexcount, int indicescount, [texture/material name])", returns="()"},
["boneid"] = {type='function', description = " returns or sets boneid it is linked to. Only makes sense if model is animateable).", args="(meshid,[boneid])", returns="([boneid])"},
["skinid"] = {type='function', description = " returns or sets skinid it is linked to. Only makes sense if model is animateable).", args="(meshid,[skinid])", returns="([skinid])"},
["name"] = {type='function', description = " returns name of mesh", args="(meshid)", returns="([string])"},
["texname"] = {type='function', description = " returns original texturename (material / texture).", args="(meshid)", returns="([string])"},
["rendermesh"] = {type='function', description = " returns rendermesh (be aware that it is only valid as long as the model is kept alive. No error checking is done.", args="(meshid)", returns="(rendermesh)"},
["material"] = {type='function', description = " returns material of the mesh or nothing if there's no material", args="(meshid)", returns="([material])"},
["matsurface"] = {type='function', description = " returns matsurface", args="(meshid)", returns="([matsurface])"},
["texture"] = {type='function', description = " returns texture of the mesh or nothing if there's no texture", args="(meshid)", returns="([texture])"}}}
CameraEgoMCtrl = {type='class',description="Uses Mouse mostly. This controller modifies camera like a first person spectator. Rotation\
is done with leftmouse drag, while translation with rightmouse (forward/side) and\
right+left or middle (up/side).\
",childs={}}
vertexarray = {type='class',description="meshes, l3dmodels (morphable or compiled) or l2dimage usermeshes contain vertices you can modify.This interface allows access to it. For models this only has effect if they are not rendered via display list, nor vbo, else those need to be updated as well.",childs={["vertexNormalTris"] = {type='function', description = " returns interpolated normal for given triangle indices, using the barycentric coordinates.", args="(vertexarray, int a, int b, int c, float ba, float ca)", returns="([float x,y,z])"},
["vertexPosTris"] = {type='function', description = " returns interpolated position for given triangle indices, using the barycentric coordinates.", args="(vertexarray, int a, int b, int c, float ba, float ca)", returns="([float x,y,z])"},
["vertexUpdateVBO"] = {type='function', description = " if possible submits array using vertexAllocatedcount or [from,to] range to VBO, returns true on success else false (no VBO or non compatible vertexarray).", args="(vertexarray,[int fromidx, count])", returns="(boolean)"},
["vertexAllocState"] = {type='function', description = " can create or remove the local data copy of the vertices. Only allowed if mesh is a VBO usermesh.", args="(vertexarray,[boolean])", returns="([boolean])"},
["vertexNormalarray"] = {type='function', description = " returns or sets vertex position from given array (3 times the size of vertexAllocatedcount).", args="(vertexarray,[floatarray])", returns="([floatarray])"},
["vertexPosarray"] = {type='function', description = " returns or sets vertex position from given array (3 times the size of vertexAllocatedcount).", args="(vertexarray,[floatarray])", returns="([floatarray])"},
["vertexBBox"] = {type='function', description = " gets bounding box of vertices", args="(vertexarray)", returns="(float minx,miny,minz,maxx,maxy,maxz)"},
["vertexInverttexcoord"] = {type='function', description = " inverts y (or x) coordinates of texcoord channel for all vertices by doing 1.0f-coord. ", args="(vertexarray, boolean y,[int texchannel 0-3])", returns="()"},
["vertexTransform"] = {type='function', description = " transform all vertices with given matrix", args="(vertexarray, matrix4x4)", returns="()"},
["vertexColor"] = {type='function', description = " set or return color", args="(vertexarray, int index,[float r,g,b,a])", returns="([float r,g,b,a])"},
["vertexMeshtype"] = {type='function', description = " returns what type of mesh the indices/vertices are stored for display.", args="(vertexarray)", returns="([meshtype])"},
["vertexTexcoordtransform"] = {type='function', description = " transforms texcoords by given matrix ", args="(vertexarray, matrix4x4,[int texchannel 0-3])", returns="()"},
["vertexColorarray"] = {type='function', description = " returns or sets vertex colors from given array (4 times the size of vertexAllocatedcount).", args="(vertexarray,[floatarray])", returns="([floatarray])"},
["vertexCopy"] = {type='function', description = " copies vertices from other vertexarray, optionally with transfrom matrix.", args="(vertexarray, int start, vertexarray from,int fromstart, int size, [matrix4x4])", returns="()"},
["vertexFromVBO"] = {type='function', description = " if possible retrieves array using vertexAllocatedcount or [from,to] range from VBO, returns true on success else false (no VBO or non compatible vertexarray).", args="(vertexarray,[int fromidx, count])", returns="(boolean)"},
["vertexTexcoord"] = {type='function', description = " set or return texture coordinates for given channel. All vertices have 1 channel, without normals 2 and bigvertex 4. channel 0 is used for textures, channel 1 is used for lightmaps.", args="(vertexarray, int index,[float u,v],[int texchannel 0-3])", returns="([float u,v])"},
["vertexPos2texcoord"] = {type='function', description = " copy xy coordinates from positions to texcoord channel for all vertices, or project them on given plane normal. ", args="(vertexarray,[float planex,y,z], [int texchannel 0-3])", returns="()"},
["vertexVidbuffer"] = {type='function', description = " if stored as VBO returns vidbuffer and offset bytes.", args="(vertexarray)", returns="([vidbuffer,int vbooffset])"},
["vertexAllocatedcount"] = {type='function', description = " return vertex allocated count. This is the number of vertices that can be used in this vertexarray, index must always be smaller than this.", args="(vertexarray)", returns="([int cnt])"},
["vertexNormal"] = {type='function', description = " set or return normal, some vertexarrays do not have normals", args="(vertexarray, int index,[matrix4x4],[float x,y,z])", returns="([float x,y,z])"},
["vertexCount"] = {type='function', description = " set or return vertex count. This count is used for statistics and for optimizing, it can be smaller than allocated count and should be equal to the last vertex you use. Morphable l3dmodels will not allow setting it.", args="(vertexarray, [int cnt])", returns="([int cnt])"},
["newfromptrs"] = {type='function', description = " creates a vertexarray handle from the pointers. Make sure they stay valid as long as you use the handle.", args="(vertextype,pointer begin,end)", returns="(vertexarray)"},
["vertexPos"] = {type='function', description = " set or return position. Transformed with by matrix if given.", args="(vertexarray, int index,[matrix4x4],[float x,y,z])", returns="([float x,y,z])"},
["vertexType"] = {type='function', description = " returns the vertextype.", args="(vertexarray)", returns="(vertextype)"},
["vertexTexcoordTris"] = {type='function', description = " returns texture coordinates for given triangle indices, using the barycentric coordinates.", args="(vertexarray, int a, int b, int c, float ba, float ca,[int texchannel 0-3])", returns="([float u,v])"},
["vertexPtrs"] = {type='function', description = " returns C pointers for begin and end of array.", args="(vertexarray)", returns="(pointer start,end])"},
["vertexColorTris"] = {type='function', description = " returns interpolated color for given triangle indices, using the barycentric coordinates.", args="(vertexarray, int a, int b, int c, float ba, float ca)", returns="([float r,g,b,a])"}}}
Keyboard = {type='class',description="	The Keyboard class handles events from the input class of the luxinia\
	core classes. It provides a system for callbackmechanisms and other\
	utility functions.\
	",childs={["removeAllKeyBindings"] = {type='function', description = " removes all keybindings, and defaults APPEXIT key back to system.exit call", args="()", returns="()"},
["keycode.Q"] = {type='value', description = "[int] - q key keycode"},
["keycode.DEL"] = {type='value', description = "[int] - del key keycode"},
["keycode.F8"] = {type='value', description = "[int] - f8 key keycode"},
["keycode.N"] = {type='value', description = "[int] - n key keycode"},
["popKeys"] = {type='value', description = "boolean value - if set to false, no keys are popped (input.popkey) and thus, no keyevents are handled. This function can be used for handling manually popping keys."},
["keycode.W"] = {type='value', description = "[int] - w key keycode"},
["keycode.Y"] = {type='value', description = "[int] - y key keycode"},
["isKeyDown"] = {type='function', description = " this is the same function as input.iskeydown.\
	It is only included here for consistence. This method is insensitive to\
	modifier keys such as SHIFT or ALT. If you poll your keycodes for game actions\
	you should use this method.\
\
	The function accepts either the numerical keycode as used in the Keyboard.keycode\
	table or the nameentry in Keyboard.keycode (i.e. \"LSHIFT\").\
\
	This function also handles \"CTRL\" and \"SHIFT\" as special codes - since\
	the left and right shift / ctrl keys are different keys and must\
	be polled each - however, if you just pass these strings as arguments,\
	the function will return true if either the left or right key is\
	pressed.\
\
	Since 0.93a, this function is case insensitive.", args="(int/string code)", returns="(boolean isdown)"},
["keycode.B"] = {type='value', description = "[int] - b key keycode"},
["keycode.F4"] = {type='value', description = "[int] - f4 key keycode"},
["keycode.7"] = {type='value', description = "[int] - 7 key keycode"},
["keycode.BACKSPACE"] = {type='value', description = "[int] - backspace key keycode"},
["keycode"] = {type='value', description = "[table] - List of keycode constants"},
["keycode.L"] = {type='value', description = "[int] - l key keycode"},
["keycode.I"] = {type='value', description = "[int] - i key keycode"},
["keycode.HOME"] = {type='value', description = "[int] - home key keycode"},
["keycode.F11"] = {type='value', description = "[int] - f11 key keycode"},
["keycode.NUM5"] = {type='value', description = "[int] - num5 key keycode"},
["keycode.ALT"] = {type='value', description = "[int] - alt key keycode"},
["keycode.F"] = {type='value', description = "[int] - f key keycode"},
["keycode.ENTER"] = {type='value', description = "[int] - enter key keycode"},
["keycode.2"] = {type='value', description = "[int] - 2 key keycode"},
["keycode.G"] = {type='value', description = "[int] - g key keycode"},
["keycode.PAGEDOWN"] = {type='value', description = "[int] - pagedown key keycode"},
["keycode.LEFT"] = {type='value', description = "[int] - left key keycode"},
["keycode.NUM1"] = {type='value', description = "[int] - num1 key keycode"},
["keycode.1"] = {type='value', description = "[int] - 1 key keycode"},
["keycode.RCTRL"] = {type='value', description = "[int] - rctrl key keycode"},
["keycode.NUM7"] = {type='value', description = "[int] - num7 key keycode"},
["keycode.MINUS"] = {type='value', description = "[int] - minus key keycode"},
["keycode.NUM8"] = {type='value', description = "[int] - num8 key keycode"},
["keycode.PLUS"] = {type='value', description = "[int] - plus key keycode"},
["keycode.A"] = {type='value', description = "[int] - a key keycode"},
["keycode.F12"] = {type='value', description = "[int] - f12 key keycode"},
["keycode.5"] = {type='value', description = "[int] - 5 key keycode"},
["keycode.6"] = {type='value', description = "[int] - 6 key keycode"},
["keycode.E"] = {type='value', description = "[int] - e key keycode"},
["keycode.NUM0"] = {type='value', description = "[int] - num0 key keycode"},
["keycode.RSHIFT"] = {type='value', description = "[int] - rshift key keycode"},
["keycode.APPEXIT"] = {type='value', description = "[int] - appexit key keycode"},
["keycode.LCTRL"] = {type='value', description = "[int] - lctrl key keycode"},
["keycode.F10"] = {type='value', description = "[int] - f10 key keycode"},
["keycode.NUMDIV"] = {type='value', description = "[int] - numdiv key keycode"},
["keycode.U"] = {type='value', description = "[int] - u key keycode"},
["keycode.8"] = {type='value', description = "[int] - 8 key keycode"},
["keycode.M"] = {type='value', description = "[int] - m key keycode"},
["keycode.F2"] = {type='value', description = "[int] - f2 key keycode"},
["keycode.END"] = {type='value', description = "[int] - end key keycode"},
["keycode.R"] = {type='value', description = "[int] - r key keycode"},
["keycode.4"] = {type='value', description = "[int] - 4 key keycode"},
["keycode.F6"] = {type='value', description = "[int] - f6 key keycode"},
["keycode.DOWN"] = {type='value', description = "[int] - down key keycode"},
["keycode.X"] = {type='value', description = "[int] - x key keycode"},
["keycode.P"] = {type='value', description = "[int] - p key keycode"},
["keycode.TAB"] = {type='value', description = "[int] - tab key keycode"},
["keycode.NUMMUL"] = {type='value', description = "[int] - nummul key keycode"},
["keycode.J"] = {type='value', description = "[int] - j key keycode"},
["keycode.NUMPLUS"] = {type='value', description = "[int] - numplus key keycode"},
["keycode.F9"] = {type='value', description = "[int] - f9 key keycode"},
["keycode.NUMMINUS"] = {type='value', description = "[int] - numminus key keycode"},
["enableKeyBinds"] = {type='function', description = " Enables or disables the keybinding (if console.active()==true, the binding is disabled automaticly). This function is currently used by the GUI, which means that it may not be safe to disable the keybinds in combination with using the GUI.", args="(on)", returns="()"},
["keycode.ALTGR"] = {type='value', description = "[int] - altgr key keycode"},
["keycode.C"] = {type='value', description = "[int] - c key keycode"},
["keycode.UP"] = {type='value', description = "[int] - up key keycode"},
["getPressedKeys"] = {type='function', description = " returns two tables: One with all pressed keynames and\
		one with the keycode values. This only includes keys that are listed in the\
		keycode table of the Keyboard class. It is also a slow method since it polls\
		every keycode one by one.", args="()", returns="([table keys,codes])"},
["keycode.NUM9"] = {type='value', description = "[int] - num9 key keycode"},
["keycode.NUMENTER"] = {type='value', description = "[int] - numenter key keycode"},
["keycode.NUM3"] = {type='value', description = "[int] - num3 key keycode"},
["keycode.3"] = {type='value', description = "[int] - 3 key keycode"},
["keycode.V"] = {type='value', description = "[int] - v key keycode"},
["keycode.0"] = {type='value', description = "[int] - 0 key keycode"},
["keycode.NUM4"] = {type='value', description = "[int] - num4 key keycode"},
["keycode.:"] = {type='value', description = "[int] - : key keycode"},
["keycode.NUMCOMMA"] = {type='value', description = "[int] - numcomma key keycode"},
["keycode.NUM2"] = {type='value', description = "[int] - num2 key keycode"},
["removeKeyBinding"] = {type='function', description = " removes keybinding for this key", args="(int keycode/string keycode)", returns="()"},
["keycode.H"] = {type='value', description = "[int] - h key keycode"},
["keycode.ESC"] = {type='value', description = "[int] - esc key keycode"},
["keycode.LSHIFT"] = {type='value', description = "[int] - lshift key keycode"},
["keycode.O"] = {type='value', description = "[int] - o key keycode"},
["keycode.9"] = {type='value', description = "[int] - 9 key keycode"},
["keycode.SPACE"] = {type='value', description = "[int] - space key keycode"},
["keycode.S"] = {type='value', description = "[int] - s key keycode"},
["keycode.T"] = {type='value', description = "[int] - t key keycode"},
["keycode.F7"] = {type='value', description = "[int] - f7 key keycode"},
["keycode.NUM6"] = {type='value', description = "[int] - num6 key keycode"},
["keycode.INS"] = {type='value', description = "[int] - ins key keycode"},
["keycode.PAGEUP"] = {type='value', description = "[int] - pageup key keycode"},
["keycode.RIGHT"] = {type='value', description = "[int] - right key keycode"},
["keycode.Z"] = {type='value', description = "[int] - z key keycode"},
["keycode.K"] = {type='value', description = "[int] - k key keycode"},
["keycode.F5"] = {type='value', description = "[int] - f5 key keycode"},
["keycode.F3"] = {type='value', description = "[int] - f3 key keycode"},
["addKeyListener"] = {type='function', description = " adds the keylistener to the listener list", args="(KeyListener listener)", returns="()"},
["keycode.D"] = {type='value', description = "[int] - d key keycode"},
["keycode.F1"] = {type='value', description = "[int] - f1 key keycode"},
["removeKeyListener"] = {type='function', description = " removes keylistener from the listener list", args="(KeyListener listener)", returns="()"},
["setKeyBinding"] = {type='function', description = " adds keybinding for this\
	key and calls the given function every delay milliseconds while the key is\
	pressed. The keycode can be a string that describes the key same as the\
	keycode names (i.e. \"W\" or \"DEL\"). If only a keycode is provided, the\
	keybinding is removed.", args="(int/string keycode, [function, [int delay] ])", returns="()"},
["keyBindsEnabled"] = {type='function', description = " returns enabled state of the keybinding", args="()", returns="(on)"}}}
l3dcamera = {type='class',description="Cameras are used to render the frame.You can link them with actornodes or scenenodes. And activate them in specific l3dviews, or globally by making it the default camera. However there is always a default camera at startup.",childs={["visflagid"] = {type='function', description = " returns the id the camera was intialized with", args="(l3dcamera)", returns="(int)"},
["viewmatrix"] = {type='function', description = " returns viewmatrix, viewmatrixinv is worldmatrix of l3dnode.", args="(l3dcamera)", returns="([matrix4x4])"},
["reflectplane"] = {type='function', description = " returns or sets reflection plane (worldspace).", args="(l3dcamera,[float x,y,z,w])", returns="([float x,y,z,w])"},
["usereflection"] = {type='function', description = " returns or sets if camera is reflected on the reflectplane. Useful for reflection rendering", args="(l3dcamera,[boolean])", returns="([boolean])"},
["usemanualprojection"] = {type='function', description = " returns or sets if manual projection matrix is used. That means aspect/frontplane.. will not modify projection matrix (settable via projmatrix).", args="(l3dcamera,[boolean])", returns="([boolean])"},
["toworld"] = {type='function', description = " computes screen pixel position (reference coordinates or local to l3dview) to world coordinates.The camera returns the coordinates seen from 0,0,0. You will need to transform the coordinate with a matrix, if you link the camera against an actornode/scenenode. If l3dview is not passed, we will use window.refsize.", args="(l3dcamera,float x,y,z,[l3dview,[viewlocal]])", returns="(float x,y,z)"},
["useinfinitebackplane"] = {type='function', description = " returns or sets if this camera needs shadow projection and therefore infinite backplane should be used. (only works for perspective projection)", args="(l3dcamera,[boolean])", returns="([boolean])"},
["forceupdate"] = {type='function', description = " forces the camera matrix to be updated (synchronized with its linked interface). If leavedirty is true, then the node will be updated in the next drawcall, otherwise results of this operation might be cached.This is neccessary if you use the toscreen and toworld functions and changed the position of the camera.", args="(l3dcamera,[boolean leavedirty])", returns="()"},
["clipplane"] = {type='function', description = " returns or sets clipping plane (worldspace). To make clipping useful the camera must be on the negative side of the plane.", args="(l3dcamera,[float x,y,z,w])", returns="([float x,y,z,w])"},
["new"] = {type='function', description = " creates new camera. The id must be unique and a l3dnode must get an update to its visflag, if it should be visible to it.", args="(string name,[l3dlayerid], int id 1-31)", returns="([l3dcamera])"},
["projmatrix"] = {type='function', description = " returns or sets current projection matrix.", args="(l3dcamera,[matrix4x4])", returns="([matrix4x4])"},
["toview"] = {type='function', description = " computes position in modelview matrix. (w=1.0 default)", args="(l3dcamera,float x,y,z,[w])", returns="(float x,y,z,w)"},
["projmatrixinv"] = {type='function', description = " returns current inverse of projection matrix.", args="(l3dcamera)", returns="([matrix4x4])"},
["frontplane"] = {type='function', description = " returns or sets frontplane", args="(l3dcamera,[float])", returns="([float])"},
["aspect"] = {type='function', description = " returns or sets aspect ratio = width/height, if negative then current window aspect will be used.", args="(l3dcamera,[float])", returns="([float])"},
["useclipping"] = {type='function', description = " returns or sets if clipping plane should be used", args="(l3dcamera,[boolean])", returns="([boolean])"},
["toscreen"] = {type='function', description = " computes screen pixel position. Uses reference width/height or custom.", args="(l3dcamera,float x,y,z,[width,height])", returns="(float x,y,z)"},
["backplane"] = {type='function', description = " returns or sets backplane", args="(l3dcamera,[float])", returns="([float])"},
["getrect"] = {type='function', description = " computes viewable rectangle on the given plane.		axis is the plane normal 0 = X, 1 = Y, 2 = Z. Method returns 4 Vectors that lie on the plane, or nothing if plane		wasnt intersected by frustum limiting rays. hitpoint order is, top left, top right, right bottom, left bottom", args="(l3dcamera,int axis,float distance)", returns="(4 float x,y,z)"},
["cwfront"] = {type='function', description = " returns or sets if front faces are clockwise, default off. Is needed when reflection plane creates artefacts", args="(l3dcamera,[boolean])", returns="([boolean])"},
["default"] = {type='function', description = " returns or sets current global default camera", args="([l3dcamera])", returns="([l3dcamera])"},
["fov"] = {type='function', description = " returns or sets fov horizontal angle. Negative values are used for orthographic projection and their absolute value will become width of view.", args="(l3dcamera,[float])", returns="([float])"},
["viewprojmatrix"] = {type='function', description = " returns viewprojmatrix. Can be used to transform vectors into clipspace", args="(l3dcamera)", returns="([matrix4x4])"},
["remfobj"] = {type='function', description = " removes single frustumobject or all.", args="(l3dcamera, [frustumobject])", returns="(boolean success)"},
["addfobj"] = {type='function', description = " adds frustumobject to the camera, this automatically disables useage of the standard frustum for vistesting. ==prevents gc of frustumobject", args="(l3dcamera, frustumobject)", returns="(boolean success)"},
["nearpercentage"] = {type='function', description = " returns or sets percentage of what is considered near. range = backplane * nearpercentage. If a drawnode is closer than its drawn first. This helps making use of zbuffer better.", args="(l3dcamera,[float])", returns="([float])"}}}
rcmdr2vb = {type='class',description="Allows storage of processed vertices  into a vidbuffer. All vertices are captured in the order as they are drawn.",childs={["capture"] = {type='function', description = " sets or gets if the number of captured primitives shall be captured. (default is false).", args="(rcmdr2vb,[boolean])", returns="([boolean])"},
["buffer"] = {type='function', description = " returns or sets vidbuffer used for storage. size of 0 means rest is used.", args="(rcmdr2vb,[vidbuffer,[int offset],[size]])", returns="([vidbuffer,offset,size])"},
["attrib"] = {type='function', description = " sets which vertex attribute and how many components shall be read. Use the Cg semantic names (eg. 'TEXCOORD3'). Components can be 1-4 for POSITION,TEXCOORD and ATTR and 1 for rest. The index defines the ordered index how you want to store the output. index must be 0-15.", args="(rcmdr2vb,int index, string name, int components)", returns="()"},
["noraster"] = {type='function', description = " sets or gets whether rasterization is disabled. (default true, ie. nothing is drawn to framebuffer.)", args="(rcmdr2vb,[boolean])", returns="([boolean])"},
["numattrib"] = {type='function', description = " sets or gets how many attribs are read.", args="(rcmdr2vb,[int])", returns="([int])"},
["drawmesh"] = {type='function', description = " returns or sets the mesh to be drawn.", args="(rcmdr2vb,[rcmddrawmesh])", returns="([rcmddrawmesh])"},
["lastcaptured"] = {type='function', description = " returns number of captured vertices in last frame (if capture was active).", args="(rcmdr2vb)", returns="([int])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdr2vb)"}}}
Hashspace = {type='class',description="A hashspace stores data paired with positional information in order\
		to accelerate requests for data within a certain area. \
		\
		This hashspace is implemented in lua and is restricted to 2D spaces \
		and rectangular areas,\
		which means that only two coordinates can be used to store the data.\
		\
		The structure is - even though it is implemented in lua only - quite\
		fast. If you have complex environments but don't want to use ODE for \
		collision detection, you can use this class. It is very easy to use and\
		can manage thousands of objects cheaply. You can even remove items \
		from the space and reinsert them somewhere else while the costs for \
		doing that are cheap.\
		\
		!Example\
		\
		 space = Hashspace.new() -- create hashspace\
		 space:add(\"pawn1\",5,4,10,10) -- insert pawn at 5,4 with size 10,10\
		 space:add(\"pawn2\",15,6,10,10) -- insert pawn at 15,6 with size 10,10\
		 environment = Hashspace.new() -- create a hashspace for the environment\
		 for i=1,100 do\
		   -- insert now lots of small boxes scattered around randomly\
		   environment:add(\"obstacle \"..i,math.random()*100,math.random()*100,4,4)\
		 end\
		 space:test(environment, -- test the playerspace against the environment\
		   function (a,b) -- function is called if two items from each space intersects\
		     print(a,b) -- print out intersecting items\
		   end)\
		\
		!Output\
		The result from the test above (may differ from other results due to different\
		random number generation):\
		 obstacle 4   pawn2\
		 obstacle 6   pawn2\
		 obstacle 23  pawn1\
		 obstacle 29  pawn1\
		\
		 ",childs={["remove"] = {type='function', description = " removes a certain item from the hashspace. \
	This can be used if an object has moved over the time and the \
	rectangle has to be updated in the hashspace. If you have lots of objects\
	in a hashspace and only few are changing their position, you shouldn't rebuild\
	the space from scratch (which might be more efficient if lot's of data has changed)\
	but remove the item and reinsert it again. As this is still somewhat \
	expensive, you could also prefer to insert your items with a slightly larger\
	rectangle and make an exact collisiontest for the hitlists yourself and update\
	the rectangle only if the object has moved a larger distance. It improves \
	speed alot if you chose rectangles that are 10% larger if it helps to reduce\
	the number of removes and add calls per frame for about 1:10. ", args="(Hashspace, item)", returns="()"},
["test"] = {type='function', description = " \
	Tests two hashspaces against each other and call the callback function in\
	case of intersection with both intersecting items (function (a,b)). \
	Testing two hashspaces against each other is much more efficient than \
	doing all the requests by calling the get function. If you have more requests\
	to do, you should batch all requests in another hashspace and test it then\
	with the other space. However, if both structures must be built from scratch,\
	the get function will be a little bit faster. It only pays out if at least \
	one of both structures has been built before anyway.\
	\
	If two spaces are tested, all items will be only be tested once against \
	each other. However, if both spaces are the same space (for testing \
	intercollisions), you have to ignore selfintersection of an item which \
	will occur then.\
	", args="(Hashspace self, Hashspace otherspace, fncallback)", returns="()"},
["new"] = {type='function', description = " Creates a hashspace structure. The gridsize\
	determines the minimum size of the cells in the space - which cannot be \
	smaller than that. If your objects and coordinates are much smaller (i.e. 0.01),\
	you should pass another size which fits the average sizes in your case better.\
	The hashspace works well if the gridsize is somewhere between the minimum and\
	average size of all your objects in your environment.", args="([gridsize = 2])", returns="(Hashspace)"},
["get"] = {type='function', description = " \
	rectangular request \
	to the hashspace. It will return a list of all items that are intersecting\
	this area. If the appentable is passed, the items will be appended to that\
	list. This is useful if you have multiple spaces and test them each for \
	an area, creating a single list.\
	\
	 list = space:get(2,4,10,6) -- request area is at 2,4 with width/height=10,6\
	 for i,item in ipairs(list) do -- iterate all items\
	   print(item) -- print out intersecting items\
	 end\
	", args="(Hashspace,centerx,centery,width,height,[appendtable = {}])", returns="(table)"},
["add"] = {type='function', description = " \
	inserts item (which can be any type) into the hashspace at the given coordinates.\
	The given rectangle will be used if an intersection case is tested.\
	\
	Reinserting an element if it is already present in the space will throw an \
	error. Make sure it does not exist in that space before adding it!", args="(Hashspace, item, centerx,centery,width,height)", returns="()"}}}
ClassInfo = {type='class',description="There are two systems in luxinia that describe the classes and their\
information: The fpubclass class of the the c core and the LuxModule class\
that is written in lua. While the fpubclass takes care about all C classes,\
the LuxModule class handles all classes that are written in Lua or are\
imported via DLLs. The ClassInfo class trys to provide a minimalistic\
access on both systems for returning classnames or their functions and\
descriptions without distinguishing between the origin of the class.\
",childs={["getFunctionDescription"] = {type='function', description = " Returns the description\
		for the function of the given name of the given classname.", args="(string classname, functionname)", returns="(string name)"},
["getClassDescription"] = {type='function', description = " Returns the dedscription for\
		a class of the given name", args="(string classname)", returns="(string description)"},
["getClassName"] = {type='function', description = " returns the classname of the\
		given datavalue if possible or nil.", args="(table/userdata object)", returns="(string name)"},
["getFunctionList"] = {type='function', description = " Returns a table\
		where each key is a functionname and the value is the description for\
		the class. This includes also all functions of the interfaces or\
		parent classes of the class.", args="(string classname)", returns="(table functiondescriptions)"}}}
rendersystem = {type='class',description="Rendering system information and settings",childs={["cgprefercompiled"] = {type='function', description = " gets or sets if Cg should check for compiled programs first.", args="([boolean])", returns="([boolean])"},
["vendor"] = {type='function', description = " returns vendor of rendering system (ati,nvidia,intel,unknown)", args="()", returns="(string)"},
["hwbonesparams"] = {type='function', description = " gets or sets how many parameters you use additionally to matrices in your gpuskin programs", args="([int])", returns="([int])"},
["cguseoptimal"] = {type='function', description = " gets or sets if Cg should set optimal profile compiler arguments, using driver and GPU info. Be aware that there is no way to disable it, hence once the first Cg gpuprogram is loaded from that time on all will use compile flags for the local machine. When you want to precompile your shaders using generic profile options, ie like the offline Cg compiler, you should set this value to false before loading your shaders. The only machine dependent flag will be use of ATI_draw_buffers over ARB_draw_buffers.", args="([boolean])", returns="([boolean])"},
["batchmaxindices"] = {type='function', description = " l3dbatchbuffers will finish batch after indices are reached.", args="([int])", returns="([int])"},
["usebaseshaders"] = {type='function', description = " returns or sets if baseshaders should be used. Make sure they are specified before.", args="([boolean])", returns="([boolean])"},
["texcompression"] = {type='function', description = " gets or sets if texture compression should be used", args="([boolean])", returns="([boolean])"},
["poppedgl"] = {type='function', description = " returns true if GL resources are just popped, ie rendering is disabled.", args="()", returns="(boolean)"},
["force2tex"] = {type='function', description = " sets/gets if system should be forced to have only two textureunits, useful for debugging. Affects system only during startup.", args="([boolean])", returns="([boolean])"},
["checkstate"] = {type='function', description = " returns whether there are errors in the state tracker (prints to console).", args="()", returns="(boolean)"},
["usevbos"] = {type='function', description = " sets/gets if vertex buffer objects should be enabled. This generally turns them on/off (on will have no effect if your hardware cant do it), the other option is to disable them per model.load. By default it is on if system technique is higher than VID_ARB_V.", args="([boolean])", returns="([boolean])"},
["glinfo"] = {type='function', description = " returns information about OpenGL Driver", args="()", returns="(string renderer,string version, string vendor)"},
["cglowprofileglsl"] = {type='function', description = " sets if GLSL is used in the low Cg profiles. Setting will enforce GLSL useage for lowCgProfile (normally arbfp1/arbvp1) and highCgProfile, disabling will revert to original state. Be aware that setting should be done on startup, changing between modes so that shaders will be in mixed types, will result into errors. The commands main purpose is to test GLSL codepaths profiles.", args="([boolean])", returns="()"},
["glfinish"] = {type='function', description = " waits until all pending GL processes are finished.", args="()", returns="()"},
["cgdumpcompiled"] = {type='function', description = " gets or sets if all Cg programs will saved to their corresponding compiled filename, will overwrite files.", args="([boolean])", returns="([boolean])"},
["pushgl"] = {type='function', description = " pushes all GL resources back (ie restores active data). Should be done after a major GLContext change. This function is also only for use with custom window managers. It is automatically called when switching from windowed to fullscreen mode. While GL resources are pushed rendering will be ignored, and many OpenGL calls will result into errors.", args="()", returns="()"},
["noglextensions"] = {type='function', description = " sets/gets if 'nice-to-have' GLextensions are disabled. Affects system only during startup.", args="([boolean])", returns="([boolean])"},
["texanisolevel"] = {type='function', description = " sets value for anisotropic filtering. Must be <= maximum capable", args="([float])", returns="([float])"},
["nodefaultgpuprogs"] = {type='function', description = " sets/gets if defaultgpuprogs are disabled. Affects system only during startup.", args="([boolean])", returns="([boolean])"},
["glextensions"] = {type='function', description = " returns the GL extension string", args="()", returns="(string)"},
["cgdumpbroken"] = {type='function', description = " gets or sets if Cg programs, who failed to load and were compiled at runtime, should be saved. Their filename is like pre-compiled version just with a BROKEN added.", args="([boolean])", returns="([boolean])"},
["popgl"] = {type='function', description = " pops GL resources from useage (ie retrieves data). Should be done before a major GLContext change. Only relative if cusom window managers are used.", args="()", returns="()"},
["gldriverinfo"] = {type='function', description = " returns current driver info.", args="()", returns="(string vendor, renderer, version)"},
["cghighprofile"] = {type='function', description = " sets the Cg high profiles, used in higher techniques, also allows downgrade of max capable technique. Strings are profilenames of Cg, there is no error checking if profilename actually correspons to maximum tehniques. Be aware that setting should be done on startup, changing between modes so that shaders will be in mixed types, will result into errors. The commands main purpose is to test profile codepaths.", args="(string vertexprofile, fragmentprofile, [technique])", returns="()"},
["texanisotropic"] = {type='function', description = " gets or sets if texture anisotropic filtering should be used", args="([boolean])", returns="([boolean])"},
["baseshaders"] = {type='function', description = " returns or sets baseshaders. Any non-material mesh, ie just having a texture or just having a color, will use those shaders and pass its texture (if exists) as Texture:0 to the shader. All other materials will use the Shader:0 they come with.", args="([shader color_only, color_lightmap, 1tex, 1tex_lightmap])", returns="([shader color_only, color_lightmap, 1tex, 1tex_lightmap])"},
["purehwvertices"] = {type='function', description = " returns or sets if you can guarantee that all vertices (cept for debug helpers or font) are processed by your shaders which all use programmable pipeline. In that case we can ignore a few costly state changes that are only needed for fixed function pipeline.", args="([boolean])", returns="([boolean])"},
["cgcompilerargs"] = {type='function', description = " returns the cg compiler args. Args must be separated by ;", args="([string])", returns="([string])"},
["batchmeshmaxtris"] = {type='function', description = " l3dbatchbuffers will immediately render meshes with less triangles.", args="([int])", returns="([int])"},
["cgallowglslsm3up"] = {type='function', description = " gets or sets if Cg on startup should allow use of GLSL for non-nvidia cards, that can compile a test vertex- and fragment shader with SM3 features. From Cg 2.1 on this defaults to true.", args="([boolean])", returns="([boolean])"},
["forcefinish"] = {type='function', description = " if true then renderfunction will wait until all rendering is finished after swapbuffers. This results into smoother fps especially with vsynch enabled, but reduces the theoretical maximum thruough-put.", args="([boolean])", returns="([boolean])"},
["swapinterval"] = {type='function', description = " gets or sets swapbuffer interval behavior 0 = vsynch off, 1 on, 2 double buffered on ...", args="([int])", returns="([int])"},
["detail"] = {type='function', description = " gets or sets users detail setting 1 - 3, 3 = highest detail. 1 = half texture size, 16 bit. 2 = 16 bit texture, 3 = 32 bit textures.", args="([int])", returns="([int])"}}}
CameraCtrl = {type='class',description="The CameraCtrl virtual class is a helper class for camera manipulation in editors and alike.\
Various implementations exist. The attrib array is currently\
as follows (values used depending on implementation):\
* shiftmulti: float - speed multiplier when keys.fast is pressed\
* movemulti: float - movement multiplier\
* rotmulti: float - rotation multiplier\
* invert: bool - mouse inverted (up/down)\
* mousesense: float - multiplied on all mouse deltas\
* mousewheel: float - multiplied on all wheel deltas\
* fix: boolean - whether mouse position is fixed to action start (default true)\
* keys: table - each value can be a string/keycode or table of such.\
** forward\
** backward\
** left\
** right\
** up\
** down\
** fast\
",childs={["runThink"] = {type='function', description = "\
	The think performs the actual manipulation of the l3dcamera and its\
actornode and calls the registered listeners. It polls the keyboard and\
processes the batched mouse move events.", args="(CameraCtrl)", returns="()"},
["addListener"] = {type='function', description = "\
	registers a function to be called fn(l3dcamera,actornode) on changes", args="(CameraCtrl,fn)", returns="()"},
["new"] = {type='function', description = "\
	creates the controller.", args="(table class, l3dcamera, actornode, table attribs)", returns="(CameraCtrl)"},
["createML"] = {type='function', description = "\
	creates a mouselistener based on input. Pass the host component,\
to get drag for action behavior. Or pass no host and assign to the \
MouseCursor itself, and the mouse position will be fixed at\
center of screen and always firing (same when MouseCursor is disabled).", args="(CameraCtrl, [Component])", returns="(MouseListener)"},
["runListeners"] = {type='function', description = "\
	enforces call of all listeners.", args="(CameraCtrl,fn)", returns="()"},
["removeListener"] = {type='function', description = "\
	unregisters the function.", args="(CameraCtrl,fn)", returns="()"},
["reset"] = {type='function', description = "\
	Resets internal caches of mouse movement and alike.", args="(CameraCtrl)", returns="()"}}}
CyclicQueue = {type='class',description="The CyclicQueue is a utility class for storing cyclic fields. This is usefull for creating histories. The index operator ([]) can be used to index the queue. I.e. mylist[1] will always return the elment that was inserted last.",childs={["pop"] = {type='function', description = " pops a value from the queue. If no element is in the list, nothing is returned", args="(CyclicQueue)", returns="([value])"},
["top"] = {type='function', description = " returns the latest inserted element", args="(CyclicQueue)", returns="([value])"},
["push"] = {type='function', description = " pushes a value on the list.", args="(CyclicQueue,value)", returns="()"},
["overwrite"] = {type='value', description = "{[boolean]} - if false, an exception is thrown if the list is full"},
["size"] = {type='value', description = "{[int]} - size of the list"},
["start"] = {type='value', description = "{[int]} - position of current element"},
["history"] = {type='value', description = "{[table]} - the table containing the entries"},
["count"] = {type='value', description = "{[int]} - number of entries in list"},
["new"] = {type='function', description = " Creates a CyclicQueue object of given size. If overwrite is false (default), an error is thrown if the array is full.", args="(int size, [boolean overwrite])", returns="(CyclicQueue)"}}}
vidbuffer = {type='class',description="Allows allocation of memory mostly resident on graphics card, or managed by driver for fast data exchange. Several vidbuffertypes exist, OpenGL allows changing use of same buffer during a lifetime.",childs={["keeponloss"] = {type='function', description = " whether to keep a temporary local copy of the data in case of context loss, such as fullscreen toggle. Default is false.", args="(vidbuffer,[bool])", returns="([bool])"},
["submit"] = {type='function', description = " submits data from the given pointer.", args="(vidbuffer,int frombyte, sizebytes, pointer output)", returns="(int bytes)"},
["maprange"] = {type='function', description = " maps the buffer into application memory. Only the specified range is mapped if maprange capability exists, otherwise full is mapped and pointers offset to match range. The last arguments are only valid for maprange capability.Manual flush means that the data is not marked 'valid' after unmap, but requires calls to flush.Unsynchronized access means data can be accessed even if still modified by graphics.While mapped other content operations (retreve or submit) are not allowed.", args="(vidbuffer, vidmapping, int from, sizebytes, [bool manualflush], [bool unsync])", returns="(pointer start,end)"},
["map"] = {type='function', description = " maps the full buffer into application memory. While mapped other content operations (retreve or submit) are not allowed.", args="(vidbuffer, vidmapping)", returns="(pointer start,end)"},
["glid"] = {type='function', description = " returns the native graphics buffer identifier stored in a pointer. Cast the (void*) to (GLuint). If you pass a vidtype, the buffer is also bound, if you pass any none vidtype, the buffer is unbound from all possible types. As OpenGL uses reference counting itself, the buffer is kept alive, even if luxinia flags it for deletion. Useful for interoperability with CUDA/OpenCL.", args="(vidbuffer,[vidtype/other])", returns="(pointer)"},
["copy"] = {type='function', description = " copies data from one to another buffer (or same, if interval doesnt overlap). Buffers may not be mapped.", args="(vidbuffer,int dstoffset, vidbuffer src, int srcoffset, size)", returns="()"},
["mapped"] = {type='function', description = " is the buffer mapped, if yes returns pointers", args="(vidbuffer)", returns="([pointer start,end])"},
["localalloc"] = {type='function', description = " advances the internal allocation state. To aid storing multiple content in same buffer (speed benefit) as well as mapping safety, the returned offset can be used to identify the region of current allocation. The allocation can be aligned to a given size. For example storing multiple vertextypes in same buffer, works if they all allocation starts are aligned to the greatest vertexsize.If a pointer is passed, then its content is submitted as well.", args="(vidbuffer, int sizebytes, [int alignpad=4], [pointer data])", returns="(int offset)"},
["release"] = {type='function', description = " deletes the buffer (driver might delay resource release, if still in use).", args="(vidbuffer)", returns="(int bytes)"},
["retrieve"] = {type='function', description = " stores the data into the given pointer.", args="(vidbuffer,int frombyte, sizebytes, pointer output)", returns="()"},
["unmap"] = {type='function', description = " unmaps the buffer", args="(vidbuffer)", returns="()"},
["new"] = {type='function', description = " creates a new buffer with the given size. Optionally copies content from given pointer.", args="(vidtype,vidhint,int sizebytes,[pointer])", returns="(vidbuffer)"}}}
texcombop = {type='class',description="The texcombiner operand are the values that are used from the source.",childs={["color"] = {type='function', description = " RGB value", args="()", returns="(texcombop)"},
["invcolor"] = {type='function', description = " (1 - RGB) value. (Inverted colors)", args="()", returns="(texcombop)"},
["alpha"] = {type='function', description = " Alpha value", args="()", returns="(texcombop)"},
["invalpha"] = {type='function', description = " (1 - Alpha) value", args="()", returns="(texcombop)"}}}
TimerTask = {type='class',description="A TimerTask is a function that is executed at a certain point of time.\
		When you create a new task, you specify a time in the future at which\
		the function should be executed. This class also offers a very simple\
		system of scheduling for a little loadbalancing.\
\
		TimerTasks are useful when you want to execute certain actions over\
		a timer of at a point of time. For example, when an enemy is killed, you\
		can create a timertask function that will remove the enmey after some time -\
		or you can check then if a certain condition is set and react on that.\
\
		!Samples:\
\
		 TimerTask.new(function () print \"time over\" end, 1000)\
		  -- prints \"time over\" in about a second\
\
\
		 TimerTask.new(function () print \"next frame\" end)\
		  -- prints \"next frame\" in the next frame\
\
\
		 TimerTask.new(\
		 	function ()\
		 		print \"from now on 30 secs\"\
		 		coroutine.yield(15000)\
		 		print \"... 15 seconds\"\
		 		coroutine.yield(5000)\
		 		for i=10,1,-1 do\
		 			print (i)\
		 			coroutine.yield(1000)\
		 		end\
		 		print \"bang\"\
		 	end,1\
		 ) -- a countdown that starts in a millisecond\
\
\
		",childs={["isValid"] = {type='function', description = " returns true if the task is still scheduled in the future", args="()", returns="(boolean)"},
["deleteAll"] = {type='function', description = " deletes all Tasks that are scheduled.", args="()", returns="()"},
["reenable"] = {type='function', description = " reenable the task. This is senseless once the date lies in the\
		past.", args="()", returns="()"},
["pauseAll"] = {type='function', description = " Pauses the TimerTask scheduler. When scheduling is paused, no functions will be executed. If pause is is false, the scheduling is continued at the point when the system was paused.", args="(boolean pause)", returns="()"},
["tick"] = {type='function', description = " called from the timer each frame.", args="()", returns="()"},
["when"] = {type='function', description = " Returns absolute moment of time when the function is called.", args="()", returns="(int time)"},
["new"] = {type='function', description = " Creates a new Task and returns it if the\
		task is scheduled. The time is measured in milliseconds.\
\
		The function will be called when the current time is larger or same as\
		the time that was used for scheduling, which is as close as possible.\
		Be aware that a single frame may use 3-5 ms, so multiple tasks with\
		different schedule times may be called within the same frame!\
\
		If no time is passed, the function will be called on the beginning of\
		the next frame.\
\
		You can specify a variance in which the function should be called.\
		The function is then scheduled between time\
		and time+variance. You can specify a weight of that task and the\
		scheduling will try to place the task at a time where the totalweight\
		is at a minimum. The algorithm is pretty primitive and no rescheduling\
		is done here.\
\
		If absolute is true, the moment of time is absolute, otherwise it is\
		relative in the future.\
\
		A taskobject will become garbage once its scheduling time lies in the\
		past - it is like an entry in a \"calendar\" which becomes unimportant once\
		the date passed.\
\
		Once a task is scheduled, you cannot change the point of time when\
		it will be executed.\
\
		Note: The timertasks create coroutines that are then executed. You can\
		yield a function that is called as timertask at any time, which means that\
		the execution is continued later. If you pass no argument to the\
		yield call (see coroutine.yield), the execution at this point is continued\
		at the next frame. If you pass a number, the execution is continued\
		at this point of time in the future.\
		", args="(function f, [int time, [int variance, [int weight,\
		[boolean absolute] ] ] ])", returns="([TimerTask])"},
["getTaskTime"] = {type='function', description = " The TimerTask scheduling is using a own time (which can\
		be paused). The returned time is the number of milliseconds that have\
		passed since luxinia started minus the time when the scheduling was\
		started. If you pass an absolute time, you have to calculate the\
		time with this time.", args="()", returns="(int time)"},
["disable"] = {type='function', description = " disables a task. It won't be executed anymore.", args="()", returns="()"}}}
LuxiniaParam = {type='class',description="The LuxiniaParam class stores the original list of arguments with which \
luxinia was called. The string of the commandline execution, i.e.:\
\
 luxinia.exe -abc test 1 -f \"hello world\" --word 13\
\
will be converted in a array that is stored in a global variable named \"arg\", \
which will look like this:\
\
 arg[1] = \"luxinia.exe\"\
 arg[2] = \"-abc\"\
 arg[3] = \"test\"\
 arg[4] = \"1\"\
 arg[5] = \"-f\"\
 arg[6] = \"hello world\"\
 arg[7] = \"--word\"\
 arg[8] = \"13\"\
\
The LuxiniaParam class also provides a set of utility functions \
to simplify the processing of commandline options. The arguments with \
which luxinia was called are put into a table that can be accessed and \
modified. I.e. the example above will make create a table structure that \
looks like this:\
\
 env[\"a\"] = {\"test\",\"1\"}\
 env[\"b\"] = {\"test\",\"1\"}\
 env[\"c\"] = {\"test\",\"1\"}\
 env[\"f\"] = {\"hello world\"}\
 env[\"word\"] = {\"13\"}\
\
You can change values in this table with the given getters and setters.\
\
Additionally, the LuxiniaParam class can help to describe the commandline \
options. ",childs={["addTriggerDescription"] = {type='function', description = " Adds a trigger description to the\
	known descriptions. The known descriptions will be listed here. If your \
	trigger description is not listed here, please make sure that the \
	autodocc creation is done right after you have registered the trigger.\
	!!!!Known triggers:	\
	\
	* dbg<br>This parameter will enter in debug mode when the project is being loaded.\
* p<br>requires a path argument (i.e. -p c:\\project\\bla). Sets the\
projectpath to the given argument and trys to execute a \"main.lua\"\
file in the given path. The path may be relative or absolute.\
\"main.lua\" is not loaded if -v for the viewer is also set.\
\
* i<br>Like -p but for .lxi files\
\
* s<br>Like -p but allows filepaths inside project- or subdirectory of the project to be passed.\
The actual projectpath is searched by recursively stepping down the directory,\
searching for main.lua. Only absolute paths are allowed.\
\
* v<br>launches the viewer requires 1 filename (.mtl, .prt, .f3d, .mm) optionally a second (.ma). You can combine it with setting the projectpath and resources will be loaded from there.\
* w<br>x y - sets window position\
* h<br>prints out all known module trigger descriptions\
* d<br>Writes the documentation files.\
", args="(string trigger, string description)", returns="()"},
["setArg"] = {type='function', description = " sets a new table value for the \
	given triggername. Pass nil to delete the triggername value.\
	", args="(string name, table newvalue)", returns="([table])"},
["triggerDescriptionIterator"] = {type='function', description = " returns a iterator function that can be used \
	to list all known triggers to this moment. Use it like this:\
	\
	 for index, trigger, description in LuxiniaParam.iterator() do\
	   print(index,trigger,description)\
	 end\
	", args="()", returns="(function iterator)"},
["getOrigArgs"] = {type='function', description = " returns a copy of the original arguments which is stored in \
	a global named \"arg\". Since the LuxiniaParam module makes a copy of this \
	table during startup, you must not worry about overwriting the original\
	argument table suplied by the luxinia core.\
	", args="()", returns="(table)"},
["getArg"] = {type='function', description = " returns an argument table for the given \
	triggername.\
	", args="(string name)", returns="([table])"}}}
system = {type='class',description="system information and settings",childs={["exit"] = {type='function', description = " closes application, if nocleanup is true, this will perform no proper cleanup but leave to os.", args="([boolean nocleanup])", returns="()"},
["osinfo"] = {type='function', description = " returns information about OS", args="()", returns="(string)"},
["drivesizes"] = {type='function', description = " returns information on drive sizes or nil if not succesful", args="(string drive)", returns="([float freetocaller,totalbytes,freebytes])"},
["currenttime"] = {type='function', description = " returns time", args="()", returns="(float seconds)"},
["maxfps"] = {type='function', description = " gets or sets if fps of the app should be capped, 0 is uncapped, minimum will be 15.", args="([int])", returns="([int])"},
["queryfrontend"] = {type='function', description = " queries the frontend, in which luxinia is embedded", args="([string])", returns="(string)"},
["getmillis"] = {type='function', description = " returns time in milliseconds, time is taken from motherboard high precision timer. Useful for profiling", args="()", returns="(float millis)"},
["drivelist"] = {type='function', description = " returns available drives on windows", args="()", returns="(string drive, ...)"},
["processors"] = {type='function', description = " returns number of processors in system", args="()", returns="(int)"},
["vidinfo"] = {type='function', description = " prints info on renderer", args="()", returns="()"},
["screenshotquality"] = {type='function', description = " quality of jpg screenshots (0-100).", args="([int])", returns="([int])"},
["refcount"] = {type='function', description = " returns current number of references in the system. There's (currently) a 		limit of 65000 references. Although Luxinia is using the garbage collection system of Lua, it 		permanent data outside of Lua can be created which results in memory leaks if this is not managed.", args="()", returns="(int refcount)"},
["version"] = {type='function', description = " returns luxinia version, builddate and buildtime.", args="()", returns="(string version,string data,string time)"},
["screenshot"] = {type='function', description = " writes an jpg or tga image file in a file with the given name, depending on the suffix of the string (.jpg or .tga - case sensitive!). The scaling should be a number >=0 and <=3 and tells luxinia the scaling factor of the screenshot. 0 means full resolution, 3 means 1/8th of the resolution. The scaling is done with a simple and fast but lowquality pixelresize. The quality integer describes the quality of the jpg compression: lower means less quality but smaller filesize. Note: Smaller files can be flushed much faster to the HD, so if you want to do a little imagesequence, you may prefer a lower resolution mode with low quality.<br>You can also make a snapshot of a screenarea by defining x,y,w,h. Be aware those coordinates are in GL coords meaning 0,0 is bottom left.", args="(string filename,[int scaling],[int quality],[int x,y,w,h])", returns="()"},
["sleep"] = {type='function', description = " trys to sleep for given time. The sleeptime will be subtracted from the next thinktime difference", args="(int millis)", returns="()"},
["drivetype"] = {type='function', description = " returns type for given drive. A trailing backslash is required. Returns either 'unkown', 'removable', 'norootdir', 'fixed', 'cdrom', 'ramdisk' or 'remote' (network)", args="(string drive)", returns="(string type)"},
["time"] = {type='function', description = " returns internal luxinia time in milliseconds since start and precise difference since the last frame, plus average of last 8 frames", args="()", returns="(int milisecs, float frametimediff, float avgdiff)"},
["projectpath"] = {type='function', description = " gets or sets used projectpath.", args="([string])", returns="([string])"},
["buffermempoolsize"] = {type='function', description = " gets or sets maximum size in bytes of bufferpool used primarily in l3d rendering and various load buffers.		This is a scratch memory in which visible nodes, particles... are written into. It uses various		worst-case approximations, hence the maximum size it needs at runtime depends both on total l3dnodes		and per-frame situation. Don't change this unless you know what you are doing and have used luxinias's		profiling info (render.drawstats -> rpoolmax) and know the upper limits. Only try to lower the pool if		you either exceed limits or want to save every byte.<br>Large memory operations such as screenshot and texture saving may resize the buffer to prevent an allocation error, all other operations however will quit with error message written to log.", args="([int])", returns="([int])"},
["nosound"] = {type='function', description = " sets/gets if sound is disabled. Affects system only during startup.", args="([boolean])", returns="([boolean])"},
["autoscreenshot"] = {type='function', description = " makes a screenshot at end of every frame.", args="([boolean],[boolean tga])", returns="([boolean])"},
["macaddress"] = {type='function', description = " returns MAC adress of first network adapter.", args="()", returns="(string)"},
["processframe"] = {type='function', description = " allows manuall processing of frames. timediff is in milliseconds, if not passed or -1, we will compute from the last time this function was called. this will run all internal thinks except the lua think. You should never start this unless you want to do frame processing from this time on for the rest of the runtime. Ideally this function is part of a loop which you start right in your initialisation script. Using this kind of setup will not return the same results as the automatic think and maxfps will show no effect. For one the performance graphs will not measure the luathink correctly, as well as ode. Also the order of the thinkcycle is slightly different. Be aware that you must run swapbuffers yourself to see the result of rendering. A good order of your think would be: processframe,your changes, swapbuffers. This would be close to the internal order, just that swapbuffers is called differently, but still would allow some cpu/gpu parallelism. Internally the order of a think in automatic mode is in one frame: render, luathink, sound, actors/scenenodes,swapbuffers. <br>Compared to the manual mode of this function: sound,actors/scenenodes,render. However when setting drawfirst to true, sound/actor etc. stuff is handled after rendering.", args="([float timediff],[boolean drawfirst])", returns="()"},
["frame"] = {type='function', description = " returns current render frame", args="()", returns="(int frame)"},
["drivelabel"] = {type='function', description = " returns drivelabel or nil if not succesful", args="(string drive)", returns="([string name])"},
["swapbuffers"] = {type='function', description = " should only be used in manual frame processing. swaps backbuffer, which we normally render to, and front buffer, which is what you see.", args="()", returns="()"}}}
LuaConsole = {type='class',description="The console is a programming and debugging tool within the runtime environment of Luxinia. The LuaConsole provides interactive access on Luxinia.",childs={["lastinput"] = {type='value', description = "[AutoTable] - The last line of input the user made before started scrolling through the history."},
["lines"] = {type='value', description = "[CyclicQueue] - A cyclic array object obtained from the CyclicQueue class. Stores 1000 lines per default."},
["cursor"] = {type='value', description = "[int] - position of inputcursor, must be >0 and <= size of input + 1."},
["setConsolePlugin"] = {type='function', description = " Add a pluginfunction to the console. All.\
		Plugins are being executed at the end of a drawcycle which means that\
		additional characters can be set on the console, i.e. interactive help.", args="(function fn)", returns="(any key)"},
["inputHistory"] = {type='value', description = "[CyclicQueue] - cyclic array with defaultsize = 1000 of all user (successful) inputs he made."},
["inputModified"] = {type='value', description = "[boolean] - True if the input was changed by user, so the input must be stored in 'lastinput'"},
["runningApplication"] = {type='value', description = "[table] - currently running consoleapplication."},
["browseHistory"] = {type='value', description = "[int] - position where the user is in history"},
["applications"] = {type='value', description = "[table] - table of all consoleapplications."},
["activeplugins"] = {type='value', description = "[table] - table of all plugin functions."},
["input"] = {type='value', description = "[AutoTable] - A 'normal' table that is obtained from the AutoTable class. Represents userinput as array"},
["scrollLine"] = {type='value', description = "[int] - position in output display."}}}
io = {type='class',description="The I/O library provides two different styles for file manipulation. The first\
one uses implicit file descriptors; that is, there are operations to set a\
default input file and a default output file, and all input/output operations\
are over these default files. The second style uses explicit file descriptors.\
\
When using implicit file descriptors, all operations are supplied by table io.\
When using explicit file descriptors, the operation io.open returns a file\
descriptor and then all operations are supplied as methods of the file\
descriptor.\
\
The table io also provides three predefined file descriptors with their usual\
meanings from C: io.stdin, io.stdout, and io.stderr.\
\
Unless otherwise stated, all I/O functions return nil on failure (plus an error\
message as a second result) and some value different from nil on success.\
",childs={["file:write"] = {type='function', description = " Writes the value of each of its\
			arguments to the file. The arguments must be strings or numbers.\
			To write other values, use tostring or string.format before write.", args="(value1, ...)", returns="(?)"},
["lines"] = {type='function', description = "\
			Opens the given file name in read mode and returns an iterator\
			function that, each time it is called, returns a new line from\
			the file. Therefore, the construction\
\
			 for line in io.lines(filename) do ... end\
\
			will iterate over all lines of the file. When the iterator\
			function detects the end of file, it returns nil (to finish\
			the loop) and automatically closes the file.\
\
			The call io.lines() (without a file name) is equivalent to\
			io.input():lines(); that is, it iterates over the lines of\
			the default input file. In this case it does not close the\
			file when the loop ends. ", args="([filename])", returns="(?)"},
["close"] = {type='function', description = "\
			Equivalent to file:close(). Without a file, closes the default\
			output file. ", args="([file])", returns="(?)"},
["file:close"] = {type='function', description = " Closes file. Note that files are automatically closed\
			when their handles are garbage collected, but that takes an\
			unpredictable amount of time to happen. ", args="()", returns="(?)"},
["file:lines"] = {type='function', description = " Returns an iterator function that, each time it\
			is called, returns a new line from the file. Therefore,\
			the construction\
\
			 for line in file:lines() do ... end\
\
			will iterate over all lines of the file. (Unlike io.lines,\
			this function does not close the file when the loop ends.)", args="()", returns="(?)"},
["file:setvbuf"] = {type='function', description = "\
			Sets the buffering mode for an output file.\
			There are three available modes:\
\
			* \"no\" --- no buffering; the result of any output operation appears\
			immediately.\
			* \"full\" --- full buffering; output operation is performed only when\
			the buffer is full (or when you explicitly flush the file (see 5.7)).\
			* \"line\" --- line buffering; output is buffered until a newline is\
			output or there is any input from some special files (such as a\
			terminal device).\
\
			For the last two cases, sizes specifies the size of the buffer,\
			in bytes. The default is an appropriate size.", args="(mode [, size])", returns="(?)"},
["file:read"] = {type='function', description = "\
			Reads the file file, according to the given formats, which specify\
			what to read. For each format, the function returns a string\
			(or a number) with the characters read, or nil if it cannot\
			read data with the specified format. When called without formats, it\
			uses a default format that reads the entire next line (see below).\
\
			The available formats are\
\
			* \"*n\" reads a number; this is the only format that returns a\
			number instead of a string.\
			* \"*a\" reads the whole file, starting at the current position.\
			On end of file, it returns the empty string.\
			* \"*l\" reads the next line (skipping the end of line), returning\
			nil on end of file. This is the default format.\
			* number reads a string with up to this number of characters,\
			returning nil on end of file. If number is zero, it reads nothing\
			and returns an empty string, or nil on end of file. ", args="(format1, ...)", returns="(?)"},
["popen"] = {type='function', description = "\
			Starts program prog in a separated process and returns a file\
			handle that you can use to read data from this program\
			(if mode is \"r\", the default) or to write data to this program\
			(if mode is \"w\").\
\
			This function is system dependent and is not available on all platforms.", args="([prog [, mode] ])", returns="(?)"},
["write"] = {type='function', description = " Equivalent to io.output():write. ", args="(value1, ...)", returns="(?)"},
["flush"] = {type='function', description = " Equivalent to file:flush over the default output file. ", args="()", returns="(?)"},
["open"] = {type='function', description = "\
			This function opens a file, in the mode specified in the string mode.\
			It returns a new file handle, or, in case of errors, nil plus an\
			error message.\
\
			The mode string can be any of the following:\
\
			* \"r\" --- read mode (the default);\
			* \"w\" --- write mode;\
			* \"a\" --- append mode;\
			* \"r+\" --- update mode, all previous data is preserved;\
			* \"w+\" --- update mode, all previous data is erased;\
			* \"a+\" --- append update mode, previous data is preserved, writing is\
			only allowed at the end of file.\
\
			The mode string may also have a `bÂ´ at the end, which is needed in\
			some systems to open the file in binary mode. This string is exactly\
			what is used in the standard C function fopen.", args="(filename [, mode])", returns="(?)"},
["output"] = {type='function', description = " Similar to io.input, but operates\
			over the default output file.", args="([file])", returns="(?)"},
["read"] = {type='function', description = " Equivalent to io.input():read. ", args="(format1, ...)", returns="(?)"},
["file:seek"] = {type='function', description = "\
			Sets and gets the file position, measured from the beginning of\
			the file, to the position given by offset plus a base specified by\
			the string whence, as follows:\
\
			* \"set\" --- base is position 0 (beginning of the file);\
			* \"cur\" --- base is current position;\
			* \"end\" --- base is end of file;\
\
			In case of success, function seek returns the final file position,\
			measured in bytes from the beginning of the file. If this function\
			fails, it returns nil, plus a string describing the error.\
\
			The default value for whence is \"cur\", and for offset is 0. Therefore,\
			the call file:seek() returns the current file position, without\
			changing it; the call file:seek(\"set\") sets the position to the\
			beginning of the file (and returns 0); and the call file:seek(\"end\")\
			sets the position to the end of the file, and returns its size. ", args="([whence] [, offset])", returns="()"},
["input"] = {type='function', description = "\
			When called with a file name, it opens the named file (in text\
			mode), and sets its handle as the default input file. When\
			called with a file handle, it simply sets this file handle as the\
			default input file. When called without parameters, it returns\
			the current default input file.\
\
			In case of errors this function raises the error, instead of\
			returning an error code. ", args="([file])", returns="(?)"},
["type"] = {type='function', description = " Checks whether obj is a valid file handle.\
			Returns the string \"file\" if obj is an open file handle,\
			\"closed file\" if obj is a closed file handle, or nil if obj is\
			not a file handle.", args="()", returns="(obj)"},
["file:flush"] = {type='function', description = " Saves any written data to file. ", args="()", returns="(?)"},
["tmpfile"] = {type='function', description = " Returns a handle for a temporary file. This file is\
			opened in update mode and it is automatically removed when the\
			program ends. ", args="()", returns="(?)"}}}
l2dnode = {type='class',description="A node meant for 2d drawing",childs={["rotrad"] = {type='function', description = " returns or sets l2dnode's rotation in radians", args="(l2dnode,[float x,y,z])", returns="([float x,y,z])"},
["local2world"] = {type='function', description = " returns coordinates after transforms. l3dtargets will not be taken in account.", args="(l2dnode,float x,y,z)", returns="(float x,y,z)"},
["scissorparent"] = {type='function', description = " returns or sets if parent's scissor information is used as well. If own node has no scissor set we will use parents, else we cap own with parent's ", args="(l2dnode,[boolean])", returns="([boolean])"},
["scale"] = {type='function', description = " returns or sets l2dnode's scale", args="(l2dnode,[float x,y,z])", returns="([float x,y,z])"},
["scissor"] = {type='function', description = " returns or sets if scissoring should be used. If scissoring is enabled only pixels within scissor rectangle are drawn. Makes sure proper scissorsize and scissorstart are set.", args="(l2dnode,[boolean])", returns="([boolean])"},
["new"] = {type='function', description = " returns a new l2dnode, that can be used for hierarchy and organisation", args="(string name)", returns="(l2dnode)"},
["rotdeg"] = {type='function', description = " returns or sets l2dnode's rotation in degrees", args="(l2dnode,[float x,y,z])", returns="([float x,y,z])"},
["delete"] = {type='function', description = " deletes node.", args="(l2dnode)", returns="()"},
["sortid"] = {type='function', description = " returns or sets l2dnode's sortid (lower gets rendered first). Setting a value will result into the parent's children list being resorted.", args="(l2dnode,[int])", returns="([int])"},
["scissorstart"] = {type='function', description = " returns or sets scissor rectangle startpoint. ", args="(l2dnode,[float x,y])", returns="([float x,y])"},
["world2local"] = {type='function', description = " returns coordinates in localspace. l3dtargets will not be taken in account.", args="(l2dnode,float x,y,z)", returns="(float x,y,z)"},
["pos"] = {type='function', description = " returns or sets l2dnode's position", args="(l2dnode,[float x,y,z])", returns="([float x,y,z])"},
["scissorsize"] = {type='function', description = " returns or sets scissor rectangle size. ", args="(l2dnode,[float x,y])", returns="([float x,y])"},
["color"] = {type='function', description = " returns or sets l2dnode's color", args="(l2dnode,[float r,g,b,a])", returns="([float r,g,b,a])"},
["scissorlocal"] = {type='function', description = " returns or sets if own scissorstart is transformed with the node's matrix. The size is not transformed.", args="(l2dnode,[boolean])", returns="([boolean])"},
["rotcenter"] = {type='function', description = " returns or sets l2dnode's center of rotation", args="(l2dnode,[float x,y,z])", returns="([float x,y,z])"},
["swapinchildlist"] = {type='function', description = " swaps the children within the parent's childlist.", args="(l2dnode,l2dnode)", returns="()"},
["parent"] = {type='function', description = " returns or sets parent node. Passing a non l2dnode will unlink from parent. If linked will inherit transforms of parents and also won't be drawn if parent is not drawn. ==parent prevents gc of self, unless parent is root.", args="(l2dnode,[l2dnode parent])", returns="([l2dnode])"},
["firstchild"] = {type='function', description = " returns or sets first child of the children list. First child is rendered first. Useful for manual sorting. ", args="(l2dnode,[l2dnode])", returns="([l2dnode])"}}}
fpubclass = {type='class',description="The luxinia API is provided by a system that we call functionpublishing. The functionpublishing is standalone and not bound to a certain scripting language. It also provides basic descriptions (like this text) and implements an objectoriented system of inheritance, even though Luxinia is written in pure C (which isn't an objectoriented programminglanguage). Every object that is created in the Luxinia C core is wrapped in a fpubclass which provides information about the class functions, parent classes and interface classes.",childs={["ischildof"] = {type='function', description = " checks if the child is derived from parent", args="(fpubclass child,fpubclass parent)", returns="(boolean)"},
["description"] = {type='function', description = " returns description string for the class", args="(fpubclass)", returns="([string])"},
["classid"] = {type='function', description = " returns the internal ID number of the class", args="(fpubclass c)", returns="(int)"},
["parent"] = {type='function', description = " returns the parent of the class if it has a parent", args="(fpubclass)", returns="([fpubclass])"},
["class"] = {type='function', description = " returns the maximum number of classes that are registered in the functionpublishing (not all the numbers are registered classes) if no argument is given. If an int is applied, the class with this classid is returned. If a string is given, a class with that name is searched, and if an object is given, the class of the given object is returned. If a class was not found, nil is returned.", args="(string/int/any handle)", returns="([fpubclass/int])"},
["hasinterface"] = {type='function', description = " checks if the class c implements the given interface class", args="(fpubclass c, fpubclass interface)", returns="(boolean)"},
["isinterface"] = {type='function', description = " returns true if the given class is an interface class", args="(fpubclass)", returns="(boolean)"},
["name"] = {type='function', description = " returns the name of the given class", args="(fpubclass)", returns="(string)"},
["functioninfo"] = {type='function', description = " returns the number of functions within this class (not within it's parents or interfaces). If n is provided, it returns the name and the description of the n'th function, where n is >= 0 and < the number of functions. If a string is passed, the return is the same as for n if the functinname is known.", args="(fpubclass, [int n/string name])", returns="(int/[string name,string description])"},
["interface"] = {type='function', description = " returns the number of implemented interfaces. If an index is provided (>=0, <interfacecount) it returns the interface of the class", args="(fpubclass,[int index])", returns="([int/fpubclass])"},
["isluxnative"] = {type='function', description = " returns whether the class is part of the base luxinia.", args="(fpubclass c)", returns="(boolean)"},
["inherited"] = {type='function', description = " returns true if the given function is inherited to child classes", args="(fpubclass,string functionname)", returns="(boolean)"},
["datapointer"] = {type='function', description = " converts a luxinia core-class userdata to a pointer.This is useful for threading and custom dll extenders, BUT be aware that you loose all garbage collection tracking.Because that is solely based on the lua userdata in the main lua thread.", args="(any handle)", returns="(pointer)"}}}
CameraEgoMKCtrl = {type='class',description="Uses Mouse and Keyboard. This controller modifies camera like a first person spectator. Default \
is WASD + SPACE/C for movement and mouse for looking. \
",childs={}}
music = {type='class',description="Music playback, currently only for Ogg files. One file per time can be loaded and played. The playback is threaded and is only updated every 100ms. Thus, changes to the playback may lag behind for a small time period.",childs={["gain"] = {type='function', description = " sets playback gain, must be set after loading a file again.", args="(number gain)", returns="()"},
["stop"] = {type='function', description = " stops a loaded musicfile", args="()", returns="()"},
["time"] = {type='function', description = " seeks a position in the musicfile", args="([number time])", returns="([number time])"},
["play"] = {type='function', description = " plays a loaded musicfile", args="()", returns="()"},
["getcomment"] = {type='function', description = " reads the comments of a musicfile and returns a table that contains a list of it.", args="(string file)", returns="([table string])"},
["isplaying"] = {type='function', description = " returns true if the music is playing", args="()", returns="(boolean)"},
["load"] = {type='function', description = " loads a musicfile", args="(string filename)", returns="()"}}}
dgeomcylinder = {type='class',description="Flatended cylinder. The cylinder is in the unstable branch of ODE. It doesn't collide with other cylinders or planes. It also seems to react unstable in certain positions.",childs={["radius"] = {type='function', description = " sets/gets the radius of the dgeomccylinder", args="(dgeomccylinder,[float])", returns="([float])"},
["length"] = {type='function', description = " sets/gets the length of the dgeomccylinder", args="(dgeomccylinder,[float])", returns="([float])"},
["new"] = {type='function', description = " creates a flatended cylinder", args="(float radius,length)", returns="(dgeomcylinder)"},
["lenrad"] = {type='function', description = " sets/gets the radius and length of the dgeomccylinder", args="(dgeomccylinder,[float rad, float len])", returns="([float rad,float len])"}}}
soundcapture = {type='class',description="Capturing audio input from different sources. If the first call on any of the		functions of this class are done, the capturing is initialized. If the initialization fails, 		false plus the eror is returned. Further calls on functions of this class 		will be terminated too.",childs={["defaultdevice"] = {type='function', description = " returns default capture device", args="()", returns="(string)"},
["stop"] = {type='function', description = " Stops the recording and writes the buffer to the file and closes it.", args="()", returns="()"},
["devicelist"] = {type='function', description = " returns a list of available devices", args="()", returns="([string,...])"},
["start"] = {type='function', description = " Starts recording.", args="()", returns="()"},
["open"] = {type='function', description = " 		opens a device for recording. Only one open device is supported here. The 		format is a number from 0 to 3 and represents MONO 8 bit, MONO 16 bit, STEREO 		8 bit and STEREO 16 bit. If no device is given, the default device is used.", args="(string filename, int samplefrequence, 		int format 0...3, int buffersize, [string device])", returns="(boolean sucecss,[string error])"}}}
ode = {type='class',description="Physical simulation using the ODE Lib.Use its childclasses for simulating physical behaviour of objects (@see http://www.ode.org). Read the ODE API documentation for better understanding, parts of it are included in this documentation. The luxinia API is simplifies some calls or renames them, but basicly, the functions are the same.\
A physical simulation can be divided in two object types: Static and dynamic objects. In ode, simulated objects that are staticly are called geoms, and objects that can interact and move dynamicly are called bodies. Geoms are solid (except trimeshes, which is the source of most problems when using them) objects, socalled primitives - cubes, spheres, cylinders and so on. Bodies are built using multiple geoms, allowing more complex objects for your simulation. The collision detection is done by using socalled spaces.",childs={}}
console = {type='class',description="The console of luxinia is nothing more than  a screen containing lot's of letters. Each letter has a color and a style value that  can be set individually. The console has also a keyinput queue that represents the  keys that the user has pressed since the last frame. This queue is only filled if the  console is active.",childs={["clear"] = {type='function', description = " clears the console screen", args="()", returns="()"},
["active"] = {type='function', description = " returns activestatus if no arguments given and sets activestatus if arg is boolean", args="([boolean active])", returns="([boolean active])"},
["popstd"] = {type='function', description = " returns (if available) a line that was printed to standard stream. If you like to provide an mechanism that prints out information that comes from the Luxinia C core, you need to pop the messages from this queue.", args="()", returns="([string err])"},
["width"] = {type='function', description = " returns width of console", args="()", returns="(int width)"},
["poperr"] = {type='function', description = " returns (if available) a line that was printed to error stream. If you like to provide an mechanism that prints out information that comes from the Luxinia C core, you need to pop the messages from this queue.", args="()", returns="([string err])"},
["put"] = {type='function', description = " writes the string given by text to the console. Stylecodes are: \
* 1: Bold\
* 2: Italic\
* 4: Underline\
* 8: Strikeout\
* 16: Smaller\
If you want to combine the values, just make the sum of the styles you want to use(i.e. 2+4+16).", args="(string text,[int style],[int r,g,b])", returns="()"},
["height"] = {type='function', description = " returns height of console", args="()", returns="(int height)"},
["get"] = {type='function', description = " Returns character information at given x,y", args="(int x,y)", returns="(char c, int r,g,b,style)"},
["popKey"] = {type='function', description = " returns a key and its keycode, that was pressed or nil. tab,backspace and enter get converted to regular keycodes, all other special keys stay as original keycode", args="()", returns="([char key],[int keycode])"},
["pos"] = {type='function', description = " returns position or sets position", args="([int x,y])", returns="([int x,y])"}}}
FileSystem = {type='class',description="Luxinia used an internal way to gain access to the directory \
			structures that was located in the luxinia.dir function that \
			was undocumented. The function returned a table of filenames. \
			For plattformindependance and other reasons, we decided to use \
			the Lua File System which is part of the Kepler project \
			(http://www.keplerproject.org/luafilesystem/). You can use the \
			lfs lib or this class. This class is a pure wrapper for the \
			lfs lib and provides only additional documentation in the way \
			the other classes are described. The function descriptions are \
			extracts from the lfs documentation that can be found at the \
			given link.",childs={["touch"] = {type='function', description = "\
	Set access and modification times of a file. This function is a bind to \
	utime function. The first argument is the filename, the second argument \
	(atime) is the access time, and the third argument (mtime) is the \
	modification time. Both times are provided in seconds (which should be \
	generated with Lua standard function os.date). If the modification time \
	is omitted, the access time provided is used; if both times are omitted, \
	the current time is used.\
\
	Returns true if the operation was successful; in case of error, it returns \
	nil plus an error string.", args="(string filepath [, atime [, mtime] ])", returns="([boolean success],[string error])"},
["dir"] = {type='function', description = " \
	Lua iterator over the entries of a given directory. Each time the \
	iterator is called it returns a string with an entry of the directory; \
	nil is returned when there is no more entries. Raises an error if path \
	is not a directory.", args="(string path)", returns="([function iterator], [string error])"},
["unlock"] = {type='function', description = "\
	Unlocks a file or a part of it. This function works on open files; the \
	file handle should be specified as the first argument. The optional \
	arguments start and length can be used to specify a starting point and its \
	length; both should be numbers.\
\
	Returns true if the operation was successful; in case of error, it returns \
	nil plus an error string. ", args="(filehandle[, start[, length] ])", returns="([boolean success],[string error])"},
["currentdir"] = {type='function', description = " Returns a string with the current \
	working directory or nil  plus an error string.", args="()", returns="([string dir], [string error])"},
["isDir"] = {type='function', description = " return true if the given file is an directory\
	", args="(file)", returns="(boolean isdir)"},
["lock"] = {type='function', description = "\
	Locks a file or a part of it. This function works on open files; the file \
	handle should be specified as the first argument. The string mode could be \
	either r (for a read/shared lock) or w (for a write/exclusive lock). The \
	optional arguments start and length can be used to specify a starting point \
	and its length; both should be numbers.\
\
	Returns true if the operation was successful; in case of error, it returns \
	nil plus an error string.", args="(filehandle, mode[, start[, length] ])", returns="([boolean success], [string error])"},
["attributes"] = {type='function', description = " \
	Returns a table with the file attributes corresponding to filepath (or nil \
	followed by an error message in case of error). If the second optional \
	argument is given, then only the value of the named attribute is returned \
	(this use is equivalent to lfs.attributes(filepath).aname, but the table is \
	not created and only one attribute is retrieved from the O.S.). The \
	attributes are described as follows; attribute mode is a string, all the \
	others are numbers, and the time related attributes use the same time \
	reference of os.time:\
\
	* dev: on Unix systems, this represents the device that the inode resides on. \
		On Windows systems, represents the drive number of the disk containing the file\
	* ino: on Unix systems, this represents the inode number. On Windows systems \
		this has no meaning mode string representing the associated protection \
		mode (the values could be file, directory, link, socket, named pipe, \
		char device, block device or other)\
	* nlink: number of hard links to the file\
	* uid: user-id of owner (Unix only, always 0 on Windows)\
	* gid: group-id of owner (Unix only, always 0 on Windows)\
	* rdev: on Unix systems, represents the device type, for special file inodes. \
		On Windows systems represents the same as dev\
	* access: time of last access\
	* modification: time of last data modification\
	* change: time of last file status change\
	* size: file size, in bytes\
	* blocks: block allocated for file; (Unix only)\
	* blksize: optimal file system I/O blocksize; (Unix only) \
	", args="(string filepath, [string attributename])", returns="([mixed attributevalues])"},
["mkdir"] = {type='function', description = "\
	Creates a new directory. The argument is the name of the new directory.\
	Returns true if the operation was successful; in case of error, it returns \
	nil plus an error string.", args="(string dirname)", returns="([boolean success],[string error])"},
["chdir"] = {type='function', description = "\
	Changes the current working directory to the given path.\
	Returns true in case of success or nil plus an error string.", args="(path)", returns="([boolean success], [string error])"},
["rmdir"] = {type='function', description = "\
	Removes an existing directory. The argument is the name of the directory.\
	Returns true if the operation was successful; in case of error, it returns \
	nil plus an error string.", args="(string dirname)", returns="([boolean success],[string error])"}}}
rcmdfncall = {type='class',description="Wraps an external function call lxRcmdcall_func_fn",childs={["matrix"] = {type='function', description = " returns or sets.", args="(rcmdfncall,[matrix4x4])", returns="([matrix4x4])"},
["size"] = {type='function', description = " returns or sets.", args="(rcmdfncall,[float x,y,z])", returns="([float x,y,z])"},
["orthographic"] = {type='function', description = " returns or sets whether 2d orhographic overlay mode should be used instead of the current active camera.", args="(rcmdfncall,[boolean])", returns="([boolean])"},
["func"] = {type='function', description = " returns or sets function and upvalue pointers.", args="(rcmdfncall,[pointer fn, upvalue])", returns="([pointer fn, upvalue])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdfncall)"}}}
FXUtils = {type='class',description="The FXUtils class is a collection of lua functions that aid setting up effects.",childs={["applyMaterialTexFilter"] = {type='function', description = " adds a texture filter material to an object that supports\
	matobject and matsurface assignments. Texoffsets and weights should match in length and may not exceed 9. Both contain tables of sizes\
	up to 4. Texoffsets should be passed in \"pixelsize\" ie {-1,-1} would be lower left neighboring pixel. Weights reflect\
	weighting for each color channel. The resulting pixel will be the weighted sum of all contributing pixels. Rectangle or powerof2 textures are\
	correctly dealt with and approrpriate conversions of texture coordinates are done.<br>\
	Colorbias is added at the end and be default a table of {0,0,0,0}. \
	\
	Returns matcontrolids for changing control values later, if needed. \
	", args="(matobject, texture, table texoffsets, table weights, [table colorbias], [Rectangle visible])", returns="(matcontrolid texoffsets, weights, clrbias)"},
["getCubeMapCameras"] = {type='function', description = " returns table with 6 cameras. \
	Each setup for dynamic cubemap rendering. Order is CubeMap sides 0-5. Local matrices are set and rotation inherition is\
	disabled.\
	", args="(int visflagstart, [spatialnode], [float frontplane], [float backplane])", returns="(table cameras)"}}}
AutoTable = {type='class',description="The AutoTable class provides a constructor for a table that offers a simple way to insert new values. Although the AutoTable object is a lua table that can be used like any normal table, you can use the table like a function. Any provided argument is inserted at the end of the table. In any case, the number of elements of the table is returned.",childs={}}
ressubid = {type='class',description="Some resources contain sub resources, such as a model is made of meshes. Ressubids allow access to those.",childs={["hostinfo"] = {type='function', description = " returns the index in the host and the host resource", args="(ressubid)", returns="(int index,[resource])"}}}
l3dlist = {type='class',description="The List3D is the main rendering list, it contains l3dnodes that represent visual items.		It is organised in l3dsets l3dlayerids and l3dviews. l3dviews can render l2dnodes thru		special commands as well.<br><br>		The l3dlist the buffermempool for per-frame results. Various limits such as l3dset,		layer and perlayer draws influence its useage. You can alter some of these limits and the poolsize at runtime.		However these are critical operations and should only be looked into if you exceed limits, or had		quits with error messages regarding buffermempool.",childs={["l3dlayercount"] = {type='function', description = " returns how many l3dlayers exist", args="()", returns="(int)"},
["maxtotalprojectors"] = {type='function', description = " gets or sets how many total projectors per-frame can be active. Say you have two meshes		that each are affected by the same projector, this would result into two total projectors. It is		the sum of used projectors per mesh, over all meshes. Changing this value influences runtime limits		and rendermempool consumption (4 bytes per cnt).", args="([int])", returns="([int])"},
["maxdrawsperlayer"] = {type='function', description = " gets or sets how many meshes per l3dlayer in total can ever be rendered.		Changing this value influences runtime limits and rendermempool consumption (8 bytes per l3dset*l3dlayer).", args="([int])", returns="([int])"},
["fbotest"] = {type='function', description = " performs a test run on current rcmdfbo related setups. For testing l3dview:drawnow you can pass the view directly. It takes enable flags of rcmds into account. Returns an error (+1) or warning(-1) string, or nothing if all is working.", args="([l3dview])", returns="([int stringtype, string message])"},
["l3dsetcount"] = {type='function', description = " returns how many l3dsets exist", args="()", returns="(int)"}}}
AutoDoc = {type='class',description="The AutoDoc system creates documentation files from the information\
provided from Luxinia and the modulekernel. The AutoDoc class provides\
a system that can be extended to create help files that fits your use.\
\
For creating your own documentation, you have to set up a template table.\
This table may contain string, tables and functions.\
\
",childs={["templates.apiSingleHtmlDoc"] = {type='value', description = "[table] - Template table for creating the HTML API of all native Luxinia classes."},
["templatePages.moduleHtmlDoc"] = {type='value', description = "[table] - Template table for creating the HTML API of the modules."},
["templatePages"] = {type='value', description = "[table] - contains a number of default templates for creating documentation pages"},
["templateFunctions.descriptor"] = {type='function', description = "\
returns a function that can be used in the template system.\
\
* classfmt: the strings $classname,$classparent, $classdescription, $interfacelist, $childlist,\
$functionlist in the classfmt string will be replaced by the actual meaning\
* interfacefmt: $interfacename\
* childfmt: function (class, depth): function that should return a string\
* functionfmt: function (fname,description,cleandesc)\
", args="(string classfmt, interfacefmt,childfmt,functionfmt,modulefmt)", returns="(function)"},
["templateFunctions"] = {type='value', description = "[table] - contains a number of default functions that can be used within template pages."},
["templates.templatePages.apiHTMLFrameDoc"] = {type='value', description = "[table] - Documentation of api and module pages as frames."},
["templates.templatePages.apiDocIndex"] = {type='value', description = "[table] - API documentation in a single file."},
["writeDoc"] = {type='function', description = " similiar to createDoc, except that the output\
is written to files in a given output directory.\
", args="(path, table template)", returns="()"},
["createDoc"] = {type='function', description = "\
Creates a string from a table that was passed that acts\
as a template. The table may contain functions, tables and strings.\
\
The table is converted\
to a string that represents the final document. The table is therefore iterated\
from 1 to n, where n is the number of number-indexed values in the table.\
That means that you can use any kind of keys for storing additional information\
that you need during the process. In each iteration,\
\
* Strings are written to the output directly\
* Table values are passed as argument to a recursive function call on createDoc\
* Functions will be called with the table itself, the api hierarchy, the list of\
modules and a table containing all classes with their names as keys. The\
function may return itself a table (which is resolved as in the point above) or\
a string.\
\
The template may contain strings that are formated like \"%file=abc%\".\
The string \"abc\" is then used as a key in the table that is additionally\
returned. Per default, all output is saved to the key \"main\" in the table, as\
long as no such instruction is used. You can use the created table with all\
the outputstrings to write it to a file or another structure.\
", args="(table template)", returns="(string doc, table struct)"},
["templateFunctions.hierarchylist"] = {type='function', description = " returns a\
function that returns a string of a hierarchical listing of all class in a list\
form. If api is true, the apihierarchy is used, if its false or not used,\
the modulehierarchy is used.\
\
The passed string is used for each element in the list, the sublistfmt is\
used for childs in the hierarchy.\
\
* $name is replaced by the name of the element or (in the sublistfmt) with the\
childlist of the element.\
* $ifinterface=xyz$; will show xyz if the class is an interface class\
* $list will insert the sublist in the sublistfmt\
", args="(string format, string sublistfmt, [boolean api])", returns="(function)"}}}
skinid = {type='class',description="Skin within a model. Skins allow weighted vertex transforms based on the model's bones. Changing skin data after model.createfinish is not recommended.",childs={["boneid"] = {type='function', description = " returns or sets boneid of internal bonelist.", args="(skinid,int bindex,[boneid])", returns="([boneid])"},
["init"] = {type='function', description = " sets skindata, only works on empty skins in model.create generated models. vertexcount must match the mesh's count the skin is for. bonecount should be the minimum number of bones you need.", args="(skinid,int vertexcount,int bonecount)", returns="()"},
["hwsupport"] = {type='function', description = " returns if skinning can be done in hardware. Only valid after model.initskin was called.", args="(skinid,[boolean])", returns="([boolean])"},
["skinvertexInfluence"] = {type='function', description = " returns or sets how much the influence of the bone is. You must sort weights by descending influences and make sure they sum to 1", args="(skinid,int vindex,int weight,[float influence])", returns="([float])"},
["skinvertexWeights"] = {type='function', description = " returns or sets how many weights are used for this vertex. Hardware support will use 2 weights, lowdetail 1 weight, else a maximum of 4 is allowed.", args="(skinid,int vindex,[int numweights])", returns="([int])"},
["skinvertexBonelookup"] = {type='function', description = " returns or sets index to internal bonelist.", args="(skinid,int vindex,int weight,[int lookup])", returns="([int])"}}}
l3dtext = {type='class',description="A text node",childs={["posatchar"] = {type='function', description = " returns the character's position offset. Behaviour undefined if pos>length of text.", args="(l3dtext, int pos)", returns="(float x,y)"},
["text"] = {type='function', description = " returns or sets text", args="(l3dtext,[string])", returns="([string])"},
["fontset"] = {type='function', description = " returns or sets fontset.", args="(l3dtext,[fontset])", returns="([fontset])"},
["font"] = {type='function', description = " returns or sets font texture", args="(l3dtext,[texture])", returns="([texture])"},
["tabwidth"] = {type='function', description = " returns or sets tab width spacing, default is 0. 0 means spacing * 4 is used, otherwise values will be directly applied.", args="(l3dtext,[float])", returns="(float)"},
["spacing"] = {type='function', description = " returns or sets font spacing, default is 16", args="(l3dtext,[float])", returns="([float])"},
["charatpos"] = {type='function', description = " returns character index at given x,y. Returns true / false wether it x,y was inside or not.", args="(l3dtext, float x, float y)", returns="(boolean inside, int charpos)"},
["size"] = {type='function', description = " returns or sets font size, default is 16", args="(l3dtext,[float])", returns="([float])"},
["dimensions"] = {type='function', description = " returns dimension of space it would take when printed", args="(l3dtext)", returns="(float x,y,z)"},
["new"] = {type='function', description = " creates new l3dtext", args="(string name,|l3dlayerid|,string text,[fontset])", returns="([l3dtext])"}}}
djointfixed = {type='class',description="The fixed joint maintains a fixed relative position and orientation between two bodies, or between a body and the static environment. Using this joint is almost never a good idea in practice, except when debugging. If you need two bodies to be glued together it is better to represent that as a single body.",childs={["setfixed"] = {type='function', description = " Call this on the fixed joint after it has been attached to remember the current desired relative offset and desired relative rotation between the bodies.", args="(djointfixed)", returns="()"},
["new"] = {type='function', description = " creates a new fixedjoint", args="([djointgroup group])", returns="(djointfixed)"}}}
particlecloud = {type='class',description="A ParticleCloud contains many static particles, which are organised as groups. The user specifies all particle properties, the groups are used to handle automatic particle position updates. The fastest types to render are quad,triangle and point.",childs={["drawlayer"] = {type='function', description = " at the end of which layer it will be drawn, l3dset info is ignored.", args="(particlecloud,[l3dlayerid])", returns="()"},
["color"] = {type='function', description = " gets or sets common color for all particles, if particlecolor is false.", args="(particlecloud,[float r,g,b,a])", returns="([float r,g,b,a])"},
["typemodel"] = {type='function', description = " meshes taken from the given model, very expensive. Set the model with 'model' command. Faster if instancemesh is used.", args="(particlecloud)", returns="()"},
["clearparticles"] = {type='function', description = " delets all active particles", args="(particlecloud)", returns="()"},
["worldaxis"] = {type='function', description = " the user given align matrix for all billboards when useworldaxis is true. It will remove the camrotfix flag as it is unneeded.", args="(particlecloud,[matrix4x4])", returns="([matrix4x4])"},
["usesizemul"] = {type='function', description = " if set output size is multiplied with sizemul", args="(particlecloud,[boolean])", returns="([boolean])"},
["attpointsize"] = {type='function', description = " gets or sets the automatic point parameter sizes. Combined with pointdist you can define how point particles should change size depending on distance.", args="(particlecloud,[float min,max,alpha])", returns="([float min,max,alpha])"},
["useoriginoffset"] = {type='function', description = " if set the quads/triangles center will be moved by the originoffset vector. Useful to create particles that dont have their center in the middle.", args="(particlecloud,[boolean])", returns="([boolean])"},
["sizemul"] = {type='function', description = " size multiplier applied when usesizemul is true", args="(particlecloud,[float])", returns="([float])"},
["visflag"] = {type='function', description = " sets visibility bit flag, default is true for id 1 and false for rest. It is bitwise 'and'ed with camera bitid to decide if particles should be drawn.", args="(particlecloud,int id,[boolean])", returns="([boolean])"},
["rotatedirection"] = {type='function', description = " automaticall rotates into the direction their normals point.", args="(particlecloud,[boolean])", returns="([boolean])"},
["typepoint"] = {type='function', description = " just simple points, some systems may have capability for simple textured sprites. particle sizes will be ignored. but using pointsize (default 32) and attpointsize/dist you can influence the sizes.", args="(particlecloud)", returns="()"},
["lightmapmatrix"] = {type='function', description = " generates texture coordinates when lightmap is used.", args="(particlecloud,[matrix4x4])", returns="([matrix4x4])"},
["typetriangle"] = {type='function', description = " a single triangle facing camera", args="(particlecloud)", returns="()"},
["particlenormal"] = {type='function', description = " will use particle's normal. Only applied when instancing renderpath is used.", args="(particlecloud,[boolean])", returns="([boolean])"},
["instancemesh"] = {type='function', description = " sets the instance mesh. Trys to lookup the mesh in the model that is used for rendering. If the mesh is small (only triangles/quads, max 32 vertices, 96 indices) we can instance it. Returns true on success", args="(particlecloud,string meshname)", returns="(boolean)"},
["model"] = {type='function', description = " gets or sets model, only will be used if pcloud type is also set to model.", args="(particlecloud,[model])", returns="([model])"},
["useworldaxis"] = {type='function', description = " when set the billboards will be aligned with the user given world axis and not face camera.", args="(particlecloud,[boolean])", returns="([boolean])"},
["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"},
["pointsize"] = {type='function', description = " gets or sets particle pointsize for typepoint, size is in pixels at 640x480.", args="(particlecloud,[float])", returns="([float])"},
["usecolormul"] = {type='function', description = " if set output colors are multipiled with colormul", args="(particlecloud,[boolean])", returns="([boolean])"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["lightmap"] = {type='function', description = " lightmap texture to be used. for texture coordinates the world space positions are transformed with lightmapmatrix", args="(particlecloud,[texture])", returns="([texture])"},
["camrotfix"] = {type='function', description = " gets or sets if particle rotation is influenced by the camera orientation. Fixes billboard rotation issues when we look 'down' on particles, but will rotate them if we are the same plane as well.", args="(particlecloud,[boolean])", returns="([boolean])"},
["range"] = {type='function', description = " gets or sets range for particles, depending on the 'inside' flag, particles are either only drawn when inside range or outside.", args="(particlecloud,[float])", returns="([float])"},
["sort"] = {type='function', description = " gets or sets z-sort state, setting can be good for some blendtypes.", args="(particlecloud,[boolean])", returns="([boolean])"},
["attpointdist"] = {type='function', description = " gets or sets automatic point size attenuation along with the min and max values from pointsize.", args="(particlecloud,[float const,lin,quad])", returns="([float const,lin,quad])"},
["particlecolor"] = {type='function', description = " gets or sets if particles have their own colors.", args="(particlecloud,[boolean])", returns="([boolean])"},
["probabilityfadeout"] = {type='function', description = " fadeout threshold. when particle's render probability is between probability-thresh its color alpha will be interpolated accordingly. The more it closes the probability value the less its alpha will be.", args="(particlecloud,[float])", returns="([float])"},
["create"] = {type='function', description = " creates a particlecloud with the number of given particles, the name is just a identifier. However make sure to pick a unique name, else a old cloud will be returned.", args="(string name,int particlecount,[int sortkey])", returns="(particlecloud)"},
["probability"] = {type='function', description = " percentage of how many particles are rendered when useprobability is true", args="(particlecloud,[float])", returns="([float])"},
["inside"] = {type='function', description = " gets or sets insideflag, if it is set and range is specified particles need to be within the range to be rendered.", args="(particlecloud,[boolean])", returns="([boolean])"},
["smoothpoints"] = {type='function', description = " gets or sets if points should be smoothed.", args="(particlecloud,[boolean])", returns="([boolean])"},
["checktype"] = {type='function', description = " returns or sets what kind of axis aligned bounding box check should be done. Only particles within the box (defined by checkmin/max) are drawn. Checks performed are:<br> 1 = x-axis <br> 2 = y-axis <br> 3 = x,y-axis <br> 4 = z-axis <br> 5 = x,z-axis <br> 6 = y,z-axis <br> 7 = all axis <br> any other value = no check (default)", args="(particlecloud,[int])", returns="([int])"},
["sequencecount"] = {type='function', description = " gets or sets number of sequence items that the material holds.", args="(particlecloud,[int])", returns="([int])"},
["particlerotate"] = {type='function', description = " gets or sets if particles can have rotation.", args="(particlecloud,[boolean])", returns="([boolean])"},
["colormul"] = {type='function', description = " color multiplier applied when usecolormul is true", args="(particlecloud,[float r,g,b,a])", returns="([float r,g,b,a])"},
["typesphere"] = {type='function', description = " spheres, that can be lit but are yet untextured", args="(particlecloud)", returns="()"},
["matsurface"] = {type='function', description = " gets or sets what kind of material/texture should be used. If your textures contain combined sequences use sequencecount to set how many.", args="(particlecloud,[matsurface])", returns="([material/texture])"},
["checkmin"] = {type='function', description = " returns or sets minimum of the check boundingbox.", args="(particlecloud,[float x,y,z])", returns="([float x,y,z])"},
["typehemisphere"] = {type='function', description = " hemisphere facing towards camera.", args="(particlecloud)", returns="()"},
["forceinstance"] = {type='function', description = " will use instancing rendering even for the small normally batched billboards", args="(particlecloud,[boolean])", returns="([boolean])"},
["typequad"] = {type='function', description = " quad facing towards camera. origin at center", args="(particlecloud)", returns="()"},
["nogpu"] = {type='function', description = " wont use the default gpu programs", args="(particlecloud,[boolean])", returns="([boolean])"},
["useprobability"] = {type='function', description = " if set not all particles are drawn but user given percentage", args="(particlecloud,[boolean])", returns="([boolean])"},
["checkmax"] = {type='function', description = " returns or sets maximum of the check boundingbox.", args="(particlecloud,[float x,y,z])", returns="([float x,y,z])"},
["originoffset"] = {type='function', description = " returns or sets vector that is added to the generic quad/triangle center. Only applied if useoriginoffset is true.", args="(particlecloud,[float x,y,z])", returns="([float x,y,z])"}}}
djointhinge2 = {type='class',description="The hinge-2 joint is the same as two hinges connected in series, with different hinge axes. An example, shown in the above picture is the steering wheel of a car, where one axis allows the wheel to be steered and the other axis allows the wheel to rotate.\
The hinge-2 joint has an anchor point and two hinge axes. Axis 1 is specified relative to body 1 (this would be the steering axis if body 1 is the chassis). Axis 2 is specified relative to body 2 (this would be the wheel axis if body 2 is the wheel).\
Axis 1 can have joint limits and a motor, axis 2 can only have a motor.\
Axis 1 can function as a suspension axis, i.e. the constraint can be compressible along that axis.\
The hinge-2 joint where axis1 is perpendicular to axis 2 is equivalent to a universal joint with added suspension.",childs={["suspensioncfm"] = {type='function', description = " Suspension constraint force mixing (CFM) value", args="(djointhinge2,[float])", returns="([float])"},
["axis2"] = {type='function', description = " Sets/gets hinge-2 axis2. Axis 1 and axis 2 must not lie along the same line.", args="(djointhinge2,[float x,y,z])", returns="([float x,y,z])"},
["anglerate1"] = {type='function', description = " ", args="(djointhinge2)", returns="(float)"},
["suspensionerp"] = {type='function', description = " Suspension error reduction parameter (ERP)", args="(djointhinge2,[float])", returns="([float])"},
["axis1"] = {type='function', description = " Sets/gets hinge-2 axis1. Axis 1 and axis 2 must not lie along the same line.", args="(djointhinge2,[float x,y,z])", returns="([float x,y,z])"},
["anchor"] = {type='function', description = " Sets/gets hinge-2 anchor.", args="(djointhinge2,[float x,y,z])", returns="([float x,y,z])"},
["anglerate2"] = {type='function', description = " ", args="(djointhinge2)", returns="(float)"},
["angle1"] = {type='function', description = " ", args="(djointhinge2)", returns="([float])"},
["new"] = {type='function', description = " creates a new hinge2joint", args="([djointgroup group])", returns="(djointhinge2)"}}}
Icon = {type='class',description="An Icon is a small gui element for graphical symbols. An Icon in Luxinia\
	could be of any type - 2D, 3D, animated and so on, so this class should\
	provide some basic interface definititions and functions to create, delete\
	and hiding the graphical representation of the Icon.",childs={["surface"] = {type='value', description = "[string] - surface that should be used for this icon"},
["color"] = {type='function', description = " Sets the color of the icon - might depend on implementation.", args="(Icon,[r,g=1,b=1,a=1])", returns="([r,g,b,a])"},
["update"] = {type='function', description = " function that is called if something has changed.\
	The reason should be one of the constants defined in the Icon class and\
	describes the reason why the icon was updated more precisly.", args="(Icon,reason)", returns="()"},
["REASON.RESIZED"] = {type='value', description = "{[string]}=resized - resized skin"},
["setClip"] = {type='function', description = " sets clipping for icon or disables it if no clipping is passed", args="(Icon,[x,y,w,h])", returns="()"},
["setLocation"] = {type='function', description = " sets new location for icon", args="(Icon,x,y)", returns="()"},
["onDestroy"] = {type='function', description = " called by the garbagecollector", args="(Icon)", returns="()"},
["visibleflag"] = {type='value', description = "[boolean] - true if the icon should be visible, but depends if the visible resources exists"},
["toString"] = {type='function', description = " called by the tostring function and returns a string\
	representing the icon information", args="(Icon)", returns="(string)"},
["y"] = {type='value', description = "[float] - position of the bounds of the icon"},
["REASON.VISCHANGE"] = {type='value', description = "{[string]}=vischange - vischange reason"},
["clone"] = {type='function', description = " Creates a copy of this Icon ready to be used. Must be\
	overloaded, otherwise an error is thrown.", args="(Icon)", returns="(Icon)"},
["z"] = {type='value', description = "[float] - z position in l2d layer"},
["height"] = {type='value', description = "[float] - height of the icon"},
["createVisibles"] = {type='function', description = " Creates all visible resources required for displaying the icon.\
	Might get called even if the visible information have been created already.", args="(Icon,l2dnode parent)", returns="()"},
["REASON.COLORCHANGE"] = {type='value', description = "{[string]}=colorchange - colorchange reason"},
["deleteVisibles"] = {type='function', description = " frees resources that are required for displaying the icon.\
	Might get called even if the visible information have been deleted.", args="(Icon)", returns="()"},
["setBounds"] = {type='function', description = " sets self.x, self.y, self.width and self.height to\
	the given values and calls the update function", args="(Icon,x,y,w,h)", returns="()"},
["getWidth"] = {type='function', description = " returns width of the Icon", args="(Icon)", returns="(w)"},
["new"] = {type='function', description = " Sets\
	metatable index to class. Per default, a skin does not create any visual\
	objects during start. These must be created by calling createVisibles. ", args="(class, [width,height])", returns="(Icon)"},
["REASON.CREATEDVIS"] = {type='value', description = "{[string]}=createdvis - vischange reason"},
["delete"] = {type='function', description = " deletes the icon. This function might get called multiple times so\
	flag your icon once you have deleted it. Per default the deletefunction will\
	call the deleteVisibles function. If your Icon does not require further\
	resources you can leave it this way.", args="(Icon)", returns="()"},
["getClip"] = {type='function', description = " gets clipping for icon or disables it if no clipping is passed", args="(Icon)", returns="([x,y,w,h])"},
["id"] = {type='value', description = "[float] - l2d sortid"},
["x"] = {type='value', description = "[float] - position of the bounds of the icon"},
["getHeight"] = {type='function', description = " returns height of the Icon", args="(Icon)", returns="(h)"},
["width"] = {type='value', description = "[float] - width of the icon"},
["getSize"] = {type='function', description = " returns width and height of the Icon", args="(Icon)", returns="(w,h)"},
["selectIcon"] = {type='function', description = " Selects an Icon. This means a different representation\
	of the same icon. If the icon is used by a Skin2D object, the Skin2D object\
	will automaticly forward its selectSkin parameter to this function. So an\
	icon that is assigned to a skin used by a component should provide the\
	\"surface\" that are specific for this component.\
\
	If no surface of that name exists the surface \"default\" is tried out, if that\
	fails too the object handles the case on its own.", args="(Icon, icon)", returns="()"},
["REASON.DELETEDVIS"] = {type='value', description = "{[string]}=deletedvis - vischange reason"},
["setVisibility"] = {type='function', description = " Shows or hides the icon. Only affects\
	Icons that have created visible resources.", args="(Icon,boolean visible)", returns="()"},
["REASON.SKINCHANGE"] = {type='value', description = "{[string]}=skinchange - skinchange reason"},
["contains"] = {type='function', description = " returns true if the specific pixel is clickable.\
	Returns true per default", args="(Icon, x,y)", returns="(boolean)"},
["setSortID"] = {type='function', description = " sets sortids for l2d sorting", args="(Icon, id)", returns="()"},
["setZ"] = {type='function', description = " Z offset to l2dlayer", args="(Icon, z)", returns="()"}}}
soundnode = {type='class',description="soundnodes are sound sources in space.",childs={["rewind"] = {type='function', description = " rewinds soundnode", args="(soundnode self)", returns="()"},
["delete"] = {type='function', description = " deletes soundnode", args="(soundnode self)", returns="()"},
["gain"] = {type='function', description = " sets or gets gain value", args="(soundnode self, [float])", returns="([float])"},
["refdist"] = {type='function', description = " sets or gets reference distance value", args="(soundnode self, [float])", returns="([float])"},
["velocity"] = {type='function', description = " sets or gets velocity vector", args="(soundnode self, [float x,y,z])", returns="([float x,y,z])"},
["update"] = {type='function', description = " manualy updates the node parameters (gain, pitch, position...). This is done automaticly once per frame, use this function only if you want to make your changes work instantly. Remember that sound playback is threaded and you will instantly hear any changes to the soundplayback (unlike the graphics which is synchronized per frame).", args="(soundnode self)", returns="()"},
["autodelete"] = {type='function', description = " sets or gets autodelete value. If true, the 		soundnode is automaticly delete when the soundplaying is stoped. This is the default.", args="(soundnode self, [boolean])", returns="([boolean])"},
["pause"] = {type='function', description = " pauses soundnode", args="(soundnode self)", returns="()"},
["loop"] = {type='function', description = " sets or gets looping value", args="(soundnode self, [boolean])", returns="([boolean])"},
["stop"] = {type='function', description = " stops soundnode", args="(soundnode self)", returns="()"},
["pos"] = {type='function', description = " sets or gets position", args="(soundnode self, [float x,y,z])", returns="([float x,y,z])"},
["pitch"] = {type='function', description = " sets or gets pitch value", args="(soundnode self, [float])", returns="([float])"},
["play"] = {type='function', description = " plays soundnode. Make adjustments to pitch, gain, position, etc.before calling this function, otherwise you may hear not what you expect. These properties are only updated once per frame and when play is executed. Returns true if the sound is played, false if it couldn't play it (too many sounds playing) or nil if the sound playback is disabled.", args="(soundnode self)", returns="(boolean)"},
["isplaying"] = {type='function', description = " true if soundnode is playing", args="(soundnode self)", returns="(boolean)"},
["new"] = {type='function', description = " new soundnode", args="(Sound snd)", returns="(soundnode node)"}}}
dgeomtransform = {type='class',description="A geometry transform `T' is a geom that encapsulates another geom `E', allowing E to be positioned and rotated arbitrarily with respect to its point of reference.\
Most placeable geoms (like the sphere and box) have their point of reference corresponding to their center of mass, allowing them to be easily connected to dynamics objects. Transform objects give you more flexibility - for example, you can offset the center of a sphere, or rotate a cylinder so that its axis is something other than the default.\
T mimics the object E that it encapsulates: T is inserted into a space and attached to a body as though it was E. E itself must not be inserted into a space or attached to a body. E's position and rotation are set to constant values that say how it is transformed relative to T. If E's position and rotation are left at their default values, T will behave exactly like E would have if you had used it directly.",childs={["geom"] = {type='function', description = " sets/gets the geom to be transformed. The passed geom must not be inserted in a space or must not be transformed.", args="(dgeomtranform self, [dgeom])", returns="([dgeom])"},
["new"] = {type='function', description = " creates a new transforminst", args="([dspace space])", returns="(dgeomtranform)"}}}
boneid = {type='class',description="Bone within a model. Normally reference state is returned but its also possible to retrieve animcache values.",childs={["rotdeg"] = {type='function', description = " returns bone's reference rotation in object space. degrees", args="(boneid,[boolean animcache])", returns="(float x,y,z)"},
["matrix"] = {type='function', description = " returns bone's reference matrix in object space.", args="(boneid,[boolean animcache])", returns="(matrix4x4)"},
["init"] = {type='function', description = " sets bonedata, only works on empty bones in model.create generated models. matrix should not have scaling.", args="(boneid,string name,matrix4x4 refmatrix,[boneid parent])", returns="()"},
["parent"] = {type='function', description = " returns parent if exists", args="(boneid)", returns="([boneid])"},
["disableaxis"] = {type='function', description = " disable bone's rotation axis", args="(boneid,int axis)", returns="()"},
["name"] = {type='function', description = " returns name", args="(boneid)", returns="(string)"},
["enableaxis"] = {type='function', description = " enables a bone's rotation axis when its controlled by bonecontrol and allows limited rotation. limit is relative to reference position. ", args="(boneid,int axis,boolean limit,float minangle,float maxangle)", returns="()"},
["rotrad"] = {type='function', description = " returns bone's reference rotation in object space. radians", args="(boneid,[boolean animcache])", returns="(float x,y,z)"},
["rotaxis"] = {type='function', description = " returns bone's reference rotation in object space. axis", args="(boneid,[boolean animcache])", returns="(float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz)"},
["pos"] = {type='function', description = " returns bone's reference position in object space", args="(boneid,[boolean animcache])", returns="(float x,y,z)"}}}
djointball = {type='class',description="A ball-joint that rotates without limits. Can be used to simulate ropes for example",childs={["anchor"] = {type='function', description = " sets anchor point of joint if x,y,z is given (world coordinates) or returns the current anchors of the bodies if no argument is passed. Since the simulation is imperfect, there's a gap between the anchor that is set and the actual anchors of the bodies.", args="(djointball,[float x,y,z])", returns="([float x1,y1,z1,x2,y2,z2])"},
["new"] = {type='function', description = " creates a new balljoint", args="([djointgroup group])", returns="(djointball)"}}}
dgeomtrimeshdata = {type='class',description="Trimesh data that is used for dgeomtrimesh. You can instantiate one trimeshdata and reuse it multiple times.",childs={["new"] = {type='function', description = " Creates a trimeshdataset. Indices and positions are stored as continous streams. For example ind{0,1,2, 3,4,5, ...} pos={x,y,z, x1,y1,z1, ...}", args="(table triangleindices,table vertexpositions)", returns="(dgeomtrimeshdata)"}}}
scenenode = {type='class',description="The SceneTree is a hierarchical SceneGraph organised as tree, containing scenenodes. 		The SceneTree is optimized for static data, for dynamic		nodes better use actornodes, however the scenenodes can be changed in position and rotation just fine as well.<br>		Retrieving world data can return wrong results, you need to wait one frame until they are uptodate or enforce a full 		tree updateall.<br>Compared to the other visual node types, scenenodes are automatically linked to the rootnode on creation, however this won't prevent garbagecollection.",childs={["localrotaxis"] = {type='function', description = " returns or sets local rotation axis, make sure they make a orthogonal basis.", args="(scenenode s3d,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])", returns="([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])"},
["transform"] = {type='function', description = " transforms x,y,z with final matrix of the node into world coordinates", args="(scenenode self,float x,y,z)", returns="(float x,y,z)"},
["parent"] = {type='function', description = " return or sets parent. If parent is not a scenenode, the node becomes unlinked. ==parent will prevent gc of self, unless parent is root.", args="(scenenode s3d,[scenenode parent])", returns="([scenenode parent])"},
["worldrotaxis"] = {type='function', description = " returns or sets last world rotation axis, make sure they make a orthogonal basis.", args="(scenenode s3d,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])", returns="([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])"},
["worldrotdeg"] = {type='function', description = " returns world rotation (degrees)", args="(scenenode s3d)", returns="(float x,y,z)"},
["localrotdeg"] = {type='function', description = " updates node's local rotation or returns it in degrees", args="(scenenode s3d,[float x,y,z])", returns="(float x,y,z)"},
["new"] = {type='function', description = " creates a new scenenode with given position as local pos. By default has root as parent.", args="(string name,[boolean drawable],[float x,y,z])", returns="([scenenode s3d])"},
["localrotrad"] = {type='function', description = " updates node's local rotation or returns it in radians", args="(scenenode s3d,[float x,y,z])", returns="(float x,y,z)"},
["delete"] = {type='function', description = " removes the Node from the SceneTree and deletes it. withchildren defaults to false", args="(scenenode)", returns="()"},
["vistestbbox"] = {type='function', description = " sets/gets visibility testing boundingbox when scenenode is drawable ", args="(scenenode self, [float minX,minY,minZ,maxX,maxY,maxZ])", returns="([float minX,minY,minZ,maxX,maxY,maxZ])"},
["localrotquat"] = {type='function', description = " updates node's local rotation or returns it as quaternion", args="(scenenode s3d,[float x,y,z,w])", returns="(float x,y,z,w)"},
["getroot"] = {type='function', description = " returns the root node. The root node can't be deleted nor modified", args="()", returns="(scenenode s3d)"},
["updateall"] = {type='function', description = " done automatically before rendering is done, but if you need uptodate world data, right after setting your scenenodes, call this function.", args="()", returns="()"},
["worldrotquat"] = {type='function', description = " returns world rotation as quaternion", args="(scenenode s3d,[float x,y,z,w])", returns="(float x,y,z,w)"},
["localpos"] = {type='function', description = " updates node's local position or returns it", args="(scenenode s3d,[float x,y,z])", returns="(float x,y,z)"},
["worldpos"] = {type='function', description = " returns world position", args="(scenenode s3d)", returns="(float x,y,z)"},
["worldrotrad"] = {type='function', description = " returns world rotation (radians)", args="(scenenode s3d)", returns="(float x,y,z)"},
["localmatrix"] = {type='function', description = " updates node's local matrix or returns it", args="(scenenode s3d,[matrix4x4])", returns="([matrix4x4])"},
["worldmatrix"] = {type='function', description = " returns node's world matrix", args="(scenenode s3d)", returns="([matrix4x4])"}}}
L2DIcon = {type='class',description="",childs={["new"] = {type='function', description = "\
	", args="(class,width, height, oncreate, ondelete)", returns="()"}}}
dgeomccylinder = {type='class',description="A capped cylinder is like a normal cylinder except it has half-sphere caps at its ends. This feature makes the internal collision detection code particularly fast and accurate. The cylinder's length, not counting the caps, is given by length. The cylinder is aligned along the geom's local Z axis. The radius of the caps, and of the cylinder itself, is given by radius.",childs={["radius"] = {type='function', description = " sets/gets the radius of the dgeomccylinder", args="(dgeomccylinder,[float])", returns="([float])"},
["length"] = {type='function', description = " sets/gets the length of the dgeomccylinder", args="(dgeomccylinder,[float])", returns="([float])"},
["new"] = {type='function', description = " Create a capped cylinder geom of the given parameters, and return its ID. If space is nonzero, insert it into that space.", args="([float r,l],[dspace space])", returns="(dgeomccylinder)"},
["lenrad"] = {type='function', description = " sets/gets the radius and length of the dgeomccylinder", args="(dgeomccylinder,[float rad, float len])", returns="([float rad,float len])"}}}
dgeombox = {type='class',description="A solid box object.",childs={["size"] = {type='function', description = " sets/gets size of the box", args="(dgeombox,[float x,y,z])", returns="([float x,y,z])"},
["new"] = {type='function', description = " creates a box with width=w, height=h and length=l", args="([float w,h,l],[dspace space])", returns="(dgeombox box)"}}}
fileloader = {type='class',description="",childs={["setfileopen"] = {type='value', description = "():() -"},
["setfileexists"] = {type='value', description = "():() -"}}}
dgeomsphere = {type='class',description="A sphere with a radius, the fastest and most simple collission solid.",childs={["r"] = {type='function', description = " sets/gets radius of sphere", args="(dgeomsphere sphere,[float r])", returns="([float r])"},
["new"] = {type='function', description = " creates a new sphere with radius r. Inserts the sphere in space, if given", args="([float r],[dspace space])", returns="(dgeomsphere sphere)"}}}
dbody = {type='class',description="A rigid body has various properties from the point of view of the simulation. Some properties change over time:\
* Position vector (x,y,z) of the body's point of reference. Currently the point of reference must correspond to the body's center of mass.\
* Linear velocity of the point of reference, a vector (vx,vy,vz).\
* Orientation of a body, represented by a quaternion (qs,qx,qy,qz) or a 3x3 rotation matrix.\
* Angular velocity vector (wx,wy,wz) which describes how the orientation changes over time.\
Other body properties are usually constant over time:\
* Mass of the body.\
* Position of the center of mass with respect to the point of reference. In the currentimplementation the center of mass and the point of reference must coincide.\
* Inertia matrix. This is a 3x3 matrix that describes how the body's mass is distributed around the center of mass. ",childs={["addrelforce"] = {type='function', description = " adds force to the body in the body's orientation. If coordinates are given, the force is added at this point, which will add some force at the torque. If a 7th parameter (boolean) is given, the point is in relative coordinates.", args="([float fx,fy,fz],[float x,y,z],[rel])", returns="()"},
["angvel"] = {type='function', description = " sets/gets angular velocity of the body", args="(dbody self,[float fx,fy,fz])", returns="([float vx,vy,vz])"},
["rotdrag"] = {type='function', description = " this vector is multiplied with the 		angular velocity vector of the body each step. Don't set the vector to values >1 or <0, 		otherwise your body will either flicker around or accelerate to infinity. This is 		a useful value to let the system lose energy which is stabilizing the simulation quite well.", args="(body,[float x,y,z])", returns="([float x,y,z])"},
["gravity"] = {type='function', description = " sets/gets if gravity is on for this body", args="([boolean on])", returns="([boolean on])"},
["massadjust"] = {type='function', description = " sets new mass", args="(dbody self, float newmass)", returns="()"},
["massaddbox"] = {type='function', description = " adds mass of a box. If a 6th argument is passed, the density is calculated to total mass", args="(dbody self,float density,lx,ly,lz,[any total])", returns="()"},
["lock"] = {type='function', description = " sets/gets locking for body. One axis can be set to be locked at a certain value. x=1,y=2,z=3,0=no locking. Planewidth is the width in which the body can move. Planeveldamp is the damping applied to the velocity in the locking axis. The damping should be >=0 and <=1. Default values are for unused arguments is 0.", args="(dbody,[int axis,float value],[planewidth],[planeveldamp])", returns="([int axis,float value,planewidth,planeveldamp])"},
["disablesteps"] = {type='function', description = " trace depth when an enabled body touches a group of disabled bodies.\
", args="([int])", returns="([int])"},
["force"] = {type='function', description = " sets gets power of force", args="()", returns="([float x,y,z])"},
["reaffect"] = {type='function', description = " sets/gets body reaffection. If two bodies collide and at least one affect bit of the other body is set that is set in reaffect, the body is affected by the other body.", args="(dbody,[int reaffect])", returns="([int reaffect])"},
["jointenergy"] = {type='function', description = " returns the kineticenergy applied to the body by connected bodies. Since the sum can become too small, an additional multiplier can be applied.", args="(dbody,[float multiplier])", returns="(float kineticenergy)"},
["massparam"] = {type='function', description = " sets/gets massproperties of the body. Refer to the ode docs here, this function is for advanced people who know what they want.", args="(dbody self,[float mass,cx,cy,cz, i11,i22,i33,i12,i13,i23])", returns="([float mass,cx,cy,cz, i11,i22,i33,i12,i13,i23])"},
["matrix"] = {type='function', description = " sets/gets matrix of geom", args="(dgeom geom,[matrix4x4])", returns="([matrix4x4])"},
["worldpointvel"] = {type='function', description = " retrieve velocity at world point x,y,z", args="(dbody,float x,y,z)", returns="(float x,y,z)"},
["addreltorque"] = {type='function', description = " adds torque force to the body in the body's orientation", args="([float fx,fy,fz])", returns="()"},
["rotrad"] = {type='function', description = " sets/gets 				 rotation of geom. The angles must be calculated from a matrix, so the results 				 can differ from what you set. These matrix calculations are quite expensive, 				 so use it with care. This functions uses x,y,z as angles in radians (180°==PI)", args="(dgeom geom,[float x,y,z])", returns="([float x,y,z])"},
["torque"] = {type='function', description = " sets/gets power of torque force", args="([float x,y,z])", returns="([float x,y,z])"},
["velocity"] = {type='function', description = " sets/gets linear velocity of the body", args="(dbody self,[float fx,fy,fz])", returns="([float vx,vy,vz])"},
["rotquat"] = {type='function', description = " sets/gets 				  rotation of geom as quaternion.", args="(dgeom geom,[float x,y,z,w])", returns="([float x,y,z,w])"},
["state"] = {type='function', description = " returns true if the body is enabled. Disables/Enables body if boolean value is passed. Disabled bodies don't use CPU power.", args="([boolean enable])", returns="([boolean])"},
["localpointvel"] = {type='function', description = " retrieve velocity at relative point x,y,z", args="(dbody,float x,y,z)", returns="(float x,y,z)"},
["veldrag"] = {type='function', description = " this vector is multiplied with the 		velocity vector of the body each step. Don't set the vector to values >1 or <0, 		otherwise your body will either flicker around or accelerate to infinity. This is 		a useful value to let the system lose energy which is stabilizing the simulation quite well.", args="(body,[float x,y,z])", returns="([float x,y,z])"},
["masscylinder"] = {type='function', description = " sets mass of a cylinder with density, radius and length. The axis indicates the orientation of the cylinder: 1=x, 2=y, 3=z.", args="(dbody self, float density,int axis, float radius,length, [any total])", returns="()"},
["minenableforce"] = {type='function', description = " sets/gets the required force to enable the body (default=0).", args="(dbody self,[float f])", returns="([float f])"},
["massaddsphere"] = {type='function', description = " adds the mass to the mass of a sphere with density and radius. If a third argument is applied, the density will be calculated to the total mass of the sphere.", args="(dbody self, float density,radius,[any total])", returns="()"},
["jointforces"] = {type='function', description = " returns the sum of all force vectors that is contributed by all joints that are attached to the body, the total length of the forcevector and the sum of all lengths of forces together. Note that the sum of all lengths is never 0 if a force is applied, while all other values can be 0.", args="(dbody)", returns="(float fx,fy,fz,forcesumlength,forcelengthsum)"},
["jointcount"] = {type='function', description = " the number of joints that the body is connected to.", args="(dbody)", returns="(int)"},
["rotaxis"] = {type='value', description = "([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz]) : 				  (dgeom geom,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])) - 				  returns or sets local rotation axis, make sure they make a orthogonal basis."},
["pos"] = {type='function', description = " sets/gets position of geom", args="(dgeom geom,[float x,y,z])", returns="([float x,y,z])"},
["addforce"] = {type='function', description = " adds force to the body. If coordinates are given, the force is added at this point, which will add some force at the torque. If a 7th parameter (boolean) is given, the point is in relative coordinates.", args="([float fx,fy,fz],[float x,y,z],[rel])", returns="()"},
["velthreshold"] = {type='function', description = " when the velocity drops below this value, the body becomes autodisabled.", args="([float])", returns="([float])"},
["defaults"] = {type='function', description = " resets the autodisable properties to the settings of the world.", args="(dbody)", returns="()"},
["nextminenableforce"] = {type='function', description = " sets/gets the required force to enable the body (default=0), once it was activated - it overwrites the minenableforce then. This is usefull if you have a brickwall and the bricks need lot's of force to be loosed. But once loosed, it shouldn't need much effort anymore to reenable them.", args="(dbody self,[float f])", returns="([float f])"},
["masssphere"] = {type='function', description = " sets the mass to the mass of a sphere with density and radius. If a third argument is applied, the density will be calculated to the total mass of the sphere.", args="(dbody self, float density,radius,[any total])", returns="()"},
["finitemode"] = {type='function', description = " Sets/gets mode and axis of the finite rotation\
The mode controls the way a body's orientation is updated at each time step. \
* true: An 'infinitesimal' orientation update is used. This is fast to compute, but it can occasionally cause inaccuracies for bodies that are rotating at high speed, especially when those bodies are joined to other bodies. This is the default for every new body that is created.\
* false: A 'finite' orientation update is used. This is more costly to compute, but will be more accurate for high speed rotations. Note however that high speed rotations can result in many types of error in a simulation, and this mode will only fix one of those sources of error.\
The three floats set the finite rotation axis for a body. This is axis only has meaning when the finite rotation mode is set.\
If this axis is zero (0,0,0), full finite rotations are performed on the body.If this axis is nonzero, the body is rotated by performing a partial finite rotation along the axis direction followed by an infinitesimal rotation along an orthogonal direction.\
This can be useful to alleviate certain sources of error caused by quickly spinning bodies. For example, if a car wheel is rotating at high speed you can call this function with the wheel's hinge axis as the argument to try and improve its behavior. ", args="([boolean on],[float x,y,z])", returns="([boolean on,float x,y,z])"},
["vectortoworld"] = {type='function', description = " rotate a vector into world coordinates", args="(dbody,float x,y,z)", returns="(float x,y,z)"},
["masszero"] = {type='function', description = " sets mass of body to zero", args="()", returns="()"},
["massaddcylinder"] = {type='function', description = " adds mass of a cylinder with density, radius and length. The axis indicates the orientation of the cylinder: 1=x, 2=y, 3=z.", args="(dbody self, float density,int axis, float radius,length, [any total])", returns="()"},
["actdepth"] = {type='function', description = " returns -1 if it was activated by a body that has a minactdepth >= 0", args="(dbody self)", returns="(int)"},
["joint"] = {type='function', description = " returns the i-th joint the body is connected to.", args="(dbody,int i)", returns="([djoint])"},
["local2world"] = {type='function', description = " converts local to world coordinates", args="(dbody,float x,y,z)", returns="(float x,y,z)"},
["new"] = {type='function', description = " creates a new body", args="()", returns="(dbody)"},
["affect"] = {type='function', description = " sets/gets body affection. If two bodies collide and at least one reaffect bit of the other body is set that is set in affect, the other body is affected by the body.", args="(dbody,[int affect])", returns="([int affect])"},
["rotdeg"] = {type='function', description = " sets/gets 				 rotation of geom. The angles must be calculated from a matrix, so the results 				 can differ from what you set. These matrix calculations are quite expensive, 				 so use it with care. This function uses x,y,z as angles in degrees (180°==PI).", args="(dgeom geom,[float x,y,z])", returns="([float x,y,z])"},
["addtorque"] = {type='function', description = " adds torque force to the body", args="([float fx,fy,fz])", returns="()"},
["massrotate"] = {type='function', description = " rotates (radians) the mass of the body.", args="(dbody self, float x,y,z)", returns="()"},
["angularthreshold"] = {type='function', description = " rotational minimum limit when the body should become disabled.", args="([float])", returns="([float])"},
["world2local"] = {type='function', description = " converts world to local coordinates", args="(dbody,float x,y,z)", returns="(float x,y,z)"},
["delete"] = {type='function', description = " deletes the dbody", args="(dbody)", returns="()"},
["disabletime"] = {type='function', description = " amount of time to be waited until the body becomes autodisabled.", args="([float])", returns="([float])"},
["connected"] = {type='function', description = " true if both bodies are connected through a joint", args="(dbody,dbody)", returns="(boolean)"},
["masscappedcyl"] = {type='function', description = " sets mass of a cappedcylinder with density, radius and length. The axis indicates the orientation of the cylinder: 1=x, 2=y, 3=z. A capped cylinder is a cylinder that has spheres at its end.", args="(dbody self, float density,int axis, float radius,length, [any total])", returns="()"},
["massbox"] = {type='function', description = " sets mass of a box. If a 6th argument is passed, the density is calculated to total mass", args="(dbody self,float density,lx,ly,lz,[any total])", returns="()"},
["vectorfromworld"] = {type='function', description = " converts world rotation into local", args="(dbody,float x,y,z)", returns="(float x,y,z)"},
["lockrotaxis"] = {type='function', description = " sets/gets locking rotation axis for body. Chose the axis with the axis number (x=1,y=2,z=3,0=no lock) and set the direction where this axis should look to. ", args="(dbody,[int axis,float x,y,z])", returns="([int axis,float x,y,z])"},
["minactdepth"] = {type='function', description = " sets/gets minimum activation depth, if ==-1 => disabled (default). Use this to reduce the number of activated bodys outgoing from a activator source.", args="(dbody self,[int])", returns="([int])"},
["massaddcappedcyl"] = {type='function', description = " adds mass of a cappedcylinder with density, radius and length. The axis indicates the orientation of the cylinder: 1=x, 2=y, 3=z. A capped cylinder is a cylinder that has spheres at its end.", args="(dbody self, float density,int axis, float radius,length, [any total])", returns="()"},
["autodisable"] = {type='function', description = " if true, the body can become disabled if it doesn't do much. This will speed up the simulation alot if you have lot's of objects that are just lieing around.", args="([boolean on])", returns="([boolean])"},
["nocollissionwithconnected"] = {type='function', description = " sets/gets boolean, default=true. If it is true for two bodies that are connected, the collissioncheck is rejected if the two bodies of the collission are connected by a joint, before the complex collissioncheck is done - so it saves performance. If only one of the bodies has this flag set, it will be not affected by the other body. If the flag is false for both of them, they will collide normally with each other.", args="([boolean on])", returns="([boolean on])"}}}
sound = {type='class',description="sound resources",childs={["setdevice"] = {type='function', description = " Trys to set the sounddevice according to a device with the given name or the default device if nil or no string is passed. If it fails, it will try to select the default device. Returns the selected device. Setting the current device will make all soundnodes invalid, which may result in a runtime error in lua when old (invalid) soundnodes are reused.", args="([string devicename])", returns="(string device)"},
["monocount"] = {type='function', description = " returns the maximum for mono sources for the current device", args="()", returns="(int n)"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["devices"] = {type='function', description = " returns available sound devices", args="()", returns="(string ...)"},
["getdevicename"] = {type='function', description = " returns the name of the current device", args="()", returns="(string name)"},
["stereocount"] = {type='function', description = " returns the maximum for stereo sources for the current device", args="()", returns="(int n)"},
["load"] = {type='function', description = " adds a soundfile to loaded resources", args="(string filename)", returns="(Sound snd)"},
["play"] = {type='function', description = " plays a soundfile. Returns true if it plays the sound.", args="(Sound snd)", returns="(boolean)"},
["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"}}}
particlesys = {type='class',description="ParticleSystem contains of dynamic particles, which spawn at emitters and die after a given time.  The way they move and appear is controlled by the particlescript, which has its own detailed manual.  All particles of a system are rendered at the end of a l3dset and a particlesystem can be used in only one l3dst.  If you want to use the same particlesystem in multiple l3dsets, use one forceload per l3dset.<br> Compared to ParticleClouds you cannot control particles individually.",childs={["volumesize"] = {type='function', description = " size of the volume", args="(particlesys,[float x,y,z])", returns="([float x,y,z])"},
["drawlayer"] = {type='function', description = " at the end of which layer it will be drawn, l3dset info is ignored.", args="(particlesys,[l3dlayerid])", returns="()"},
["bbox"] = {type='function', description = " returns or sets bounding box", args="(model,[float minx,miny,minz, maxx,maxy,maxz])", returns="([float minx,miny,minz, maxx,maxy,maxz])"},
["clearparticles"] = {type='function', description = " deletes all active particles", args="(particlesys)", returns="()"},
["worldaxis"] = {type='function', description = " the user given align matrix for all billboards when useworldaxis is true. It will remove the camrotfix flag as it is unneeded.", args="(particlesys,[matrix4x4])", returns="([matrix4x4])"},
["usesizemul"] = {type='function', description = " if set output size is multiplied with sizemul", args="(particlesys,[boolean])", returns="([boolean])"},
["nodraw"] = {type='function', description = " wont draw the system", args="(particlesys,[boolean])", returns="([boolean])"},
["getsubsysdigits"] = {type='function', description = " returns the special digit subsys string, to access subsys emitters in l3dpemitter, based on particle resource names (substring search is done, the preciser the resname the less ambigous). E.g \"bomb,sparks\" will search bomb subsys in this psys, then spark in bomb and so on. Returns nothing when not found.", args="(particlesys,string)", returns="([string])"},
["sizemul"] = {type='function', description = " size multiplier applied when usesizemul is true", args="(particlesys,[float])", returns="([float])"},
["intervelocity"] = {type='function', description = " returns or sets the velocity multiplier at the particle interpolator step.", args="(particlesys,int step (0..127),[float])", returns="([float])"},
["checkmax"] = {type='function', description = " returns or sets maximum of the check boundingbox.", args="(particlesys,[float x,y,z])", returns="([float x,y,z])"},
["probabilityfadeout"] = {type='function', description = " fadeout threshold. when particle's render probability is between probability-thresh its color alpha will be interpolated accordingly. The more it closes the probability value the less its alpha will be.", args="(particlesys,[float])", returns="([float])"},
["volumeoffset"] = {type='function', description = " the position that is used when volumecaminfluence is 0", args="(particlesys,[float x,y,z])", returns="([float x,y,z])"},
["volumecaminfluence"] = {type='function', description = " how much the camera position affects the volumecenter (default is 1,1,1).", args="(particlesys,[float x,y,z])", returns="([float x,y,z])"},
["lightmapmatrix"] = {type='function', description = " generates texture coordinates when lightmap is used.", args="(particlesys,[matrix4x4])", returns="([matrix4x4])"},
["interrot"] = {type='function', description = " returns or sets the rotation multiplier at the particle interpolator step.", args="(particlesys,int step (0..127),[float])", returns="([float])"},
["usevolume"] = {type='function', description = " particles are kept in a box volume, and treated as infinite distribution", args="(particlesys,[boolean])", returns="([boolean])"},
["useworldaxis"] = {type='function', description = " when set the billboards will be aligned with the user given world axis and not face camera.", args="(particlesys,[boolean])", returns="([boolean])"},
["load"] = {type='function', description = " loads a particlesystem", args="(string filename,[int sortkey])", returns="(Particlesys psys)"},
["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"},
["usecolormul"] = {type='function', description = " if set output colors are multipiled with colormul", args="(particlesys,[boolean])", returns="([boolean])"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["lightmap"] = {type='function', description = " lightmap texture to be used. for texture coordinates the world space positions are transformed with lightmapmatrix", args="(particlesys,[texture])", returns="([texture])"},
["annotation"] = {type='function', description = " searches and returns annotation string", args="(particlesys, string name)", returns="([string])"},
["intertex"] = {type='function', description = " returns or sets the texturenumber at the particle interpolator step.", args="(particlesys,int step (0..127),[int])", returns="([int])"},
["intercolor"] = {type='function', description = " returns or sets the color at the particle interpolator step.", args="(particlesys,int step (0..127),[float r,g,b,a])", returns="([float r,g,b,a])"},
["timescale"] = {type='function', description = " you can slow down or speed up particle update and aging. 1.0 is default", args="(particlesys,[float])", returns="([float])"},
["checktype"] = {type='function', description = " returns or sets what kind of axis aligned bounding box check should be done. Only particles within the box (defined by checkmin/max) are drawn. Checks performed are:<br> 1 = x-axis <br> 2 = y-axis <br> 3 = x,y-axis <br> 4 = z-axis <br> 5 = x,z-axis <br> 6 = y,z-axis <br> 7 = all axis <br> any other value = no check (default)", args="(particlesys,[int])", returns="([int])"},
["getforceid"] = {type='function', description = " returns particleforceid if found.", args="(particlesys,string name)", returns="([particleforceid])"},
["pause"] = {type='function', description = " will not perform any updates to the particles", args="(particlesys,[boolean])", returns="([boolean])"},
["colormul"] = {type='function', description = " color multiplier applied when usecolormul is true. Make sure to call this after interpolatercolors are set.", args="(particlesys,[float r,g,b,a])", returns="([float r,g,b,a])"},
["probability"] = {type='function', description = " percentage of how many particles are rendered when useprobability is true", args="(particlesys,[float])", returns="([float])"},
["forceload"] = {type='function', description = " forces load of a particlesystem. If the same file was already loaded before, this will create another copy of it.", args="(string filename,[int sortkey])", returns="(Particlesys psys)"},
["particlenormal"] = {type='function', description = " will use particle's normal. Only applied when instancing renderpath is used.", args="(particlesys,[boolean])", returns="([boolean])"},
["useprobability"] = {type='function', description = " if set not all particles are drawn but user given percentage", args="(particlesys,[boolean])", returns="([boolean])"},
["forceinstance"] = {type='function', description = " will use instancing rendering even for the small normally batched billboards", args="(particlesys,[boolean])", returns="([boolean])"},
["checkmin"] = {type='function', description = " returns or sets minimum of the check boundingbox.", args="(particlesys,[float x,y,z])", returns="([float x,y,z])"},
["nogpu"] = {type='function', description = " wont use the default gpu programs", args="(particlesys,[boolean])", returns="([boolean])"},
["volumedistance"] = {type='function', description = " distance from volume center to camera", args="(particlesys,[float])", returns="([float])"},
["intersize"] = {type='function', description = " returns or sets the size multiplier at the particle interpolator step.", args="(particlesys,int step (0..127),[float])", returns="([float])"},
["visflag"] = {type='function', description = " sets visibility bit flag, default is true for id 1 and false for rest. It is bitwise 'and'ed with camera bitid to decide if particles should be drawn.", args="(particlesys,int id,[boolean])", returns="([boolean])"}}}
dspacehash = {type='class',description="Multi-resolution hash table space. This uses an internal data structure that records how each geom overlaps cells in one of several three dimensional grids. Each grid has cubical cells of side lengths 2^i, where i  is an integer that ranges from a minimum to a maximum value. The time required to do intersection testing for n objects is O(n) (as long as those objects are not clustered together too closely), as each object can be quickly paired with the objects around it.",childs={["new"] = {type='function', description = " creates a hashspace, if space is given, the new space is inserted in the given space", args="([dspace space])", returns="(dspacehash)"}}}
dspacequad = {type='class',description="The quadtree is suited for collision that is mostly planar. However the use of this class is not recommend.",childs={["new"] = {type='function', description = " Creates a quadtree space. center and extents define the size of the root block. depth sets the depth of the tree - the number of blocks that are created is 4^depth", args="([dspace space],[float cx,cy,cz, float w,h,d, int depth])", returns="(dspacequad)"}}}
technique = {type='class',description="Techniques are used in shaders and depend on the graphics hardware capabilities.",childs={["arb_vf_tex8"] = {type='function', description = " same as arb_vf with 8 texture images", args="()", returns="(technique)"},
["lowdetail"] = {type='function', description = " lowdetail, overrides all other techniques", args="()", returns="(technique)"},
["cg_sm3"] = {type='function', description = " advanced cg support, shader model 3.0 and 16 texture images", args="()", returns="(technique)"},
["supported"] = {type='function', description = " checks if given technique is supported.", args="(technique)", returns="(boolean)"},
["cg_sm3_tex8"] = {type='function', description = " advanced cg support, shader model 3.0 and 16 texture images", args="()", returns="(technique)"},
["arb_vf"] = {type='function', description = " same as arb_v but with arb_fragmentprograms support, also allows cg useage for better fragmentshaders.", args="()", returns="(technique)"},
["arb_texcomb"] = {type='function', description = " arbitrary texture access in combiners, cubemap textures, dot3 combiner.", args="()", returns="(technique)"},
["cg_sm4"] = {type='function', description = " advanced cg support, shader model 4.0 and 32 texture images", args="()", returns="(technique)"},
["arb_v"] = {type='function', description = " arb_vertexprograms support and arb_texcomb. Basic cg vertex programs are allowed too.", args="()", returns="(technique)"},
["supported_tex4"] = {type='function', description = " checks if given technique is supported with 4 textures.", args="(technique)", returns="(boolean)"}}}
l2dtext = {type='class',description="Displays text on the screen. The Text can be formatted in different ways in order to change its color or textposition: \
* \\vrgb - where r,g,b is replaced by a number between 0 and 9:  The textprint color is replaced by the specified color. For example, this given string would print out different colors: \"\\v900red\\v090green\\v009blue\\v909mangenta\\v990yellow\"\
* \\vc - resets the color to the original color value\
* \\n - starts a new line\
* \\t - inserts a tab character\
* \\vxn; - replace n with a number that specifies an absolute distance in pixels from the left boundary\
* \\vR - aligns the current line to the RIGHT. The widest line of the printed text sets the total width\
* \\vC - aligns the current line centered, works as \\vR\
* \\vs - puts a shadow below the text, used to improve readability. Note that the used font texture can also implement a shadow.\
",childs={["posatchar"] = {type='function', description = " returns the character's position offset. Behaviour undefined if pos>length of text.", args="(l2dtext, int pos)", returns="(float x,y)"},
["text"] = {type='function', description = " returns or sets text", args="(l2dtext,[string])", returns="(string)"},
["fontset"] = {type='function', description = " returns or sets fontset.", args="(l2dtext,[fontset])", returns="(fontset)"},
["font"] = {type='function', description = " returns or sets font texture", args="(l2dtext,[texture])", returns="(texture)"},
["tabwidth"] = {type='function', description = " returns or sets tab width spacing, default is 0. 0 means spacing * 4 is used, otherwise values will be directly applied.", args="(l2dtext,[float])", returns="(float)"},
["spacing"] = {type='function', description = " returns or sets font spacing, default is 16", args="(l2dtext,[float])", returns="(float)"},
["charatpos"] = {type='function', description = " returns character index at given x,y. Returns true / false wether it x,y was inside or not.", args="(l2dtext, float x, float y)", returns="(boolean inside, int charpos)"},
["size"] = {type='function', description = " returns or sets font size, default is 16", args="(l2dtext,[float])", returns="(float)"},
["dimensions"] = {type='function', description = " returns dimension of space it would take when printed", args="(l2dtext)", returns="(float x,y,z)"},
["new"] = {type='function', description = " returns a new l2dtext", args="(string name,string text,[fontset])", returns="(l2dtext)"}}}
vidhint = {type='class',description="The dominant memory update behavior of a vidbuffer. Frequency: * 0 content update very rarely and only used a few times (stream).\
* 1 content update very rarely but used often. (static)\
* 2 content update frequently and used often. (dynamic)\
\
A typical vertexbuffer hint would be draw.1",childs={["draw"] = {type='function', description = " content from application, read by graphics. 0 update rare used rare, 1 update rare, used often, 2 update often used often.", args="(int frequency 0-2)", returns="(vidhint)"},
["copy"] = {type='function', description = " content from graphics, ready by graphics. 0 update rare used rare, 1 update rare, used often, 2 update often used often.", args="(int frequency 0-2)", returns="(vidhint)"},
["read"] = {type='function', description = " content from graphics, read by application. 0 update rare used rare, 1 update rare, used often, 2 update often used often.", args="(int frequency 0-2)", returns="(vidhint)"}}}
dspace = {type='class',description="Spaces are grouping geoms and are doing the collisiondetection on the geoms inside of them. You can insert space into spaces, which should be done for performance reasons. For example, you may want to create a space that does not test it's geoms inside with each other, while it should create with the rest of the environment.",childs={["geomcount"] = {type='function', description = " Return the number of geoms contained within a space.", args="(dspace space)", returns="(int count)"},
["remove"] = {type='function', description = " removes the geom from the space", args="(dspace space, dcollider geom)", returns="()"},
["query"] = {type='function', description = " returns true if the geom is in the space", args="(pscape space, dcollider geom)", returns="(boolean isin)"},
["collidetest"] = {type='function', description = " if collidetest is true, the space's objects are tested against each other. It is usefull to create a 'static' space without collidetest that contains no bodies and inserting this space into a 'dynamic' space that contains bodies. That way, a lot of collisiontesting can be avoided and the simulation runs faster.", args="(dspace space,[int])", returns="([int])"},
["get"] = {type='function', description = " Return the i'th geom contained within the space. i must range from 0 to dSpaceGetNumGeoms()-1.\
If any change is made to the space (including adding and deleting geoms) then no guarantee can be made about how the index number of any particular geom will change. Thus no space changes should be made while enumerating the geoms.\
This function is guaranteed to be fastest when the geoms are accessed in the order 0,1,2,etc.Other non-sequential orders may result in slower access, depending on the internal implementation.", args="(dspace space, int i)", returns="([dcollider])"},
["delete"] = {type='function', description = " destroys a space. If cleanup is true it will delete the geoms that are in the space.", args="(dspace space,[boolean cleanup])", returns="()"},
["add"] = {type='function', description = " adds a geom to the space", args="(dspace space, dcollider geom)", returns="()"}}}
Label = {type='class',description="A Label element for displaying only.",childs={["deleteVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when a Component is no longer displayed", args="(Component self)", returns="()"},
["onGainedFocus"] = {type='function', description = " simply forwards the focus to the next element.", args="(from)", returns="()"},
["LABEL_ALIGNTOP"] = {type='value', description = "[int] - constant for vertical text alignment at top"},
["textDimensions"] = {type='function', description = " returns the text's bounding size (can exceed component's size)", args="(Label,text)", returns="(float,float)"},
["setText"] = {type='function', description = " sets the label's text", args="(Label,string)", returns="()"},
["setFontColor"] = {type='function', description = " sets RGBA font color of the label\
	", args="(r,g,b,a)", returns="()"},
["getText"] = {type='function', description = " returns the string label", args="(Label)", returns="(string)"},
["mouseClicked"] = {type='function', description = " description from overloaded method of Component:\
\
called if the mouse was clicked on the component.", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["new"] = {type='function', description = " creates a labelwith the\
	given dimensions. The align value can be a constant from the Label\
	table (Label_ALIGNRIGHT, ...).", args="(class, int x,y,w,h, text, [align, [autofocus] ])", returns="(Label)"},
["LABEL_ALIGNBOTTOM"] = {type='value', description = "[int] - constant for vertical text alignment at bottom"},
["LABEL_ALIGNLEFT"] = {type='value', description = "[int] - constant for left text alignment"},
["LABEL_ALIGNCENTERED"] = {type='value', description = "[int] - constant for centered text alignment"},
["getAlignment"] = {type='function', description = " returns current alignment of the label's text", args="(Label)", returns="(string alignment)"},
["isFocusable"] = {type='function', description = " returns true if visible", args="(Label)", returns="(boolean)"},
["positionUpdate"] = {type='function', description = " description from overloaded method of Component:\
\
called when the component was moved or resized.\
	Overload this method for visual appearance. The zindex is the id to use for\
	zordering the components. Return the newz value, reserving all the values that\
	you require for your visual nodes.", args="(Component self,int zindex,Rectangle clip)", returns="(int newz)"},
["setAlignment"] = {type='function', description = " sets textalignment, or resets to default (left aligned)", args="(Label,[alignment],[vertical_align])", returns="()"},
["toString"] = {type='function', description = " returns simple component representation", args="(Label)", returns="(string)"},
["onTextChange"] = {type='function', description = " called if the text changed (ie. by user input)", args="(Label)", returns="()"},
["LABEL_ALIGNRIGHT"] = {type='value', description = "[int] - constant for right text alignment"},
["getMaxLines"] = {type='function', description = " gets the maximum number of currently (or for height) visible lines", args="(Label,[height=getHeight])", returns="(lines)"},
["maxLineCount"] = {type='function', description = " uses the current label's font and size to\
	calculate how many lines can be displayed at the moment. The return\
	value is floating point, as lines might not fit in completly.\
	", args="([height])", returns="(float lines)"},
["wrapLine"] = {type='function', description = " uses the current label's font and size to wrap the line by inserting \\n\
	characters. If a width is provided, the wrapping is done using this width\
	", args="(Label,string,[width])", returns="(string)"},
["createVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when a Component is now displayable\
	(doesn't have to be visible)", args="(Component self,l2dnode basel2d)", returns="()"},
["setTabWidth"] = {type='function', description = " sets the label's tabwidth. 0 means fontspacing*4 is used, which is default.", args="(Label,float)", returns="()"},
["getTabWidth"] = {type='function', description = " gets the label's tabwidth.", args="(Label)", returns="(float)"}}}
rcmdcopytex = {type='class',description="Copys drawbuffer to texture",childs={["offset"] = {type='function', description = " returns or sets offset into texture.", args="(rcmdcopytex,[int x,y])", returns="([int x,y])"},
["mipmaplevel"] = {type='function', description = " returns or sets mipmap level.", args="(rcmdcopytex,[int])", returns="([int)"},
["autosize"] = {type='function', description = " returns or sets. 0 off -1 viewsized. Default is -1", args="(rcmdcopytex,[int])", returns="([int])"},
["tex"] = {type='function', description = " returns or sets texture", args="(rcmdcopytex,[texture])", returns="([texture])"},
["screenbounds"] = {type='function', description = " returns or sets area of window to be copied into texture. OpenGL coordinates are used.", args="(rcmdcopytex,[int x,y,w,h])", returns="([int x,y,w,h])"},
["sideordepth"] = {type='function', description = " returns or sets side of texture for cubemaps 0..5, or z slice depth for 3d textures.", args="(rcmdcopytex,[int])", returns="([int)"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdcopytex)"}}}
actornode = {type='class',description="The actorlist is a double linked ring list containing actornodes. The purpose of actors is to provide positional and movement information as dynamic spatialnodes. \
\
Actors are normaly used for objects that are moved around and can be directly linked with dbody objects, which are used in physical simulations.\
\
!!Example\
[img actornode.info.png align='left']A simple visible box, attached to an actor. The visual appearance can be manipulated with the functions listed in the l3dnode or l3dprimitive classes.\
\
 -- connect a l3dprimitive with an actor and use another actor as camera\
 UtilFunctions.simplerenderqueue() actor = actornode.new('actor')\
 actor.l3d = l3dprimitive.newbox('box',1,1,1)\
 actor.l3d:linkinterface(actor) -- connect the box with the actor\
 cam = actornode.new('camera',5,4,3)\
 l3dcamera.default():linkinterface(cam) -- use the cam actornode as camera\
 cam:lookat(0,0,0, 0,0,1) -- look at 0,0,0 and up is 0,0,1\
",childs={["lookat"] = {type='function', description = " rotates actornode to look at a point along defined axis. axis can be 0:x, 1:y (defualt) 2:z.", args="(actornode self, float tox,toy,toz,upx,upy,upz,[int axis 0-2])", returns="()"},
["linkbone"] = {type='function', description = " Links the actor to a certain bone.                                 The position of the actor can not be changed anymore when it is linked. The matrix of a bone                                 is only correct if the l3dnode is visible! Otherwise the behaviour is undefined.", args="(actornode self, l3dmodel model, string bone,[matrix4x4 offset])", returns="()"},
["new"] = {type='function', description = " creates a new actornode (default is drawable at 0,0,0) with the given name", args="(string name,[boolean drawable],[float x,y,z])", returns="(actornode)"},
["rotdeg"] = {type='function', description = " sets/gets rotation in degrees", args="(actornode self, [float x,y,z])", returns="([float x,y,z])"},
["matrix"] = {type='function', description = " sets/gets matrix ", args="(actornode self, [matrix4x4 m])", returns="([matrix4x4 m])"},
["vistestbbox"] = {type='function', description = " sets/gets visibility testing boundingbox when actornode is drawable ", args="(actornode self, [float minX,minY,minZ,maxX,maxY,maxZ])", returns="([float minX,minY,minZ,maxX,maxY,maxZ])"},
["link"] = {type='function', description = " links actornode to given body or                                 unlinks it if other type is given (i.e. boolean) or if nothing is given. An actor can't tell you                                 the body that it is linked to.", args="(actornode, [dgeom/dbody/other])", returns="()"},
["rotaxis"] = {type='function', description = " returns or sets rotation axis, make sure they make a orthogonal basis.", args="(ActorNode self,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])", returns="([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])"},
["rotquat"] = {type='function', description = " sets/gets rotation as quaternion", args="(actornode self, [float x,y,z,w])", returns="([float x,y,z,w])"},
["fromindex"] = {type='function', description = " returns the actornode at the given index. Returns nothing if the index is out of bounds. Index may be negative and will count back from the end of the list then.", args="(int index)", returns="([actornode])"},
["next"] = {type='function', description = " returns the next actornode in the list (which can be the same if only one actornode is present).", args="(actornode)", returns="(actornode)"},
["name"] = {type='value', description = "[string name] name (ActorNode self) - gets the name"},
["prev"] = {type='function', description = " returns the prev actornode in the list (which can be the same if only one actornode is present).", args="(actornode)", returns="(actornode)"},
["rotrad"] = {type='function', description = " sets/gets rotation in radians", args="(actornode self, [float x,y,z])", returns="([float x,y,z])"},
["getcount"] = {type='function', description = " returns the current number of actornodes in the system.", args="()", returns="(int count)"},
["delete"] = {type='function', description = " deletes the actornode", args="(actornode)", returns="()"},
["pos"] = {type='function', description = " sets/gets position", args="(actornode self, [float x,y,z])", returns="([float x,y,z])"}}}
l3dpgroup = {type='class',description="list3d node of a particle group. The group can contain manually spawned particles, which will not perform any additional movement unless user changes them. The particles are transformed with the groups matrix in local types, also the renderscale is applied. There is 4 different types of particlegroups, only local/world allow manual spawning. All particles of the same particlecloud will be rendered at once, to optimize performance you should use as little particleclouds as possible. You can tweak particles appearance individually or update them all in one batch. When they spawn they will get default values, to assign those use 0 as particle in the prt??? functions, to update all particles' attributes you can pass 1 as particle.<br> Automatic particlegroups, such as typeworldref,typemodelvertices,typemodelbones remove their particles when references become invalid.",childs={["prtColor"] = {type='function', description = " gets or sets particle color. particlecloud must have particlecolor flag set to make it use the value.", args="(l3dpgroup,particle,[float r,g,b,a])", returns="([float r,g,b,a])"},
["usedrawlist"] = {type='function', description = " gets or sets if the manual drawlist should be used. You specify the list of particles that should be drawn with the drawlisthead/tail commands.", args="(l3dgroup,[particle])", returns="([particle])"},
["prtSize"] = {type='function', description = " gets or sets particle size.", args="(l3dpgroup,particle,[float])", returns="([float])"},
["prtNext"] = {type='function', description = " returns next particle or null if last. useful for manual iteration.", args="(l3dpgroup,particle)", returns="(particle)"},
["typeworld"] = {type='function', description = " sets the grouptype to WORLD, particle coordinates are in worldspace", args="(l3dgroup)", returns="()"},
["particlecount"] = {type='function', description = " returns current particle count of the group.", args="(l3dgroup)", returns="(int)"},
["typelocal"] = {type='function', description = " sets the grouptype to LOCAL, particle coordinates are in localspace", args="(l3dgroup)", returns="()"},
["rotvar"] = {type='function', description = " gets or sets rotationangle variance for spawned particles. outvalue = random [in-variance,in+variance]", args="(l3dgroup,[float])", returns="([float])"},
["removemulti"] = {type='function', description = " removes multiple particles that fulfill all commands.<br>		The command string specifies what should be compared, and after the string each compare function has a different set of arguments: \
\
		* 't': seqeunce texid (comparemode,int) \
\
		* 'd': distance to point (comparemode,float x,y,z,distance) \
\
		* 's': size (comparemode,float) \
\
		e.g. grp:(\"td\",comparemode.greater(),1,comparemode.less(),1,2,3,100)<br>		kicks all particles with texseqid greater than one and with distance to point(1,2,3) less than 100.", args="(l3dgroup,string cmds, ...)", returns="([int count])"},
["prtNormalworld"] = {type='function', description = " gets or sets particle normal. Make sure to call l3dpgroup.updatetoworld, else positions might not be uptodate.", args="(l3dpgroup,particle)", returns="([float x,y,z])"},
["typemodelvertices"] = {type='function', description = " 		sets the grouptype to LOCAL, particle coordinates are in localspace and taken from the l3dmodel's vertices. 		You can specify how many percent of the mesh's surface you want to put particles on.", args="(l3dgroup,l3dmodel,meshid,float percent)", returns="()"},
["autorot"] = {type='function', description = " gets or sets automatic rotation in radians per second. Set to 0 to disable.", args="(l3dgroup,[float])", returns="([float])"},
["prtPos"] = {type='function', description = " gets or sets particle position, does not allow 'set all'", args="(l3dpgroup,particle,[float x,y,z])", returns="([float x,y,z])"},
["getfirst"] = {type='function', description = " returns first particle", args="(l3dgroup)", returns="(particle)"},
["autoscale"] = {type='function', description = " gets or sets automatic scaling add per second. scale = scale + (autoscale/second)*time", args="(l3dgroup,[float])", returns="([float])"},
["prtSwap"] = {type='function', description = " swaps content of the two particles.", args="(l3dpgroup,particle,particle)", returns="()"},
["prtPosworld"] = {type='function', description = " gets or sets particle world position. Make sure to call l3dpgroup.updatetoworld, else positions might not be uptodate.", args="(l3dpgroup,particle)", returns="([float x,y,z])"},
["typeworldref"] = {type='function', description = " sets the grouptype to WORLD_REFERENCE, particle coordinates are in worldspace, and auto linked to actornode or scenenode.", args="(l3dgroup)", returns="()"},
["new"] = {type='function', description = " new particle group l3dnode. The layer itself isnt important but the l3dset is extracted from it. Particlecloud has a command to define in which layer it should be rendered.", args="(string name,|l3dlayerid layer|,particlecloud)", returns="(l3dgroup)"},
["drawlisthead"] = {type='function', description = " gets or sets particle that serves as head of the drawlist when usedrawlist is enabled. Be aware that there is no error checking if the particle really belongs to this group, you will get undefined behavior if you assign particles from other groups.", args="(l3dgroup,[particle])", returns="([particle])"},
["spawnworldref"] = {type='function', description = " spawns a single particle that is autolinked to the given node. Axis is 0(X),1(Y),2(Z) and will mark the axis used for normals. Particle uses default values for the rest.", args="(l3dgroup,[actornode]/[scenenode],int axis)", returns="(particle)"},
["getparticlecloud"] = {type='function', description = " returns particlecloud of group.", args="(l3dgroup)", returns="(particlecloud)"},
["prtPrev"] = {type='function', description = " returns prev particle or null if first. useful for manual iteration.", args="(l3dpgroup,particle)", returns="(particle)"},
["typemodelbones"] = {type='function', description = " sets the grouptype to LOCAL, particle coordinates are in localspace and taken from the l3dmodel's bonesystem. Axis is 0(X),1(Y),2(Z) and will mark the axis used for normals, stringstack allows up to 128 items. To make sure the bones are updated before the particle group is activated and that their positions match, link the group as children to the l3dmodel.", args="(l3dgroup,l3dmodel,int axis,stringstack)", returns="()"},
["updatetoworld"] = {type='function', description = " transforms all particles to world state, using the current worldmatrix of the l3dpgroup. Can be useful if manual manipulation of the particles needs to be done.", args="(l3dgroup)", returns="()"},
["prtNormal"] = {type='function', description = " gets or sets particle normal, does not allow 'set all'.", args="(l3dpgroup,particle,[float x,y,z])", returns="([float x,y,z])"},
["drawlisttail"] = {type='function', description = " gets or sets particle that serves as trail of the drawlist when usedrawlist is enabled. Be aware that there is no error checking if the particle really belongs to this group, you will get undefined behavior if you assign particles from other groups.", args="(l3dgroup,[particle])", returns="([particle])"},
["autoseq"] = {type='function', description = " gets or sets automatic sequencing, time in ms until the next texid is used, simply loops thru seqeunces in the texture. 0 to disable", args="(l3dgroup,[float])", returns="([float])"},
["remove"] = {type='function', description = " removes the particle, but performs no error checking, so any l3dpgroup could have spawned it belonging to the same particlecloud.", args="(l3dgroup,particle)", returns="()"},
["prtRotangle"] = {type='function', description = " gets or sets particle rotation in radians. particlecloud must have rotate flag set to make it use the value.", args="(l3dpgroup,particle,[float])", returns="([float])"},
["sizevar"] = {type='function', description = " gets or sets size variance for spawned particles. outvalue = random [in-variance,in+variance]", args="(l3dgroup,[float])", returns="([float])"},
["colorvar"] = {type='function', description = " gets or sets color variances. outvalue = random [in-variance,in+variance]", args="(l3dgroup,[float r,g,b,a])", returns="([float r,g,b,a])"},
["prtSeq"] = {type='function', description = " gets or sets particle sequence number, the subtexture to be used if we have a sequencecount greater 1.", args="(l3dpgroup,particle,[int])", returns="([int])"},
["usecolorvar"] = {type='function', description = " gets or sets if colorvariance is used for spawned particles.", args="(l3dgroup,[float])", returns="([float])"},
["spawn"] = {type='function', description = " spawns a single particle, depending on the l3dpgroup type either in object coords or local coords. It will get the default particle values, to set those just pass 0 as particle in the prt??? functions.", args="(l3dgroup,float pos x,y,z,[float normal x,y,z])", returns="(particle)"}}}
dworld = {type='class',description="Luxinia uses only one world (ode can simulate multiple worlds) for the sake of simplicity. The dworld class controls the parameters of the ode object. But it also has some special functions like a surfacemanagement system. You can specify 256 different types of surface parametersets that directly set how contacts will react at each other. Each dgeom has a surfaceid and the combination of the two surfaceids will tell the automatic contactgenerator what set of surfaceparameters should be used.",childs={["contactsurfacelayer"] = {type='function', description = " Set and get the depth of the surface layer around all geometry objects. Contacts are allowed to sink into the surface layer up to the given depth before coming to rest. The default value is zero. Increasing this to some small value (e.g. 0.001) can help prevent jittering problems due to contacts being repeatedly made and broken.", args="([float depth])", returns="([float])"},
["dinfinity"] = {type='function', description = " ODE Infinity value, used by some joints.", args="()", returns="(float)"},
["surfacebitbounce"] = {type='function', description = " If set, the contact surface is bouncy, in other words the bodies will bounce off each other. The exact amount of bouncyness is controlled by the bounce parameter.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["activebodies"] = {type='function', description = " Returns the number of currently active bodies.", args="()", returns="(int)"},
["contactcount"] = {type='function', description = " returns the current number of contacts in the world", args="()", returns="(n)"},
["gravity"] = {type='function', description = " set/get gravity", args="([double x,y,z])", returns="(double x,y,z)"},
["step"] = {type='function', description = " make a step in simulation. We disadvise to use this function unless you are sure about its consequences. Simulations tend to produce strange error messages plus it is slower than quickstep.", args="(float stepsize)", returns="()"},
["maxcollisions"] = {type='function', description = " sets/gets maximum number of traceable collisions. Per default this is 4000.", args="(int size)", returns="([int])"},
["surfacebitfdir"] = {type='function', description = " Compute the fdir vector using the given normals of the geoms.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["surfacebouncevel"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["surfacebitmotion2"] = {type='function', description = " The same thing as above, but for friction direction 2.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["collidetest"] = {type='function', description = " runs collisiondetection on space (and spaces in that space), resets collisionbuffer", args="(dspace space)", returns="()"},
["surfacemu2"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["randomseed"] = {type='function', description = " set/get random seed (for all worlds)", args="([int seed])", returns="([int seed])"},
["surfacebitapprox2"] = {type='function', description = " Use the friction pyramid approximation for friction direction 2. If this is not specified then the constant-force-limit approximation is used (and mu is a force limit).", args="(int surfaceid,[boolean])", returns="([boolean])"},
["jointempty"] = {type='function', description = " Deletes all contact joints, automaticly done by makecontacts", args="()", returns="()"},
["surfacemotion1"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["contactmaxcorrectingvel"] = {type='function', description = " Set and get the maximum correcting velocity that contacts are allowed to generate. The default value is infinity (i.e. no limit). Reducing this value can help prevent \"popping\" of deeply embedded objects.", args="([float])", returns="([float])"},
["surfacecombination"] = {type='function', description = " sets/gets the result for the surfacecombination s1 and s2 (then the surface with surfaceid is selected for the contact parameters. The parameters s1 and s2 are symmetric, so the result for s2 and s1 is the same as for s1 and s2.", args="(int s1,int s2,[int matid])", returns="([int])"},
["count"] = {type='function', description = " returns sum of spaces,geoms,bodies,joints,jointgroups currently in memory", args="()", returns="(int)"},
["surfacefdirmixmode"] = {type='function', description = " The fdirmixmode specifies how the fdir vectors of different geoms should be handled. The mode values are: \
* use higher surfaceid = 0\
* use lower surfaceid = 1\
* use higher fdirpriority of geom = 2\
* use lower fdirpriority of geom = 3\
* use specified ID of surface = 4\
* mix the fdirs by average = 5\
* mix the fdirs using the priorities (prio1+prio2)/prio1*normal1 + (prio1+prio2)/prio2*normal2 = normal = 6\
\
* use higher surfaceid as world coordinates = 7\
* use lower surfaceid as world coordinates = 8\
* use higher priority as world coordinates = 9\
* use lower priority as world coordinates = 10\
* use specified ID of surface = 11\
* use average fdirs as world coordinates = 12\
* mix the fdirs as world coordinates based on priorities = 13\
", args="(int surfaceid,[int mode])", returns="([int])"},
["surfacebitslip1"] = {type='function', description = " Force-dependent-slip (FDS) in friction direction 1.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["get"] = {type='function', description = " each geom,joint and jointgroup (and all child classes) are stored in a global list that can be traversed.", args="(int index)", returns="([dgeom/djoint/djointgroup])"},
["autodisablesteps"] = {type='function', description = " trace depth of activation if an enabled body hits a group of disabled bodies.", args="([int])", returns="([int])"},
["surfaceslip2"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["autodisablevel"] = {type='function', description = " velocity at which the body is disabled.", args="([float])", returns="([float])"},
["getactivebody"] = {type='function', description = " Returns active (enabled) body of given index. 		If the index is larger than the active body count, nil is returned.", args="(int index)", returns="([dbody])"},
["surfaceslip1"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["surfacebitapprox1"] = {type='function', description = " Use the friction pyramid approximation for friction direction 1. If this is not specified then the constant-force-limit approximation is used (and mu is a force limit).", args="(int surfaceid,[boolean])", returns="([boolean])"},
["surfacemotion2"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["surfacesofterp"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["surfacebitsoftcfm"] = {type='function', description = " If set, the constraint force mixing parameter of the contact normal can be set with the soft_cfm parameter. This is useful to make surfaces soft.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["quickstep"] = {type='function', description = " make a quickstep in simulation", args="(float stepsize)", returns="()"},
["iterations"] = {type='function', description = " sets/gets number of iterations for quickstep", args="([int])", returns="([int])"},
["collisionget"] = {type='function', description = " gets two geoms that may are colliding", args="(int index)", returns="([dgeom a,dgeom b])"},
["autodisable"] = {type='function', description = " if switched off, bodies won't be disabled. Disabled bodies are no longer consuming CPU power.", args="([boolean on])", returns="([boolean])"},
["surfacemu"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["surfacebounce"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["makecontacts"] = {type='function', description = " run this after collidetest if you want to autogenerate the contact joints. This will automaticly reset the default contactgroup.\
\
This method may crash if geoms has been deleted between the collidetest and the call on makecontacts. This can happen for example if the garbage collector collects a geom in between. Make sure that if an object is to be deleted, it is gone before you do the collidetest (by calling the :delete() function or enforcing the garbage collection (which is costly))", args="()", returns="()"},
["surfacebitmotion1"] = {type='function', description = " If set, the contact surface is assumed to be moving independently of the motion of the bodies. This is kind of like a conveyor belt running over the surface. When this flag is set, motion1 defines the surface velocity in friction direction 1.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["autodisabletime"] = {type='function', description = " minimum time until a body can be disabled after exceeding one of the thresholds.", args="([float])", returns="([float])"},
["surfacefdirid"] = {type='function', description = " specify the surfaceid of the geom that's fdir normal should be used. If both have the same surface id, the first geom found is used and the outcoming is undefined. The fdirid is only used if the fdirmixmode is set to 4 or 11.", args="(int surfaceid,[int])", returns="([int])"},
["collisioncount"] = {type='function', description = " gets number of calculated collisions", args="()", returns="([int])"},
["surfacesoftcfm"] = {type='function', description = " ", args="(int surfaceid,[float])", returns="([float])"},
["autodisableang"] = {type='function', description = " angular velocity at which the body is disabled.", args="([float])", returns="([float])"},
["surfacebitmu2"] = {type='function', description = " If not set, use mu for both friction directions. If set, use mu for friction direction 1, use mu2 for friction direction 2.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["active"] = {type='function', description = " Sets or gets active dworld. Will be used for all following operations for that world.", args="([dworld])", returns="([dworld])"},
["new"] = {type='function', description = " creates a new world. Can be activated using dworld.active(world). Worlds share surfaceid data.", args="()", returns="(dworld)"},
["surfacebitslip2"] = {type='function', description = " Force-dependent-slip (FDS) in friction direction 2.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["erp"] = {type='function', description = " set/get Error Reduction Parameter (should be 0< erp < 1, default=0.2)", args="([double erp])", returns="(double erp)"},
["surfacebitsofterp"] = {type='function', description = " If set, the error reduction parameter of the contact normal can be set with the soft_erp parameter. This is useful to make surfaces soft.", args="(int surfaceid,[boolean])", returns="([boolean])"},
["cfm"] = {type='function', description = " set/get Constraint force mixing parameter (should be around 10e-9 to 1, default=10e-5)", args="([double cfm])", returns="(double erp)"}}}
dcollresult = {type='class',description="The tesult of manual collision results are stored here. The returned count can be higher thanthe detailed contact info stored within and prevents gc of stored dgeoms.",childs={["clear"] = {type='function', description = " clears contact info, releases dgeoms for gc. (automatically called before each test)", args="(dcollresult)", returns="()"},
["tri"] = {type='function', description = " returns ith triangle sub info.", args="(dcollresult, int index, int subtri)", returns="(int triid, float u, v)"},
["max"] = {type='function', description = " returns maximum contacts", args="(dcollresult)", returns="(int)"},
["contacts"] = {type='function', description = " returns current contact count (may be smaller than returned hit counts).", args="(dcollresult)", returns="(int)"},
["testnear"] = {type='function', description = " tests two dcolliders if they are (have subnodes) near each other (aaboxes overlap).", args="(dcollresult, dcollider, dcollider)", returns="(int count)"},
["complete"] = {type='function', description = " returns whether all contacts were stored.", args="(dcollresult)", returns="(bool)"},
["geoms"] = {type='function', description = " returns ith contact geoms.", args="(dcollresult, int index)", returns="(dgeom,dgeom)"},
["pos"] = {type='function', description = " returns ith contact position", args="(dcollresult, int index)", returns="(float x,y,z)"},
["test"] = {type='function', description = " tests two dcolliders against each other and returns the number of contacts.", args="(dcollresult,dcollider,dcollider)", returns="(int count)"},
["normal"] = {type='function', description = " returns ith contact normal and depth of penetration.", args="(dcollresult, int index)", returns="(float x,y,z, d)"},
["trihits"] = {type='function', description = " returns ith number of tri hits.", args="(dcollresult, int index)", returns="(int)"},
["new"] = {type='function', description = " returns new dcollresult with the given number of maximum contact info. (default is 128)", args="([int maxcontacts])", returns="(dcollresult)"}}}
rcmdfbotex = {type='class',description="Attaches textures to the current bound fbo. By default the drawbuffer is used for assignments.",childs={["readbuffer"] = {type='function', description = " returns or sets whether target is readbuffer fbo binding, or drawbuffer. Readbuffer functionality requires extra capability and by default is off.", args="(rcmdfbobind, [boolean readbuffer])", returns="([boolean readbuffer])"},
["stencil"] = {type='function', description = " returns or sets renderbuffer attachment for stencil target. You can disable assignment by passing 0.", args="(rcmdfbotex,[texture,[int sideordepth],[int miplevel]])", returns="([texture, sideordepth, miplevel])"},
["depth"] = {type='function', description = " returns or sets renderbuffer attachment for depth target. You can disable assignment by passing 0.", args="(rcmdfbotex,[texture,[int sideordepth],[int miplevel]])", returns="([texture, sideordepth, miplevel])"},
["color"] = {type='function', description = " returns or sets renderbuffer attachments for color targets 0..3. You can disable certain assignments by passing 0. sideordepth is the side of a cubemap, or the z slice/layer of a 3d/array texture. Miplevel defaults to 0.", args="(rcmdfbotex,int clr,[texture,[int sideordepth],[miplevel]])", returns="([texture, sideordepth, miplevel])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdfbotex)"}}}
fontset = {type='class',description="It defines how each character of a string is rendered. You can define what grid the font texture has, and which quad of the grid each character takes.",childs={["delete"] = {type='function', description = " deletes the fontset.", args="(fontset)", returns="()"},
["offsety"] = {type='function', description = " returns or sets glyphoffset from topleft", args="(fontset,[float])", returns="([float])"},
["new8x8"] = {type='function', description = " returns a new fontset with default values.", args="()", returns="(fontset)"},
["maxcharacters"] = {type='function', description = " returns how many gridfields exist.", args="(fontset)", returns="(int)"},
["getdefault"] = {type='function', description = " returns default fontset, you shouldnt change it as console and other drawings rely on it.", args="()", returns="(fontset)"},
["lookup"] = {type='function', description = " returns or sets which grid field should be used for this character. gridfield must be between 0 and maxcharacters", args="(fontset,int character,[int gridfield])", returns="(int)"},
["new16x16"] = {type='function', description = " returns a new fontset with default values.", args="()", returns="(fontset)"},
["new6x6"] = {type='function', description = " returns a new fontset with default values.", args="()", returns="(fontset)"},
["linespacing"] = {type='function', description = " returns or sets size of a line, default is 16", args="(fontset,[float])", returns="([float])"},
["width"] = {type='function', description = " returns or sets character width (0-1).", args="(fontset,int character,[float width])", returns="([int])"},
["offsetx"] = {type='function', description = " returns or sets glyphoffset from topleft", args="(fontset,[float])", returns="([float])"},
["ignorespecials"] = {type='function', description = " returns or sets if special command characters suchs as \\n should be ignored.", args="(fontset,[boolean])", returns="([boolean])"},
["new"] = {type='function', description = " returns a new fontset with default values. Allowed values for size are 6, 8 and 16. Size denotes the number of rows and columns in the fonttexture, which results in the number of glyphs for the font (36, 64 or 256).", args="([int size=16])", returns="(fontset)"}}}
TitleFrame = {type='class',description="TitleFrames are containers with an initial skin. Following skinnames are being used:\
\
	* titleframe\
	* titleframe_hover\
	* ...",childs={["setTitleAlign"] = {type='function', description = " sets titlecaption alignment. Can be either\
	Skin2D.ALIGN.LEFT, Skin2D.ALIGN.RIGHT or Skin2D.ALIGN.CENTERED or a number\
	for the absolute x coordinate.", args="(TitleFrame,align)", returns="(TitleFrame)"},
["setTitle"] = {type='function', description = " sets titlecaption", args="(TitleFrame,text)", returns="(TitleFrame)"},
["new"] = {type='function', description = "\
	creates a container with the given bounds. If no skin is given the\
	default skin for frames is being used.", args="(table class, int x,y,w,h,[Skin2D skin],[string title])", returns="(TitleFrame)"}}}
l2dflag = {type='class',description="list2d node that does only set some rendering parameters",childs={["new"] = {type='function', description = " returns a new l2dflag", args="(string name)", returns="(l2dflag)"}}}
material = {type='class',description="To allow more complex surface detail than just simple textures, materials		can be used to have more control over the surface. Every material consists of a shader		which defines how textures are blend, and textures or color definitions.<br>		See the mtlscript manual for more details.",childs={["getalphatex"] = {type='function', description = " returns texture and alphatesting info if the shader supports it (alphaTEX defined).", args="(material,[int sid])", returns="([texture,comparemode,float ref,int texchannel])"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["getshdcontrol"] = {type='function', description = " returns matshdcontrolid, if found.", args="(material,string name)", returns="([matshdcontrolid])"},
["gettexcontrol"] = {type='function', description = " returns mattexcontrolid, if found.", args="(material,string name)", returns="([mattexcontrolid])"},
["name"] = {type='function', description = " returns the name of the loaded material.", args="(material)", returns="(string)"},
["getshader"] = {type='function', description = " returns a shader, optional shader id can be given, defaults to 0", args="(material,[int sid])", returns="(Shader)"},
["annotation"] = {type='function', description = " searches and returns annotation string", args="(material, string name)", returns="([string])"},
["getcontrol"] = {type='function', description = " returns matcontrolid, if found.", args="(material,string name)", returns="([matcontrolid])"},
["load"] = {type='function', description = " loads a material. Optionally can pass compilerstrings, eg. \"-DSOMETHING;\". You can create a simple material with a special filename when it starts with 'MATERIAL_AUTO:'. What follows in the string should be a pipe '|' separated list of .shd or texture filenames that make the shader/texture stages. Their ids are linearly generated. For textures you can put the special texturetype before, as defined in mtl-format.		<br><br>For example: \"MATERIAL_AUTO:myshader.shd|mytexture.jpg|TEXDOTZ anothertex.tga\" generates a simple material using the given shader and the 2 textures from which one is a special texture.", args="(string filename,[compilerargs])", returns="(Material mtl)"},
["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"}}}
VFSmapper = {type='class',description="The Virtual File System mapper package provides access on files by\
which may either exist in directories of the harddisc or in zip file\
archives. Overloads loadfile/dofile in order to load lua source\
code from zip archives as well. Further filehandlers can be added\
during runtime which allows loading files from different locations\
(i.e. Network) as well.\
",childs={["removeCallback"] = {type='function', description = " removes the given function\
	from the callback list.", args="(function func)", returns="()"},
["dir"] = {type='function', description = " iterates the content of the given\
	directoryname. Even if the directory does not exist, it will return\
	a function that returns nil. Overloads lfs/FileSystem.dir to use this\
	function.", args="(dirname)", returns="(func iterator)"},
["removeZip"] = {type='function', description = " remove a zipfile from the list", args="(file)", returns="()"},
["addZip"] = {type='function', description = " adds a file to the list\
	of zip archives that are browsed for requested files. If the\
	given file could not be opened as zip file, it returns false\
	and the reported error string.", args="(file)", returns="(result,[error])"},
["ziploader"] = {type='function', description = " callback function\
	for that is automaticly added to the list of callbacks. Handles\
	the zipfile loading.", args="(file,read)", returns="(exists/filecontent)"},
["addCallback"] = {type='function', description = " adds a callback\
	function that is called when a file should be loaded. It receives\
	two arguments: the filname to be looked for and a boolean value if\
	it should be read and returned:\
\
	 function func (filename, read)\
	   return read and (read the file content) or (true if it exists)\
	 end\
\
	If the function returns nil (nothing), further callback functions\
	are called. If it returns false, it is assumed that the file does\
	not exist. If it returns true, the file exists and it should be\
	possible to return the content as well if needed.\
\
	Luxinia checks if a file exists before it trys to open it. If\
	this callback returns true, it MUST be able to return the filecontent\
	if requested. Otherwise Luxinia might crash. This callback might\
	be extended in near future to determine the filetype as well by\
	returning the filetype.", args="(function func)", returns="(function func)"}}}
rcmdforceflag = {type='class',description="Sets enforced renderflag",childs={["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdforceflag)"}}}
morphcontrol = {type='class',description="To add morph effects between models or meshes.		Morphing is done between vertex normal, position and color info. Activate it on l3dmodels.",childs={["delete"] = {type='function', description = " deactivates and deletes the morphcontrol", args="(morphcontrol)", returns="()"},
["meshtarget"] = {type='function', description = " sets mesh that will get morphed", args="(morphcontrol,meshid)", returns="()"},
["modelto"] = {type='function', description = " sets model to morph to, if a none-model is passed we will use previous morph results", args="(morphcontrol,model)", returns="()"},
["newmeshmorph"] = {type='function', description = " only a single mesh will get morphed", args="()", returns="(morphcontrol)"},
["deactivate"] = {type='function', description = " deactivates the morph effect", args="(morphcontrol)", returns="()"},
["factor"] = {type='function', description = " sets or returns the blend factor of the morph", args="(morphcontrol,float)", returns="(float)"},
["meshto"] = {type='function', description = " sets mesh to morph to", args="(morphcontrol,meshid)", returns="()"},
["meshfrom"] = {type='function', description = " sets mesh to morph from", args="(morphcontrol,meshid)", returns="()"},
["newforceall"] = {type='function', description = " we will always use the vertices in the modeulupdate container.", args="()", returns="(morphcontrol)"},
["modelfrom"] = {type='function', description = " sets model to morph from, if a none-model is passed we will use previous morph results", args="(morphcontrol,model)", returns="()"},
["newfullmorph"] = {type='function', description = " all meshes are affected by the morph", args="()", returns="(morphcontrol)"},
["activate"] = {type='function', description = " activates the morph effect on the given l3dmodel", args="(morphcontrol,l3dmodel)", returns="()"}}}
rcmdreadpixels = {type='class',description="Allows storage of drawn pixels into a vidbuffer.",childs={["buffer"] = {type='function', description = " returns or sets vidbuffer used for storage.", args="(rcmdreadpixels,[vidbuffer,[int offset]])", returns="([vidbuffer,offset])"},
["rect"] = {type='function', description = " returns or sets the screen rectangle used to read from.", args="(rcmdreadpixels,[int x,y,w,h])", returns="([int x,y,w,h])"},
["format"] = {type='function', description = " sets whicht data and in what format it is read.", args="(rcmdreadpixels,textype,texdatatype)", returns="()"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdreadpixels)"}}}
TextField = {type='class',description="A textfield element for usertextinput. Textfields have following skinsurfaces:\
	* textfield\
	* textfield_hover\
	* textfield_focus\
	* textfield_disabled\
	",childs={["setPasswordChar"] = {type='function', description = " if a character is passed, this character is used as character\
	for each typed character, like a passwordfield. to deactivate this, pass nothing", args="(TextField, [char])", returns="()"},
["positionUpdate"] = {type='function', description = " description from overloaded method of Component:\
\
called when the component was moved or resized.\
	Overload this method for visual appearance. The zindex is the id to use for\
	zordering the components. Return the newz value, reserving all the values that\
	you require for your visual nodes.", args="(Component self,int zindex,Rectangle clip)", returns="(int newz)"},
["setCursorCaretPosAtXY"] = {type='function', description = "\
	sets caret position to local pixel coordinate. If a fourth argument is passed and\
	is true, the selectionstart is not repositioned.", args="(TextField,x,boolean ignoreselectionstartset)", returns="()"},
["TEXTFIELD_ALIGNCENTERED"] = {type='value', description = "[int] - constant for centered text alignment"},
["mousePressed"] = {type='function', description = " description from overloaded method of Component:\
\
called if the mouse was pressed on the component. If mouseover is true,\
	the mouse is actually on THIS component and not on one of its childs,\
	which will create events too.", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["TEXTFIELD_ALIGNLEFT"] = {type='value', description = "[int] - constant for left text alignment"},
["pasteText"] = {type='function', description = "\
	paste text from clipboard in textfield and overwrite the selection", args="(TextField)", returns="()"},
["disablekeybinds"] = {type='value', description = "[boolean]=true - any component having this key will disable the keybinding (managed by the container think function)"},
["onTextChanged"] = {type='function', description = " called if the text changed (ie. by user input).", args="(TextField)", returns="()"},
["copyText"] = {type='function', description = "\
	Copy selected text in textfield into clipboard.", args="(TextField)", returns="()"},
["insertText"] = {type='function', description = " inserts the text at the specified\
	index. Returns the index at which the insertion stoped.", args="(TextField, string tx, int at)", returns="(int)"},
["new"] = {type='function', description = " creates a textfield with the\
	given dimensions. The align value can be a constant from the TextField\
	table (TEXTFIELD_ALIGNRIGHT, ...).", args="(class, int x,y,w,h, align)", returns="(TextField)"},
["setText"] = {type='function', description = " sets text of the textfield,\
	causes onTextChanged call. If donnotfireevent is true, the onTextChanged\
	function is not called.", args="(TextField,string,[boolean donnotfireevent])", returns="()"},
["getCursorCaretPosAtXY"] = {type='function', description = "\
	converts relative pixel coordinate in caret position ", args="(TextField,x)", returns="(x)"},
["getTextLength"] = {type='function', description = " returns number of chars", args="(TextField)", returns="(int length)"},
["getText"] = {type='function', description = " returns the text of the textfield, if\
	bounds are given it returns the text within that range", args="(TextField,[from,[to] ])", returns="(string)"},
["isFocusable"] = {type='function', description = " returns true if visible", args="(TextField)", returns="(boolean)"},
["toString"] = {type='function', description = " returns simple component representation", args="(TextField)", returns="(string)"},
["mouseReleased"] = {type='function', description = " description from overloaded method of Component:\
\
called if the mouse was released on the component", args="(Component self, MouseEvent e, boolean mouseover)", returns="()"},
["TEXTFIELD_ALIGNRIGHT"] = {type='value', description = "[int] - constant for right text alignment"},
["onAction"] = {type='function', description = " called if the user pressed enter. Overload this to react on this", args="(TextField, String text)", returns="()"},
["deleteVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when a Component is no longer displayed", args="(Component self)", returns="()"},
["onKeyTyped"] = {type='function', description = " called if a key was typed on the textfield.", args="(TextField, KeyEvent)", returns="()"},
["replaceText"] = {type='function', description = " returns true if visible", args="(TextField)", returns="(boolean)"},
["cutText"] = {type='function', description = "\
	Cut selected text in textfield into clipboard, deleting the selected text.", args="(TextField)", returns="()"},
["createVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when a Component is now displayable\
	(doesn't have to be visible)", args="(Component self,l2dnode basel2d)", returns="()"},
["showVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when visible objects (l2ds) are now visible", args="(Component self)", returns="()"},
["hideVisibles"] = {type='function', description = " description from overloaded method of Component:\
\
called when visible objects (l2ds) are no longer visible", args="(Component self)", returns="()"}}}
animation = {type='class',description="The animation contains tracks which store position, rotation and scale changes over time.		Such a tripple is called a prskey. You can use animations on bonesystems found in l3dmodels,		or evaluate prskey states for given times manually. The current interpolation and updatetype is copied when assigned to a bonesystem. Therefore same animation can be used with different interpolation or update definitions.",childs={["loaderprescale"] = {type='function', description = " prescales bone positions with a given vector. The factor remains active for all follwing 'animation.load' calls. Prescale will be reapplied if the anim is reloaded from disk again.", args="([float x,y,z])", returns="([float x,y,z])"},
["trackcount"] = {type='function', description = " returns number of tracks within the animation", args="(animation)", returns="(int)"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["splineinterpolation"] = {type='function', description = " sets or gets if animation uses spline interpolation for position between keys.", args="(animation,[boolean])", returns="(boolean)"},
["gettrack"] = {type='function', description = " returns trackid of track within animation", args="(animation,string trackname/ int number)", returns="([trackid])"},
["rotonlyupdate"] = {type='function', description = " sets or gets if animation calculates only the rotation keys.", args="(animation,[boolean])", returns="(boolean)"},
["length"] = {type='function', description = " returns animation length in ms", args="(animation)", returns="(int)"},
["load"] = {type='function', description = " loads a animation with given properties. default: spline=true, rotationonly=false", args="(string filename,[boolean splineinterpolation],[boolean rotationonly])", returns="([animation])"},
["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"}}}
rcmdignore = {type='class',description="Ignore certain properties",childs={["lights"] = {type='function', description = " returns or sets if lights should be turned off.", args="(rcmdignore,[boolean])", returns="([boolean])"},
["projectors"] = {type='function', description = " returns or sets if projectors should be disabled.", args="(rcmdignore,[boolean])", returns="([boolean])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdignore)"}}}
matcontrolid = {type='class',description="matcontrolid to access material control values in matobjects",childs={}}
GroupFrame = {type='class',description="Groupframes are containers with an initial skin",childs={["new"] = {type='function', description = " \
	creates a container with the given bounds. If no skin is given the \
	default skin for frames is being used.", args="(table class, int x,y,w,h,[Skin2D skin])", returns="(GroupFrame)"}}}
rcmdshadersoff = {type='class',description="Disables use of l3dview baseshaders",childs={["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdshadersoff)"}}}
texcombsrc = {type='class',description="The texcombiner source for the function specifies where values should be taken from.",childs={["texture2"] = {type='function', description = " texture at unit 2 (needs crossbar capability / higher technique than default)", args="()", returns="(texcombsrc)"},
["texture1"] = {type='function', description = " texture at unit 1 (needs crossbar capability / higher technique than default)", args="()", returns="(texcombsrc)"},
["vertex"] = {type='function', description = " vertex color/alpha", args="()", returns="(texcombsrc)"},
["constant"] = {type='function', description = " constant value (texture env color)", args="()", returns="(texcombsrc)"},
["previous"] = {type='function', description = " previous result", args="()", returns="(texcombsrc)"},
["texture0"] = {type='function', description = " texture at unit 0 (needs crossbar capability / higher technique than default)", args="()", returns="(texcombsrc)"},
["texture3"] = {type='function', description = " texture at unit 3 (needs crossbar capability / higher technique than default)", args="()", returns="(texcombsrc)"},
["texture"] = {type='function', description = " current texture", args="()", returns="(texcombsrc)"}}}
meshtype = {type='class',description="The meshtype defines how a mesh's vertex and indexdata is stored for display. Depending on system different capabilities exist.",childs={["ram"] = {type='function', description = " Stored in regular ram, submitted with each drawcall. Slow for lots of data, but allows easy changes.", args="()", returns="(meshtype)"},
["vbo"] = {type='function', description = " Store in bufferobjects in video/driver ram. Updates to local data", args="()", returns="(meshtype)"},
["displaylist"] = {type='function', description = " Store in displaylist in video ram. All needed attributes are stored along. Local copy is kept in ram as well.", args="()", returns="(meshtype)"},
["auto"] = {type='function', description = " Either unset or pick 'best' depending on current material assignments.", args="()", returns="(meshtype)"}}}
Object = {type='class',description="	Parent class of all OO classes. The object oriented system\
	is an implementation for an object oriented like programming\
	in lua. The Object class provides some basic functionality.\
	",childs={["getParentClass"] = {type='function', description = " returns the parent class, if it exists (Object\
			does not have a parent class, any other class does).\
		", args="(object)", returns="([class])"},
["getTypeName"] = {type='function', description = " returns name of the class\
		", args="(object)", returns="(string)"},
["getClass"] = {type='function', description = " returns class object\
		", args="(object)", returns="(class)"},
["id"] = {type='value', description = "			int id - a counter that is incremented by 1 whenever an object is\
			created\
		"},
["toString"] = {type='function', description = " returns a string code for the given\
			object, you can overload this in order to provide your\
			own identification of objects.\
		", args="(object)", returns="(string)"}}}
scalararray = {type='class',description="Scalarrays are created as plain C arrays within luxinia. 		They can be used for operations that require lot's of 		calculations or are used by other native C functions. They can be 1D,2D or 3D similar to textures and contain 1-4 component vectors. 		<br><br>Normally the arrays have a memorychunk and you can set the 'region' of operation within this chunk via offset, size and stride. 		<br><br>'Mounted' arrays, however do not have their own allocated data, but directly 		operate on their host data. Be aware that there is no mechanism to check whether internal host is still valid, you will 		need to do this yourself.",childs={["scalartype"] = {type='function', description = " gets or sets current scalartype. Changing can influence size as types have different memcosts.", args="(scalararray, [scalartype])", returns="([scalartype])"},
["op1"] = {type='function', description = " performs a single operation into out. Returns self on success.", args="(scalararray out,scalarop,scalararray/values)", returns="(scalararray)"},
["convert"] = {type='function', description = " Straight converts current vector count from one scalararray (different types allowed) to another", args="(scalararray to, scalararray from)", returns="(scalararray to)"},
["curvelinear"] = {type='function', description = " creates linear interpolated curve/line based from the key segment points. Closed is false by default. Make sure vectorsizes are equal and out array has higher count than key array.", args="(scalararray out, scalararray keys, [boolean closed])", returns="(scalararray)"},
["ftransformrot"] = {type='function', description = " rotates the vectors (size must 2,3 or 4) with given matrix. Input and output array can be same.", args="(scalararray outfloats, scalararray floats, matrix44)", returns="(scalararray)"},
["fnormalizeacc"] = {type='function', description = " normalizes the vectors to unit-length. Accurate version. Input and output array can be same.", args="(scalararray outfloats, scalararray floats)", returns="(scalararray)"},
["op0"] = {type='function', description = " performs a single operation. Returns self on success.", args="(scalararray,scalarop)", returns="(scalararray)"},
["offset"] = {type='function', description = " gets or sets sets access pointer from current memchunk start. Must be within current size.", args="(scalararray, [int w,h,d])", returns="([int w,h,d])"},
["mountscalararray"] = {type='function', description = " returns a new mounted array on the current's content. Mounting a scalararray from another will make sure the data stays valid, as it prevents host's gc. The maximum size you can operate with, is taken at the moment the mount happens using active offset,stride and count. Resizing host via maxscalars will cause crashes!", args="(scalararray)", returns="(scalararray)"},
["op0region"] = {type='function', description = " performs a single operation. Returns self on success.", args="(scalararray,scalarop, int w,h,d)", returns="(scalararray)"},
["newfrompointer"] = {type='function', description = " returns a new mounted scalar array. vectorsize defaults to 1 and stride equals vectorsize. You must make sure the pointer is and stays valid. If endpointer is given count is derived from the remaining attributes.!", args="(pointer start, [int count / pointer end], scalartype, [vectorsize], [vecotrstride])", returns="([scalararray])"},
["asstring"] = {type='function', description = " returns the current content (size,type,offset...) as binary string.", args="(scalararray)", returns="(binstring)"},
["ftransformfull"] = {type='function', description = " homogeneously transforms the vectors (size must 2,3 or 4) with given matrix. Vectorsize of 2 and 3 will be divided by w coordinate. Input and output array can be same.", args="(scalararray outfloats, scalararray floats, matrix44)", returns="(scalararray)"},
["sample"] = {type='function', description = " samples data with given texcoord, always returns float interpolated data. Unclamped is true by default.", args="(scalararray,float x,y,z, [boolean unclamped])", returns="([float values...)"},
["datastart"] = {type='function', description = " gets or sets startpoint in bytes. The startpoint is the base from which offsets are applied. Useful for accessing individual components. Will keep size and reapply offset from new startpoint.", args="(scalararray, [int bytes])", returns="([int bytes])"},
["datapointer"] = {type='function', description = " you can access the memory directly in other lua dlls. Be aware that you must make sure not to corrupt memory, make sure you are always smaller than the 'end' pointer.", args="(staticarray self)", returns="(pointer start, end, sarray3dstruct)"},
["mounted"] = {type='function', description = " returns whether array is mounted, i.e. points to external memory. When mounted to internal data, its rather unsafe to change sizes or strides.", args="(scalararray)", returns="(boolean)"},
["datasize"] = {type='function', description = " gets or sets maximum number of bytes. If keep is true (default false) then old data is preserved (can be slower). Decreasing can result into error if current size and stride settings are beyond new datasize. Offset and datashift will be reseted.", args="(scalararray, [int bytes],[boolean keep])", returns="([int bytes]/[boolean kept])"},
["curvespline"] = {type='function', description = " creates catmull rom spline interpolated curve/line based from the key segment points. Closed is false by default. Make sure vectorsizes are equal and out array has higher count than key array.", args="(scalararray out, scalararray keys, [boolean closed])", returns="(scalararray)"},
["vectorat"] = {type='function', description = " assigns vector at the given position the float/int value if 		given or simply returns the value at the position. Returns error in case of invalid position address (< 0 or > size).", args="(scalararray,x,y,z,[values...])", returns="([values...])"},
["vector"] = {type='function', description = " assigns i-th vector the float/int value if 		given or simply returns the value at the index. Returns error in case of invalid indices (< 0 or > count).", args="(scalararray,index,[values...])", returns="([values...])"},
["op3region"] = {type='function', description = " performs a triple operation int out. Returns self on success.", args="(scalararray out,int w,h,d, scalarop, scalararray,scalararray,scalararray/values)", returns="(scalararray)"},
["vectorall"] = {type='function', description = " assigns all vectors the float/int values", args="(scalararray,[values...])", returns="()"},
["new"] = {type='function', description = " returns a new compact scalar array. vectorsize defaults to 1 and stride equals vectorsize.", args="(scalartype, int count, [vectorsize])", returns="([scalararray])"},
["ftransform"] = {type='function', description = " transforms the vectors (size must 2,3 or 4) with given matrix. For Vector4 ignores W. Input and output array can be same.", args="(scalararray outfloats, scalararray floats, matrix44)", returns="(scalararray)"},
["fnormalize"] = {type='function', description = " normalizes the vectors to unit-length. Fast version less accurate, output length may not exactly be 1. Input and output array can be same.", args="(scalararray outfloats, scalararray floats)", returns="(scalararray)"},
["vectorstride"] = {type='function', description = " gets or sets current vector stride. This must be zero or vectorsize as minimum, but can be greater for interleaved data. Using zero allows to create virtually any sizes from a single vector.", args="(scalararray, [int])", returns="([int])"},
["fromstring"] = {type='function', description = " copies the data from a binary string. Copies as much as possible, ignores dataoffset. Will throw error if stride does not match vectordim.", args="(scalararray, binstring, [byteoffset])", returns="()"},
["convertranged"] = {type='function', description = " Straight converts current vector count from one scalararray (different types allowed) to another. And ranges input and output values accordingly. values are int/float.", args="(scalararray to, value tomin, tomax, scalararray from, value frommin, frommax)", returns="(scalararray to)"},
["count"] = {type='function', description = " returns maximum number of current affected vectors (takes size and offset into account)", args="(scalararray)", returns="(int)"},
["op2region"] = {type='function', description = " performs a dual operation into out. Returns self on success.", args="(scalararray out,int w,h,d, scalarop, scalararray,scalararray/values)", returns="(scalararray)"},
["vectorsize"] = {type='function', description = " gets or sets current vector dimension. Raising may cause vectorstride to change.", args="(scalararray, [int])", returns="([int])"},
["mountstaticarray"] = {type='function', description = " returns a new mounted array on the current's content. Mounting a staticarray from another will make sure the data stays valid, as it prevents host's gc. The maximum size you can operate with, is taken at the moment the mount happens using active offset,stride and count. Resizing host via maxscalars will cause crashes!", args="(scalararray)", returns="(floatarray/intarray)"},
["op3"] = {type='function', description = " performs a triple operation int out. Returns self on success.", args="(scalararray out,scalarop,scalararray,scalararray,scalararray/values)", returns="(scalararray)"},
["op2"] = {type='function', description = " performs a dual operation into out. Returns self on success.", args="(scalararray out,scalarop,scalararray,scalararray/values)", returns="(scalararray)"},
["size"] = {type='function', description = " gets or sets current total dimension of used elements. Will throw error if datasize isnt sufficient for current vectorsize and vectorstride. Setting will reset offset to 0,0,0.", args="(scalararray, [int w,h,d])", returns="([int w,h,d])"},
["op1region"] = {type='function', description = " performs a single operation into out. Returns self on success.", args="(scalararray out, int w,h,d, scalarop, scalararray/values)", returns="(scalararray)"}}}
rendermesh = {type='class',description="This class allows creation of custom meshes with all supported primitivetypes. Typically usermeshes are created 'in place' for l3dprimitive, l2dimage and rcmddrawmesh. But you can generate them externally and share as well.",childs={["new"] = {type='function', description = " used for vertex attribute streams. Needs VBO capability():(l3dprimitive, vertextype, int numverts, int numindices, [vidbuffer vbo], [int vbooffset], [vidbuffer ibo], [int ibooffset]) - gives the l3dprimitive a unique mesh.The new rendermesh is completely empty, so make sure you fill it with content before it gets rendered the first time (use indexarray and vertexarray interfaces). You can pass vidbuffers for content as well. Uses the byte offset passed to the buffers or (-1) allocates from the buffer. Allocation is useful if multiple meshes shall reside in same vidbuffers, manual offset is needed if you want to make use of instancing the same buffer content multiple time.Don't forget to set indexCount and vertexCount and at the end indexMinmax, if you use indices! When VBOs are passed then the corresponding memory will not exist in system memory, which means accessing individual indices and vertices via indexarray and vertexarray will not work directly.", args="(vertextype, int vertices, indices, [vidbuffer vbo], [int offset], [vidbuffer ibo],[int offset])", returns="()"}}}
rcmddrawbg = {type='class',description="Draws the background (skybox) of the current l3dview",childs={["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmddrawbg)"}}}
l3dtrail = {type='class',description="Contains a collection of points, that are rendered as a quad strip.",childs={["recompile"] = {type='function', description = " tells trail mesh to be recompiled. Useful if mounted arrays modify trail data.", args="(l3dtrail)", returns="()"},
["normalizedsize"] = {type='function', description = " sets or returns size of an absolute ulength when materialnormalized is used (0 disables).", args="(l3dtrail,[float])", returns="([float])"},
["color"] = {type='function', description = " sets or returns color interpolater at step. There is 0-2 steps, step 3 or -1 sets all.", args="(l3dtrail,int step,[float r,g,b,a])", returns="([float r,g,b,a])"},
["drawlength"] = {type='function', description = " sets or return drawlength of trail", args="(l3dtrail,[int])", returns="([int])"},
["memto_size0"] = {type='function', description = " byte offset within tpoint to size scaler (will not belong to the trailpoint, but stored interleaved).", args="()", returns="(int bytes)"},
["usevelocity"] = {type='function', description = " sets or returns if velocity vector should be added", args="(l3dtrail,[boolean])", returns="([boolean])"},
["tpIndex"] = {type='function', description = " gets offset within trailpoint memory.", args="(l3dtrail,trailpoint)", returns="(int index)"},
["typeworld"] = {type='function', description = " local transforms are not used on the points, ie all points are in world coordinates. You should do this after a new trail, or after resetting. (default)", args="(l3dtrail)", returns="()"},
["memtonext"] = {type='function', description = " size of the trailpoint structure.", args="()", returns="(int bytes)"},
["tpPosarray"] = {type='function', description = " sets or returns position of active trailpoints from floatarray", args="(l3dtrail,[floatarray 3t])", returns="([floatarray 3t])"},
["typelocal"] = {type='function', description = " local transforms are used on the points, ie points are in local coordinates. You should do this after a new trail, or after resetting. It does not allow spawnstep.", args="(l3dtrail)", returns="()"},
["size"] = {type='function', description = " sets or returns size interpolater at step. There is 0-2 steps, step 3 or -1 sets all.", args="(l3dtrail,int step,[float size])", returns="([float s])"},
["materialnormalized"] = {type='function', description = " sets or returns if the material/texture is stretched in such a fashion that its width is the length of the trail. If materialscale was applied before uscale will be applied, too.", args="(l3dtrail,[boolean])", returns="([boolean])"},
["memtovel"] = {type='function', description = " byte offset within tpoint to velocity (float3, SSE aligned, w can be overwritten) ", args="()", returns="(int bytes)"},
["indexcolor"] = {type='function', description = " sets or returns color at index. There is 0...length-1 steps. The regular color function creates linear interpolated values. This function lets you precisely modify every single value. However if you start using it, the regular color function will be ignored", args="(l3dtrail,int step,[float r,g,b,a])", returns="([float r,g,b,a])"},
["materialscale"] = {type='function', description = " sets how often a material/texture is repeated/minified. length is along x axis ", args="(l3dtrail,float length, width)", returns="()"},
["closed"] = {type='function', description = " sets or returns if trail ends where it starts. The last added point will be skipped and the first is used instead, so add one more point than the ones you really need.", args="(l3dtrail,[boolean])", returns="([boolean])"},
["memtopos"] = {type='function', description = " byte offset within tpoint to position (float3, SSE aligned, w can be overwritten ", args="()", returns="(int bytes)"},
["memto_size1"] = {type='function', description = " byte offset within tpoint to size scaler (will not belong to the trailpoint, but stored interleaved). Size1 is always multiplied by -1.", args="()", returns="(int bytes)"},
["localtime"] = {type='function', description = " sets or returns trail's own localtime (in ms). Only active when uselocaltime is used.", args="(l3dtrail,[int])", returns="([int])"},
["reset"] = {type='function', description = " clears all points", args="(l3dtrail)", returns="()"},
["tpVelarray"] = {type='function', description = " sets or returns velocity of active trailpoints from floatarray", args="(l3dtrail,[floatarray 3t])", returns="([floatarray 3t])"},
["planarmap"] = {type='function', description = " sets or returns planar projection axis. -1 is none/disabled, 0 = x, 1 = y, z = 2. Materials will be projected along these axis.", args="(l3dtrail,[int])", returns="([int])"},
["planarscale"] = {type='function', description = " sets or returns planarscale multiplier. texcoord = worldpos.projected * planarscale.", args="(l3dtrail,[float])", returns="([float])"},
["facecamera"] = {type='function', description = " sets or return facecamera flag", args="(l3dtrail,[bool])", returns="([bool])"},
["firstpoint"] = {type='function', description = " returns first trailpoint", args="(l3dtrail)", returns="([trailpoint])"},
["uselocaltime"] = {type='function', description = " sets or returns if trail uses its own localtime (in ms). If false(default) the global time by luxinia is used. All events such as spawstep, usevelocity and spawntime for manually created tpoints depend on this.", args="(l3dtrail,[boolean])", returns="([boolean])"},
["new"] = {type='function', description = " a new trail system", args="(string name,|l3dlayerid|,int length)", returns="(trail)"},
["indexsize"] = {type='function', description = " sets or returns size at index. There is 0...length-1 steps. The regular size function creates linear interpolated values. This function lets you precisely modify every single value. However if you start using it, the regular size function will be ignored.", args="(l3dtrail,int step,[float r,g,b,a])", returns="([float r,g,b,a])"},
["spawnworldref"] = {type='function', description = " spawns a single particle that is autolinked to the given node. Axis is 0(X),1(Y),2(Z) and will mark the axis used for normals. Only works if typeworldref is used.", args="(l3dtrail,actornode/scenenode,int axis)", returns="(trailpoint)"},
["tpVel"] = {type='function', description = " gets or sets trailpoint's position. Either local or world coordinates, depending on if trail:uselocalpoints is set.", args="(l3dtrail,trailpoint,[float x,y,z])", returns="([float x,y,z])"},
["spawnstep"] = {type='function', description = " sets or returns spawnstep in ms, one point will be spawned every spawnstep, if spanwstep is greater 0.", args="(l3dtrail,[int])", returns="(int)"},
["velocity"] = {type='function', description = " sets or returns velocity vector in local space, units per second.", args="(l3dtrail,[float x,y,z])", returns="([float x,y,z])"},
["typeworldref"] = {type='function', description = " points take their world coordinates from linked references. You should do this after a new trail, or after resetting. It does not allow spawnstep.", args="(l3dtrail)", returns="()"},
["tpPos"] = {type='function', description = " gets or sets trailpoint's position. Either local or world coordinates, depending on if trail:uselocalpoints is set.", args="(l3dtrail,trailpoint,[float x,y,z])", returns="([float x,y,z])"},
["vertexpointer"] = {type='function', description = " returns first and end address of mesh array. Operations must be weithin [start,end[. The mesh has 2 vertices (vertex32lit) per trailpoint. You can manipulate color and texcoords directly with these pointers.", args="(l3dtrail)", returns="(pointer start,end)"},
["memtonormal"] = {type='function', description = " byte offset within tpoint to normal (float3, SSE aligned, w can be overwritten) ", args="()", returns="(int bytes)"},
["matsurface"] = {type='function', description = " sets or returns matsurface", args="(l3dtrail,[matsurface])", returns="([material/texture])"},
["closestdistance"] = {type='function', description = " returns closest line segment and distance to it. The closest point is fracc*(nexttpoint-tpoint). Last frame's state is used.", args="(l3dtrail,[float x,y,z])", returns="([float dist,trailpoint,float fracc ])"},
["closestpoint"] = {type='function', description = " returns closest active trailpoint and distance to it. Last frame's state is used.", args="(l3dtrail,[float x,y,z])", returns="([float dist,trailpoint])"},
["tpNormal"] = {type='function', description = " gets or sets trailpoint's position. Either local or world coordinates, depending on if trail:uselocalpoints is set.", args="(l3dtrail,trailpoint,[float x,y,z])", returns="([float x,y,z])"},
["tpNormalarray"] = {type='function', description = " sets or returns normal of active trailpoints from floatarray", args="(l3dtrail,[floatarray 3t])", returns="([floatarray 3t])"},
["datapointer"] = {type='function', description = " returns first and end address of trailpointer array. Operations must be weithin [start,end[. Trailpoints are saved in cyclic array, the first index can be retrieved with firstpoint. Subsequent points are stored after the first and wrapped around trailpoint array. Within this array the size scalers for the trail sides are stored linearly from start to end pointer.", args="(l3dtrail)", returns="(pointer start,end)"},
["spawn"] = {type='function', description = " spawns a new point in world/local coordinates, normal is needed when you dont use facecamera, and velocity when you use velocity. You can automaically spawn points with spawnstep. Illegal if typeworldref is used.", args="(l3dtrail,float pos x,y,z,float normal x,y,z,[float vel x,y,z])", returns="(trailpoint)"}}}
rcmdfbodrawto = {type='class',description="Sets to which color attachments it should be rendered to. Using only fragment shaders you can also write to up to four attachments simultaneously.",childs={["setup"] = {type='function', description = " returns or sets the active color drawbuffers. Only ints from 0-3 are allowed. You can specify up to 4 ints, if you want multiple rendertargets and capability exists.", args="(rcmdfbodrawto,[int buffer0,buffer1..])", returns="([int buffer0,buffer1..])"},
["new"] = {type='function', description = " returns the rcmd. By default draws to color attach 0", args="()", returns="(rcmdfbodrawto)"}}}
ExtMath = {type='class',description="The Extended Math class contains some generic math operations. Vectors and \
		matrices are passed as indexed tables from 1-3 or 1-16. Matrices are stored column-major. \
		Compared to the Luxinia CoreApi functions, the operations here are written and processed entirely in Lua",childs={["interpolate"] = {type='function', description = " returns interpolated value between from and to", args="(float fraction,float from, float to)", returns="(float)"},
["v3min"] = {type='function', description = " returns minimum vector a and b", args="(table a, b)", returns="(table vector)"},
["v4interpolate"] = {type='function', description = " returns interpolated vector between from and to", args="(float fraction,table from, table to)", returns="(table)"},
["v4add"] = {type='function', description = " returns addition a + b", args="(table a,b)", returns="(table sum)"},
["v3polar"] = {type='function', description = " converts polar coords to regular x,y,z", args="(float len,planeangle,heightangle)", returns="(floar x,y,z)"},
["v3sub"] = {type='function', description = " returns subraction a - b", args="(table a,b)", returns="(table difference)"},
["v3spline"] = {type='function', description = " returns catmull-rom spline interpolated vector between from and to", args="(float fraction, table prevfrom, table from, table to, table nextto)", returns="(table)"},
["v4mul"] = {type='function', description = " returns componentwise multiplication a * b", args="(table a,b)", returns="(table out)"},
["quatslerpqt"] = {type='function', description = " returns quaternion spherical quadratic tangent interoplation", args="(number fracc, table qprev, q0, q1, qnext)", returns="(tabel qout)"},
["v4div"] = {type='function', description = " returns componentwise multiplication a / b", args="(table a,b)", returns="(table out)"},
["v3normalize"] = {type='function', description = " returns normalized \
	vector 3d vector and the original length of the vector", args="(table vec)", returns="(table normalized,float origlength)"},
["v4scaledadd"] = {type='function', description = " returns a + (b * f)", args="(table a,table b, float f)", returns="(table out)"},
["v3sqlen"] = {type='function', description = " square distance. This function is a little bit \
	faster than the len function which returns the squareroot of this function.\
	If you only want to compare distances (i.e. is this point inside my distance),\
	you can square the distance you would like to compare with. This is worth \
	the effort since it does not make much difference in code and work.", args="(table vec)", returns="(float len)"},
["v3scale"] = {type='function', description = " returns component wise a * f", args="(table a,float f)", returns="(table out)"},
["v3dist"] = {type='function', description = " return distance |(v1-v2)| of vectors", args="(table v1,v2)", returns="(float sqdist)"},
["nearestpowerof2"] = {type='function', description = " calculates the nearest positive power of 2 number", args="(number)", returns="(number)"},
["v3dot"] = {type='function', description = " returns dotproduct for 2 3vectors", args="(table v1, v2)", returns="(float dot)"},
["v3add"] = {type='function', description = " returns addition a + b", args="(table a,b)", returns="(table sum)"},
["v3interpolate"] = {type='function', description = " returns interpolated vector between from and to", args="(float fraction,table from, table to)", returns="(table)"},
["quatslerpq"] = {type='function', description = " returns quaternion spherical quadratic interoplation", args="(number fracc, table qprev, q0, q1, qnext)", returns="(tabel qout)"},
["v4sub"] = {type='function', description = " returns subraction a - b", args="(table a,b)", returns="(table difference)"},
["v4spline"] = {type='function', description = " returns catmull-rom spline interpolated vector between from and to", args="(float fraction, table prevfrom, table from, table to, table nextto)", returns="(table)"},
["v3axisrotate"] = {type='function', description = " rotates vector vec around angle of the given axis", args="(table axis,number angle, table vec)", returns="(table point)"},
["anglediff"] = {type='function', description = " calculates the shortest angledifference between two angles (which is a bit tricky i.e. -Math.PI - Math.PI == 0)", args="(radians1, radians2)", returns="(angle)"},
["v3div"] = {type='function', description = " returns componentwise multiplication a / b", args="(table a,b)", returns="(table out)"},
["v3len"] = {type='function', description = " euklid length of vecotr (a²+b²+c²)^0.5", args="(table vec)", returns="(float len)"},
["v3mul"] = {type='function', description = " returns componentwise multiplication a * b", args="(table a,b)", returns="(table out)"},
["quatslerp"] = {type='function', description = " returns quaternion spherical interoplation", args="(number fracc, table q1, q2)", returns="(tabel qout)"},
["v3max"] = {type='function', description = " returns maximum vector a and b", args="(table a, b)", returns="(table vector)"},
["v3cross"] = {type='function', description = " returns cross product of 3d vector a and b", args="(table a, b)", returns="(table vector)"},
["nextpowerof2"] = {type='function', description = " calculates the next positive power of 2 number", args="(number)", returns="(number)"},
["v4scale"] = {type='function', description = " returns component wise a * f", args="(table a,float f)", returns="(table out)"},
["v3scaledadd"] = {type='function', description = " returns a + (b * f)", args="(table a,table b,float f)", returns="(table out)"},
["v3sqdist"] = {type='function', description = " return square distance |(v1-v2)|² of vectors", args="(table v1,v2)", returns="(float sqdist)"},
["spline"] = {type='function', description = " returns catmull-rom spline interpolated value between from and to", args="(float fraction,float prevfrom, float from, float to, float nextto)", returns="(float)"}}}
l3dset = {type='class',description="The List3D is organised in l3dsets, every set contains multiple layers. You can render the same set from different l3dviews. One default l3dview always exists per l3dset.		Each l3dset has its own sun. particlesystems and particleclouds are rendered at the end of every l3dset.		Every l3dnode requires a l3dlayerid, directly or indirectly via defaults. l3dsets are independent from each other, and l3dnodes		can only be rendered in one l3dset. By default 0-2 are disabled.<br>		l3dsets are renderd in this order: 0,1,2,3.<br>",childs={["sun"] = {type='function', description = " returns or sets sun, disabled when 2nd arg is not a l3dlight. If disabled we will use default sun", args="(l3dset,[l3dlight])", returns="(l3dlight)"},
["default"] = {type='function', description = " returns or sets default l3dset.", args="([l3dset])", returns="([l3dset])"},
["getdefaultview"] = {type='function', description = " returns default l3dview of the set", args="(l3dset)", returns="(l3dview)"},
["disabled"] = {type='function', description = " returns or sets disabled state", args="(l3dset,[boolean])", returns="(boolean)"},
["layer"] = {type='function', description = " returns l3dlayerid for l3dset or default l3dset. If default l3dset is used the layer is also set as default layer. So whenever you dont pass l3dlayerid to l3dnodes, the default layer/l3dset combo will be used.", args="([l3dset],int 0..15)", returns="(l3dlayerid)"},
["updateall"] = {type='function', description = " updates all nodes, so that world state is uptodate", args="(l3dset)", returns="()"},
["get"] = {type='function', description = " returns l3dset", args="(int 0-3)", returns="(l3dset)"}}}
Compat = {type='class',description="Compat is a class that provides compatibility functions for previous \
		releases of Luxinia. The changes to the last released developer version are\
		automatically applied. Else load compatibility manually. Sometimes backwards compatibility cannot be achived.",childs={["setcompatibility"] = {type='function', description = " sets compatibility from the given version string e.g 0.98 ", args="(float fromversion)", returns="(boolean)"}}}
djointhinge = {type='class',description="Hinges are limited in their rotation at one axis. Can be used for carwheel simulation.",childs={["anchor"] = {type='function', description = " sets anchor point in worldcoordinates if x,y,z is given. If not, the two anchorpoints are returned that both bodies apply. ", args="(djointhinge,[float x,y,z])", returns="([float x1,y1,z1,x2,y2,z2])"},
["angle"] = {type='function', description = " sets/gets axis orientation of the hinge.The angle is measured between the two bodies, or between the body and the static environment. The angle will be between -pi..pi.\
When the hinge anchor or axis is set, the current position of the attached bodies is examined and that position will be the zero angle. ", args="(djointhinge)", returns="([float angle,rate])"},
["axis"] = {type='function', description = " sets/gets axis orientation of the hinge ", args="(djointhinge,[float x,y,z])", returns="([float x,y,z])"},
["new"] = {type='function', description = " creates a new hingejoint", args="([float x,y,z],[djointgroup group])", returns="(djointhinge)"}}}
logicmode = {type='class',description="bitwise logical operations between source and destination.",childs={["nor"] = {type='function', description = " ~(s | d)", args="()", returns="(logicmode)"},
["nand"] = {type='function', description = " ~(s & d)", args="()", returns="(logicmode)"},
["andrev"] = {type='function', description = " s	& ~d", args="()", returns="(logicmode)"},
["orinv"] = {type='function', description = " ~s | d", args="()", returns="(logicmode)"},
["copy"] = {type='function', description = " sets to source", args="()", returns="(logicmode)"},
["or"] = {type='function', description = "  s | d", args="()", returns="(logicmode)"},
["invert"] = {type='function', description = " inverts destination", args="()", returns="(logicmode)"},
["clear"] = {type='function', description = " sets to 0", args="()", returns="(logicmode)"},
["equivalent"] = {type='function', description = " ~(s ^ d)", args="()", returns="(logicmode)"},
["copyinv"] = {type='function', description = " sets to negated source", args="()", returns="(logicmode)"},
["and"] = {type='function', description = " s & d", args="()", returns="(logicmode)"},
["xor"] = {type='function', description = " s ^ d", args="()", returns="(logicmode)"},
["noop"] = {type='function', description = " keeps destination", args="()", returns="(logicmode)"},
["orrev"] = {type='function', description = " s	| ~d", args="()", returns="(logicmode)"},
["set"] = {type='function', description = " sets to 1", args="()", returns="(logicmode)"},
["andinv"] = {type='function', description = " ~s & d", args="()", returns="(logicmode)"},
["disable"] = {type='function', description = " disables logic ops", args="()", returns="(logicmode)"}}}
l3dmodel = {type='class',description="l3dnode of a model instance. Every l3dmodel has unique materials, bone and morph data, if specified. You can apply boneanimation with the sequence commands, control bones with bonecontrol or run morphing with morphcontrol. On creation the l3dmodel will copy all material and renderflags (if material provides a shader) data from the source model.",childs={["bonerotdeg"] = {type='function', description = " gets bone rotation degrees", args="(l3dmodel,boneid/string bonename)", returns="(float x,y,z)"},
["bonereset"] = {type='function', description = " sets bones to reference positions", args="(l3dmodel)", returns="()"},
["seqDuration"] = {type='function', description = " returns duration of sequence", args="(l3dmodel,int sequence)", returns="(int)"},
["newinstance"] = {type='function', description = " creates instance of another l3dmodel, they will share bone and morph data. Only works if bone data is not set to worldspace.", args="(string name,|l3dlayerid|,l3dmodel)", returns="(l3dmodel)"},
["seqOffset"] = {type='function', description = " sets or returns current offset between anims of sequence, negative means overlapping. Dont call before anims were set. It will also set the proper duration for the sequence.", args="(l3dmodel,int sequence,[int])", returns="([int])"},
["seqAnimsource"] = {type='function', description = " sets or returns sequence:anim animation", args="(l3dmodel,int sequence,int anim,[animation])", returns="([animation])"},
["getindexarray"] = {type='function', description = " returns vertexarray of a batched l3dmodel's mesh.", args="(l3dmodel,meshid)", returns="(vertexarray)"},
["seqSpeed"] = {type='function', description = " sets or returns speed of sequence, default is 1", args="(l3dmodel,int sequence,[float])", returns="([float])"},
["seqBlendmanual"] = {type='function', description = " sets or returns if sequence is blended manually", args="(l3dmodel,int sequence,[boolean])", returns="([boolean])"},
["seqAnimMax"] = {type='function', description = " returns how many anims per sequence can be set", args="()", returns="([int])"},
["morphreset"] = {type='function', description = " sets morphdata to reference positions", args="(l3dmodel)", returns="()"},
["seqAnimstart"] = {type='function', description = " sets or returns sequence:anim start time", args="(l3dmodel,int sequence,int anim,[int])", returns="([int])"},
["nonbatchable"] = {type='function', description = " returns or sets state. If a batchbuffer affects this model it will not be included.", args="(l3dmodel,[boolean])", returns="([boolean])"},
["new"] = {type='function', description = " creates l3dmodel. If you want to be able to apply animations on it set boneanim to true. If you want it to have unique vertices or allow morphing set meshanim to true. (both default to false)", args="(string name,|l3dlayerid|,model,[boolean boneanim],[boolean meshanim])", returns="(l3dmodel)"},
["seqTime"] = {type='function', description = " sets or returns current time of sequence", args="(l3dmodel,int sequence,[int])", returns="([int])"},
["getl3dbatchbuffer"] = {type='function', description = " returns batchbuffer of the model, if it was batched.", args="(l3dmodel)", returns="([l3dbatchbuffer])"},
["seqMax"] = {type='function', description = " returns how many sequences can be set.", args="()", returns="([int])"},
["seqState"] = {type='function', description = " sets or returns state of sequence. 0 inactive, 1 run, 2 pause, 3 singleframe", args="(l3dmodel,int sequence,[int state])", returns="([int])"},
["bonepos"] = {type='function', description = " gets bone position", args="(l3dmodel,boneid/string bonename)", returns="(float x,y,z)"},
["seqBlendfactor"] = {type='function', description = " sets or returns blendfactor of sequence", args="(l3dmodel,int sequence,[float])", returns="([float])"},
["seqAnimlength"] = {type='function', description = " sets or returns sequence:anim length", args="(l3dmodel,int sequence,int anim,[int])", returns="([int])"},
["bonesinworldspace"] = {type='function', description = " returns or sets if bones should be calculated in world space. If set in worldspace you cannot instance this l3dmodel, and you will get problems when others were already instanced.", args="(l3dmodel,[boolean])", returns="([boolean])"},
["getvertexarray"] = {type='function', description = " returns vertexarray of a batched or morphable l3dmodel's mesh.", args="(l3dmodel,meshid)", returns="(vertexarray)"},
["matsurface"] = {type='function', description = " sets or returns material of specific mesh", args="(l3dnode,meshid,[matsurface])", returns="([material/texture])"},
["getmodel"] = {type='function', description = " returns model of this l3dnode", args="(l3dnode)", returns="(model)"},
["bonerotaxis"] = {type='function', description = " gets bone rotation axis", args="(l3dmodel,boneid/string bonename)", returns="(float Xx,Xy,Xz,Yx,Yy,Yz,Zx,Zy,Zz)"},
["projectorflag"] = {type='function', description = " returns or sets to which projectors the model reacts to. id is 0-31.", args="(l3dnode,int id,[boolean])", returns="([boolean])"},
["seqLoop"] = {type='function', description = " sets or returns if sequence loops, default is true", args="(l3dmodel,int sequence,[boolean])", returns="([boolean])"},
["bonematrix"] = {type='function', description = " gets bone matrix", args="(l3dmodel,boneid/string bonename)", returns="(matrix4x4)"},
["bonerotrad"] = {type='function', description = " gets bone rotation radians", args="(l3dmodel,boneid/string bonename)", returns="(float x,y,z)"}}}
l3dpemitter = {type='class',description="l3dnode of a particle emitter. Every emitter starts with the default values from the particle system. You can change the emittertype afterwards.<br><br>Important note about accessing subsystems: The l3dpemitter also hosts all subsystem emitters (all but trail, trail's common shared emitter is referenced), you can access them with a special ''subsys string'', that is made of the subsystem indices (0-based).<br>For example \"0\" accesses first subemitter, \"12\" the 2nd emitter of l3dpemitter and the 3rd of that one. An error is thrown when indexing is done out of bounds or on trail. You can use particlesys.getsubsysdigits to generate the string based on normal names. Be aware that if a trail subsystem is indexed, its default emitter (as used by trail effects) is modified. Also when a trail is used it wont report subsystems, as those are ignored in rendering as well.<br> Subsystem translation offsets can be scaled via renderscale.",childs={["getparticlesys"] = {type='function', description = " returns particlesys emitter was created from", args="(l3dpemitter,[subsys string])", returns="(particlesys)"},
["spreadout"] = {type='function', description = " returns or sets outer spread (radians)", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["prtsize"] = {type='function', description = " returns or sets particle size", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["flipdirection"] = {type='function', description = " returns or sets percent of flip direction", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["velocity"] = {type='function', description = " returns or sets velocity", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["startage"] = {type='function', description = " returns or sets starting age of a particle", args="(l3dpemitter,[subsys string],[int])", returns="([int])"},
["spreadin"] = {type='function', description = " returns or sets inner spread (radians)", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["offsetvelocity"] = {type='function', description = " returns or sets offset velocity", args="(l3dpemitter,[subsys string],[float x,y,z])", returns="([float x,y,z])"},
["typerectangle"] = {type='function', description = " sets emitter type to RECTANGLE. Default plane normal is Z (2)", args="(l3dpemitter,[subsys string], float width, float height, [int axis])", returns="()"},
["new"] = {type='function', description = " new particle emitter l3dnode (default type). The layer itself isnt important but the l3dset is extracted from it. Particlesys has a command to define in which layer it should be rendered.", args="(string name,|l3dlayerid layer|,particlesys)", returns="(l3dpemitter)"},
["typemodel"] = {type='function', description = " sets emitter type to MODEL", args="(l3dpemitter,[subsys string], model, float scale)", returns="()"},
["radius"] = {type='function', description = " returns or sets emitter radius for typecircle/typeshere. equivalent to size", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["typepoint"] = {type='function', description = " sets emitter type to POINT", args="(l3dpemitter,[subsys string])", returns="()"},
["typecircle"] = {type='function', description = " sets emitter type to CIRCLE", args="(l3dpemitter,[subsys string], float radius)", returns="()"},
["typesphere"] = {type='function', description = " sets emitter type to SPHERE", args="(l3dpemitter,[subsys string], float radius)", returns="()"},
["typerectanglelocal"] = {type='function', description = " sets emitter type to RECTANGLELOCAL. width = along X axis, height = along Z axis", args="(l3dpemitter,[subsys string], float width, float height)", returns="()"},
["rate"] = {type='function', description = " returns or sets rate", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["width"] = {type='function', description = " returns or sets emitter width for typerectangles. equivalent to size", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["velocityvar"] = {type='function', description = " returns or sets velocityvar", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["subsyscount"] = {type='function', description = " returns how many subsys emitters are nested", args="(l3dpemitter,[subsys string])", returns="(int)"},
["stop"] = {type='function', description = " end with offset from now, disallow restarts", args="(l3dpemitter,int timeoffset,boolean norestarts)", returns="()"},
["start"] = {type='function', description = " start with timeoffset(ms) from now", args="(l3dpemitter,int timeoffset)", returns="()"},
["height"] = {type='function', description = " returns or sets emitter height for typerectangle(local)", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["size"] = {type='function', description = " returns or sets emitter size (radius,width)", args="(l3dpemitter,[subsys string],[float])", returns="([float])"},
["axis"] = {type='function', description = " returns or sets emitter plane normal axis for typerectangle", args="(l3dpemitter,[subsys string],[int 0..2])", returns="([float])"},
["maxoffsetdist"] = {type='function', description = " returns or sets max random offset from original spawnposition", args="(l3dpemitter,[subsys string],[float])", returns="([float])"}}}
texture = {type='class',description="Bitmaps that store color information.<br> There is two kind of textures: loaded from file and created in memory. Filebased textures are 'load'ed while pure memory textures are created with 'create'. Loading defaults to mipmap true and keepdata false.When a texturename looks like 'USER_TEX(myname)' then luxinia will check if a loaded texture was registered as usertex with 'myname' or if a user created texture with that name exists.",childs={["deletevid"] = {type='function', description = " unloads the texture from video memory, can result into errors when you free a still in use texture.", args="(texture)", returns="()"},
["combinecube"] = {type='function', description = " combines all 2d textures to a single cubemap, 6 textures are required", args="(stringstack,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["deletedata"] = {type='function', description = " deletes the imagedata in system memory and removes keepdata flag. You can no longer change or sample it.", args="(texture)", returns="()"},
["loadlum"] = {type='function', description = " loads a luminance 1d/2d texture.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["create3d"] = {type='function', description = " creates a new empty texture in memory. Sizes must be power of two (unless np2 supported). Automatically registered as USER_TEX. Same creation, compression and mipmap rules as for new2d", args="(string name, int width, int height, int depth, textype, [boolean keepdata], [boolean nofilter],[boolean mipmap],[texdatatype])", returns="(texture)"},
["copy"] = {type='function', description = " copies content of one texture to another. lvl being the mipmap level. Requires texcopy capability.", args="(texture, int lvl, x,y,z, texture src, int lvl, x,y,z, dimx,dimy,dimz)", returns="()"},
["uploaddata"] = {type='function', description = " will upload the current data to video memory. Only works on user-created textures with data, or if dataarray is passed. x,y,z are the starting points, w,h,d the dimension of the updated area. If arraycount does not match full texture dimension, then dataarray is assumed to be only the update rectangle. Scalararrays offsets are ignored. Side is for cubemaps (0-5), else cubemaps take Z as side. All numbers passed must be positive", args="(texture,[int x,y,z,w,h,d]/[int side],[staticarray/scalararray uploaddata])", returns="()"},
["create1darray"] = {type='function', description = " creates a new empty texture in memory. Width must be power of two, height <= capability.texarraylayers. Resizing will not change type.", args="(string name, int width, int height,textype, [boolean keepdata], [boolean nofilter],[boolean mipmap],[texdatatype])", returns="(texture)"},
["create2d"] = {type='function', description = " creates a new empty texture in memory. Width and height must be power of two (unless capability for np2 textures exists). texdatatype is uchar (Unsigned Byte) by default. Automatically registered as USER_TEX. No compression supported. Mipmapping will only work when keepdata + reloaddata is used, or when hardware mipmapping exists. If height is 1 it will be a 1D texture and stay like that (ie. resizing will not change this).", args="(string name, int width, int height,textype, [boolean keepdata], [boolean nofilter],[boolean mipmap],[texdatatype])", returns="(texture)"},
["loadcubeproj"] = {type='function', description = " loads a special color cubemap texture, generated from a single 2d image to fix backprojection problems, if nothing is specified we will use mipmapping.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["mountscalararray"] = {type='function', description = " returns a mounted array if data is available.", args="(texture, [int cubeside])", returns="([scalararray])"},
["createbuffer"] = {type='function', description = " creates a texture that allows binding a vidbuffer as texture. The vidbuffer must be specified with setvidbuffer command. Only alpha,lumalpha,intensity and rgba are allowed as textypes.", args="(string name, textype, texdatatype)", returns="(texture)"},
["getscalartype"] = {type='function', description = " the format of the local data.", args="(texture)", returns="(scalartype)"},
["clamp"] = {type='function', description = " sets or gets clamping of the texture. If not set texture will repeat, default is off. By passing one boolean you will toggle all, else you can specify in detail which axis to repeat/clamp.", args="(texture,[boolean all]/[boolean x,y,z])", returns="([boolean x,y,z])"},
["reload"] = {type='value', description = "() : (texture,[string filename,boolean keepoldsize] - reloads the texture with original (or new filename) with same specifications as on first load. If the texture was bound to an renderfbo, make sure to call renderfbo:resetattach. The internal filename remains to be the original filename. Optionally the texture can be forced to the current texturesize."},
["mipmapping"] = {type='function', description = " turn on/off mipmapping for the texture. Only works when texture was created with mipmap support.", args="(texture,[boolean])", returns="([boolean])"},
["glid"] = {type='function', description = " returns OpenGL ID (GLuint) as pointer.", args="(texture)", returns="(pointer)"},
["sample"] = {type='function', description = " gets color from data texture, does clamped,bilinear filtering. More details under pixel function.", args="(texture,float u,v,[w],[boolean clamp])", returns="([float r,g,b,a])"},
["load3d"] = {type='function', description = " loads a color 3d texture (RGB or RGBA depending on file). 3D textures are either .dds or a 2d image whose slices are stored vertically along image height. So that depth = height/width, height = width", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["create2drect"] = {type='function', description = " creates a new empty rectangle texture in memory. Width and height can be arbitrary. texdatatype is uchar (Unsigned Byte) by default. Automatically registered as USER_TEX. No compression supported.", args="(string name, int width, int height,textype, [boolean keepdata], [boolean nofilter],[texdatatype])", returns="(texture)"},
["loadrect"] = {type='function', description = " loads a color 2d rect texture (check capability) MipMap is ignored. Dimension depends on file.<br>			There are some special commands that you can attach to your load filename. \"nocompress;filename.ext\" will disable compression. 'normalize' will normalize the texture and its mipmaps. 'normal2light' will create a greyscale version of the normalmap using a fixed light direction vector. 'dxt1','dxt3' or 'dxt5' enforce specifc compression (if enabled), otherwise let driver choose compression format. If the filename contains 'lightmap' compression will be disabled, too. Note that compressed-stored textures will not work with the commands.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["load"] = {type='function', description = " loads a color 1d/2d texture (RGB or RGBA depending on file). Dimension depends on file.<br>			There are some special commands that you can attach to your load filename. \"nocompress;filename.ext\" will disable compression. 'normalize' will normalize the texture and its mipmaps. 'normal2light' will create a greyscale version of the normalmap using a fixed light direction vector. 'dxt1','dxt3' or 'dxt5' enforce specifc compression (if enabled), otherwise let driver choose compression format. If the filename contains 'lightmap' compression will be disabled, too. Note that compressed-stored textures will not work with the commands.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["datapointer"] = {type='function', description = " if the texture has imagedata availabe, you can access the memory directly in other lua dlls. Be aware that you must make sure to not corrupt memory, make sure you are always smaller than the 'end' pointer. Start may be NULL if no image data present.", args="(texture)", returns="(pointer start, end, s3darray)"},
["savetofile"] = {type='function', description = " saves texture to file. quality must be within 1 and 100 and is used for .jpg (default is 85). cubeside can be 0-5 for cubemap textures (default 0)", args="(texture,string filename,[int quality],[int cubeside])", returns="()"},
["create2darray"] = {type='function', description = " creates a new empty texture in memory. Width and height must be power of two (unless np2 supported), depth <= capability.texarraylayers. Automatically registered as USER_TEX. Same creation, compression and mipmap rules as for create2d", args="(string name, int width, int height, int depth, textype, [boolean keepdata], [boolean nofilter],[boolean mipmap],[texdatatype])", returns="(texture)"},
["reloaddata"] = {type='function', description = " deletes old image in videomemory, and uploads a new one with the current imagedata. this is slower than uploaddata but supports all textures.", args="(texture)", returns="()"},
["load3dlum"] = {type='function', description = " loads a luminance 3d texture.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["lightmapscale"] = {type='function', description = " returns or sets how much the output is scaled, when this texture is used as lightmap outside of shaders (or when lightmapscale is used in shader stage)", args="(texture,[float])", returns="([float])"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["downloaddata"] = {type='function', description = " if texture was not loaded with keepdata, we can retrieve imagedata this way. Also allows updating local data from vidmem if keepdata was set on init, but texture content has changed. Note that without keepdata set, you must refetch data everytime major visual changes occur (fullscreen/res toggle). Optionally downloads uncompressed 1st mipmap into given scalararray", args="(texture,[scalararray])", returns="(boolean success)"},
["loaddata"] = {type='function', description = " loads a texture, but it will not be renderable. (autosets keepdata)", args="(string file)", returns="(Texture tex)"},
["loadcube"] = {type='function', description = " loads a color cube texture (RGB or RGBA depending on file). Cube texture are either .dds or 2d image whose sides are stored (+x,-x,+y,-y,+z,-z) vertically. So that height = width*6.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["loadalpha"] = {type='function', description = " loads a alpha 1d/2d texture.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["pack2d"] = {type='function', description = " combines all 2d textures to a single image where each image file becomes one color channel. 3 or 4 filenames required.", args="(string filenameR, string filenameG, string filenameB,[string filenameA],[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["downloadbuf"] = {type='function', description = " similar to downloaddata but stored into the vidbuffer. Offset (bytes) must be positive and within size of vidbuffer.", args="(texture,vidbuffer, [int offset])", returns="(boolean success)"},
["name"] = {type='function', description = " returns name of texture", args="(texture tex)", returns="(string)"},
["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"},
["resize"] = {type='function', description = " resizing textures. previous data is lost. depth only for 3d textures", args="(texture,int width, int height, [int depth])", returns="()"},
["dimension"] = {type='function', description = " will return infos about the texture. It returns the size in memory		and the original size. If system.detail() is <2, the loaded textures are resized at half of their size! If 		you do any calculations on the image depending on its size, you have to take this into account!", args="(texture)", returns="(int width,height,depth,bpp,origwidth,origheight,components)"},
["load3dalpha"] = {type='function', description = " loads a alpha 3d texture", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["swap"] = {type='function', description = " swaps both texture contents, all images who already referenced one of either, now uses the other data. Names stay as they were.", args="(texture,texture)", returns="()"},
["createsame"] = {type='function', description = " creates a new empty texture in memory with same size and format description as the texture passed.", args="(string name, texture)", returns="(texture)"},
["createcube"] = {type='function', description = " creates a new empty texture in memory. Size must be power of two. Automatically registered as USER_TEX. Same creation, compression and mipmap rules as for create2d", args="(string name, int size, textype, [boolean keepdata], [boolean nofilter],[boolean mipmap],[texdatatype])", returns="(texture)"},
["uploadbuf"] = {type='function', description = " similar to uploaddata but reads from vidbuffer. Offset must be positive and within size range. Data by default is 4 component float32 and mipmaplevel is 0.", args="(texture,int x,y,z,w,h,d, vidbuffer,[int offset],[scalartype], [int offset], [mipmaplevel])", returns="()"},
["settexbuffer"] = {type='function', description = " assigns the given vidbuffer to the texture. texture must be of 'buffer' format. Internalformat as defined by texture creation is used. Passing a none vidbuffer disables binding.", args="(texture, vidbuffer)", returns="()"},
["registerusertex"] = {type='function', description = " registers the texture as USER_TEX. If anyone access a texture with the name 'USER_TEX(username)' this texture will be used. The name will be unavailable once texture was deleted.", args="(texture,string username)", returns="()"},
["loadcubedotz"] = {type='function', description = " loads a special color cubemap texture, generated from a single 1d image to create a vector.dot.+Z cubemap, cube.size is half of width. -1 is left and +1 is right. if nothing is specified we will use mipmapping.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["createfullwindow"] = {type='function', description = " creates a new empty windowsized texture. Should only be used within materials or as rendertargets, else you might need to set texture matrices manually (needed if capability for rectangle textures exists). Automatically registered as USER_TEX. No mipmapping nor compression supported. By default nofilter is true and textype is rgba (internally whatever is closest to window is used). The speciality about windowsized textures is that if you change window resolution they are automatically resized.", args="(string name,[textype],[nofilter],[texdatatype])", returns="(texture)"},
["combine2d"] = {type='function', description = " combines all 2d textures to a single row, ideally number of textures should be power of 2, max 64 textures", args="(stringstack,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["pixel"] = {type='function', description = " same as sample but works with discrete coordinates and can set pixels. Writing to texture is not visible until uploaddata or reloaddata was called. Z can be 0-5 for cubemap side, and 0-depth for 3d textures. If internal format is BGR/BGRA/ABGR values must be manually reordered, LUMALPHA uses R and G channels. ALPHA/LUM use R channel.)", args="(texture,int x,y,[z],[float r,g,b,a])", returns="([float r,g,b,a])"},
["filter"] = {type='function', description = " returns or sets if texture filtering is used for minfication or/and magnification.", args="(texture,[boolean both]/[boolean min,mag])", returns="([boolean min,mag])"},
["pixelbyte"] = {type='function', description = " same as pixel but assumes channels as byte values (0-255).", args="(texture,int x,y,[z],[int r,g,b,a])", returns="([int r,g,b,a])"},
["loadcubelum"] = {type='function', description = " loads a luminance cube texture.", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"},
["formattype"] = {type='function', description = " the format in which the texture is stored as string, e.g. 1d, 2d, 3d, rect, cube, 1darray, 2darray.", args="(texture)", returns="(string)"},
["loadcubealpha"] = {type='function', description = " loads a alpha cube texture", args="(string file,[boolean mipmap],[boolean keepdata])", returns="(Texture tex)"}}}
mattexcontrolid = {type='class',description="mattexcontrolid to access material texcontrol values in matobjects",childs={}}
vidmapping = {type='class',description="Defines the access type of a pointer that is mapped into application memory.",childs={["discard"] = {type='function', description = " content within mapping will be overwritten.", args="()", returns="(vidmapping)"},
["write"] = {type='function', description = " content only written", args="()", returns="(vidmapping)"},
["read"] = {type='function', description = " content only read", args="()", returns="(vidmapping)"},
["readwrite"] = {type='function', description = " content written and read", args="()", returns="(vidmapping)"},
["discardall"] = {type='function', description = " complete buffer content will be overwritten.", args="()", returns="(vidmapping)"}}}
renderinterface = {type='class',description="Most renderable surfaces allow a detailed control of how they are rendered. Several interfaces exist for greater control. Also some other related classes are stored here.",childs={}}
Clipboard = {type='class',description="The Clipboard class allows primitive text access on the clipboard.",childs={["getText"] = {type='function', description = " returns a string that is currently in the clipboard", args="()", returns="(string)"},
["setText"] = {type='function', description = " copies a string in the clipboard", args="(string)", returns="()"}}}
shadercgparamhost = {type='class',description="A Cg Parameter that serves as host to all parameters with the same name. Use it to make it easier to control many parameters thru one with optimal efficiency. Directly creates a CGparam and connects the ones found in gpuprograms. Such parameters may not be controlled individually in a shader. Be aware that there is not much error checking done on parameter value get/set. If arrays passed are too small or length is set incorrect there will be no error warning.",childs={["destroy"] = {type='function', description = " tries to destroy the parameter, will return the number of still dependent parameters when parameter could not be destroyed, as its still in use.", args="(string name)", returns="(int users)"},
["sizes"] = {type='function', description = " returns various dimensions of parameter", args="(shadercgparamhost)", returns="(int columns, int rows, int totalarraysize)"},
["valueinto"] = {type='function', description = " similar to value, but performs a get into the given parameters. Will not work for single vectors.", args="(shadercgparamhost, matrix4x4 / staticarray, [int offset])", returns="(matrix4x4 / staticarray)"},
["value"] = {type='function', description = " sets/gets the value of a parameter, depending on type it will return/need different types. Arrays will alwas need corresponding staticarray (float/int), whilse matrices use matrix4x4 and vectors or scalars are directly pushed/popped on stack. When arrays are accessed you can fill them with an offset value. Counters for those are always single scalars. Return will always return the full array", args="(shadercgparamhost, [float x,y,z,w / matrix4x4 / staticarray], [int offset, length])", returns="([float x,y,z,w / matrix4x4 / staticarray])"},
["create"] = {type='function', description = " creates a parameter with the given name (or returns nil if name is already in use). Typename can be found in the Cg documentary. For array types the size value is taken.", args="(string name, string cgtypename, [int size])", returns="([shadercgparamhost])"},
["get"] = {type='function', description = " gets parameter or returns nil if noone with the name is registered", args="(string name)", returns="([shadercgparamhost])"}}}
l3dnode = {type='class',description="l3dnodes of different classes represent any visual item	you want to draw, models, particles etc. Each l3dnode can have a subtree of l3dnodes, however visibilty is only	tested for the root l3dnode, so if the root is not visible, childs won't be either. For a l3dnode to become active	it must be linked with a actornode or scenenode, from which it will get its world position information.<br>	for more info on the order nodes are rendered see l3dset.<br>	Retrieving world positions and rotations can return wrong results. Because world updates are only done when the node	was visible. So they lag one frame behind. Alternatively you can use updateall to enforce uptodate world data.",childs={["localrotaxis"] = {type='function', description = " returns or sets local rotation axis, make sure they make a orthogonal basis.", args="(l3dnode node,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])", returns="([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])"},
["parent"] = {type='function', description = " links node to a parent. ==parent prevents gc of self", args="(l3dnode node,[l3dnode parent])", returns="([l3dnode parent])"},
["rotationlock"] = {type='function', description = " returns or sets rotation lock. axis 0=X 1=Y 2=Z 3=All. Rotation lock is applied before local transforms.", args="(l3dnode node,int axis,[boolean state])", returns="(boolean)"},
["uselookat"] = {type='function', description = " gets or sets if node should face camera. Local updates are done post align.", args="(l3dnode,[boolean])", returns="([boolean])"},
["localrotdeg"] = {type='function', description = " returns or sets local rotation in degrees", args="(l3dnode node,[float x,y,z])", returns="([float x,y,z])"},
["renderscale"] = {type='function', description = " returns or sets render scale factor. (1,1,1) will disable renderscale, which is cheaper to render. For l3dpemitters it applies scaling to subsystem offsets. For l3dprimitives this matches size on start, however setting renderscale overrides size, and size changes will only affect bbox.", args="(l3dnode node,[float x,y,z])", returns="([float x,y,z])"},
["worldpos"] = {type='function', description = " returns or sets last world position. Setting only allowed if 'usemanualworld' is true.", args="(l3dnode node,[float x,y,z])", returns="([float x,y,z])"},
["localrotrad"] = {type='function', description = " returns or sets local rotation in radians", args="(l3dnode node,[float x,y,z])", returns="([float x,y,z])"},
["cambox"] = {type='function', description = " sets visibility box, if camera is inside (inside set to true) / outside (inside set to false) the box it will be drawn. If you pass the second box,which must be smaller than the first, we will perform a ranged check. This means the node will be marked as inside if camera is within outer box, and outside of innerbox.", args="(l3dnode node,boolean inside,float outer min x,y,z,float outer max x,y,z,[float inner min x,y,z, float inner max x,y,z])", returns="()"},
["setlayer"] = {type='function', description = " sets the nodes layer/set. l3dmodels can pass meshid. An l3dset change always affects all", args="(l3dnode,l3dlayerid,[meshid])", returns="()"},
["name"] = {type='function', description = " returns name", args="(l3dnode node)", returns="(string name)"},
["uselocal"] = {type='function', description = " enables local matrices, automatically on when you link to another l3dnode. You must not call it before the l3dnode was linked.", args="(l3dnode node,[boolean])", returns="([boolean])"},
["worldmatrix"] = {type='function', description = " returns or sets world matrix. Setting only allowed if 'usemanualworld' is true.", args="(l3dnode node,[matrix4x4/ actornode / scenenode])", returns="([matrix4x4])"},
["novistest"] = {type='function', description = " gets or sets novistest state. If set to true, node will always be drawn, as well as all its children.", args="(l3dnode,[boolean])", returns="([boolean])"},
["worldrotrad"] = {type='function', description = " returns or sets last world rotation in radians. Setting only allowed if 'usemanualworld' is true.", args="(l3dnode node,[float x,y,z])", returns="([float x,y,z])"},
["isanimateable"] = {type='function', description = " checks if the l3dnode is a l3dmodel and if yes, if it can be animated. Won't throw an error if a valid l3d is passed.", args="(l3dnode)", returns="(boolean)"},
["unparentbone"] = {type='function', description = " unlinks l3dnode from bone", args="(l3dnode node)", returns="()"},
["worldrotaxis"] = {type='function', description = " returns or sets last world rotation axis, make sure they make a orthogonal basis. Setting only allowed if 'usemanualworld' is true.", args="(l3dnode node,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])", returns="([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])"},
["lightmaptexmatrix"] = {type='function', description = " sets or returns node's lightmap texmatrix, if not a matrix4x4 is passed as argument, it will be disabled.", args="(l3dnode node,[matrix4x4])", returns="([matrix4x4])"},
["camvolumedelete"] = {type='function', description = " removes the extra visibility test based on camera position", args="(l3dnode node)", returns="()"},
["parentbone"] = {type='function', description = " tries to link node to parent's bonesystem", args="(l3dnode node,string bonename)", returns="()"},
["worldrotquat"] = {type='function', description = " returns or sets local rotation as quaternion. Setting only allowed if 'usemanualworld' is true.", args="(l3dnode node,[float x,y,z,w])", returns="([float x,y,z,w])"},
["delete"] = {type='function', description = " deletes l3dnode, by default children are also deleted", args="(l3dnode node)", returns="()"},
["localmatrix"] = {type='function', description = " returns or sets local matrix. As visibility culling is based on the scene/actornode using too much localposition offsets can create problems. You should rather create new actor/scenenodes in that case.", args="(l3dnode node,[matrix4x4])", returns="([matrix4x4])"},
["localrotquat"] = {type='function', description = " returns or sets local rotation as quaternion", args="(l3dnode node,[float x,y,z,w])", returns="([float x,y,z,w])"},
["updateall"] = {type='function', description = " updates world positions of all l3d nodes, visible or not. Useful if you need that data after you created and linked l3ds.", args="()", returns="()"},
["camsphere"] = {type='function', description = " sets visibilty sphere, if camera is inside (inside set to true) / outside (inside set to false) the sphere it will be drawn. If you pass the inner range we will perform a ranged check. This means the node will be marked as inside if camera is within outer sphere, and outside of inner sphere.", args="(l3dnode node,boolean inside,float outer range, [float inner range])", returns="()"},
["unlink"] = {type='function', description = " fully unlinks l3dnode, wont be drawn until linked again", args="(l3dnode node)", returns="()"},
["color"] = {type='function', description = " returns or sets node's color. Only used when rfNovertexcolor is set. Optionally can pass meshid for l3dmodels", args="(l3dnode node,[meshid],[float r,g,b,a])", returns="([float r,g,b,a])"},
["lightmap"] = {type='function', description = " sets or returns node's lightmap, if not a texture is passed as argument, it will be disabled.", args="(l3dnode node,[texture])", returns="([texture])"},
["lastframe"] = {type='function', description = " returns the last frame the node was rendered in.", args="(l3dnode node)", returns="([int])"},
["localpos"] = {type='function', description = " returns or sets local position. As visibility culling is based on the scene/actornode using too much localposition offsets can create problems. You should rather create new actor/scenenodes in that case.", args="(l3dnode node,[float x,y,z])", returns="([float x,y,z])"},
["linkinterface"] = {type='function', description = " links l3dnode to interfaces of scenenode or actornode (or returns current)", args="(l3dnode node,[scenenode]/[actornode])", returns="([scenenode]/[actornode])"},
["visflag"] = {type='function', description = " gets or sets visiblity status for each id. If a camera's id is set to true, the l3dnode will be visible to it. By default all are visible to id 0, which is the default camera.", args="(l3dnode,int id 0-31,[boolean])", returns="([boolean])"},
["worldrotdeg"] = {type='function', description = " returns or sets last world rotation in degrees. Setting only allowed if 'usemanualworld' is true.", args="(l3dnode node,[float x,y,z])", returns="([float x,y,z])"},
["usemanualworld"] = {type='function', description = " enables manual world matrices. Bonelinking, inheritlocks and local matrices will be disabled. You must not call it before the l3dnode was linked.", args="(l3dnode node,[boolean])", returns="([boolean])"}}}
intarray = {type='class',description="Intarray in Luxinia for array operations.",childs={["sub"] = {type='function', description = " self-=a or self = a - b", args="(intarray self,intarray / value a, [intarray b])", returns="()"},
["mul"] = {type='function', description = " self*=a or self = a * b", args="(intarray self,intarray / value a, [intarray b])", returns="()"},
["min"] = {type='function', description = " self = min(self,a) or self = min(a,b)", args="(intarray self,intarray / value a, [intarray b])", returns="()"},
["set"] = {type='function', description = " self = a (copy an array or set value to all)", args="(intarray self,intarray / value a)", returns="()"},
["max"] = {type='function', description = " self = max(self,a) or self = max(a,b)", args="(intarray self,intarray / value a, [intarray b])", returns="()"},
["div"] = {type='function', description = " self/=a or self = a / b", args="(intarray self,intarray / value a, [intarray b])", returns="()"},
["add"] = {type='function', description = " self+=a or self = a + b", args="(intarray self,intarray / value a, [intarray b])", returns="()"},
["new"] = {type='function', description = " creates a new staticarray. Count must be >0.", args="(int count)", returns="(intarray)"}}}
reschunk = {type='class',description="resdata is separated into resource chunks, each chunk has a memory pool, and can hold a specific amount of resources. Every chunk also generates Vertex/IndexBufferObjects for the models if needed.<br><br>If you want to clear resources and keep others active during runtime, you will need multiple resource chunks. When a chunk is destroyed it will however keep the resources that are still needed by other chunks. Since the 'unique resource' lookup on loading is done over all resources and not individually to save memory, this was needed. The separation in ResourceChunks can be done only once until the built in maximums are hit. On startup a core chunk is generated, only to holdall resources that the engine itself needs. A default chunk is allocated (8 megs) afterwards. If you destroy the default, you must set up all yourself.<br> The user can specify what should happen when a chunk is full and a resource wants to be loaded in it. you can either throw an error, or just fill the next chunk.<br> <br> Resources are classified as 'direct' loaded or 'indirect' indirect are those resources that are loaded by other resources. When a ResourceChunk is reloaded only 'directlys' are loaded again, of course with their dependants This is done to prevent collecting unused resources, when e.g. materials or other scripts have changed some textures might not be needed anymore.<br> <br>",childs={["activate"] = {type='function', description = " makes this the active reschunk, all new resources will be loaded into it.", args="(reschunk)", returns="()"},
["vbonewsize"] = {type='function', description = " returns or sets the size of new allocated Vertex/IndexBufferObjects in KiloBytes. Be aware that using a size greater 2048, means that only vertex64 can be addressed via shorts.", args="([int vbo,int ibo])", returns="([int vbo,int ibo])"},
["create"] = {type='function', description = "creates a new resource chunk, with given sized memory pool (in megabytes, kbsize optional),and given number of openslots per restype. The slotcount comes at the 'restyped' position. When a count is < zero it is used as multiplied of the total slots. So -1 tries to use all slots, -0.5 half and so on. Of course if more slots are already in use, than queried for, we will use the maximum of those still available.<br>Make sure you have called destroydefault() before you use your own chunks.<br>", args="(string name,int mbsize,|int kbsize|, float restypecnt...)", returns="(reschunk)"},
["getdefault"] = {type='function', description = " returns default chunk (or first if default was destroyed).", args="()", returns="(reschunk)"},
["clearload"] = {type='function', description = " clears all resources in this chunk.Then reloads resources with a smaller or equal indirection depth than the given, or none if indirection is negative.About indirection: eg. a model loads a texture and a material, both have a ind. depth of 1, the material loads a texture and shader, both with depth of 2. The shader finally loads another texture with depth of 3. So we have 3 textures with depths of 1,2,3 and 1 material with depth of 1, and 1 shader with depth of 1. The model has level 0, and to do a complete clear you pass -1.<br>Additionally we will always try to reload resources that were referenced from other reschunks.", args="(reschunk,int indirection)", returns="()"},
["usecore"] = {type='function', description = " uses core memory chunk (very small and reserved for luxinia core modules, you should never use this).", args="(boolean)", returns="()"},
["vbostats"] = {type='function', description = " returns strings on vertexbufferobjects useage statistics for this chunk.", args="(reschunk)", returns="(string,string)"},
["destroydefault"] = {type='function', description = " destroys the default chunk. If you want to do your own handling you must call this right at start, before you create new reschunks.", args="()", returns="()"},
["getloaded"] = {type='function', description = " returns either number of all loaded resources or the nth resource of that type.", args="(reschunk, int restype, [int nth])", returns="(int count/resource)"},
["getcurrent"] = {type='function', description = " returns current active chunk.", args="()", returns="(reschunk)"}}}
texcombiner = {type='class',description="A texcombiner defines how textures are blend together / what color/alpha values they return. Luxinia comes with a bunch of predefined combiners that the shadercompiler uses and which you can access in the shaderscript. If those are not enough or you need specific operations to be done you can define your own combiners. You must make sure they run well, as there wont be error checking. GL_ARB_texture_env_combine is the main extension this system builds on.",childs={}}
vertextype = {type='class',description="For usercreated meshes it is necessary to specify what vertextype you want to have. Different vertextypes have different attributes and sizes.",childs={["vertex16color"] = {type='function', description = " size 16 bytes, position (3 floats), color (4 unsigned byte).", args="()", returns="(vertextype)"},
["memtotex2"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["vertex64skin"] = {type='function', description = " size 64 bytes, normals (3 shorts), position (3 floats), color (4 unsigned bytes), 2 texcoord channels (2*2 floats), tangents (4 shorts). Supports 4-weight hardware skinning using 4 unsigned bytes for indices and 4 unsigned shorts for weights.", args="()", returns="(vertextype)"},
["memtoblendw"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["memtotex0"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["tangenttype"] = {type='function', description = " returns scalartype of the attribute or nil if not found.", args="(vertextype)", returns="([scalartype])"},
["vertex32tex2"] = {type='function', description = " size 32 bytes, position (3 floats), color (4 unsigned byte), 2 texcoord channels (2*2 floats).", args="()", returns="(vertextype)"},
["memsize"] = {type='function', description = " returns size in bytes.", args="(vertextype)", returns="(int bytes)"},
["memtotex1"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["memtocolor"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["textype"] = {type='function', description = " returns scalartype of the attribute or nil if not found.", args="(vertextype)", returns="([scalartype])"},
["memtoblendi"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["memtonormal"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["normaltype"] = {type='function', description = " returns scalartype of the attribute or nil if not found.", args="(vertextype)", returns="([scalartype])"},
["vertex64tex4"] = {type='function', description = " size 64 bytes, normals (3 shorts), position (3 floats), color (4 unsigned bytes), 4 texcoord channels (4*2 floats), tangents (4 shorts). ", args="()", returns="(vertextype)"},
["memtotex3"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["postype"] = {type='function', description = " returns scalartype of the attribute or nil if not found.", args="(vertextype)", returns="([scalartype])"},
["memtopos"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["vertex32normals"] = {type='function', description = " size 32 bytes, normals (3 shorts), position (3 floats), color (4 unsigned bytes), 1 texcoord channel (2 floats).", args="()", returns="(vertextype)"},
["memtotangent"] = {type='function', description = " returns byte offset from start of the vertex to this component. Returns nil if component not part of vertex.", args="(vertextype)", returns="([int bytes])"},
["blenditype"] = {type='function', description = " returns scalartype of the attribute or nil if not found.", args="(vertextype)", returns="([scalartype])"},
["blendwtype"] = {type='function', description = " returns scalartype of the attribute or nil if not found.", args="(vertextype)", returns="([scalartype])"},
["colortype"] = {type='function', description = " returns scalartype of the attribute or nil if not found.", args="(vertextype)", returns="([scalartype])"}}}
particle = {type='class',description="A single static particle part of a l3dpgroup",childs={}}
rcmdclear = {type='class',description="Clears drawbuffers (stencil,depth,color).",childs={["depth"] = {type='function', description = " returns or sets", args="(rcmdclear,[boolean])", returns="([boolean])"},
["colorvalue"] = {type='function', description = " returns or sets", args="(rcmdclear,[float r,g,b,a])", returns="([float r,g,b,a])"},
["color"] = {type='function', description = " returns or sets", args="(rcmdclear,[boolean])", returns="([boolean])"},
["stencilvalue"] = {type='function', description = " returns or sets", args="(rcmdclear,[int])", returns="([int])"},
["stencil"] = {type='function', description = " returns or sets", args="(rcmdclear,[boolean])", returns="([boolean])"},
["depthvalue"] = {type='function', description = " returns or sets", args="(rcmdclear,[float 0-1])", returns="([float])"},
["colormode"] = {type='function', description = " returns or sets mode for color (0 float, 1 int, 2 uint) must have appropriate rendertarget!", args="(rcmdclear,[int 0-2])", returns="([int])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdclear)"}}}
trackid = {type='class',description="trackid - a track within animation contains prskey changes",childs={["updatekey"] = {type='function', description = " computes key for given time", args="(trackid,[matrix4x4],int time,boolean spline)", returns="()"}}}
rcmd = {type='class',description="The rendercommand mechanism allows you to program the renderer of each l3dview. You can precisely define what you want to render and in which order.",childs={["flag"] = {type='function', description = " sets rcmd process bit flag. If rcmdflag of view AND the own flag bitwise return true, then the rcmd will be processed. id = 0..31", args="(rcmd,int id,[boolean])", returns="([boolean])"}}}
textype = {type='class',description="For creating textures or renderbuffers this defines the internal storage. Be aware that the rendersystem might not always be able to provide the format you asked for. Some types are baseformats which will leave it up to driver on which internalmode to pick. Formats such as depth and depth_stencil require special capabilities",childs={["r"] = {type='function', description = " baseformat for R (needs capability.texrg)", args="()", returns="(textype)"},
["depth24"] = {type='function', description = " 24 bit DEPTH_COMPONENT", args="()", returns="(textype)"},
["lumalpha"] = {type='function', description = " baseformat for LUMINANCE_ALPHA", args="()", returns="(textype)"},
["depth32"] = {type='function', description = " 32 bit DEPTH_COMPONENT", args="()", returns="(textype)"},
["stencil"] = {type='function', description = " baseformat for STENCIL_INDEX. only for renderbuffers", args="()", returns="(textype)"},
["abgr"] = {type='function', description = " reverses order of data for RGBA, internal remains baseformat", args="()", returns="(textype)"},
["alpha"] = {type='function', description = " baseformat for ALPHA", args="()", returns="(textype)"},
["rgba"] = {type='function', description = " baseformat for RGBA", args="()", returns="(textype)"},
["lum"] = {type='function', description = " baseformat for LUMINANCE", args="()", returns="(textype)"},
["rgb"] = {type='function', description = " baseformat for RGB", args="()", returns="(textype)"},
["depthstencil"] = {type='function', description = " baseformat for DEPTH_STENCIL", args="()", returns="(textype)"},
["bgr"] = {type='function', description = " reverses order of data for RGB, internal remains baseformat", args="()", returns="(textype)"},
["bgra"] = {type='function', description = " reverses order of data for RGBA, internal remains baseformat", args="()", returns="(textype)"},
["depth"] = {type='function', description = " baseformat for DEPTH_COMPONENT", args="()", returns="(textype)"},
["rg"] = {type='function', description = " baseformat for RG (needs capability.texrg)", args="()", returns="(textype)"},
["depth16"] = {type='function', description = " 16 bit DEPTH_COMPONENT", args="()", returns="(textype)"}}}
pgraph = {type='class',description="profiling graph. If render.drawpgraph is enabled sampling is done per frame and rendered as line graph at the end.",childs={["getl3d"] = {type='function', description = " l3d pgraph is subpart of render pgraph)", args="()", returns="(pgraph)"},
["color"] = {type='function', description = " returns or sets color of the pgraph", args="(pgraph,[float r,g,b])", returns="([float r,g,b])"},
["getparticle"] = {type='function', description = " particle pgraph is subpart of render pgraph.", args="()", returns="(pgraph)"},
["drawpos"] = {type='function', description = " returns or sets position of the pgraphs", args="([float x,y,z])", returns="([float x,y,z])"},
["renderfinish"] = {type='function', description = " renderpgraph will show full rendering time, it will wait until all rendering commands are executed by driver. This will reduce performance greatly as it kills all parallelism.", args="([boolean])", returns="([boolean])"},
["getl2d"] = {type='function', description = " l2d pgraph is subpart of render pgraph", args="()", returns="(pgraph)"},
["getuser0"] = {type='function', description = " user pgraph, the only ones you should be adding samples to", args="()", returns="(pgraph)"},
["stipple"] = {type='function', description = " returns or sets if stippling should be used", args="(pgraph,[float r,g,b])", returns="([float r,g,b])"},
["getvistest"] = {type='function', description = " vistest frame pgraph", args="()", returns="(pgraph)"},
["draw"] = {type='function', description = " draw pgraph individually or all, also enables time sampling.", args="([pgraph],[boolean])", returns="([boolean])"},
["getphysics"] = {type='function', description = " ode simulation pgraph.", args="()", returns="(pgraph)"},
["getuser3"] = {type='function', description = " user pgraph, the only ones you should be adding samples to", args="()", returns="(pgraph)"},
["starttimesample"] = {type='function', description = " starts a time sample. (in milliseconds)", args="(pgraph)", returns="()"},
["drawmax"] = {type='function', description = " returns or sets maximum value,individually or for all. (default is 16.667 for 60 fps as internal graphs sample in milliseconds). When drawing the values are scaled and clamped accordingly.", args="([pgraph],[float])", returns="([float])"},
["endtimesample"] = {type='function', description = " ends the time sample and adds it to graph.", args="(pgraph)", returns="()"},
["getuser1"] = {type='function', description = " user pgraph, the only ones you should be adding samples to", args="()", returns="(pgraph)"},
["addsample"] = {type='function', description = " adds a sample to the cached values.", args="(pgraph,float sample)", returns="()"},
["getuser2"] = {type='function', description = " user pgraph, the only ones you should be adding samples to", args="()", returns="(pgraph)"},
["getthink"] = {type='function', description = " think pgraph (lua mostly).", args="()", returns="(pgraph)"},
["getrender"] = {type='function', description = " rendering pgraph without full accurate driver time (unless pgraph.renderfinish is set)", args="()", returns="(pgraph)"},
["drawsize"] = {type='function', description = " returns or sets size of the pgraphs", args="([float x,y])", returns="([float x,y])"}}}
vistest = {type='class',description="The Vistest system is responsible for culling of spatialnodes, which can be drawable. It also takes care of assigning l3dlights and l3dprojects to such nodes. With render.drawvisspace you can make several of the octrees used visible.",childs={["maxdepthcamera"] = {type='function', description = " sets/gets maximum octree depth for l3dcamera octree.", args="([int])", returns="([int])"},
["volcheckcnt"] = {type='function', description = " sets/gets how many items an octree node must have to do an additional check on its subvolume, which might be smaller than the ocnodes outer bounds.", args="([int])", returns="([int])"},
["maxdepthscene"] = {type='function', description = " sets/gets maximum octree depth for scenenode octree.", args="([int])", returns="([int])"},
["maxdepthvislight"] = {type='function', description = " sets/gets maximum octree depth for visible l3dlight octree, used for light source finding.", args="([int])", returns="([int])"},
["maxdepthactor"] = {type='function', description = " sets/gets maximum octree depth for actornode octree.", args="([int])", returns="([int])"},
["maxdepthlight"] = {type='function', description = " sets/gets maximum octree depth for l3dlight octree.", args="([int])", returns="([int])"},
["maxdepthproj"] = {type='function', description = " sets/gets maximum octree depth for l3dprojector octree.", args="([int])", returns="([int])"}}}
model = {type='class',description="A model contains triangle meshes and bonesystems, it can also have skin information for weighted vertex deformation based on bones. Models can be animateable or static, they can also have normals for lighting computation or simple vertex data. The information is needed for optimized storage and rendering of the model.<br> Every model can be loaded only once, so if one instance needs lighting use neednormals.",childs={["meshcount"] = {type='function', description = " returns number of meshes within model.", args="(model)", returns="(int)"},
["setanimcache"] = {type='function', description = " updates the animcache of a model with the given data. There is no visual effect of this operation, but only to be able to compute animation results without visual representation and query results via the boneid functions.", args="(model,animation, int time,[matrix4x4 rootmatrix])", returns="()"},
["bonecount"] = {type='function', description = " returns number of bones within model.", args="(model)", returns="(int)"},
["bbox"] = {type='function', description = " returns or sets bounding box. Returning can be done with matrix transformation applied (computes new AABB based)", args="(model,[matrix4x4/float minx,miny,minz, maxx,maxy,maxz])", returns="([float minx,miny,minz, maxx,maxy,maxz])"},
["getrestype"] = {type='function', description = " returns the resource type as int value, useful for resdata or reschunk functions", args="()", returns="(int restype)"},
["meshid"] = {type='function', description = " returns meshid within model. If a string is applied, a mesh with that name is seeked and if it doesn't exist, nothing is returned. If a number is passed, the mesh with this index is returned, or an error is thrown to a index out of bounds exception. The index must be >=0 and <meshcount.", args="(model,[string meshname/int index])", returns="(meshid)"},
["skinid"] = {type='function', description = " returns skinid within model. The skin with this index is returned, or an 		error is thrown to a index out of bounds exception. The index must be >=0 and < skincount.", args="(model,[int index])", returns="(boneid)"},
["skincount"] = {type='function', description = " returns number of skins within model.", args="(model)", returns="(int)"},
["updatebbox"] = {type='function', description = " updates bounding box based on current vertices and reference bones.", args="(model)", returns="()"},
["loaderprescale"] = {type='function', description = " prescales vertices and bone positions with a given vector. The factor remains active for all follwing 'model.load' calls. Animations based on original size may cause problems. Prescale will be reapplied if the model is reloaded from disk again.", args="([float x,y,z])", returns="([float x,y,z])"},
["removefromanim"] = {type='function', description = " when animations are applied to models, they create an assignlist for each model to speed up track/bone matching. If you know this model will not use the given animation again, you can remove it from that list for speed's sake.", args="(model,animation)", returns="()"},
["getboneparents"] = {type='function', description = " returns an array of the parent index for every bone. We start at 0 not 1. -1 means it has no parent. With model.boneid(index) command you can get more info about the bone.", args="(model)", returns="([array int])"},
["forceload"] = {type='value', description = "(model):(string filename,[boolean animateable],[boolean neednormals],[boolean bigvertex],[boolean nodisplaylist],[boolean novbo] - same as load but enforces to load a copy if resource was loaded before.)"},
["create"] = {type='function', description = " returns an empty model, using boneid,meshid,skinid.init as well as vertex-/indexarrays you can fill it with content. To make it useable you must run the createfinish command after you set all data. There will be bonecount+meshcount bones at start, and the first bones are linked with the meshes.", args="(string name, vertextype, int meshcount, int bonecount,[int skincount])", returns="(model)"},
["boneid"] = {type='function', description = " returns boneid within model. If a string is applied, a bone with that name is seeked and if it doesn't exist, nothing is returned. If a number is passed, the bone with this index is returned, or an error is thrown to a index out of bounds exception. The index must be >=0 and <bonecount.", args="(model,[string bonename/int index])", returns="(boneid)"},
["setmeshtype"] = {type='function', description = " updates all meshes with given type. defaults for displaylist: lmcoords = false, vertexcolors = true", args="(model,meshtype,[boolean lmcoords],[boolean vertexcolors])", returns="()"},
["createfinish"] = {type='function', description = " returns itself after successful compiling and errorchecking. To make the model useable you must call this function after all data was set. It will load all needed textures and materials as well as creating proper bone hierarchy. If it's not animateable we will precompute all vertices and remove bonelinks from meshids, as well as compute the internal bounding box. For last two parameters see load command (set both false if you know that you will often change vertex/index data). If skins are set and model is animateable, those will be initialized as well.", args="(model,boolean animatable,[boolean nodisplaylist],[boolean novbo],[boolean lmcoords])", returns="(model)"},
["load"] = {type='function', description = " loads a model. Bigvertex means that multiple texcoords, hardware skinning, normal mapping.. can be used. If you pass the novbo and nodisplaylist with true, then the model will not get special GL memory processing for faster rendering, it is supposedly used for compiled l3dmodels. Normally the engine will favor vbo if avaliable over displaylists. However as displaylists allow only few changes (need to use same shader, cant disable vertexcolors) depending on your needs it is useful to disable them. VBOs dont have those disadvantages, but can be costly for older cards if the model has just very few vertices.<br> When you should need lightmap texcoords use lmcoords with true.<br>(defaults: neednormals:true, rest:false)<", args="(string filename,[boolean animateable],[boolean neednormals],[boolean bigvertex],[boolean nodisplaylist],[boolean novbo],[boolean lmcoords])", returns="(model)"},
["defaultpath"] = {type='function', description = " returns or sets the default resource path. Luxinia will search in those when resources are not found.", args="([string])", returns="([string])"}}}
dgeom = {type='class',description="Geoms are solid objects that can collide with other geoms.",childs={["fdirpriority"] = {type='function', description = " sets/gets priority of the fdirnormal. The priority can be used in different ways.", args="(dgeom geom,[float])", returns="([float])"},
["world2local"] = {type='function', description = " transforms the given coordinates from world coordinates into local coordinates of the geom.", args="(dgeom geom,float x,y,z)", returns="(float x,y,z)"},
["fdirnormal"] = {type='function', description = " sets/gets normal vector to the friction direction vector that defines a direction along which frictional force is applied. The friction direction vector is computed as the crossproduct of the contactnormal and the normal vector that is defined here.", args="(dgeom geom,[float x,y,z])", returns="([float x,y,z])"},
["setcategory"] = {type='function', description = " sets/gets raw category bits as number", args="(dgeom,int set {0,1})", returns="([int])"},
["body"] = {type='function', description = " sets/gets the geom - if 2nd arg is not a dbody, it removes the geom from the body. The geom must not be transformed if a body is set. If the geom is transformed and the body is requested, the function will look look up the body of the transformer in a loop.", args="(dgeom geom, [dbody body/other])", returns="(dbody body)"},
["maxcontacts"] = {type='function', description = " sets/gets maximum number of contacts for this geom. If two geoms are tested for collision, multiple contacts can be generated for this case. If a geom has a limited number of possible contacts (set <=0 for deactivation of maximum), the minimum of maxcontacts of both geoms is chosen. Reducing the number of contacts max boost up the simulation, but can cause jittering of bodies, making autodisabling useless. Defaultvalue is 0 (no limit), but the general limit of contacts per geom is 128. The effect depends on the geom type. For example, two colliding spheres will never generate more than one contact, while two colliding boxes can generate not more than 4 contacts. Only if a geom collides with a complex trimesh, the limit can be exceeded.", args="(dgeom geom,[int])", returns="([int])"},
["maxcontactinfo"] = {type='function', description = " sets/gets the maximum number of generated contact info. The contactinfo is a structure that stores the coordinates, the normal and the depth of a contact. This is normaly also stored in a contactjoint that is generated from a contact. However, if you want to create a geom that only works as a sensor for collision (i.e. if a door should open if someone stands in front of it), and turn nocontactgeneration on, you can retrieve contactinformation from such geoms.", args="(dgeom geom, [int])", returns="([int])"},
["transformer"] = {type='function', description = " returns the geomtransform that transforms the geom or returns nothing if the geom is not transformed. Note that you might get the 'final' geom in the transformhierarchy if you get a collision feedback, what may not be what you want / need.", args="(dgeom)", returns="([dgeomtransform])"},
["rotdeg"] = {type='function', description = " sets/gets rotation of geom. The angles must be calculated from a matrix, so the results can differ from what you set. These matrix calculations are quite expensive, so use it with care. This function uses x,y,z as angles in degrees (180°==PI).", args="(dgeom geom,[float x,y,z])", returns="([float x,y,z])"},
["matrix"] = {type='function', description = " sets/gets matrix of geom", args="(dgeom geom,[matrix4x4])", returns="([matrix4x4])"},
["enabledspace"] = {type='function', description = " The enabledspace is the space a geom is put into if it has no body or if its body is enabled. This is usefull if you have a large amount of bodies that should collide with each other but that are disabled most of the time.", args="(dgeom geom,[dspace])", returns="([dspace])"},
["rotrad"] = {type='function', description = " sets/gets rotation of geom. The angles must be calculated from a matrix, so the results can differ from what you set. These matrix calculations are quite expensive, so use it with care. This functions uses x,y,z as angles in radians (180°==PI)", args="(dgeom geom,[float x,y,z])", returns="([float x,y,z])"},
["getcontactinfo"] = {type='value', description = "(int / float x,y,z, nx,ny,nz, depth, dgeom othergeom):(dgeom geom, [int index])If contacts have been generated in your simulation and you have set the maxcontactinfo value for this geom to a value>0, a collision generation that creates contacts will also store the contact results in the contactinfo of the geom. You can read out the values for contact generation with this function. If no index is given as argument, the number of stored contactinformation are returned for this geom. If an index is passed, the contactinformation for this index is returned. The index must be >=0 and <contactcount in order to return valid values. The returned values are the position, the normalvector and the depth (distance) of the penetraction."},
["surfaceid"] = {type='function', description = " sets/gets surfaceid of geom (0-255). If two geoms generate a contact, the surfaceproperties must be specified. These properties can be rather complicated and may depend from the type of the surface (rubber on glas won't slide, wood on glas slides, both slides on ice, but both don't slide at each other very well, etc.). In order to give you as much control as possible, yet keeping it as simple as possible, you can specify every surfacecombination that you wish by defining a list of contactparameters and defining the surface to be used by a combination of surfaceids.", args="(dgeom,[int])", returns="([int])"},
["rotquat"] = {type='function', description = " sets/gets 					 rotation of geom as quaternion.", args="(dgeom geom,[float x,y,z,w])", returns="([float x,y,z,w])"},
["category"] = {type='function', description = " Sets ODE's collide and category bits. A geom can gollidewith other geoms if cat1&col2 or cat2&col1 are not zero.\
\
ODE uses collide and categorybits to reject geoms for collision. They can be used to prevent collision between certain geoms. A collision is rejected if both the bitset 1 of geom A doesn't have bits in common with the bitset 2 of geom B, and if the bitset 2 of geom A doesn't have bits in common with bitset 1 of geom B.", args="(dgeom,int set {0-1}, int bit {0-31}, [boolean on])", returns="([boolean])"},
["motion2"] = {type='function', description = " sets/gets motion values of surface. This means that the contact will look like in motion for other objects that are in contact with this geom. Behavior is undefined if the fdirmixing is set to priority or average.", args="(dgeom geom,[float])", returns="([float])"},
["motion1"] = {type='function', description = " sets/gets motion values of surface. This means that the contact will look like in motion for other objects that are in contact with this geom. Behavior is undefined if the fdirmixing is set to priority or average.", args="(dgeom geom,[float])", returns="([float])"},
["disabledspace"] = {type='function', description = " The disabledspace is the space a geom is put into if it has a body that is disabled. This is usefull if you have a large amount of bodies that should collide with each other but that are disabled most of the time.", args="(dgeom geom,[dspace])", returns="([dspace])"},
["rotaxis"] = {type='value', description = "([float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz]) : (dgeom geom,[float Xx,Xy,Xz, Yx,Yy,Yz, Zx,Zy,Zz])) - returns or sets local rotation axis, make sure they make a orthogonal basis."},
["nocontactgenerator"] = {type='function', description = " sets/gets if contacts should be generated for this geom. You might want to deactivate contactgeneration for geoms that only should act as sensors in your physical environment.", args="(dgeom geom, [boolean])", returns="([boolean])"},
["local2world"] = {type='function', description = " transforms the given coordinates with the matrix of the geom, as if x,y,z are local coordinates of the geom and world coordinates are returned.", args="(dgeom geom,float x,y,z)", returns="(float x,y,z)"},
["pos"] = {type='function', description = " sets/gets position of geom", args="(dgeom geom,[float x,y,z])", returns="([float x,y,z])"}}}
rcmdshaders = {type='class',description="Sets use of baseshaders",childs={["shaderstage"] = {type='function', description = " returns or sets shaderstage of the material. A material can define up to 4 shaders, the id that you pass here will be used. If a material does not have a shader with the given id, we will use the color-only baseshader. Only active if usebaseshaders is true.", args="(rcmdshaders,[int 0-3])", returns="([int])"},
["shaders"] = {type='function', description = " returns or sets baseshaders. Any non-material mesh, ie just having a texture or just having a color, will use those shaders and pass its texture (if exists) as Texture:0 to the shader.", args="(rcmdshaders,[shader color-only,shader color_lightmap,shader 1tex,shader 1tex_lightmap])", returns="([shader color-only,shader color_lightmap,shader 1tex,shader 1tex_lightmap])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdshaders)"}}}
input = {type='class',description="Luxinia's function publishing  does not offer direct calling of external functions if an event arises, such as key or mouseinputs. Instead, Luxinia saves event occurances in queues that can be processed when the scripting language is running.",childs={["popkey"] = {type='function', description = " pops a key from keyhistoryqueue. The key is the resulted char of the keyboard. The keycode is the number on the keyboard, which doesn't have to be a printable letter. In case of unprintable letters, key is 0.", args="()", returns="([int key, int keycode, boolean isDown])"},
["iskeydown"] = {type='function', description = " returns true if the key is pressed.", args="(int keycode)", returns="(boolean isDown)"},
["intrecord"] = {type='function', description = " sets or gets if internal record via auto screenshot is allowed (F11).", args="([boolean on])", returns="([boolean on])"},
["mousewheel"] = {type='function', description = " sets or gets mousewheelposition", args="([int])", returns="([int])"},
["ismousedown"] = {type='function', description = " returns true if the mousebutton is currently hold down. The mousebutton must be >=0 and <3 where 0 is the left, 1 the right and 2 the middle mousebutton. ", args="(int mousebutton)", returns="(boolean isDown)"},
["escquit"] = {type='function', description = " sets or gets quit when esc is pressed", args="([boolean on])", returns="([boolean on])"},
["joystick"] = {type='function', description = " returns joystick position and currently pressed buttons or false, if the given number does not exist. If no number is passed, joystick 0 is used. nr must be smaller than 16 and >= 0. Luxinia limits the number of axis to 8 and the number of buttons to 32, which should be enough.", args="([int nr])", returns="(boolean exists,[int joysticknr,int axiscount,int btncnt, float pos1,..., boolean btn1,...])"},
["mousepos"] = {type='function', description = " sets or gets mouseposition in reference coordinates (see window.refsize)", args="([float x,y])", returns="([float x,y])"},
["popmouse"] = {type='function', description = " pops a mouseevent from queue. -1 button means no button changes (only motion).", args="()", returns="([float x,y, int button, boolean isDown,float time_seconds])"},
["fixmouse"] = {type='function', description = " If the OS mousecursor is not shown, this flag is either locking the mousecursor at the center of the window or disallows it. Per default, this value is set to true.", args="(boolean fix)", returns="([boolean fixed])"},
["intscreenshot"] = {type='function', description = " sets or gets if internal screenshot is allowed (F3 jpg, F4 tga).", args="([boolean on])", returns="([boolean on])"},
["intconsole"] = {type='function', description = " sets or gets if internal console is allowed (F1).", args="([boolean on])", returns="([boolean on])"},
["showmouse"] = {type='function', description = " sets mouse visibility of the operating system. Only if the mouse is visible, it can be moved out from the window. The invisible mouse may have coordinates that are outside the window. Initially, the mouse is invisible. If the console is activated and deactivated, the visibilitystatus is set to invisible again.", args="(boolean visible)", returns="()"}}}
rcmdfborb = {type='class',description="Attaches renderbuffers to the current bound fbo. By default the drawbuffer is used for assignments.",childs={["readbuffer"] = {type='function', description = " returns or sets whether target is readbuffer fbo binding, or drawbuffer. Readbuffer functionality requires extra capability and by default is off.", args="(rcmdfbobind, [boolean readbuffer])", returns="([boolean readbuffer])"},
["stencil"] = {type='function', description = " returns or sets renderbuffer attachment for stencil target. You can disable assignment by passing 0.", args="(rcmdfborb,[renderbuffer])", returns="([renderbuffer])"},
["depth"] = {type='function', description = " returns or sets renderbuffer attachment for depth target. You can disable assignment by passing 0.", args="(rcmdfborb,[renderbuffer])", returns="([renderbuffer])"},
["color"] = {type='function', description = " returns or sets renderbuffer attachments for color targets 0..3. You can disable certain assignments by passing 0.", args="(rcmdfborb,int clr,[renderbuffer])", returns="([renderbuffer])"},
["new"] = {type='function', description = " returns the rcmd", args="()", returns="(rcmdfborb)"}}}
rcmdfboreadfrom = {type='class',description="Sets from which color attachments data should be read.",childs={["setup"] = {type='function', description = " returns or sets the active color readbuffer.", args="(rcmdfboreadfrom,[int buffer])", returns="([int buffer])"},
["new"] = {type='function', description = " returns the rcmd. By default reads from color attach 0", args="()", returns="(rcmdfboreadfrom)"}}}
dspacesimple = {type='class',description="Simple space. This does not do any collision culling - it simply checks every possible pair of geoms for intersection, and reports the pairs whose AABBs overlap. The time required to do intersection testing for n objects is O(n2). This should not be used for large numbers of objects, but it can be the preferred algorithm for a small number of objects. This is also useful for debugging potential problems with the collision system.",childs={["new"] = {type='function', description = " creates a simple space if space is given, the new space is inserted in the given space", args="([dspace space])", returns="(dspacesimple)"}}}
end

local ret = {}
setfenv(generate,ret)()
return ret
