/*
 * Decompiled with CFR 0.152.
 */
package util;

import controlador.Editor;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;

public class Utilidades {
    public static String ColorToString(Color c) {
        String res = String.valueOf(c.getRed());
        res = res + "," + String.valueOf(c.getGreen());
        res = res + "," + String.valueOf(c.getBlue());
        res = res + "," + String.valueOf(c.getAlpha());
        return res;
    }

    public static Color StringToColor(String str) {
        String[] res = str.split(",");
        int r = Integer.parseInt(res[0]);
        int g = Integer.parseInt(res[1]);
        int b = Integer.parseInt(res[2]);
        int a = Integer.parseInt(res[3]);
        return new Color(r, g, b, a);
    }

    public static String TryIntStr(String res, String retornoEmCasoDeErro) {
        try {
            int r = Integer.valueOf(res);
        }
        catch (NumberFormatException e) {
            return retornoEmCasoDeErro;
        }
        return res;
    }

    public static int TryIntStr(String res, int retornoEmCasoDeErro) {
        int r;
        try {
            r = Integer.valueOf(res);
        }
        catch (NumberFormatException e) {
            return retornoEmCasoDeErro;
        }
        return r;
    }

    public static Color CorInversa(Color cor) {
        int A = cor.getAlpha();
        int R = 255 - cor.getRed();
        int G = 255 - cor.getGreen();
        int B = 255 - cor.getBlue();
        return new Color(R, G, B, A);
    }

    public static String decodeFontStyle(int style) {
        switch (style) {
            case 1: {
                return Editor.fromConfiguracao.getValor("Inspector.obj.font.bold");
            }
            case 0: {
                return Editor.fromConfiguracao.getValor("Inspector.obj.font.plain");
            }
            case 2: {
                return Editor.fromConfiguracao.getValor("Inspector.obj.font.italic");
            }
            case 3: {
                return Editor.fromConfiguracao.getValor("Inspector.obj.font.bolditalic");
            }
        }
        return "";
    }

    public static String ArrayToStr(String[] arr) {
        String res = "";
        for (String a : arr) {
            res = res.isEmpty() ? a : res + "," + a;
        }
        return res;
    }

    public static boolean IsUpper(String texto) {
        return texto.toUpperCase().equals(texto);
    }

    public static String Hexadecimal(byte[] arr) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            int parteAlta = (arr[i] >> 4 & 0xF) << 4;
            int parteBaixa = arr[i] & 0xF;
            if (parteAlta == 0) {
                s.append('0');
            }
            s.append(Integer.toHexString(parteAlta | parteBaixa));
        }
        return s.toString();
    }

    public static byte[] HexadecimalToByteArr(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static Rectangle Grow(Rectangle rect, int x, int y, int desconto) {
        return new Rectangle(rect.x - x, rect.y - y, rect.width + 2 * x - desconto, rect.height + 2 * y - desconto);
    }

    public static String[] getFontsList() {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        return envfonts;
    }

    public static final double distance(Point p, Point q) {
        double dx = p.x - q.x;
        double dy = p.y - q.y;
        double dist = Math.sqrt(dx * dx + dy * dy);
        return dist;
    }

    public static String EncapsuleMsg(String msg, Object[] param) {
        return String.format(Editor.fromConfiguracao.getValor("Controler.interface.mensagem." + msg), param);
    }

    public static String EncapsuleMsg(String msg, String param) {
        return Utilidades.EncapsuleMsg(msg, new Object[]{param});
    }

    public static String EncapsuleMsg(String msg, String param1, String param2) {
        return Utilidades.EncapsuleMsg(msg, new Object[]{param1, param2});
    }

    public static String textoParaCampo(String original) {
        return original.replaceAll("[\u00e3\u00e2\u00e0\u00e1\u00e4]", "a").replaceAll("[\u00ea\u00e8\u00e9\u00eb]", "e").replaceAll("[\u00ee\u00ec\u00ed\u00ef]", "i").replaceAll("[\u00f5\u00f4\u00f2\u00f3\u00f6]", "o").replaceAll("[\u00fb\u00fa\u00f9\u00fc]", "u").replaceAll("[\u00c3\u00c2\u00c0\u00c1\u00c4]", "A").replaceAll("[\u00ca\u00c8\u00c9\u00cb]", "E").replaceAll("[\u00ce\u00cc\u00cd\u00cf]", "I").replaceAll("[\u00d5\u00d4\u00d2\u00d3\u00d6]", "O").replaceAll("[\u00db\u00d9\u00da\u00dc]", "U").replace('\u00e7', 'c').replace('\u00c7', 'C').replace('\u00f1', 'n').replace('\u00d1', 'N').replaceAll("!", "").replaceAll("[\\[\\\u00b4\\`\\?!\\@\\#\\$\\%\\\u00a8\\*]", "_").replaceAll("[\\(\\)\\=\\{\\}\\~\\^\\]]", "_").replaceAll("[\\.\\;\\-\\+\\'\\\u00aa\\\u00ba\\:\\;\\/]", "_").replaceAll("\\s+", "_");
    }
}

