/*
 * Decompiled with CFR 0.152.
 */
package desenho.preDiagrama;

import controlador.apoios.IObjetoPintavel;
import controlador.apoios.ProcessadorExprSimples;
import desenho.preDiagrama.iBaseDrawer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.BrLogger;
import util.TratadorDeImagens;
import util.Utilidades;
import util.XMLGenerate;

public class baseDrawerItem
implements Serializable,
IObjetoPintavel {
    private static final long serialVersionUID = 7929621219268376814L;
    private final iBaseDrawer dono;
    public static final boolean VERTICAL = true;
    private transient boolean outroPintor = false;
    private Color cor = Color.BLACK;
    private boolean invertido = false;
    private String path = "L, T, L + W - 2, T + H - 2, L, T + H - 2, L, T";
    private boolean fill = true;
    private boolean recivePaint = false;
    private String retangulo = "L,T,W-2,H-2";
    private String curva = "L, T, L + W - 2, T + H - 2, L, T + H - 2, L, T";
    private String elipse = "L, T, W - 2, H - 2";
    private String arco = "L,T,W,H,90,135,0";
    private String posiImagem = "L,T,200,200";
    private transient Image imgres = null;
    private transient BufferedImage imagem = null;
    protected byte[] byteImage = null;
    private tipoDrawer tipo = tipoDrawer.tpRetangulo;
    private int left = 0;
    private int top = 0;
    private int width = 50;
    private int height = 50;
    private boolean gradiente = false;
    private Color gradienteEndColor = new Color(204, 204, 204, 255);
    private Color gradienteStartColor = Color.BLACK;
    private boolean vertical = true;
    private int direcaogradiente = 0;
    protected Color disabledColor = new Color(221, 221, 221);
    private boolean disablePainted = false;

    public baseDrawerItem(iBaseDrawer dono) {
        this.dono = dono;
    }

    public baseDrawerItem(iBaseDrawer dono, tipoDrawer tp) {
        this.dono = dono;
        this.tipo = tp;
    }

    @Override
    public void setOutroPintor(boolean op) {
        this.outroPintor = op;
    }

    @Override
    public boolean isOutroPintor() {
        return this.outroPintor;
    }

    public String getRetangulo() {
        return this.retangulo;
    }

    public void setRetangulo(String retangulo) {
        this.retangulo = retangulo;
    }

    public String getCurva() {
        return this.curva;
    }

    public void setCurva(String curva) {
        this.curva = curva;
    }

    public String getElipse() {
        return this.elipse;
    }

    public void setElipse(String elipse) {
        this.elipse = elipse;
    }

    public String getArco() {
        return this.arco;
    }

    public void setArco(String arco) {
        this.arco = arco;
    }

    public int getDirecaogradiente() {
        return this.direcaogradiente;
    }

    public void setDirecaogradiente(int direcaogradiente) {
        this.direcaogradiente = direcaogradiente;
    }

    public boolean LoadFromXML(Element me, boolean colando) {
        this.SetTipo(Integer.valueOf(XMLGenerate.GetValorString(me)));
        this.setCor(XMLGenerate.getValorColorFrom(me, "Cor"));
        this.setGradienteEndColor(XMLGenerate.getValorColorFrom(me, "GradienteEndColor"));
        this.setGradienteStartColor(XMLGenerate.getValorColorFrom(me, "GradienteStartColor"));
        this.setInvertido(XMLGenerate.getValorBooleanFrom(me, "Invertido"));
        this.setFill(XMLGenerate.getValorBooleanFrom(me, "Fill"));
        this.setRecivePaint(XMLGenerate.getValorBooleanFrom(me, "RecivePaint"));
        this.setGradiente(XMLGenerate.getValorBooleanFrom(me, "Gradiente"));
        this.setVertical(XMLGenerate.getValorBooleanFrom(me, "Vertical"));
        this.setPath(XMLGenerate.getValorStringFrom(me, "Path"));
        this.setRetangulo(XMLGenerate.getValorStringFrom(me, "Retangulo"));
        this.setCurva(XMLGenerate.getValorStringFrom(me, "Curva"));
        this.setElipse(XMLGenerate.getValorStringFrom(me, "Elipse"));
        this.setArco(XMLGenerate.getValorStringFrom(me, "Arco"));
        this.setPosiImagem(XMLGenerate.getValorStringFrom(me, "PosiImagem"));
        this.setDirecaogradiente(XMLGenerate.getValorIntegerFrom(me, "Direcaogradiente"));
        Rectangle r = XMLGenerate.getValorRectFrom(me, "Bounds");
        this.setLeft(r.x);
        this.setTop(r.y);
        this.setWidth(r.width);
        this.setHeight(r.height);
        String tmp = XMLGenerate.getValorTextoFrom(me, "Image");
        if (tmp != null) {
            this.byteImage = Utilidades.HexadecimalToByteArr(tmp);
        }
        return true;
    }

    public void ToXml(Document doc, Element root) {
        Element me = XMLGenerate.ValorInteger(doc, this.getClass().getSimpleName(), this.tipo.ordinal());
        me.appendChild(XMLGenerate.ValorColor(doc, "Cor", this.getCor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteEndColor", this.getGradienteEndColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteStartColor", this.getGradienteStartColor()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Invertido", this.isInvertido()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Fill", this.isFill()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "RecivePaint", this.isRecivePaint()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Gradiente", this.isGradiente()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Vertical", this.isVertical()));
        me.appendChild(XMLGenerate.ValorString(doc, "Path", this.getPath()));
        me.appendChild(XMLGenerate.ValorString(doc, "Retangulo", this.getRetangulo()));
        me.appendChild(XMLGenerate.ValorString(doc, "Curva", this.getCurva()));
        me.appendChild(XMLGenerate.ValorString(doc, "Elipse", this.getElipse()));
        me.appendChild(XMLGenerate.ValorString(doc, "Arco", this.getArco()));
        me.appendChild(XMLGenerate.ValorString(doc, "PosiImagem", this.getPosiImagem()));
        me.appendChild(XMLGenerate.ValorRect(doc, "Bounds", new Rectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight())));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Direcaogradiente", this.getDirecaogradiente()));
        if (this.byteImage != null) {
            me.appendChild(XMLGenerate.ValorText(doc, "Image", Utilidades.Hexadecimal(this.byteImage)));
        }
        root.appendChild(me);
    }

    public void DoAnyThing(int Tag) {
        if (Tag == 1) {
            this.Proporcao();
        }
    }

    public baseDrawerItem Clone(baseDrawerItem origem) {
        this.setTipo(origem.getTipo());
        this.setCor(origem.getCor());
        this.setGradienteEndColor(origem.getGradienteEndColor());
        this.setGradienteStartColor(origem.getGradienteStartColor());
        this.setInvertido(origem.isInvertido());
        this.setFill(origem.isFill());
        this.setRecivePaint(origem.isRecivePaint());
        this.setGradiente(origem.isGradiente());
        this.setVertical(origem.isVertical());
        this.setPath(origem.getPath());
        this.setRetangulo(origem.getRetangulo());
        this.setCurva(origem.getCurva());
        this.setElipse(origem.getElipse());
        this.setArco(origem.getArco());
        this.setPosiImagem(origem.getPosiImagem());
        this.setDirecaogradiente(origem.getDirecaogradiente());
        this.setLeft(origem.getLeft());
        this.setTop(origem.getTop());
        this.setWidth(origem.getWidth());
        this.setHeight(origem.getHeight());
        this.byteImage = origem.byteImage;
        return this;
    }

    public Color getCor() {
        return this.isDisablePainted() ? this.disabledColor : this.cor;
    }

    public void setCor(Color cor) {
        this.cor = cor;
    }

    public tipoDrawer getTipo() {
        return this.tipo;
    }

    public void setTipo(tipoDrawer tipo) {
        if (tipo != tipoDrawer.tpImagem && tipo != this.tipo) {
            this.imagem = null;
            this.imgres = null;
            this.byteImage = null;
        }
        this.tipo = tipo;
    }

    public void SetTipo(int tipo) {
        tipoDrawer inttp = tipoDrawer.tpRetangulo;
        try {
            inttp = tipoDrawer.values()[tipo];
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTipo(inttp);
    }

    public void DrawImagem(Graphics2D g) {
        BufferedImage img = this.getImagem();
        if (img == null) {
            return;
        }
        int[] pts = this.ArrayDePontos(this.getPosiImagem());
        if (pts.length != 4) {
            this.posiImagem = "L,T,200,200";
            this.imgres = null;
            pts = this.ArrayDePontos(this.getPosiImagem());
        }
        Rectangle rec = new Rectangle(pts[0], pts[1], pts[2], pts[3]);
        rec.grow(-2, -2);
        if (this.imgres == null) {
            this.imgres = img.getScaledInstance(rec.width, rec.height, 4);
        }
        g.drawImage(this.imgres, rec.x, rec.y, null);
    }

    public BufferedImage getImagem() {
        if (this.imagem == null && this.byteImage != null) {
            this.imagem = this.fromByteArray(this.byteImage);
        }
        return this.imagem;
    }

    public void setImagem(BufferedImage imagem) {
        this.byteImage = this.toByteArray(imagem);
        this.imagem = imagem;
    }

    private BufferedImage fromByteArray(byte[] imagebytes) {
        return TratadorDeImagens.fromByteArray(imagebytes);
    }

    private byte[] toByteArray(BufferedImage bufferedImage) {
        return TratadorDeImagens.toByteArray(bufferedImage);
    }

    public boolean LoadImageFromFile(String arq) {
        this.imagem = null;
        this.imgres = null;
        this.byteImage = null;
        try {
            File fimg = new File(arq);
            this.setImagem(ImageIO.read(fimg));
            this.Proporcao();
            this.dono.InvalidateArea();
        }
        catch (IOException iOException) {
            this.dono.InvalidateArea();
            BrLogger.Logger("ERROR_OPEN_FILE_IMG", iOException.getMessage());
            return false;
        }
        catch (Exception e) {
            this.dono.InvalidateArea();
            BrLogger.Logger("ERROR_OPEN_FILE_IMG", e.getMessage());
            return false;
        }
        if (this.imagem == null) {
            BrLogger.Logger("ERROR_OPEN_FILE_IMG", "[EMPTY IMG?]", "[]");
            return false;
        }
        return true;
    }

    public Point GetImgSize() {
        BufferedImage img = this.getImagem();
        Point res = new Point();
        if (img != null) {
            res = new Point(img.getWidth(), img.getHeight());
        }
        return res;
    }

    private void Proporcao() {
        if (this.GetImgSize().x == 0 || this.GetImgSize().y == 0) {
            return;
        }
        this.imgres = null;
        String[] dist = this.getPosiImagem().split(",");
        int[] pts = this.ArrayDePontos(this.getPosiImagem());
        int x = this.GetImgSize().y * pts[2] / this.GetImgSize().x;
        dist[3] = String.valueOf(x);
        this.setPosiImagem(Utilidades.ArrayToStr(dist));
    }

    public String getPosiImagem() {
        return this.posiImagem;
    }

    public void setPosiImagem(String posiImagem) {
        String[] dist = posiImagem.split(",");
        if (dist.length < 0) {
            posiImagem = "L,T,200,200";
            dist = posiImagem.split(",");
        }
        int[] pts = this.ArrayDePontos(posiImagem);
        dist[3] = String.valueOf(pts[3]);
        dist[2] = String.valueOf(pts[2]);
        this.posiImagem = Utilidades.ArrayToStr(dist);
        this.imgres = null;
    }

    public boolean isRecivePaint() {
        return this.recivePaint;
    }

    public void setRecivePaint(boolean recivePaint) {
        this.recivePaint = recivePaint;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isInvertido() {
        return this.invertido;
    }

    public void setInvertido(boolean invertido) {
        this.invertido = invertido;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Color getGradienteStartColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteStartColor;
    }

    public void setGradienteStartColor(Color gradienteStartColor) {
        this.gradienteStartColor = gradienteStartColor;
    }

    public boolean isGradiente() {
        return this.gradiente;
    }

    public void setGradiente(boolean gradiente) {
        this.gradiente = gradiente;
    }

    public Color getGradienteEndColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteEndColor;
    }

    public void setGradienteEndColor(Color gradienteEndColor) {
        this.gradienteEndColor = gradienteEndColor;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean aDirection) {
        this.vertical = aDirection;
    }

    protected GradientPaint PaintGradiente(Graphics2D g, int l, int t) {
        int w = this.dono.getW();
        int h = this.dono.getH();
        int L = l;
        int T = t;
        boolean dv = this.getDirecaogradiente() == 0;
        return new GradientPaint(L, T, this.getGradienteStartColor(), dv ? (float)L : (float)(L + w), dv ? (float)(T + h) : (float)T, this.getGradienteEndColor(), true);
    }

    @Override
    public void DoPaint(Graphics2D g) {
        int l = this.left;
        int t = this.top;
        if (!this.outroPintor) {
            if (this.getTipo() == tipoDrawer.tpMedida) {
                l = this.dono.getL() + this.left;
                t = this.dono.getT() + this.top;
            } else {
                l = this.dono.getL();
                t = this.dono.getT();
            }
        }
        if (!this.recivePaint) {
            if (this.isGradiente()) {
                g.setPaint(this.PaintGradiente(g, l, t));
            } else {
                g.setColor(this.getCor());
            }
        }
        Shape dr = null;
        boolean ok = false;
        switch (this.tipo) {
            case tpElipse: {
                int[] pts = this.ArrayDePontos(this.getElipse());
                if (pts.length != 4) break;
                dr = new Ellipse2D.Double(pts[0], pts[1], pts[2], pts[3]);
                break;
            }
            case tpRetangulo: {
                int[] pts = this.ArrayDePontos(this.getRetangulo());
                if (pts.length == 4) {
                    dr = new Rectangle2D.Double(pts[0], pts[1], pts[2], pts[3]);
                }
                if (pts.length != 6) break;
                dr = new RoundRectangle2D.Double(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5]);
                break;
            }
            case tpCurva: {
                int[] pts = this.ArrayDePontos(this.getCurva());
                if (pts.length == 8) {
                    dr = new CubicCurve2D.Double(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5], pts[6], pts[7]);
                }
                if (pts.length != 6) break;
                dr = new QuadCurve2D.Double(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5]);
                break;
            }
            case tpArco: {
                int[] pts = this.ArrayDePontos(this.getArco());
                if (pts.length != 7) break;
                dr = new Arc2D.Double(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5], pts[6]);
                break;
            }
            case tpImagem: {
                this.DrawImagem(g);
                ok = true;
                break;
            }
            case tpMedida: {
                if (this.vertical) {
                    this.medidaH(g, l, t);
                } else {
                    this.medidaV(g, l, t);
                }
                ok = true;
                break;
            }
            case tpPath: {
                this.DrawComplexPath(g, l, t);
                ok = true;
                break;
            }
            default: {
                g.drawLine(l, t, this.getWidth(), this.getHeight());
                ok = true;
            }
        }
        if (dr == null || ok) {
            if (dr == null && !ok) {
                g.drawString("?", l + 5, t + 5);
            }
            return;
        }
        if (this.isFill()) {
            g.fill(dr);
        } else {
            g.draw(dr);
        }
    }

    private void medidaH(Graphics2D g, int l, int t) {
        FontMetrics fm = g.getFontMetrics();
        String vl = this.dono.FormateUnidadeMedida(this.width);
        int xini = l;
        int pre_y = t;
        int xfim = l + this.width;
        int yfim = t + this.height / 2;
        int traco = this.height;
        int ytraco = pre_y;
        g.drawLine(xini, ytraco, xini, ytraco + traco);
        g.drawLine(xfim, ytraco, xfim, ytraco + traco);
        g.drawLine(xini, yfim, xfim, yfim);
        int yini = this.invertido ? yfim + (fm.getHeight() - fm.getDescent()) : yfim - fm.getDescent();
        g.drawString(vl, xini += (this.width - fm.stringWidth(vl)) / 2, yini);
    }

    private void medidaV(Graphics2D g, int l, int t) {
        FontMetrics fm = g.getFontMetrics();
        String vl = this.dono.FormateUnidadeMedida(this.height);
        int traco = this.width;
        int xIni = l;
        int xFim = xIni + traco;
        int yIni = t;
        int yFim = t + this.height;
        int xLin = l + this.width / 2;
        g.drawLine(xIni, yIni, xFim, yIni);
        g.drawLine(xIni, yFim, xFim, yFim);
        g.drawLine(xLin, yIni, xLin, yFim);
        int degrees = this.isInvertido() ? 90 : -90;
        int desse = this.isInvertido() ? 0 : fm.stringWidth(vl);
        int centra = fm.getHeight() - fm.getDescent();
        centra = this.isInvertido() ? -centra : centra;
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(degrees));
        Font f = new Font(g.getFont().getName(), 1, g.getFont().getSize());
        Font f2 = g.getFont();
        g.setFont(f.deriveFont(at));
        yIni = yIni + (this.height - fm.stringWidth(vl)) / 2 + desse;
        g.drawString(vl, xLin + centra, yIni);
        g.setFont(f2);
    }

    private boolean DrawComplexPath(Graphics2D g, int l, int t) {
        String[] dist = this.getPath().split(",");
        int dl = dist.length;
        if (dl < 3) {
            g.drawString("?", l, t);
            return false;
        }
        if (dl % 2 > 0) {
            String[] tmp = new String[dl + 1];
            tmp[dl] = "0";
            dist = tmp;
            dl = dist.length;
        }
        int tam = dl / 2;
        int[] xPoints = new int[tam];
        int[] yPoints = new int[tam];
        try {
            int y = 0;
            for (int i = 0; i < tam; ++i) {
                xPoints[i] = this.Expr(dist[y++].trim());
                yPoints[i] = this.Expr(dist[y++].trim());
            }
        }
        catch (Exception x) {
            g.drawString("?", l, t);
            return false;
        }
        if (this.isFill()) {
            g.fillPolygon(xPoints, yPoints, tam);
        } else {
            g.drawPolygon(xPoints, yPoints, tam);
        }
        return true;
    }

    private int[] ArrayDePontos(String str) {
        String[] dist = str.split(",");
        int dl = dist.length;
        int[] res = new int[dl];
        try {
            for (int i = 0; i < dl; ++i) {
                res[i] = this.Expr(dist[i].trim());
            }
        }
        catch (Exception x) {
            return new int[]{0, 0};
        }
        return res;
    }

    private int Expr(String trim) throws Exception {
        int res;
        block6: {
            String conv = trim.replaceAll("[w,W]", Integer.toString(this.dono.getW()));
            conv = conv.replaceAll("[h,H]", Integer.toString(this.dono.getH()));
            if (!this.outroPintor) {
                conv = conv.replaceAll("[l,L]", Integer.toString(this.dono.getL()));
                conv = conv.replaceAll("[t,T]", Integer.toString(this.dono.getT()));
            } else if (this.getTipo() == tipoDrawer.tpMedida) {
                conv = conv.replaceAll("[l,L]", Integer.toString(this.getLeft()));
                conv = conv.replaceAll("[t,T]", Integer.toString(this.getTop()));
            } else {
                conv = conv.replaceAll("[l,L]", "0");
                conv = conv.replaceAll("[t,T]", "0");
            }
            res = 0;
            try {
                res = Integer.valueOf(conv);
            }
            catch (NumberFormatException e) {
                ProcessadorExprSimples pEx = new ProcessadorExprSimples();
                if (!pEx.IsMathExpr(conv)) break block6;
                return pEx.processaExprInt(conv);
            }
        }
        return res;
    }

    public boolean isDisablePainted() {
        return this.disablePainted;
    }

    public void setDisablePainted(boolean disablePainted) {
        if (this.disablePainted == disablePainted) {
            return;
        }
        this.disablePainted = disablePainted;
    }

    public static enum tipoDrawer {
        tpRetangulo,
        tpElipse,
        tpCurva,
        tpArco,
        tpPath,
        tpImagem,
        tpMedida;

    }
}

