/*
 * Decompiled with CFR 0.152.
 */
package controlador.editores;

import controlador.editores.JListItemParaItemLegenda;
import desenho.formas.Legenda;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import util.Dialogos;
import util.Utilidades;

public class LegendaEditor
extends JFrame {
    private Legenda.ItemDeLegenda[] itens;
    private JList Lista;
    private Legenda atual = null;
    private JScrollPane Scroller;
    private JButton btnAtualizar;
    private JButton btnEditar;
    private JButton btnExcluir;
    private JButton btnFechar;
    private JButton btnNovo;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public LegendaEditor() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnNovo = new JButton();
        this.btnEditar = new JButton();
        this.btnAtualizar = new JButton();
        this.btnExcluir = new JButton();
        this.btnFechar = new JButton();
        this.Scroller = new JScrollPane();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new GridLayout(6, 1, 0, 6));
        this.jPanel1.add(this.jLabel1);
        this.btnNovo.setText("Novo");
        this.btnNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendaEditor.this.btnNovoActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnNovo);
        this.btnEditar.setText("Editar");
        this.btnEditar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendaEditor.this.btnEditarActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnEditar);
        this.btnAtualizar.setText("Atualizar");
        this.btnAtualizar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendaEditor.this.btnAtualizarActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnAtualizar);
        this.btnExcluir.setText("Excluir");
        this.btnExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendaEditor.this.btnExcluirActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnExcluir);
        this.btnFechar.setText("Fechar");
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendaEditor.this.btnFecharActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnFechar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.Scroller, -1, 221, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 83, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.Scroller));
        this.pack();
    }

    private void btnNovoActionPerformed(ActionEvent evt) {
        if (this.atual == null) {
            return;
        }
        String cor = Dialogos.ShowDlgCor(this.getRootPane(), "");
        if (!"".equals(cor)) {
            Color c = Utilidades.StringToColor(cor);
            String res = Dialogos.ShowDlgInputText(this.getRootPane(), "");
            if (!"".equals(res)) {
                this.atual.addLegenda(res, c);
                this.Init(this.atual);
                this.Lista.repaint();
                this.RefreshInpector();
            }
        }
    }

    private void btnEditarActionPerformed(ActionEvent evt) {
        if (this.Lista != null && this.Lista.getSelectedIndex() > -1) {
            String txt = this.atual.getItens().get(this.Lista.getSelectedIndex()).getTexto();
            String res = Dialogos.ShowDlgInputText(this.getRootPane(), txt);
            if (!"".equals(res)) {
                this.atual.setTextLegenda(this.Lista.getSelectedIndex(), res);
                this.Init(this.atual);
                this.Lista.repaint();
                this.RefreshInpector();
            }
        }
    }

    private void btnAtualizarActionPerformed(ActionEvent evt) {
        if (this.atual == null) {
            return;
        }
        this.atual.LoadColorList();
        this.RefreshInpector();
        this.invalidate();
    }

    private void btnExcluirActionPerformed(ActionEvent evt) {
        if (this.Lista != null && this.Lista.getSelectedIndex() > -1) {
            this.atual.RemoveLegenda(this.Lista.getSelectedIndex());
            this.Init(this.atual);
            this.RefreshInpector();
        }
    }

    private void btnFecharActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void Init(Legenda legenda) {
        this.atual = legenda;
        if (this.atual == null && this.Lista != null) {
            this.remove(this.Lista);
            this.Scroller.setViewportView(null);
            return;
        }
        this.itens = !legenda.getItens().isEmpty() ? legenda.getItens().toArray(new Legenda.ItemDeLegenda[0]) : new Legenda.ItemDeLegenda[0];
        if (this.Lista != null) {
            this.remove(this.Lista);
        }
        this.Lista = new JList<Legenda.ItemDeLegenda>(this.itens);
        this.Lista.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return LegendaEditor.this.itens.length;
            }

            @Override
            public Object getElementAt(int i) {
                return LegendaEditor.this.itens[i];
            }
        });
        this.add(this.Lista);
        this.Scroller.setViewportView(this.Lista);
        this.Lista.setCellRenderer(new JListItemParaItemLegenda(legenda.getTipo() == Legenda.TipoLegenda.tpLinhas));
        this.btnAtualizar.setEnabled(legenda.getTipo() == Legenda.TipoLegenda.tpCores);
    }

    private void RefreshInpector() {
        if (this.atual != null) {
            this.atual.RefreshInpector();
        }
    }
}

