/*
 * Decompiled with CFR 0.152.
 */
package org.staccato.functions;

import java.util.HashMap;
import java.util.Map;
import org.staccato.PreprocessorFunction;
import org.staccato.SubparserFunction;

public class FunctionManager {
    private static FunctionManager instance;
    private Map<String, PreprocessorFunction> preprocessorFunctions = new HashMap<String, PreprocessorFunction>();
    private Map<String, SubparserFunction> subparserFunctions = new HashMap<String, SubparserFunction>();

    public static FunctionManager getInstance() {
        if (instance == null) {
            instance = new FunctionManager();
        }
        return instance;
    }

    private FunctionManager() {
    }

    public void addPreprocessorFunction(PreprocessorFunction function) {
        for (String name : function.getNames()) {
            this.preprocessorFunctions.put(name.toUpperCase(), function);
        }
    }

    public void removePreprocessorFunction(PreprocessorFunction function) {
        for (String name : function.getNames()) {
            this.preprocessorFunctions.remove(name.toUpperCase());
        }
    }

    public PreprocessorFunction getPreprocessorFunction(String name) {
        return this.preprocessorFunctions.get(name.toUpperCase());
    }

    public void addSubparserFunction(SubparserFunction function) {
        for (String name : function.getNames()) {
            this.subparserFunctions.put(name.toUpperCase(), function);
        }
    }

    public void removeSubparserFunction(SubparserFunction function) {
        for (String name : function.getNames()) {
            this.subparserFunctions.remove(name.toUpperCase());
        }
    }

    public SubparserFunction getSubparserFunction(String name) {
        return this.subparserFunctions.get(name.toUpperCase());
    }
}

