/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import org.jfugue.pattern.Token;
import org.staccato.IVLSubparser;
import org.staccato.NoteSubparser;
import org.staccato.StaccatoParserContext;
import org.staccato.StaccatoUtil;
import org.staccato.Subparser;

public class AtomSubparser
implements Subparser {
    public static final char ATOM = '&';
    public static final String QUARK_SEPARATOR = ",";
    private static AtomSubparser instance;

    public static AtomSubparser getInstance() {
        if (instance == null) {
            instance = new AtomSubparser();
        }
        return instance;
    }

    @Override
    public boolean matches(String music) {
        return music.charAt(0) == '&';
    }

    @Override
    public Token.TokenType getTokenType(String tokenString) {
        if (tokenString.charAt(0) == '&') {
            return Token.TokenType.ATOM;
        }
        return Token.TokenType.UNKNOWN_TOKEN;
    }

    @Override
    public int parse(String music, StaccatoParserContext context) {
        if (this.matches(music)) {
            String[] quarks;
            int posNextSpace = StaccatoUtil.findNextOrEnd(music, ' ', 0);
            music = music.substring(1, posNextSpace);
            for (String quark : quarks = music.split(QUARK_SEPARATOR)) {
                if (IVLSubparser.getInstance().matches(quark)) {
                    IVLSubparser.getInstance().parse(quark, context);
                    continue;
                }
                if (!NoteSubparser.getInstance().matches(quark)) continue;
                NoteSubparser.getInstance().parse(quark, context);
            }
            return posNextSpace + 1;
        }
        return 0;
    }
}

