/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.midi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import org.jfugue.midi.MidiParser;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.player.Player;
import org.staccato.StaccatoParserListener;

public class MidiFileManager {
    public static void save(Sequence sequence, OutputStream out) throws IOException {
        int[] writers = MidiSystem.getMidiFileTypes(sequence);
        if (writers.length == 0) {
            return;
        }
        MidiSystem.write(sequence, writers[0], out);
    }

    public static void save(Sequence sequence, File file) throws IOException {
        MidiFileManager.save(sequence, new FileOutputStream(file));
    }

    public static Sequence load(File file) throws IOException, InvalidMidiDataException {
        return MidiSystem.getSequence(file);
    }

    public static void savePatternToMidi(PatternProducer patternProducer, OutputStream out) throws IOException {
        MidiFileManager.save(new Player().getSequence(patternProducer), out);
    }

    public static void savePatternToMidi(PatternProducer patternProducer, File file) throws IOException {
        MidiFileManager.savePatternToMidi(patternProducer, new FileOutputStream(file));
    }

    public static Pattern loadPatternFromMidi(InputStream in) throws IOException, InvalidMidiDataException {
        MidiParser midiParser = new MidiParser();
        StaccatoParserListener staccatoListener = new StaccatoParserListener();
        midiParser.addParserListener(staccatoListener);
        midiParser.parse(MidiSystem.getSequence(in));
        return staccatoListener.getPattern();
    }

    public static Pattern loadPatternFromMidi(File file) throws IOException, InvalidMidiDataException {
        return MidiFileManager.loadPatternFromMidi(new FileInputStream(file));
    }

    public static Pattern loadPatternFromMidi(URL url) throws IOException, InvalidMidiDataException {
        return MidiFileManager.loadPatternFromMidi(url.openStream());
    }
}

