/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.devices;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Transmitter;
import org.jfugue.devices.MidiParserReceiver;
import org.jfugue.parser.ParserListener;

public class MusicTransmitterToParserListener {
    private MidiDevice device;
    private boolean isInitiated;
    private Transmitter transmitter;
    private MidiParserReceiver mrftd;
    private List<ParserListener> listeners;

    public MusicTransmitterToParserListener(MidiDevice device) throws MidiUnavailableException {
        this.device = device;
        this.isInitiated = false;
        this.listeners = new ArrayList<ParserListener>();
        this.mrftd = new MidiParserReceiver();
    }

    private void init() throws MidiUnavailableException {
        if (!this.isInitiated) {
            try {
                if (!this.device.isOpen()) {
                    this.device.open();
                }
                this.transmitter = this.device.getTransmitter();
            }
            catch (MidiUnavailableException e) {
                this.device.close();
                throw e;
            }
        }
        this.mrftd.getParser().clearParserListeners();
        for (ParserListener listener : this.listeners) {
            this.mrftd.getParser().addParserListener(listener);
        }
    }

    public void addParserListener(ParserListener l) {
        this.listeners.add(l);
    }

    public List<ParserListener> getParserListeners() {
        return this.listeners;
    }

    public Transmitter getTransmitter() {
        return this.transmitter;
    }

    public MidiParserReceiver getMidiParserReceiver() {
        return this.mrftd;
    }

    public void startListening() throws MidiUnavailableException {
        this.init();
        this.mrftd.getParser().startParser();
        this.transmitter.setReceiver(this.mrftd);
    }

    public void stopListening() {
        this.mrftd.getParser().stopParser();
        this.close();
    }

    public void listenForMillis(long millis) throws MidiUnavailableException, InterruptedException {
        this.startListening();
        Thread.sleep(millis);
        this.stopListening();
    }

    public void close() {
        this.transmitter.close();
        this.device.close();
    }
}

